/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.gandiva.expression;

import org.apache.arrow.gandiva.exceptions.GandivaException;
import org.apache.arrow.gandiva.expression.ArrowTypeHelper;
import org.apache.arrow.gandiva.expression.TreeNode;
import org.apache.arrow.gandiva.ipc.GandivaTypes;
import org.apache.arrow.vector.types.pojo.ArrowType;

class IfNode
implements TreeNode {
    private final TreeNode condition;
    private final TreeNode thenNode;
    private final TreeNode elseNode;
    private final ArrowType retType;

    IfNode(TreeNode condition, TreeNode thenNode, TreeNode elseNode, ArrowType retType) {
        this.condition = condition;
        this.thenNode = thenNode;
        this.elseNode = elseNode;
        this.retType = retType;
    }

    @Override
    public GandivaTypes.TreeNode toProtobuf() throws GandivaException {
        GandivaTypes.IfNode.Builder ifNodeBuilder = GandivaTypes.IfNode.newBuilder();
        ifNodeBuilder.setCond(this.condition.toProtobuf());
        ifNodeBuilder.setThenNode(this.thenNode.toProtobuf());
        ifNodeBuilder.setElseNode(this.elseNode.toProtobuf());
        ifNodeBuilder.setReturnType(ArrowTypeHelper.arrowTypeToProtobuf(this.retType));
        GandivaTypes.TreeNode.Builder builder = GandivaTypes.TreeNode.newBuilder();
        builder.setIfNode(ifNodeBuilder.build());
        return builder.build();
    }
}

