/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize.simple;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class FileReaderUtil {
    private static Logger LOG = Logger.getLogger(FileReaderUtil.class);
    private static boolean isDebugEnabled = LOG.isDebugEnabled();

    public static List<String> readFile(String path) throws IOException {
        if (isDebugEnabled) {
            LOG.debug((Object)"==> FileReaderUtil readFile");
        }
        ArrayList<String> list = new ArrayList<String>();
        LOG.info((Object)("reading the file" + path));
        List<String> fileLines = Files.readAllLines(Paths.get(path, new String[0]), Charset.forName("UTF-8"));
        if (fileLines != null) {
            for (String line : fileLines) {
                if (line.startsWith("#") || !Pattern.matches(".+;;.*;;.*;;.+", line)) continue;
                list.add(line);
            }
        }
        if (isDebugEnabled) {
            LOG.debug((Object)"<== FileReaderUtil readFile");
            LOG.debug((Object)("Policies read :: " + list));
        }
        return list;
    }
}

