/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize.simple;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.atlas.authorize.AtlasAccessRequest;
import org.apache.atlas.authorize.AtlasActionTypes;
import org.apache.atlas.authorize.AtlasAuthorizationException;
import org.apache.atlas.authorize.AtlasAuthorizer;
import org.apache.atlas.authorize.AtlasAuthorizerFactory;
import org.apache.atlas.authorize.AtlasResourceTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasAuthorizationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasAuthorizationUtils.class);
    private static boolean isDebugEnabled = LOG.isDebugEnabled();
    private static final String BASE_URL = "/api/atlas/";

    public static String getApi(String contextPath) {
        if (isDebugEnabled) {
            LOG.debug("==> getApi({})", (Object)contextPath);
        }
        if (contextPath == null) {
            contextPath = "";
        }
        if (contextPath.startsWith(BASE_URL)) {
            contextPath = contextPath.substring(BASE_URL.length());
        } else if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        String[] split = contextPath.split("/", 3);
        String api = split[0];
        if (Pattern.matches("v\\d", api)) {
            api = split[1];
        }
        if (isDebugEnabled) {
            LOG.debug("<== getApi({}): {}", (Object)contextPath, (Object)api);
        }
        return api;
    }

    public static AtlasActionTypes getAtlasAction(String method) {
        AtlasActionTypes action = null;
        switch (method.toUpperCase()) {
            case "POST": {
                action = AtlasActionTypes.CREATE;
                break;
            }
            case "GET": {
                action = AtlasActionTypes.READ;
                break;
            }
            case "PUT": {
                action = AtlasActionTypes.UPDATE;
                break;
            }
            case "DELETE": {
                action = AtlasActionTypes.DELETE;
                break;
            }
            default: {
                if (!isDebugEnabled) break;
                LOG.debug("getAtlasAction(): Invalid HTTP method '{}", (Object)method);
            }
        }
        if (isDebugEnabled) {
            LOG.debug("<== AtlasAuthorizationFilter getAtlasAction HTTP Method {} mapped to AtlasAction : {}", (Object)method, (Object)action);
        }
        return action;
    }

    public static Set<AtlasResourceTypes> getAtlasResourceType(String contextPath) {
        String api;
        HashSet<AtlasResourceTypes> resourceTypes = new HashSet<AtlasResourceTypes>();
        if (isDebugEnabled) {
            LOG.debug("==> getAtlasResourceType  for {}", (Object)contextPath);
        }
        if ((api = AtlasAuthorizationUtils.getApi(contextPath)).startsWith("types")) {
            resourceTypes.add(AtlasResourceTypes.TYPE);
        } else if (api.startsWith("admin") && (contextPath.contains("/session") || contextPath.contains("/version"))) {
            resourceTypes.add(AtlasResourceTypes.UNKNOWN);
        } else if (api.startsWith("discovery") && contextPath.contains("/gremlin") || api.startsWith("admin") || api.startsWith("graph")) {
            resourceTypes.add(AtlasResourceTypes.OPERATION);
        } else if (api.startsWith("entities") || api.startsWith("lineage") || api.startsWith("discovery") || api.startsWith("entity") || api.startsWith("search")) {
            resourceTypes.add(AtlasResourceTypes.ENTITY);
        } else if (api.startsWith("taxonomies")) {
            resourceTypes.add(AtlasResourceTypes.TAXONOMY);
            resourceTypes.add(AtlasResourceTypes.ENTITY);
            if (contextPath.contains("/terms")) {
                resourceTypes.add(AtlasResourceTypes.TERM);
            }
        } else {
            LOG.error("Unable to find Atlas Resource corresponding to : {}\nSetting {}", (Object)api, (Object)AtlasResourceTypes.UNKNOWN.name());
            resourceTypes.add(AtlasResourceTypes.UNKNOWN);
        }
        if (isDebugEnabled) {
            LOG.debug("<== Returning AtlasResources {} for api {}", resourceTypes, (Object)api);
        }
        return resourceTypes;
    }

    public static boolean isAccessAllowed(AtlasResourceTypes resourcetype, AtlasActionTypes actionType, String userName, Set<String> groups, HttpServletRequest request) {
        AtlasAuthorizer authorizer = null;
        boolean isaccessAllowed = false;
        HashSet<AtlasResourceTypes> resourceTypes = new HashSet<AtlasResourceTypes>();
        resourceTypes.add(resourcetype);
        AtlasAccessRequest atlasRequest = new AtlasAccessRequest(resourceTypes, "*", actionType, userName, groups, AtlasAuthorizationUtils.getRequestIpAddress(request));
        try {
            authorizer = AtlasAuthorizerFactory.getAtlasAuthorizer();
            if (authorizer != null) {
                isaccessAllowed = authorizer.isAccessAllowed(atlasRequest);
            }
        }
        catch (AtlasAuthorizationException e) {
            LOG.error("Unable to obtain AtlasAuthorizer. ", (Throwable)e);
        }
        return isaccessAllowed;
    }

    public static String getRequestIpAddress(HttpServletRequest httpServletRequest) {
        try {
            InetAddress inetAddr = InetAddress.getByName(httpServletRequest.getRemoteAddr());
            String ip = inetAddr.getHostAddress();
            return ip;
        }
        catch (UnknownHostException ex) {
            LOG.error("Error occured when retrieving IP address", (Throwable)ex);
            return "";
        }
    }
}

