/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.atlas.authorize.AtlasActionTypes;
import org.apache.atlas.authorize.AtlasResourceTypes;
import org.apache.atlas.authorize.simple.PolicyDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyParser {
    private static Logger LOG = LoggerFactory.getLogger(PolicyParser.class);
    private static boolean isDebugEnabled = LOG.isDebugEnabled();
    public static final int POLICYNAME = 0;
    public static final int USER_INDEX = 1;
    public static final int USERNAME = 0;
    public static final int USER_AUTHORITIES = 1;
    public static final int GROUP_INDEX = 2;
    public static final int GROUPNAME = 0;
    public static final int GROUP_AUTHORITIES = 1;
    public static final int RESOURCE_INDEX = 3;
    public static final int RESOURCE_TYPE = 0;
    public static final int RESOURCE_NAME = 1;

    private List<AtlasActionTypes> getListOfAutorities(String auth) {
        if (isDebugEnabled) {
            LOG.debug("==> PolicyParser getListOfAutorities");
        }
        ArrayList<AtlasActionTypes> authorities = new ArrayList<AtlasActionTypes>();
        block6: for (int i = 0; i < auth.length(); ++i) {
            char access = auth.toLowerCase().charAt(i);
            switch (access) {
                case 'r': {
                    authorities.add(AtlasActionTypes.READ);
                    continue block6;
                }
                case 'w': {
                    authorities.add(AtlasActionTypes.CREATE);
                    continue block6;
                }
                case 'u': {
                    authorities.add(AtlasActionTypes.UPDATE);
                    continue block6;
                }
                case 'd': {
                    authorities.add(AtlasActionTypes.DELETE);
                    continue block6;
                }
                default: {
                    if (!LOG.isErrorEnabled()) continue block6;
                    LOG.error("Invalid action: '{}'", (Object)Character.valueOf(access));
                }
            }
        }
        if (isDebugEnabled) {
            LOG.debug("<== PolicyParser getListOfAutorities");
        }
        return authorities;
    }

    public List<PolicyDef> parsePolicies(List<String> policies) {
        if (isDebugEnabled) {
            LOG.debug("==> PolicyParser parsePolicies");
        }
        ArrayList<PolicyDef> policyDefs = new ArrayList<PolicyDef>();
        for (String policy : policies) {
            PolicyDef policyDef = this.parsePolicy(policy);
            if (policyDef == null) continue;
            policyDefs.add(policyDef);
        }
        if (isDebugEnabled) {
            LOG.debug("<== PolicyParser parsePolicies");
            LOG.debug(((Object)policyDefs).toString());
        }
        return policyDefs;
    }

    private PolicyDef parsePolicy(String data) {
        if (isDebugEnabled) {
            LOG.debug("==> PolicyParser parsePolicy");
        }
        PolicyDef def = null;
        String[] props = data.split(";;");
        if (props.length < 3) {
            LOG.warn("skipping invalid policy line: {}", (Object)data);
        } else {
            def = new PolicyDef();
            def.setPolicyName(props[0]);
            this.parseUsers(props[1], def);
            this.parseGroups(props[2], def);
            this.parseResources(props[3], def);
            if (isDebugEnabled) {
                LOG.debug("policy successfully parsed!!!");
                LOG.debug("<== PolicyParser parsePolicy");
            }
        }
        return def;
    }

    private boolean validateEntity(String entity) {
        if (isDebugEnabled) {
            LOG.debug("==> PolicyParser validateEntity");
        }
        boolean isValidEntity = Pattern.matches("(.+:.+)+", entity);
        boolean isEmpty = entity.isEmpty();
        if (!isValidEntity || isEmpty) {
            if (isDebugEnabled) {
                LOG.debug("group/user/resource not properly define in Policy");
                LOG.debug("<== PolicyParser validateEntity");
            }
            return false;
        }
        if (isDebugEnabled) {
            LOG.debug("<== PolicyParser validateEntity");
        }
        return true;
    }

    private void parseUsers(String usersDef, PolicyDef def) {
        if (isDebugEnabled) {
            LOG.debug("==> PolicyParser parseUsers");
        }
        String[] users = usersDef.split(",");
        String[] userAndRole = null;
        Map<String, List<AtlasActionTypes>> usersMap = new HashMap<String, List<AtlasActionTypes>>();
        if (this.validateEntity(usersDef)) {
            for (String user : users) {
                if (!Pattern.matches("(.+:.+)+", user)) continue;
                userAndRole = user.split(":");
                if (def.getUsers() != null) {
                    usersMap = def.getUsers();
                }
                List<AtlasActionTypes> userAutorities = this.getListOfAutorities(userAndRole[1]);
                usersMap.put(userAndRole[0], userAutorities);
                def.setUsers(usersMap);
            }
        } else {
            def.setUsers(usersMap);
        }
        if (isDebugEnabled) {
            LOG.debug("<== PolicyParser parseUsers");
        }
    }

    private void parseGroups(String groupsDef, PolicyDef def) {
        if (isDebugEnabled) {
            LOG.debug("==> PolicyParser parseGroups");
        }
        String[] groups = groupsDef.split("\\,");
        String[] groupAndRole = null;
        Map<String, List<AtlasActionTypes>> groupsMap = new HashMap<String, List<AtlasActionTypes>>();
        if (this.validateEntity(groupsDef.trim())) {
            for (String group : groups) {
                if (!Pattern.matches("(.+:.+)+", group)) continue;
                groupAndRole = group.split("[:]");
                if (def.getGroups() != null) {
                    groupsMap = def.getGroups();
                }
                List<AtlasActionTypes> groupAutorities = this.getListOfAutorities(groupAndRole[1]);
                groupsMap.put(groupAndRole[0], groupAutorities);
                def.setGroups(groupsMap);
            }
        } else {
            def.setGroups(groupsMap);
        }
        if (isDebugEnabled) {
            LOG.debug("<== PolicyParser parseGroups");
        }
    }

    private void parseResources(String resourceDef, PolicyDef def) {
        if (isDebugEnabled) {
            LOG.debug("==> PolicyParser parseResources");
        }
        String[] resources = resourceDef.split(",");
        String[] resourceTypeAndName = null;
        Map<AtlasResourceTypes, List<String>> resourcesMap = new HashMap<AtlasResourceTypes, List<String>>();
        if (this.validateEntity(resourceDef)) {
            for (String resource : resources) {
                if (!Pattern.matches("(.+:.+)+", resource)) continue;
                resourceTypeAndName = resource.split("[:]");
                if (def.getResources() != null) {
                    resourcesMap = def.getResources();
                }
                AtlasResourceTypes resourceType = null;
                String type = resourceTypeAndName[0].toUpperCase();
                if (type.equalsIgnoreCase("ENTITY")) {
                    resourceType = AtlasResourceTypes.ENTITY;
                } else if (type.equalsIgnoreCase("OPERATION")) {
                    resourceType = AtlasResourceTypes.OPERATION;
                } else if (type.equalsIgnoreCase("TYPE")) {
                    resourceType = AtlasResourceTypes.TYPE;
                } else if (type.equalsIgnoreCase("TAXONOMY")) {
                    resourceType = AtlasResourceTypes.TAXONOMY;
                } else if (type.equalsIgnoreCase("TERM")) {
                    resourceType = AtlasResourceTypes.TERM;
                } else {
                    LOG.warn(type + " is invalid resource please check PolicyStore file");
                    continue;
                }
                List<String> resourceList = resourcesMap.get((Object)resourceType);
                if (resourceList == null) {
                    resourceList = new ArrayList<String>();
                }
                resourceList.add(resourceTypeAndName[1]);
                resourcesMap.put(resourceType, resourceList);
                def.setResources(resourcesMap);
            }
        } else {
            def.setResources(resourcesMap);
        }
        if (isDebugEnabled) {
            LOG.debug("<== PolicyParser parseResources");
        }
    }
}

