/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize.simple;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReaderUtil {
    private static Logger LOG = LoggerFactory.getLogger(FileReaderUtil.class);
    private static boolean isDebugEnabled = LOG.isDebugEnabled();

    public static List<String> readFile(InputStream policyStoreStream) throws IOException {
        if (isDebugEnabled) {
            LOG.debug("==> FileReaderUtil readFile()");
        }
        ArrayList<String> list = new ArrayList<String>();
        List fileLines = IOUtils.readLines((InputStream)policyStoreStream, (Charset)StandardCharsets.UTF_8);
        if (fileLines != null) {
            for (String line : fileLines) {
                if (line.startsWith("#") || !Pattern.matches(".+;;.*;;.*;;.+", line)) continue;
                list.add(line);
            }
        }
        if (isDebugEnabled) {
            LOG.debug("<== FileReaderUtil readFile()");
            LOG.debug("Policies read :: " + list);
        }
        return list;
    }
}

