/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.tools;

import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasClientV2;
import org.apache.atlas.AtlasException;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasEntityHeaders;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.utils.AtlasJson;
import org.apache.atlas.utils.AuthenticationUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkFetchAndUpdate {
    private static final Logger LOG = LoggerFactory.getLogger(BulkFetchAndUpdate.class);
    private static final String DATE_FORMAT_SUPPORTED = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String OPTION_FROM = "f";
    private static final String APPLICATION_PROPERTY_ATLAS_ENDPOINT = "atlas.rest.address";
    private static final String SYSTEM_PROPERTY_USER_DIR = "user.dir";
    private static final String STEP_PREPARE = "prepare";
    private static final String STEP_UPDATE = "update";
    private static final int EXIT_CODE_SUCCESS = 0;
    private static final int EXIT_CODE_FAILED = 1;
    private static final String DEFAULT_ATLAS_URL = "http://localhost:21000/";
    private static final String FILE_CLASSIFICATION_DEFS = "classification-definitions.json";
    private static final String FILE_ENTITY_HEADERS = "entity-headers.json";
    private static final String[] filesToUse = new String[]{"classification-definitions.json", "entity-headers.json"};

    public static void main(String[] args) {
        int exitCode = 1;
        try {
            long fromTimestamp = 0L;
            CommandLine cmd = BulkFetchAndUpdate.getCommandLine(args);
            String stepToExecute = cmd.getOptionValue("s").trim();
            String uid = cmd.getOptionValue("u");
            String pwd = cmd.getOptionValue("p");
            String directory = cmd.getOptionValue("d");
            String fromTime = cmd.getOptionValue(OPTION_FROM);
            String basePath = BulkFetchAndUpdate.getDirectory(directory);
            BulkFetchAndUpdate.displayCrLf(basePath);
            String[] atlasEndpoint = BulkFetchAndUpdate.getAtlasRESTUrl();
            if (atlasEndpoint == null || atlasEndpoint.length == 0) {
                atlasEndpoint = new String[]{DEFAULT_ATLAS_URL};
            }
            if (StringUtils.equals((CharSequence)stepToExecute, (CharSequence)STEP_PREPARE)) {
                if (StringUtils.isEmpty((CharSequence)fromTime)) {
                    BulkFetchAndUpdate.displayCrLf("'fromTime' is empty" + fromTime);
                    BulkFetchAndUpdate.printUsage();
                    return;
                }
                fromTimestamp = BulkFetchAndUpdate.getTimestamp(fromTime);
                BulkFetchAndUpdate.displayCrLf("fromTimestamp: " + fromTimestamp);
                if (fromTimestamp == 0L) {
                    BulkFetchAndUpdate.printUsage();
                    return;
                }
            }
            BulkFetchAndUpdate.process(stepToExecute, basePath, atlasEndpoint, uid, pwd, fromTimestamp);
            exitCode = 0;
        }
        catch (org.apache.commons.cli.ParseException e) {
            LOG.error("Failed to parse arguments. Error: ", (Object)e.getMessage());
            BulkFetchAndUpdate.printUsage();
        }
        catch (Exception e) {
            LOG.error("Failed!", (Throwable)e);
            BulkFetchAndUpdate.displayCrLf("Failed: " + e.getMessage());
        }
        System.exit(exitCode);
    }

    private static long getTimestamp(String str) {
        try {
            if (StringUtils.isEmpty((CharSequence)str)) {
                return 0L;
            }
            TimeZone utc = TimeZone.getDefault();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT_SUPPORTED);
            simpleDateFormat.setTimeZone(utc);
            return simpleDateFormat.parse(str).getTime();
        }
        catch (ParseException e) {
            BulkFetchAndUpdate.displayCrLf("Unsupported date format: " + str);
            return 0L;
        }
    }

    private static void process(String stepToExecute, String basePath, String[] atlasEndpoint, String uid, String pwd, long fromTimestamp) throws Exception {
        AtlasClientV2 atlasClientV2 = BulkFetchAndUpdate.getAtlasClientV2(atlasEndpoint, new String[]{uid, pwd});
        switch (stepToExecute) {
            case "prepare": {
                Preparer p = new Preparer(atlasClientV2);
                p.run(basePath, fromTimestamp);
                break;
            }
            case "update": {
                Updater u = new Updater(atlasClientV2);
                u.run(basePath);
                break;
            }
            default: {
                BulkFetchAndUpdate.printUsage();
            }
        }
    }

    private static String getDirectory(String directory) {
        String basePath = System.getProperty(SYSTEM_PROPERTY_USER_DIR) + File.separatorChar;
        if (StringUtils.isNotEmpty((CharSequence)directory) && BulkFetchAndUpdate.checkDirectoryExists(directory)) {
            basePath = directory + File.separatorChar;
        } else {
            BulkFetchAndUpdate.display("Using directory: ");
        }
        return basePath;
    }

    private static CommandLine getCommandLine(String[] args) throws org.apache.commons.cli.ParseException {
        Options options = new Options();
        options.addRequiredOption("s", "step", true, "Step to run.");
        options.addOption("u", "user", true, "User name.");
        options.addOption("p", "password", true, "Password name.");
        options.addOption("d", "dir", true, "Directory for reading/writing data.");
        options.addOption(OPTION_FROM, "fromDate", true, "Date, in YYYY-MM-DD format, from where to start reading.");
        return new DefaultParser().parse(options, args);
    }

    private static void printUsage() {
        System.out.println();
        BulkFetchAndUpdate.displayCrLf("Usage: classification-updater.sh [-s <step>] [-f <from time>] [-t <optional: to time>] [-d <dir>]");
        BulkFetchAndUpdate.displayCrLf("    step: Specify which step to execute:");
        BulkFetchAndUpdate.displayCrLf("           prepare: prepare classifications and associated entities.");
        BulkFetchAndUpdate.displayCrLf("           update: update classifications and entities.");
        BulkFetchAndUpdate.displayCrLf("    dir: [optional] Directory where read/write will happen.");
        BulkFetchAndUpdate.displayCrLf("           If not specified, current directory will be used.");
        BulkFetchAndUpdate.displayCrLf("    from: [mandatory for 'prepare' step, optional for 'update' step] Date, in YYYY-MM-DD format, from where audits need to be read.");
        BulkFetchAndUpdate.displayCrLf("           If not specified, current directory will be used.");
        System.out.println();
    }

    private static String[] getAtlasRESTUrl() {
        Configuration atlasConf = null;
        try {
            atlasConf = ApplicationProperties.get();
            return atlasConf.getStringArray(APPLICATION_PROPERTY_ATLAS_ENDPOINT);
        }
        catch (AtlasException e) {
            return new String[]{DEFAULT_ATLAS_URL};
        }
    }

    private static AtlasClientV2 getAtlasClientV2(String[] atlasEndpoint, String[] uidPwdFromCommandLine) throws IOException {
        AtlasClientV2 atlasClientV2;
        if (!AuthenticationUtil.isKerberosAuthenticationEnabled()) {
            String[] uidPwd = uidPwdFromCommandLine[0] == null || uidPwdFromCommandLine[1] == null ? AuthenticationUtil.getBasicAuthenticationInput() : uidPwdFromCommandLine;
            atlasClientV2 = new AtlasClientV2(atlasEndpoint, uidPwd);
        } else {
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            atlasClientV2 = new AtlasClientV2(ugi, ugi.getShortUserName(), atlasEndpoint);
        }
        return atlasClientV2;
    }

    private static void displayCrLf(String ... formatMessage) {
        BulkFetchAndUpdate.displayFn(System.out::println, formatMessage);
    }

    private static void display(String ... formatMessage) {
        BulkFetchAndUpdate.displayFn(System.out::print, formatMessage);
    }

    private static void displayFn(Consumer<String> fn, String ... formatMessage) {
        if (formatMessage.length == 1) {
            fn.accept(formatMessage[0]);
        } else {
            fn.accept(String.format(formatMessage[0], formatMessage[1]));
        }
    }

    private static void closeReader(BufferedReader bufferedReader) {
        try {
            if (bufferedReader == null) {
                return;
            }
            bufferedReader.close();
        }
        catch (IOException ex) {
            LOG.error("closeReader", (Throwable)ex);
        }
    }

    private static BufferedReader getBufferedReader(String basePath, String fileName) throws FileNotFoundException {
        return new BufferedReader(new FileReader(basePath + fileName));
    }

    private static boolean fileCheck(String basePath, String[] files, boolean existCheck) {
        boolean ret = true;
        for (String f : files) {
            ret = ret && BulkFetchAndUpdate.fileCheck(basePath, f, existCheck);
        }
        return ret;
    }

    private static boolean fileCheck(String basePath, String file, boolean existCheck) {
        String errorMessage;
        String string = errorMessage = existCheck ? "does not exist" : "exists";
        if (BulkFetchAndUpdate.checkFileExists(basePath + file) != existCheck) {
            BulkFetchAndUpdate.displayCrLf(String.format("File '%s' %s!", basePath + file, errorMessage));
            return false;
        }
        return true;
    }

    private static boolean checkFileExists(String fileName) {
        File f = new File(fileName);
        return f.exists() && !f.isDirectory();
    }

    private static boolean checkDirectoryExists(String fileName) {
        File f = new File(fileName);
        return f.exists() && f.isDirectory();
    }

    private static FileWriter getFileWriter(String basePath, String fileName) throws IOException {
        String filePath = basePath + fileName;
        BulkFetchAndUpdate.displayCrLf("Creating %s", filePath);
        return new FileWriter(filePath, true);
    }

    private static class Updater {
        private AtlasClientV2 atlasClientV2;

        public Updater(AtlasClientV2 atlasClientV2) {
            this.atlasClientV2 = atlasClientV2;
        }

        public void run(String basePath) throws Exception {
            if (!BulkFetchAndUpdate.fileCheck(basePath, filesToUse, true)) {
                return;
            }
            BulkFetchAndUpdate.displayCrLf(new String[]{"Starting..."});
            this.readAndCreateOrUpdateClassificationDefs(basePath, BulkFetchAndUpdate.FILE_CLASSIFICATION_DEFS);
            this.readEntityUpdates(basePath, BulkFetchAndUpdate.FILE_ENTITY_HEADERS);
            BulkFetchAndUpdate.displayCrLf(new String[]{"Done!"});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readEntityUpdates(String basePath, String fileName) throws IOException {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = BulkFetchAndUpdate.getBufferedReader(basePath, fileName);
                String json = bufferedReader.readLine();
                if (StringUtils.isEmpty((CharSequence)json)) {
                    BulkFetchAndUpdate.displayCrLf(new String[]{"Empty file encountered: %s", fileName});
                    return;
                }
                AtlasEntityHeaders response = (AtlasEntityHeaders)AtlasType.fromJson((String)json, AtlasEntityHeaders.class);
                BulkFetchAndUpdate.displayCrLf(new String[]{"Found :" + response.getGuidHeaderMap().size()});
                String output = this.atlasClientV2.setClassifications(response);
                BulkFetchAndUpdate.displayCrLf(new String[]{output});
            }
            catch (AtlasServiceException e) {
                BulkFetchAndUpdate.displayCrLf(new String[]{"Error updating. Please see log for details."});
                LOG.error("Error updating. {}", (Throwable)e);
            }
            finally {
                BulkFetchAndUpdate.closeReader(bufferedReader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readAndCreateOrUpdateClassificationDefs(String basePath, String fileName) throws Exception {
            BufferedReader bufferedReader = null;
            try {
                String cd;
                bufferedReader = BulkFetchAndUpdate.getBufferedReader(basePath, fileName);
                while ((cd = bufferedReader.readLine()) != null) {
                    AtlasClassificationDef classificationDef = (AtlasClassificationDef)AtlasType.fromJson((String)cd, AtlasClassificationDef.class);
                    this.createOrUpdateClassification(classificationDef);
                }
            }
            finally {
                BulkFetchAndUpdate.closeReader(bufferedReader);
            }
        }

        private void createOrUpdateClassification(AtlasClassificationDef classificationDef) {
            String name = classificationDef.getName();
            AtlasTypesDef typesDef = new AtlasTypesDef(null, null, Collections.singletonList(classificationDef), null, null);
            try {
                BulkFetchAndUpdate.display(new String[]{"%s -> ", name});
                this.atlasClientV2.createAtlasTypeDefs(typesDef);
                BulkFetchAndUpdate.displayCrLf(new String[]{" [Done]"});
            }
            catch (AtlasServiceException e) {
                LOG.error("{} skipped!", (Object)name, (Object)e);
                BulkFetchAndUpdate.displayCrLf(new String[]{" [Skipped]", name});
                this.updateClassification(classificationDef);
                BulkFetchAndUpdate.displayCrLf(new String[]{" [Done!]"});
            }
            catch (Exception ex) {
                LOG.error("{} skipped!", (Object)name, (Object)ex);
                BulkFetchAndUpdate.displayCrLf(new String[]{" [Skipped]", name});
            }
        }

        private void updateClassification(AtlasClassificationDef classificationDef) {
            String name = classificationDef.getName();
            AtlasTypesDef typesDef = new AtlasTypesDef(null, null, Collections.singletonList(classificationDef), null, null);
            try {
                BulkFetchAndUpdate.display(new String[]{"Update: %s -> ", name});
                this.atlasClientV2.updateAtlasTypeDefs(typesDef);
                BulkFetchAndUpdate.displayCrLf(new String[]{" [Done]"});
            }
            catch (AtlasServiceException e) {
                LOG.error("{} skipped!", (Object)name, (Object)e);
                BulkFetchAndUpdate.displayCrLf(new String[]{" [Skipped]", name});
            }
            catch (Exception ex) {
                LOG.error("{} skipped!", (Object)name, (Object)ex);
                BulkFetchAndUpdate.displayCrLf(new String[]{" [Skipped]", name});
            }
        }
    }

    private static class Preparer {
        private static final String ATTR_NAME_QUALIFIED_NAME = "qualifiedName";
        private AtlasClientV2 atlasClientV2;
        private Map<String, String> typeNameUniqueAttributeNameMap = new HashMap<String, String>();

        public Preparer(AtlasClientV2 atlasClientV2) {
            this.atlasClientV2 = atlasClientV2;
        }

        public void run(String basePath, long fromTimestamp) throws Exception {
            if (!BulkFetchAndUpdate.fileCheck(basePath, filesToUse, false)) {
                return;
            }
            BulkFetchAndUpdate.displayCrLf(new String[]{"Starting: from: " + fromTimestamp + " to: current time (" + System.currentTimeMillis() + ")..."});
            this.writeClassificationDefs(basePath, BulkFetchAndUpdate.FILE_CLASSIFICATION_DEFS, this.getAllClassificationsDefs());
            this.writeEntityHeaders(basePath, BulkFetchAndUpdate.FILE_ENTITY_HEADERS, fromTimestamp);
            BulkFetchAndUpdate.displayCrLf(new String[]{"Done!"});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeClassificationDefs(String basePath, String fileName, List<AtlasClassificationDef> classificationDefs) throws IOException {
            try (FileWriter fileWriter = null;){
                fileWriter = BulkFetchAndUpdate.getFileWriter(basePath, fileName);
                for (AtlasClassificationDef classificationDef : classificationDefs) {
                    try {
                        classificationDef.setGuid(null);
                        String json = AtlasType.toJson((Object)classificationDef);
                        fileWriter.write(json + "\n");
                    }
                    catch (Exception e) {
                        LOG.error("Error writing classifications: {}", (Throwable)e);
                        BulkFetchAndUpdate.displayCrLf(new String[]{"Error writing classifications."});
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeEntityHeaders(String basePath, String fileName, long fromTimestamp) throws AtlasServiceException, IOException {
            FileWriter fileWriter = null;
            try {
                fileWriter = BulkFetchAndUpdate.getFileWriter(basePath, fileName);
            }
            catch (IOException e) {
                LOG.error("Error opening {}/{}", new Object[]{basePath, fileName, e});
                BulkFetchAndUpdate.displayCrLf(new String[]{"Error opening: %", basePath + File.separatorChar + fileName});
                return;
            }
            try {
                AtlasEntityHeaders entityHeaders = this.atlasClientV2.getEntityHeaders(fromTimestamp);
                int guidHeaderMapSize = entityHeaders.getGuidHeaderMap().size();
                try {
                    BulkFetchAndUpdate.displayCrLf(new String[]{"Read entities: " + guidHeaderMapSize});
                    AtlasEntityHeaders updatedHeaders = this.removeEntityGuids(entityHeaders);
                    fileWriter.write(AtlasType.toJson((Object)updatedHeaders));
                    BulkFetchAndUpdate.displayCrLf(new String[]{"Writing entities: " + updatedHeaders.getGuidHeaderMap().size()});
                }
                catch (Exception e) {
                    LOG.error("Error writing: {}", (Object)guidHeaderMapSize, (Object)e);
                    BulkFetchAndUpdate.displayCrLf(new String[]{"Error writing: " + e.toString()});
                }
            }
            finally {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
        }

        private AtlasEntityHeaders removeEntityGuids(AtlasEntityHeaders headers) {
            HashMap<String, AtlasEntityHeader> uniqueNameEntityHeaderMap = new HashMap<String, AtlasEntityHeader>();
            for (AtlasEntityHeader header : headers.getGuidHeaderMap().values()) {
                String uniqueName = this.getUniqueName(header);
                if (StringUtils.isEmpty((CharSequence)uniqueName)) {
                    BulkFetchAndUpdate.displayCrLf(new String[]{"UniqueName is empty.  Ignoring: " + header.getGuid()});
                    LOG.warn("UniqueName is empty. Ignoring: {}", (Object)AtlasJson.toJson((Object)header));
                    continue;
                }
                BulkFetchAndUpdate.displayCrLf(new String[]{"Processing: " + uniqueName});
                if (header.getStatus() == AtlasEntity.Status.DELETED) continue;
                String key = String.format("%s:%s", header.getTypeName(), uniqueName);
                header.setGuid(null);
                boolean keyFound = uniqueNameEntityHeaderMap.containsKey(key);
                if (!keyFound) {
                    uniqueNameEntityHeaderMap.put(key, header);
                }
                this.updateClassificationsForHeader(header, (AtlasEntityHeader)uniqueNameEntityHeaderMap.get(key), keyFound);
                BulkFetchAndUpdate.displayCrLf(new String[]{"Processing: " + uniqueName});
            }
            BulkFetchAndUpdate.displayCrLf(new String[]{"Processed: " + uniqueNameEntityHeaderMap.size()});
            headers.setGuidHeaderMap(uniqueNameEntityHeaderMap);
            return headers;
        }

        private void updateClassificationsForHeader(AtlasEntityHeader header, AtlasEntityHeader currentHeader, boolean keyFound) {
            for (AtlasClassification c : header.getClassifications()) {
                c.setEntityGuid(null);
                if (!keyFound) continue;
                boolean found = currentHeader.getClassifications().stream().anyMatch(ox -> ox.getTypeName().equals(c.getTypeName()));
                if (!found) {
                    currentHeader.getClassifications().add(c);
                    continue;
                }
                BulkFetchAndUpdate.displayCrLf(new String[]{"Ignoring: " + c.toString()});
                LOG.warn("Ignoring: {}", (Object)AtlasJson.toJson((Object)c));
            }
        }

        private String getUniqueName(AtlasEntityHeader header) {
            Object attrValue;
            String uniqueAttributeName = ATTR_NAME_QUALIFIED_NAME;
            if (!header.getAttributes().containsKey(ATTR_NAME_QUALIFIED_NAME)) {
                uniqueAttributeName = this.getUniqueAttribute(header.getTypeName());
            }
            if ((attrValue = header.getAttribute(uniqueAttributeName)) == null) {
                LOG.warn("Unique Attribute Value: empty: {}", (Object)AtlasJson.toJson((Object)header));
                return "";
            }
            return attrValue.toString();
        }

        private String getUniqueAttribute(String typeName) {
            try {
                if (this.typeNameUniqueAttributeNameMap.containsKey(typeName)) {
                    return this.typeNameUniqueAttributeNameMap.get(typeName);
                }
                AtlasEntityDef entityDef = this.atlasClientV2.getEntityDefByName(typeName);
                for (AtlasStructDef.AtlasAttributeDef ad : entityDef.getAttributeDefs()) {
                    if (!ad.getIsUnique()) continue;
                    this.typeNameUniqueAttributeNameMap.put(typeName, ad.getName());
                    return ad.getName();
                }
            }
            catch (AtlasServiceException e) {
                LOG.error("Error fetching type: {}", (Object)typeName, (Object)e);
                return null;
            }
            return null;
        }

        private List<AtlasClassificationDef> getAllClassificationsDefs() throws Exception {
            MultivaluedMapImpl searchParams = new MultivaluedMapImpl();
            searchParams.add((Object)"type", (Object)"CLASSIFICATION");
            SearchFilter searchFilter = new SearchFilter((MultivaluedMap)searchParams);
            AtlasTypesDef typesDef = this.atlasClientV2.getAllTypeDefs(searchFilter);
            BulkFetchAndUpdate.displayCrLf(new String[]{"Found classifications: " + typesDef.getClassificationDefs().size()});
            return typesDef.getClassificationDefs();
        }
    }
}

