/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.security;

import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.PrivilegedExceptionAction;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.atlas.AtlasException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticator;
import org.apache.hadoop.security.token.delegation.web.KerberosDelegationTokenAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureClientUtils {
    public static final int DEFAULT_SOCKET_TIMEOUT_IN_MSECS = 60000;
    private static final Logger LOG = LoggerFactory.getLogger(SecureClientUtils.class);
    private SSLFactory factory = null;
    private static final ConnectionConfigurator DEFAULT_TIMEOUT_CONN_CONFIGURATOR = new ConnectionConfigurator(){

        public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
            SecureClientUtils.setTimeouts(conn, 60000);
            return conn;
        }
    };

    public URLConnectionClientHandler getClientConnectionHandler(DefaultClientConfig config, Configuration clientConfig, String doAsUser, UserGroupInformation ugi) {
        config.getProperties().put("com.sun.jersey.client.property.httpUrlConnectionSetMethodWorkaround", true);
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
        conf.addResource(conf.get("hadoop.ssl.client.conf", "ssl-client.xml"));
        UserGroupInformation.setConfiguration((org.apache.hadoop.conf.Configuration)conf);
        final ConnectionConfigurator connConfigurator = this.newConnConfigurator(conf);
        KerberosDelegationTokenAuthenticator authenticator = new KerberosDelegationTokenAuthenticator();
        authenticator.setConnectionConfigurator(connConfigurator);
        final DelegationTokenAuthenticator finalAuthenticator = (DelegationTokenAuthenticator)authenticator;
        final DelegationTokenAuthenticatedURL.Token token = new DelegationTokenAuthenticatedURL.Token();
        HttpURLConnectionFactory httpURLConnectionFactory = null;
        try {
            UserGroupInformation ugiToUse = ugi != null ? ugi : UserGroupInformation.getCurrentUser();
            final UserGroupInformation actualUgi = ugiToUse.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.PROXY ? ugiToUse.getRealUser() : ugiToUse;
            LOG.info("Real User: {}, is from ticket cache? {}", (Object)actualUgi, (Object)actualUgi.isLoginTicketBased());
            if (StringUtils.isEmpty((String)doAsUser) || StringUtils.equals((String)doAsUser, (String)actualUgi.getShortUserName())) {
                doAsUser = null;
            }
            LOG.info("doAsUser: {}", (Object)doAsUser);
            final String finalDoAsUser = doAsUser;
            httpURLConnectionFactory = new HttpURLConnectionFactory(){

                public HttpURLConnection getHttpURLConnection(final URL url) throws IOException {
                    try {
                        return (HttpURLConnection)actualUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<HttpURLConnection>(){

                            @Override
                            public HttpURLConnection run() throws Exception {
                                try {
                                    return new DelegationTokenAuthenticatedURL(finalAuthenticator, connConfigurator).openConnection(url, token, finalDoAsUser);
                                }
                                catch (Exception e) {
                                    throw new IOException(e);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        if (e instanceof IOException) {
                            throw (IOException)e;
                        }
                        throw new IOException(e);
                    }
                }
            };
        }
        catch (IOException e) {
            LOG.warn("Error obtaining user", (Throwable)e);
        }
        return new URLConnectionClientHandler(httpURLConnectionFactory);
    }

    private ConnectionConfigurator newConnConfigurator(org.apache.hadoop.conf.Configuration conf) {
        try {
            return this.newSslConnConfigurator(60000, conf);
        }
        catch (Exception e) {
            LOG.debug("Cannot load customized ssl related configuration. Fallback to system-generic settings.", (Throwable)e);
            return DEFAULT_TIMEOUT_CONN_CONFIGURATOR;
        }
    }

    private ConnectionConfigurator newSslConnConfigurator(final int timeout, org.apache.hadoop.conf.Configuration conf) throws IOException, GeneralSecurityException {
        this.factory = this.getSSLFactory(conf);
        final SSLSocketFactory sf = this.factory.createSSLSocketFactory();
        final HostnameVerifier hv = this.factory.getHostnameVerifier();
        return new ConnectionConfigurator(){

            public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection c = (HttpsURLConnection)conn;
                    c.setSSLSocketFactory(sf);
                    c.setHostnameVerifier(hv);
                }
                SecureClientUtils.setTimeouts(conn, timeout);
                return conn;
            }
        };
    }

    public SSLFactory getSSLFactory(org.apache.hadoop.conf.Configuration conf) throws IOException, GeneralSecurityException {
        if (this.factory == null) {
            this.factory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
            this.factory.init();
        }
        return this.factory;
    }

    public void destroyFactory() {
        if (this.factory != null) {
            this.factory.destroy();
            this.factory = null;
        }
    }

    private static void setTimeouts(URLConnection connection, int socketTimeout) {
        connection.setConnectTimeout(socketTimeout);
        connection.setReadTimeout(socketTimeout);
    }

    private static File getSSLClientFile(String confLocation) throws AtlasException {
        File sslDir;
        try {
            if (confLocation == null) {
                String persistDir = null;
                URL resource = SecureClientUtils.class.getResource("/");
                if (resource != null) {
                    persistDir = resource.toURI().getPath();
                }
                assert (persistDir != null);
                sslDir = new File(persistDir);
            } else {
                sslDir = new File(confLocation);
            }
            LOG.info("ssl-client.xml will be created in {}", (Object)sslDir);
        }
        catch (Exception e) {
            throw new AtlasException("Failed to find client configuration directory", (Throwable)e);
        }
        return new File(sslDir, "ssl-client.xml");
    }

    public static void persistSSLClientConfiguration(Configuration clientConfig, String confLocation) throws AtlasException, IOException {
        org.apache.hadoop.conf.Configuration configuration = new org.apache.hadoop.conf.Configuration(false);
        File sslClientFile = SecureClientUtils.getSSLClientFile(confLocation);
        if (!sslClientFile.exists()) {
            configuration.set("ssl.client.truststore.type", "jks");
            configuration.set("ssl.client.truststore.location", clientConfig.getString("truststore.file"));
            if (clientConfig.getBoolean("client.auth.enabled", false)) {
                configuration.set("ssl.client.keystore.location", clientConfig.getString("keystore.file"));
                configuration.set("ssl.client.keystore.type", "jks");
            }
            configuration.set("hadoop.security.credential.provider.path", clientConfig.getString("cert.stores.credential.provider.path"));
            String hostnameVerifier = clientConfig.getString("hadoop.ssl.hostname.verifier");
            if (hostnameVerifier != null) {
                configuration.set("hadoop.ssl.hostname.verifier", hostnameVerifier);
            }
            configuration.writeXml((Writer)new FileWriter(sslClientFile));
        }
    }

    public URLConnectionClientHandler getUrlConnectionClientHandler() {
        return new URLConnectionClientHandler(new HttpURLConnectionFactory(){

            public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                if (connection instanceof HttpsURLConnection) {
                    LOG.debug("Attempting to configure HTTPS connection using client configuration");
                    try {
                        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
                        conf.addResource(conf.get("hadoop.ssl.client.conf", "ssl-client.xml"));
                        UserGroupInformation.setConfiguration((org.apache.hadoop.conf.Configuration)conf);
                        HttpsURLConnection c = (HttpsURLConnection)connection;
                        SSLFactory factory = SecureClientUtils.this.getSSLFactory(conf);
                        SSLSocketFactory sf = factory.createSSLSocketFactory();
                        HostnameVerifier hv = factory.getHostnameVerifier();
                        c.setSSLSocketFactory(sf);
                        c.setHostnameVerifier(hv);
                    }
                    catch (Exception e) {
                        LOG.info("Unable to configure HTTPS connection from configuration.  Leveraging JDK properties.");
                    }
                }
                return connection;
            }
        });
    }
}

