/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.atlas.AtlasBaseClient;
import org.apache.atlas.AtlasException;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.lineage.AtlasLineageInfo;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public class AtlasClientV2
extends AtlasBaseClient {
    public static final String TYPES_API = "api/atlas/v2/types/";
    public static final String ENTITY_API = "api/atlas/v2/entity/";
    private static final String PREFIX_ATTR = "attr:";
    private static final String TYPEDEFS_API = "api/atlas/v2/types/typedefs/";
    private static final String TYPEDEF_BY_NAME = "api/atlas/v2/types/typedef/name/";
    private static final String TYPEDEF_BY_GUID = "api/atlas/v2/types/typedef/guid/";
    private static final String GET_BY_NAME_TEMPLATE = "api/atlas/v2/types/%s/name/%s";
    private static final String GET_BY_GUID_TEMPLATE = "api/atlas/v2/types/%s/guid/%s";
    private static final String ENTITY_BULK_API = "api/atlas/v2/entity/bulk/";
    private static final String LINEAGE_URI = "api/atlas/v2/lineage/";
    private static final String DISCOVERY_URI = "api/atlas/v2/search";
    private static final String DSL_URI = "api/atlas/v2/search/dsl";
    private static final String FULL_TEXT_URI = "api/atlas/v2/search/fulltext";
    private static final String BASIC_SEARCH_URI = "api/atlas/v2/search/basic";
    private static final String FACETED_SEARCH_URI = "api/atlas/v2/search/basic";
    private static final String RELATIONSHIPS_URI = "api/atlas/v2/relationship/";

    public AtlasClientV2(String[] baseUrl, String[] basicAuthUserNamePassword) {
        super(baseUrl, basicAuthUserNamePassword);
    }

    public AtlasClientV2(String ... baseUrls) throws AtlasException {
        super(baseUrls);
    }

    public AtlasClientV2(UserGroupInformation ugi, String doAsUser, String ... baseUrls) {
        super(ugi, doAsUser, baseUrls);
    }

    public AtlasClientV2(String[] baseUrl, String cookieName, String value, String path, String domain) {
        super(baseUrl, new Cookie(cookieName, value, path, domain));
    }

    public AtlasClientV2(String[] baseUrl, Cookie cookie) {
        super(baseUrl, cookie);
    }

    public AtlasClientV2(Configuration configuration, String[] baseUrl, String[] basicAuthUserNamePassword) {
        super(configuration, baseUrl, basicAuthUserNamePassword);
    }

    @VisibleForTesting
    AtlasClientV2(WebResource service, Configuration configuration) {
        super(service, configuration);
    }

    public AtlasTypesDef getAllTypeDefs(SearchFilter searchFilter) throws AtlasServiceException {
        return (AtlasTypesDef)this.callAPI(API_V2.GET_ALL_TYPE_DEFS, AtlasTypesDef.class, searchFilter.getParams());
    }

    public boolean typeWithGuidExists(String guid) {
        try {
            this.callAPI(API_V2.GET_TYPEDEF_BY_GUID, String.class, null, new String[]{guid});
        }
        catch (AtlasServiceException e) {
            return false;
        }
        return true;
    }

    public boolean typeWithNameExists(String name) {
        try {
            this.callAPI(API_V2.GET_TYPEDEF_BY_NAME, String.class, null, new String[]{name});
        }
        catch (AtlasServiceException e) {
            return false;
        }
        return true;
    }

    public AtlasEnumDef getEnumDefByName(String name) throws AtlasServiceException {
        return this.getTypeDefByName(name, AtlasEnumDef.class);
    }

    public AtlasEnumDef getEnumDefByGuid(String guid) throws AtlasServiceException {
        return this.getTypeDefByGuid(guid, AtlasEnumDef.class);
    }

    public AtlasStructDef getStructDefByName(String name) throws AtlasServiceException {
        return this.getTypeDefByName(name, AtlasStructDef.class);
    }

    public AtlasStructDef getStructDefByGuid(String guid) throws AtlasServiceException {
        return this.getTypeDefByGuid(guid, AtlasStructDef.class);
    }

    public AtlasClassificationDef getClassificationDefByName(String name) throws AtlasServiceException {
        return this.getTypeDefByName(name, AtlasClassificationDef.class);
    }

    public AtlasClassificationDef getClassificationDefByGuid(String guid) throws AtlasServiceException {
        return this.getTypeDefByGuid(guid, AtlasClassificationDef.class);
    }

    public AtlasEntityDef getEntityDefByName(String name) throws AtlasServiceException {
        return this.getTypeDefByName(name, AtlasEntityDef.class);
    }

    public AtlasEntityDef getEntityDefByGuid(String guid) throws AtlasServiceException {
        return this.getTypeDefByGuid(guid, AtlasEntityDef.class);
    }

    @Deprecated
    public AtlasEnumDef createEnumDef(AtlasEnumDef enumDef) throws AtlasServiceException {
        AtlasTypesDef atlasTypesDef = new AtlasTypesDef();
        atlasTypesDef.getEnumDefs().add(enumDef);
        AtlasTypesDef created = this.createAtlasTypeDefs(atlasTypesDef);
        assert (created != null);
        assert (created.getEnumDefs() != null);
        return (AtlasEnumDef)created.getEnumDefs().get(0);
    }

    @Deprecated
    public AtlasStructDef createStructDef(AtlasStructDef structDef) throws AtlasServiceException {
        AtlasTypesDef atlasTypesDef = new AtlasTypesDef();
        atlasTypesDef.getStructDefs().add(structDef);
        AtlasTypesDef created = this.createAtlasTypeDefs(atlasTypesDef);
        assert (created != null);
        assert (created.getStructDefs() != null);
        return (AtlasStructDef)created.getStructDefs().get(0);
    }

    @Deprecated
    public AtlasEntityDef createEntityDef(AtlasEntityDef entityDef) throws AtlasServiceException {
        AtlasTypesDef atlasTypesDef = new AtlasTypesDef();
        atlasTypesDef.getEntityDefs().add(entityDef);
        AtlasTypesDef created = this.createAtlasTypeDefs(atlasTypesDef);
        assert (created != null);
        assert (created.getEntityDefs() != null);
        return (AtlasEntityDef)created.getEntityDefs().get(0);
    }

    @Deprecated
    public AtlasClassificationDef createClassificationDef(AtlasClassificationDef classificationDef) throws AtlasServiceException {
        AtlasTypesDef atlasTypesDef = new AtlasTypesDef();
        atlasTypesDef.getClassificationDefs().add(classificationDef);
        AtlasTypesDef created = this.createAtlasTypeDefs(atlasTypesDef);
        assert (created != null);
        assert (created.getClassificationDefs() != null);
        return (AtlasClassificationDef)created.getClassificationDefs().get(0);
    }

    public AtlasTypesDef createAtlasTypeDefs(AtlasTypesDef typesDef) throws AtlasServiceException {
        return (AtlasTypesDef)this.callAPI(API_V2.CREATE_ALL_TYPE_DEFS, AtlasTypesDef.class, AtlasType.toJson((Object)typesDef), new String[0]);
    }

    public AtlasTypesDef updateAtlasTypeDefs(AtlasTypesDef typesDef) throws AtlasServiceException {
        return (AtlasTypesDef)this.callAPI(API_V2.UPDATE_ALL_TYPE_DEFS, AtlasTypesDef.class, AtlasType.toJson((Object)typesDef), new String[0]);
    }

    public void deleteAtlasTypeDefs(AtlasTypesDef typesDef) throws AtlasServiceException {
        this.callAPI(API_V2.DELETE_ALL_TYPE_DEFS, null, AtlasType.toJson((Object)typesDef), new String[0]);
    }

    public AtlasLineageInfo getLineageInfo(String guid, AtlasLineageInfo.LineageDirection direction, int depth) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"direction", (Object)direction.toString());
        queryParams.add((Object)"depth", (Object)String.valueOf(depth));
        return (AtlasLineageInfo)this.callAPI(API_V2.LINEAGE_INFO, AtlasLineageInfo.class, (MultivaluedMap)queryParams, new String[]{guid});
    }

    public AtlasEntity.AtlasEntityWithExtInfo getEntityByGuid(String guid) throws AtlasServiceException {
        return (AtlasEntity.AtlasEntityWithExtInfo)this.callAPI(API_V2.GET_ENTITY_BY_GUID, AtlasEntity.AtlasEntityWithExtInfo.class, null, new String[]{guid});
    }

    public AtlasEntity.AtlasEntityWithExtInfo getEntityByAttribute(String type, Map<String, String> attributes) throws AtlasServiceException {
        MultivaluedMap<String, String> queryParams = this.attributesToQueryParams(attributes);
        return (AtlasEntity.AtlasEntityWithExtInfo)this.callAPI(API_V2.GET_ENTITY_BY_ATTRIBUTE, AtlasEntity.AtlasEntityWithExtInfo.class, queryParams, new String[]{type});
    }

    public EntityMutationResponse updateEntityByAttribute(String type, Map<String, String> attributes, AtlasEntity.AtlasEntityWithExtInfo entityInfo) throws AtlasServiceException {
        MultivaluedMap<String, String> queryParams = this.attributesToQueryParams(attributes);
        return (EntityMutationResponse)this.callAPI(API_V2.UPDATE_ENTITY_BY_ATTRIBUTE, EntityMutationResponse.class, entityInfo, queryParams, new String[]{type});
    }

    public EntityMutationResponse deleteEntityByAttribute(String type, Map<String, String> attributes) throws AtlasServiceException {
        MultivaluedMap<String, String> queryParams = this.attributesToQueryParams(attributes);
        return (EntityMutationResponse)this.callAPI(API_V2.DELETE_ENTITY_BY_ATTRIBUTE, EntityMutationResponse.class, queryParams, new String[]{type});
    }

    public EntityMutationResponse createEntity(AtlasEntity.AtlasEntityWithExtInfo entity) throws AtlasServiceException {
        return (EntityMutationResponse)this.callAPI(API_V2.CREATE_ENTITY, EntityMutationResponse.class, entity, new String[0]);
    }

    public EntityMutationResponse updateEntity(AtlasEntity.AtlasEntityWithExtInfo entity) throws AtlasServiceException {
        return (EntityMutationResponse)this.callAPI(API_V2.UPDATE_ENTITY, EntityMutationResponse.class, entity, new String[0]);
    }

    public EntityMutationResponse deleteEntityByGuid(String guid) throws AtlasServiceException {
        return (EntityMutationResponse)this.callAPI(API_V2.DELETE_ENTITY_BY_GUID, EntityMutationResponse.class, null, new String[]{guid});
    }

    public AtlasEntity.AtlasEntitiesWithExtInfo getEntitiesByGuids(List<String> guids) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.put((Object)"guid", guids);
        return (AtlasEntity.AtlasEntitiesWithExtInfo)this.callAPI(API_V2.GET_ENTITIES_BY_GUIDS, AtlasEntity.AtlasEntitiesWithExtInfo.class, (MultivaluedMap)queryParams);
    }

    public EntityMutationResponse createEntities(AtlasEntity.AtlasEntitiesWithExtInfo atlasEntities) throws AtlasServiceException {
        return (EntityMutationResponse)this.callAPI(API_V2.CREATE_ENTITIES, EntityMutationResponse.class, atlasEntities, new String[0]);
    }

    public EntityMutationResponse updateEntities(AtlasEntity.AtlasEntitiesWithExtInfo atlasEntities) throws AtlasServiceException {
        return (EntityMutationResponse)this.callAPI(API_V2.UPDATE_ENTITIES, EntityMutationResponse.class, atlasEntities, new String[0]);
    }

    public EntityMutationResponse deleteEntitiesByGuids(List<String> guids) throws AtlasServiceException {
        return (EntityMutationResponse)this.callAPI(API_V2.DELETE_ENTITIES_BY_GUIDS, EntityMutationResponse.class, "guid", guids);
    }

    public AtlasClassification.AtlasClassifications getClassifications(String guid) throws AtlasServiceException {
        return (AtlasClassification.AtlasClassifications)this.callAPI(this.formatPathParameters(API_V2.GET_CLASSIFICATIONS, guid), AtlasClassification.AtlasClassifications.class, null);
    }

    public void addClassifications(String guid, List<AtlasClassification> classifications) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.ADD_CLASSIFICATIONS, guid), null, classifications, null);
    }

    public void updateClassifications(String guid, List<AtlasClassification> classifications) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.UPDATE_CLASSIFICATIONS, guid), AtlasClassification.AtlasClassifications.class, classifications, new String[0]);
    }

    public void deleteClassifications(String guid, List<AtlasClassification> classifications) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.GET_CLASSIFICATIONS, guid), AtlasClassification.AtlasClassifications.class, classifications, new String[0]);
    }

    public void deleteClassification(String guid, String classificationName) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.DELETE_CLASSIFICATION, guid, classificationName), null, null);
    }

    public AtlasSearchResult dslSearch(String query) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"query", (Object)query);
        return (AtlasSearchResult)this.callAPI(API_V2.DSL_SEARCH, AtlasSearchResult.class, (MultivaluedMap)queryParams);
    }

    public AtlasSearchResult dslSearchWithParams(String query, int limit, int offset) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"query", (Object)query);
        queryParams.add((Object)"limit", (Object)String.valueOf(limit));
        queryParams.add((Object)"offset", (Object)String.valueOf(offset));
        return (AtlasSearchResult)this.callAPI(API_V2.DSL_SEARCH, AtlasSearchResult.class, (MultivaluedMap)queryParams);
    }

    public AtlasSearchResult fullTextSearch(String query) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"query", (Object)query);
        return (AtlasSearchResult)this.callAPI(API_V2.FULL_TEXT_SEARCH, AtlasSearchResult.class, (MultivaluedMap)queryParams);
    }

    public AtlasSearchResult fullTextSearchWithParams(String query, int limit, int offset) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"query", (Object)query);
        queryParams.add((Object)"limit", (Object)String.valueOf(limit));
        queryParams.add((Object)"offset", (Object)String.valueOf(offset));
        return (AtlasSearchResult)this.callAPI(API_V2.FULL_TEXT_SEARCH, AtlasSearchResult.class, (MultivaluedMap)queryParams);
    }

    public AtlasSearchResult basicSearch(String typeName, String classification, String query, boolean excludeDeletedEntities, int limit, int offset) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"typeName", (Object)typeName);
        queryParams.add((Object)"classification", (Object)classification);
        queryParams.add((Object)"query", (Object)query);
        queryParams.add((Object)"excludeDeletedEntities", (Object)String.valueOf(excludeDeletedEntities));
        queryParams.add((Object)"limit", (Object)String.valueOf(limit));
        queryParams.add((Object)"offset", (Object)String.valueOf(offset));
        return (AtlasSearchResult)this.callAPI(API_V2.BASIC_SEARCH, AtlasSearchResult.class, (MultivaluedMap)queryParams);
    }

    public AtlasSearchResult facetedSearch(SearchParameters searchParameters) throws AtlasServiceException {
        return (AtlasSearchResult)this.callAPI(API_V2.FACETED_SEARCH, AtlasSearchResult.class, searchParameters, new String[0]);
    }

    public AtlasRelationship getRelationshipByGuid(String guid) throws AtlasServiceException {
        return (AtlasRelationship)this.callAPI(API_V2.GET_RELATIONSHIP_BY_GUID, AtlasRelationship.class, null, new String[]{guid});
    }

    public void deleteRelationshipByGuid(String guid) throws AtlasServiceException {
        this.callAPI(API_V2.DELETE_RELATIONSHIP_BY_GUID, null, null, new String[]{guid});
    }

    public AtlasRelationship createRelationship(AtlasRelationship relationship) throws AtlasServiceException {
        return (AtlasRelationship)this.callAPI(API_V2.CREATE_RELATIONSHIP, AtlasRelationship.class, relationship, new String[0]);
    }

    public AtlasRelationship updateRelationship(AtlasRelationship relationship) throws AtlasServiceException {
        return (AtlasRelationship)this.callAPI(API_V2.UPDATE_RELATIONSHIP, AtlasRelationship.class, relationship, new String[0]);
    }

    protected AtlasBaseClient.API formatPathParameters(AtlasBaseClient.API api, String ... params) {
        return new AtlasBaseClient.API(String.format(api.getPath(), params), api.getMethod(), api.getExpectedStatus());
    }

    private MultivaluedMap<String, String> attributesToQueryParams(Map<String, String> attributes) {
        return this.attributesToQueryParams(attributes, null);
    }

    private MultivaluedMap<String, String> attributesToQueryParams(Map<String, String> attributes, MultivaluedMap<String, String> queryParams) {
        if (queryParams == null) {
            queryParams = new MultivaluedMapImpl();
        }
        if (MapUtils.isNotEmpty(attributes)) {
            for (Map.Entry<String, String> e : attributes.entrySet()) {
                queryParams.putSingle((Object)(PREFIX_ATTR + e.getKey()), (Object)e.getValue());
            }
        }
        return queryParams;
    }

    private <T> T getTypeDefByName(String name, Class<T> typeDefClass) throws AtlasServiceException {
        String atlasPath = this.getAtlasPath(typeDefClass);
        AtlasBaseClient.API api = new AtlasBaseClient.API(String.format(GET_BY_NAME_TEMPLATE, atlasPath, name), "GET", Response.Status.OK);
        return (T)this.callAPI(api, typeDefClass, null);
    }

    private <T> T getTypeDefByGuid(String guid, Class<T> typeDefClass) throws AtlasServiceException {
        String atlasPath = this.getAtlasPath(typeDefClass);
        AtlasBaseClient.API api = new AtlasBaseClient.API(String.format(GET_BY_GUID_TEMPLATE, atlasPath, guid), "GET", Response.Status.OK);
        return (T)this.callAPI(api, typeDefClass, null);
    }

    private <T> String getAtlasPath(Class<T> typeDefClass) {
        if (AtlasEnumDef.class.isAssignableFrom(typeDefClass)) {
            return "enumdef";
        }
        if (AtlasEntityDef.class.isAssignableFrom(typeDefClass)) {
            return "entitydef";
        }
        if (AtlasClassificationDef.class.isAssignableFrom(typeDefClass)) {
            return "classificationdef";
        }
        if (AtlasStructDef.class.isAssignableFrom(typeDefClass)) {
            return "structdef";
        }
        return "";
    }

    public static class API_V2
    extends AtlasBaseClient.API {
        public static final API_V2 GET_TYPEDEF_BY_NAME = new API_V2("api/atlas/v2/types/typedef/name/", "GET", Response.Status.OK);
        public static final API_V2 GET_TYPEDEF_BY_GUID = new API_V2("api/atlas/v2/types/typedef/guid/", "GET", Response.Status.OK);
        public static final API_V2 GET_ALL_TYPE_DEFS = new API_V2("api/atlas/v2/types/typedefs/", "GET", Response.Status.OK);
        public static final API_V2 CREATE_ALL_TYPE_DEFS = new API_V2("api/atlas/v2/types/typedefs/", "POST", Response.Status.OK);
        public static final API_V2 UPDATE_ALL_TYPE_DEFS = new API_V2("api/atlas/v2/types/typedefs/", "PUT", Response.Status.OK);
        public static final API_V2 DELETE_ALL_TYPE_DEFS = new API_V2("api/atlas/v2/types/typedefs/", "DELETE", Response.Status.NO_CONTENT);
        public static final API_V2 GET_ENTITY_BY_GUID = new API_V2("api/atlas/v2/entity/guid/", "GET", Response.Status.OK);
        public static final API_V2 GET_ENTITY_BY_ATTRIBUTE = new API_V2("api/atlas/v2/entity/uniqueAttribute/type/", "GET", Response.Status.OK);
        public static final API_V2 CREATE_ENTITY = new API_V2("api/atlas/v2/entity/", "POST", Response.Status.OK);
        public static final API_V2 UPDATE_ENTITY = new API_V2("api/atlas/v2/entity/", "POST", Response.Status.OK);
        public static final API_V2 UPDATE_ENTITY_BY_ATTRIBUTE = new API_V2("api/atlas/v2/entity/uniqueAttribute/type/", "PUT", Response.Status.OK);
        public static final API_V2 DELETE_ENTITY_BY_GUID = new API_V2("api/atlas/v2/entity/guid/", "DELETE", Response.Status.OK);
        public static final API_V2 DELETE_ENTITY_BY_ATTRIBUTE = new API_V2("api/atlas/v2/entity/uniqueAttribute/type/", "DELETE", Response.Status.OK);
        public static final API_V2 GET_ENTITIES_BY_GUIDS = new API_V2("api/atlas/v2/entity/bulk/", "GET", Response.Status.OK);
        public static final API_V2 CREATE_ENTITIES = new API_V2("api/atlas/v2/entity/bulk/", "POST", Response.Status.OK);
        public static final API_V2 UPDATE_ENTITIES = new API_V2("api/atlas/v2/entity/bulk/", "POST", Response.Status.OK);
        public static final API_V2 DELETE_ENTITIES_BY_GUIDS = new API_V2("api/atlas/v2/entity/bulk/", "DELETE", Response.Status.OK);
        public static final API_V2 GET_CLASSIFICATIONS = new API_V2("api/atlas/v2/entity/guid/%s/classifications", "GET", Response.Status.OK);
        public static final API_V2 ADD_CLASSIFICATIONS = new API_V2("api/atlas/v2/entity/guid/%s/classifications", "POST", Response.Status.NO_CONTENT);
        public static final API_V2 UPDATE_CLASSIFICATIONS = new API_V2("api/atlas/v2/entity/guid/%s/classifications", "PUT", Response.Status.OK);
        public static final API_V2 DELETE_CLASSIFICATION = new API_V2("api/atlas/v2/entity/guid/%s/classification/%s", "DELETE", Response.Status.NO_CONTENT);
        public static final API_V2 LINEAGE_INFO = new API_V2("api/atlas/v2/lineage/", "GET", Response.Status.OK);
        public static final API_V2 DSL_SEARCH = new API_V2("api/atlas/v2/search/dsl", "GET", Response.Status.OK);
        public static final API_V2 FULL_TEXT_SEARCH = new API_V2("api/atlas/v2/search/fulltext", "GET", Response.Status.OK);
        public static final API_V2 BASIC_SEARCH = new API_V2("api/atlas/v2/search/basic", "GET", Response.Status.OK);
        public static final API_V2 FACETED_SEARCH = new API_V2("api/atlas/v2/search/basic", "POST", Response.Status.OK);
        public static final API_V2 GET_RELATIONSHIP_BY_GUID = new API_V2("api/atlas/v2/relationship/guid/", "GET", Response.Status.OK);
        public static final API_V2 DELETE_RELATIONSHIP_BY_GUID = new API_V2("api/atlas/v2/relationship/guid/", "DELETE", Response.Status.NO_CONTENT);
        public static final API_V2 CREATE_RELATIONSHIP = new API_V2("api/atlas/v2/relationship/", "POST", Response.Status.OK);
        public static final API_V2 UPDATE_RELATIONSHIP = new API_V2("api/atlas/v2/relationship/", "PUT", Response.Status.OK);

        private API_V2(String path, String method, Response.Status status) {
            super(path, method, status);
        }
    }
}

