/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.tinkerpop.query.expr;

import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.repository.graphdb.tinkerpop.query.NativeTinkerpopGraphQuery;
import org.apache.atlas.repository.graphdb.tinkerpop.query.NativeTinkerpopQueryFactory;
import org.apache.atlas.repository.graphdb.tinkerpop.query.expr.QueryPredicate;

public class AndCondition {
    private List<QueryPredicate> children = new ArrayList<QueryPredicate>();

    public void andWith(QueryPredicate predicate) {
        this.children.add(predicate);
    }

    public void andWith(List<QueryPredicate> predicates) {
        this.children.addAll(predicates);
    }

    public AndCondition copy() {
        AndCondition builder = new AndCondition();
        builder.children.addAll(this.children);
        return builder;
    }

    public List<QueryPredicate> getTerms() {
        return this.children;
    }

    public <V, E> NativeTinkerpopGraphQuery<V, E> create(NativeTinkerpopQueryFactory<V, E> factory) {
        NativeTinkerpopGraphQuery<V, E> query = factory.createNativeTinkerpopQuery();
        for (QueryPredicate predicate : this.children) {
            predicate.addTo(query);
        }
        return query;
    }

    public String toString() {
        return "AndExpr [predicates=" + this.children + "]";
    }
}

