/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.BiPredicate;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusEdge;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraph;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraphDatabase;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusVertex;
import org.apache.atlas.repository.graphdb.tinkerpop.query.NativeTinkerpopGraphQuery;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.janusgraph.core.JanusGraphQuery;
import org.janusgraph.core.attribute.Contain;
import org.janusgraph.core.attribute.Text;
import org.janusgraph.graphdb.query.JanusGraphPredicate;

public class NativeJanusGraphQuery
implements NativeTinkerpopGraphQuery<AtlasJanusVertex, AtlasJanusEdge> {
    private AtlasJanusGraph graph;
    private JanusGraphQuery<?> query = AtlasJanusGraphDatabase.getGraphInstance().query();

    public NativeJanusGraphQuery(AtlasJanusGraph graph) {
        this.graph = graph;
    }

    public Iterable<AtlasVertex<AtlasJanusVertex, AtlasJanusEdge>> vertices() {
        Iterable it = this.query.vertices();
        return this.graph.wrapVertices(it);
    }

    public Iterable<AtlasEdge<AtlasJanusVertex, AtlasJanusEdge>> edges() {
        Iterable it = this.query.edges();
        return this.graph.wrapEdges(it);
    }

    public Iterable<AtlasVertex<AtlasJanusVertex, AtlasJanusEdge>> vertices(int limit) {
        Iterable it = this.query.limit(limit).vertices();
        return this.graph.wrapVertices(it);
    }

    public Iterable<AtlasVertex<AtlasJanusVertex, AtlasJanusEdge>> vertices(int offset, int limit) {
        ArrayList result = new ArrayList(limit);
        Iterator iter = this.query.limit(offset + limit).vertices().iterator();
        long resultIdx = 0L;
        while (iter.hasNext() && result.size() < limit) {
            if (resultIdx >= (long)offset) {
                result.add(iter.next());
            }
            ++resultIdx;
        }
        return this.graph.wrapVertices(result);
    }

    public void in(String propertyName, Collection<? extends Object> values) {
        this.query.has(propertyName, (JanusGraphPredicate)Contain.IN, values);
    }

    public void has(String propertyName, AtlasGraphQuery.QueryOperator op, Object value) {
        Text pred;
        if (op instanceof AtlasGraphQuery.ComparisionOperator) {
            Compare c = this.getGremlinPredicate((AtlasGraphQuery.ComparisionOperator)op);
            pred = JanusGraphPredicate.Converter.convert((BiPredicate)c);
        } else {
            pred = this.getGremlinPredicate((AtlasGraphQuery.MatchingOperator)op);
        }
        this.query.has(propertyName, (JanusGraphPredicate)pred, value);
    }

    private Text getGremlinPredicate(AtlasGraphQuery.MatchingOperator op) {
        switch (op) {
            case CONTAINS: {
                return Text.CONTAINS;
            }
            case PREFIX: {
                return Text.PREFIX;
            }
            case SUFFIX: {
                return Text.CONTAINS_REGEX;
            }
            case REGEX: {
                return Text.REGEX;
            }
        }
        throw new RuntimeException("Unsupported matching operator:" + op);
    }

    private Compare getGremlinPredicate(AtlasGraphQuery.ComparisionOperator op) {
        switch (op) {
            case EQUAL: {
                return Compare.eq;
            }
            case GREATER_THAN: {
                return Compare.gt;
            }
            case GREATER_THAN_EQUAL: {
                return Compare.gte;
            }
            case LESS_THAN: {
                return Compare.lt;
            }
            case LESS_THAN_EQUAL: {
                return Compare.lte;
            }
            case NOT_EQUAL: {
                return Compare.neq;
            }
        }
        throw new RuntimeException("Unsupported comparison operator:" + op);
    }
}

