/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus.migration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypesWithCollectionsFinder {
    private static final Logger LOG = LoggerFactory.getLogger(TypesWithCollectionsFinder.class);
    static final EnumSet<TypeCategory> nonPrimitives = EnumSet.of(TypeCategory.ENTITY, TypeCategory.STRUCT, TypeCategory.OBJECT_ID_TYPE);

    public static Map<String, Map<String, List<String>>> getVertexPropertiesForCollectionAttributes(AtlasTypeRegistry typeRegistry) {
        HashMap<String, Map<String, List<String>>> ret = new HashMap<String, Map<String, List<String>>>();
        TypesWithCollectionsFinder.addVertexPropertiesForCollectionAttributes(typeRegistry.getAllEntityTypes(), ret);
        TypesWithCollectionsFinder.addVertexPropertiesForCollectionAttributes(typeRegistry.getAllStructTypes(), ret);
        TypesWithCollectionsFinder.addVertexPropertiesForCollectionAttributes(typeRegistry.getAllClassificationTypes(), ret);
        TypesWithCollectionsFinder.displayInfo("types with properties: ", ret);
        return ret;
    }

    private static void addVertexPropertiesForCollectionAttributes(Collection<? extends AtlasStructType> types, Map<String, Map<String, List<String>>> typeAttrMap) {
        for (AtlasStructType atlasStructType : types) {
            Map<String, List<String>> collectionProperties = TypesWithCollectionsFinder.getVertexPropertiesForCollectionAttributes(atlasStructType);
            if (collectionProperties == null || collectionProperties.size() <= 0) continue;
            typeAttrMap.put(atlasStructType.getTypeName(), collectionProperties);
        }
    }

    static Map<String, List<String>> getVertexPropertiesForCollectionAttributes(AtlasStructType type) {
        try {
            HashMap<String, List<String>> collectionProperties = new HashMap<String, List<String>>();
            for (AtlasStructType.AtlasAttribute attr : type.getAllAttributes().values()) {
                TypesWithCollectionsFinder.addIfCollectionAttribute(attr, collectionProperties);
            }
            if (type instanceof AtlasEntityType) {
                AtlasEntityType entityType = (AtlasEntityType)type;
                for (Map attrs : entityType.getRelationshipAttributes().values()) {
                    for (AtlasStructType.AtlasAttribute attr : attrs.values()) {
                        TypesWithCollectionsFinder.addIfCollectionAttribute(attr, collectionProperties);
                    }
                }
            }
            return collectionProperties;
        }
        catch (Exception e) {
            LOG.error("addVertexPropertiesForCollectionAttributes", (Throwable)e);
            return null;
        }
    }

    private static void addIfCollectionAttribute(AtlasStructType.AtlasAttribute attr, Map<String, List<String>> collectionProperties) {
        AtlasType attrType = attr.getAttributeType();
        TypeCategory attrTypeCategory = attrType.getTypeCategory();
        switch (attrTypeCategory) {
            case ARRAY: {
                TypeCategory arrayElementType = ((AtlasArrayType)attrType).getElementType().getTypeCategory();
                if (!nonPrimitives.contains(arrayElementType)) break;
                TypesWithCollectionsFinder.addVertexProperty(attrTypeCategory.toString(), attr.getVertexPropertyName(), collectionProperties);
                break;
            }
            case MAP: {
                TypeCategory mapValueType = ((AtlasMapType)attrType).getValueType().getTypeCategory();
                if (nonPrimitives.contains(mapValueType)) {
                    TypesWithCollectionsFinder.addVertexProperty(attrTypeCategory.toString(), attr.getVertexPropertyName(), collectionProperties);
                    break;
                }
                TypesWithCollectionsFinder.addVertexProperty(attrTypeCategory.toString() + "_PRIMITIVE", attr.getVertexPropertyName(), collectionProperties);
            }
        }
    }

    private static void addVertexProperty(String collectionType, String propertyName, Map<String, List<String>> collectionProperties) {
        if (!collectionProperties.containsKey(collectionType)) {
            collectionProperties.put(collectionType, new ArrayList());
        }
        collectionProperties.get(collectionType).add(propertyName);
    }

    static void displayInfo(String message, Map<String, Map<String, List<String>>> map) {
        LOG.info(message);
        for (Map.Entry<String, Map<String, List<String>>> e : map.entrySet()) {
            LOG.info("  type: {} : {}", (Object)e.getKey(), e.getValue());
        }
    }
}

