/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus.migration.pc;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.atlas.repository.graphdb.janus.migration.pc.WorkItemBuilder;
import org.apache.atlas.repository.graphdb.janus.migration.pc.WorkItemConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemManager<T, U extends WorkItemConsumer> {
    private static final Logger LOG = LoggerFactory.getLogger(WorkItemManager.class);
    private final BlockingQueue<T> workQueue;
    private final ExecutorService service;
    private final List<U> consumers = new ArrayList<U>();

    public WorkItemManager(WorkItemBuilder builder, int batchSize, int numWorkers) {
        this.workQueue = new LinkedBlockingQueue<T>(batchSize * numWorkers);
        this.service = Executors.newFixedThreadPool(numWorkers);
        for (int i = 0; i < numWorkers; ++i) {
            WorkItemConsumer c = (WorkItemConsumer)builder.build(this.workQueue);
            this.service.submit(c);
            this.consumers.add(c);
        }
    }

    public void produce(T item) {
        try {
            this.workQueue.put(item);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public void shutdown() throws InterruptedException {
        int avgCommitTimeSeconds = this.getAvgCommitTimeSeconds() * 2;
        LOG.info("WorkItemManager: Shutdown started. Will wait for: {} minutes...", (Object)avgCommitTimeSeconds);
        this.service.shutdown();
        this.service.awaitTermination(avgCommitTimeSeconds, TimeUnit.MINUTES);
        LOG.info("WorkItemManager: Shutdown done!");
    }

    private int getAvgCommitTimeSeconds() {
        int commitTimeSeconds = 0;
        for (WorkItemConsumer c : this.consumers) {
            commitTimeSeconds = (int)((long)commitTimeSeconds + c.getMaxCommitTimeSeconds());
        }
        return commitTimeSeconds / this.consumers.size();
    }
}

