/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasSolrQueryBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasSolrQueryBuilder.class);
    private Set<AtlasEntityType> entityTypes;
    private String queryString;
    private SearchParameters.FilterCriteria criteria;
    private boolean excludeDeletedEntities;
    private boolean includeSubtypes;
    private Map<String, String> indexFieldNameCache;
    public static final char CUSTOM_ATTR_SEPARATOR = '=';
    public static final String CUSTOM_ATTR_SEARCH_FORMAT = "\"\\\"%s\\\":\\\"%s\\\"\"";

    public AtlasSolrQueryBuilder withEntityTypes(Set<AtlasEntityType> searchForEntityTypes) {
        this.entityTypes = searchForEntityTypes;
        return this;
    }

    public AtlasSolrQueryBuilder withQueryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public AtlasSolrQueryBuilder withCriteria(SearchParameters.FilterCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    public AtlasSolrQueryBuilder withExcludedDeletedEntities(boolean excludeDeletedEntities) {
        this.excludeDeletedEntities = excludeDeletedEntities;
        return this;
    }

    public AtlasSolrQueryBuilder withIncludeSubTypes(boolean includeSubTypes) {
        this.includeSubtypes = includeSubTypes;
        return this;
    }

    public AtlasSolrQueryBuilder withCommonIndexFieldNames(Map<String, String> indexFieldNameCache) {
        this.indexFieldNameCache = indexFieldNameCache;
        return this;
    }

    public String build() throws AtlasBaseException {
        StringBuilder queryBuilder = new StringBuilder();
        boolean isAndNeeded = false;
        if (StringUtils.isNotEmpty((String)this.queryString)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initial query string is {}.", (Object)this.queryString);
            }
            queryBuilder.append("+").append(this.queryString.trim()).append(" ");
            isAndNeeded = true;
        }
        if (this.excludeDeletedEntities) {
            if (isAndNeeded) {
                queryBuilder.append(" AND ");
            }
            this.dropDeletedEntities(queryBuilder);
            isAndNeeded = true;
        }
        if (CollectionUtils.isNotEmpty(this.entityTypes)) {
            if (isAndNeeded) {
                queryBuilder.append(" AND ");
            }
            this.buildForEntityType(queryBuilder);
            isAndNeeded = true;
        }
        if (this.criteria != null) {
            StringBuilder attrFilterQueryBuilder = new StringBuilder();
            this.withCriteria(attrFilterQueryBuilder, this.criteria);
            if (attrFilterQueryBuilder.length() != 0) {
                if (isAndNeeded) {
                    queryBuilder.append(" AND ");
                }
                queryBuilder.append(" ").append(attrFilterQueryBuilder.toString());
            }
        }
        return queryBuilder.toString();
    }

    private void buildForEntityType(StringBuilder queryBuilder) {
        String typeIndexFieldName = this.indexFieldNameCache.get(Constants.ENTITY_TYPE_PROPERTY_KEY);
        queryBuilder.append(" +").append(typeIndexFieldName).append(":(");
        HashSet<String> typesToSearch = new HashSet<String>();
        for (AtlasEntityType type : this.entityTypes) {
            if (this.includeSubtypes) {
                typesToSearch.addAll(type.getTypeAndAllSubTypes());
                continue;
            }
            typesToSearch.add(type.getTypeName());
        }
        queryBuilder.append(StringUtils.join(typesToSearch, (String)" ")).append(" ) ");
    }

    private void dropDeletedEntities(StringBuilder queryBuilder) throws AtlasBaseException {
        String indexFieldName;
        if (LOG.isDebugEnabled()) {
            LOG.debug("excluding the deleted entities.");
        }
        if ((indexFieldName = this.indexFieldNameCache.get(Constants.STATE_PROPERTY_KEY)) == null) {
            String msg = String.format("There is no index field name defined for attribute '%s'", Constants.STATE_PROPERTY_KEY);
            LOG.error(msg);
            throw new AtlasBaseException(msg);
        }
        queryBuilder.append(" -").append(indexFieldName).append(":").append(AtlasEntity.Status.DELETED.name());
    }

    private AtlasSolrQueryBuilder withCriteria(StringBuilder queryBuilder, SearchParameters.FilterCriteria criteria) throws AtlasBaseException {
        List criterion = criteria.getCriterion();
        HashSet<String> indexAttributes = new HashSet<String>();
        if (StringUtils.isNotEmpty((String)criteria.getAttributeName()) && CollectionUtils.isEmpty((Collection)criterion)) {
            String attributeName = criteria.getAttributeName();
            String attributeValue = criteria.getAttributeValue();
            SearchParameters.Operator operator = criteria.getOperator();
            ArrayList<StringBuilder> orExpQuery = new ArrayList<StringBuilder>();
            for (AtlasEntityType type : this.entityTypes) {
                String indexAttributeName = this.getIndexAttributeName(type, attributeName);
                if (indexAttributes.contains(indexAttributeName)) continue;
                StringBuilder sb = new StringBuilder();
                if (attributeName.equals(Constants.CUSTOM_ATTRIBUTES_PROPERTY_KEY)) {
                    if (operator.equals((Object)SearchParameters.Operator.CONTAINS)) {
                        operator = SearchParameters.Operator.EQ;
                    } else if (operator.equals((Object)SearchParameters.Operator.NOT_CONTAINS)) {
                        operator = SearchParameters.Operator.NEQ;
                    }
                    attributeValue = this.getIndexQueryAttributeValue(attributeValue);
                }
                if (attributeValue != null) {
                    attributeValue = attributeValue.trim();
                }
                boolean replaceWildcardChar = false;
                AtlasStructDef.AtlasAttributeDef def = type.getAttributeDef(attributeName);
                if (!this.isPipeSeparatedSystemAttribute(attributeName) && this.isWildCardOperator(operator) && def.getTypeName().equalsIgnoreCase("string")) {
                    if (def.getIndexType() == null && AtlasStructType.AtlasAttribute.hastokenizeChar((String)attributeValue)) {
                        replaceWildcardChar = true;
                    }
                    attributeValue = AtlasStructType.AtlasAttribute.escapeIndexQueryValue((String)attributeValue, (boolean)false, (boolean)false);
                } else {
                    attributeValue = AtlasStructType.AtlasAttribute.escapeIndexQueryValue((String)attributeValue);
                }
                this.withPropertyCondition(sb, indexAttributeName, operator, attributeValue, replaceWildcardChar);
                indexAttributes.add(indexAttributeName);
                orExpQuery.add(sb);
            }
            if (CollectionUtils.isNotEmpty(orExpQuery)) {
                if (orExpQuery.size() > 1) {
                    String orExpStr = StringUtils.join(orExpQuery, (String)SearchParameters.FilterCriteria.Condition.OR.name());
                    queryBuilder.append(" ( ").append(orExpStr).append(" ) ");
                } else {
                    queryBuilder.append((CharSequence)orExpQuery.iterator().next());
                }
            }
        } else if (CollectionUtils.isNotEmpty((Collection)criterion)) {
            this.beginCriteria(queryBuilder);
            Iterator iterator = criterion.iterator();
            while (iterator.hasNext()) {
                SearchParameters.FilterCriteria childCriteria = (SearchParameters.FilterCriteria)iterator.next();
                this.withCriteria(queryBuilder, childCriteria);
                if (!iterator.hasNext()) continue;
                this.withCondition(queryBuilder, criteria.getCondition().name());
            }
            this.endCriteria(queryBuilder);
        }
        return this;
    }

    private void withPropertyCondition(StringBuilder queryBuilder, String indexFieldName, SearchParameters.Operator operator, String attributeValue, boolean replaceWildCard) throws AtlasBaseException {
        if (StringUtils.isNotEmpty((String)indexFieldName) && operator != null) {
            this.beginCriteria(queryBuilder);
            switch (operator) {
                case EQ: {
                    this.withEqual(queryBuilder, indexFieldName, attributeValue);
                    break;
                }
                case NEQ: {
                    this.withNotEqual(queryBuilder, indexFieldName, attributeValue);
                    break;
                }
                case STARTS_WITH: {
                    this.withStartsWith(queryBuilder, indexFieldName, attributeValue, replaceWildCard);
                    break;
                }
                case ENDS_WITH: {
                    this.withEndsWith(queryBuilder, indexFieldName, attributeValue, replaceWildCard);
                    break;
                }
                case CONTAINS: {
                    this.withContains(queryBuilder, indexFieldName, attributeValue, replaceWildCard);
                    break;
                }
                case NOT_CONTAINS: {
                    this.withNotContains(queryBuilder, indexFieldName, attributeValue, replaceWildCard);
                    break;
                }
                case IS_NULL: {
                    this.withIsNull(queryBuilder, indexFieldName);
                    break;
                }
                case NOT_NULL: {
                    this.withIsNotNull(queryBuilder, indexFieldName);
                    break;
                }
                case LT: {
                    this.withLessthan(queryBuilder, indexFieldName, attributeValue);
                    break;
                }
                case GT: {
                    this.withGreaterThan(queryBuilder, indexFieldName, attributeValue);
                    break;
                }
                case LTE: {
                    this.withLessthanOrEqual(queryBuilder, indexFieldName, attributeValue);
                    break;
                }
                case GTE: {
                    this.withGreaterThanOrEqual(queryBuilder, indexFieldName, attributeValue);
                    break;
                }
                default: {
                    String msg = String.format("%s is not supported operation.", operator.getSymbol());
                    LOG.error(msg);
                    throw new AtlasBaseException(msg);
                }
            }
            this.endCriteria(queryBuilder);
        }
    }

    private boolean isPipeSeparatedSystemAttribute(String attrName) {
        return StringUtils.equals((String)attrName, (String)Constants.CLASSIFICATION_NAMES_KEY) || StringUtils.equals((String)attrName, (String)Constants.PROPAGATED_CLASSIFICATION_NAMES_KEY) || StringUtils.equals((String)attrName, (String)Constants.LABELS_PROPERTY_KEY) || StringUtils.equals((String)attrName, (String)Constants.CUSTOM_ATTRIBUTES_PROPERTY_KEY);
    }

    private boolean isWildCardOperator(SearchParameters.Operator operator) {
        return operator == SearchParameters.Operator.CONTAINS || operator == SearchParameters.Operator.STARTS_WITH || operator == SearchParameters.Operator.ENDS_WITH || operator == SearchParameters.Operator.NOT_CONTAINS;
    }

    private String getIndexQueryAttributeValue(String attributeValue) {
        if (StringUtils.isNotEmpty((String)attributeValue)) {
            String value;
            int separatorIdx = attributeValue.indexOf(61);
            String key = separatorIdx != -1 ? attributeValue.substring(0, separatorIdx) : null;
            String string = value = key != null ? attributeValue.substring(separatorIdx + 1) : null;
            if (key != null && value != null) {
                return String.format(CUSTOM_ATTR_SEARCH_FORMAT, key, value);
            }
        }
        return attributeValue;
    }

    private String getIndexAttributeName(AtlasEntityType type, String attrName) throws AtlasBaseException {
        AtlasStructType.AtlasAttribute ret = type.getAttribute(attrName);
        if (ret == null) {
            String msg = String.format("Received unknown attribute '%s' for type '%s'.", attrName, type.getTypeName());
            LOG.error(msg);
            throw new AtlasBaseException(msg);
        }
        String indexFieldName = ret.getIndexFieldName();
        if (indexFieldName == null) {
            String msg = String.format("Received non-index attribute %s for type %s.", attrName, type.getTypeName());
            LOG.error(msg);
            throw new AtlasBaseException(msg);
        }
        return indexFieldName;
    }

    private void beginCriteria(StringBuilder queryBuilder) {
        queryBuilder.append("( ");
    }

    private void endCriteria(StringBuilder queryBuilder) {
        queryBuilder.append(" )");
    }

    private void withEndsWith(StringBuilder queryBuilder, String indexFieldName, String attributeValue, boolean replaceWildCard) {
        String attrValuePrefix = replaceWildCard ? ":" : ":*";
        queryBuilder.append("+").append(indexFieldName).append(attrValuePrefix).append(attributeValue).append(" ");
    }

    private void withStartsWith(StringBuilder queryBuilder, String indexFieldName, String attributeValue, boolean replaceWildCard) {
        String attrValuePostfix = replaceWildCard ? " " : "* ";
        queryBuilder.append("+").append(indexFieldName).append(":").append(attributeValue).append(attrValuePostfix);
    }

    private void withNotEqual(StringBuilder queryBuilder, String indexFieldName, String attributeValue) {
        queryBuilder.append("*:* -").append(indexFieldName).append(":").append(attributeValue).append(" ");
    }

    private void withEqual(StringBuilder queryBuilder, String indexFieldName, String attributeValue) {
        queryBuilder.append("+").append(indexFieldName).append(":").append(attributeValue).append(" ");
    }

    private void withGreaterThan(StringBuilder queryBuilder, String indexFieldName, String attributeValue) {
        queryBuilder.append("+").append(indexFieldName).append(":{ ").append(attributeValue).append(" TO * ] ");
    }

    private void withGreaterThanOrEqual(StringBuilder queryBuilder, String indexFieldName, String attributeValue) {
        queryBuilder.append("+").append(indexFieldName).append(":[ ").append(attributeValue).append(" TO * ] ");
    }

    private void withLessthan(StringBuilder queryBuilder, String indexFieldName, String attributeValue) {
        queryBuilder.append("+").append(indexFieldName).append(":[ * TO ").append(attributeValue).append("} ");
    }

    private void withLessthanOrEqual(StringBuilder queryBuilder, String indexFieldName, String attributeValue) {
        queryBuilder.append("+").append(indexFieldName).append(":[ * TO ").append(attributeValue).append(" ] ");
    }

    private void withContains(StringBuilder queryBuilder, String indexFieldName, String attributeValue, boolean replaceWildCard) {
        String attrValuePrefix = replaceWildCard ? ":" : ":*";
        String attrValuePostfix = replaceWildCard ? " " : "* ";
        queryBuilder.append("+").append(indexFieldName).append(attrValuePrefix).append(attributeValue).append(attrValuePostfix);
    }

    private void withNotContains(StringBuilder queryBuilder, String indexFieldName, String attributeValue, boolean replaceWildCard) {
        String attrValuePrefix = replaceWildCard ? ":" : ":*";
        String attrValuePostfix = replaceWildCard ? " " : "* ";
        queryBuilder.append("*:* -").append(indexFieldName).append(attrValuePrefix).append(attributeValue).append(attrValuePostfix);
    }

    private void withIsNull(StringBuilder queryBuilder, String indexFieldName) {
        queryBuilder.append("-").append(indexFieldName).append(":*").append(" ");
    }

    private void withIsNotNull(StringBuilder queryBuilder, String indexFieldName) {
        queryBuilder.append("+").append(indexFieldName).append(":*").append(" ");
    }

    private void withCondition(StringBuilder queryBuilder, String condition) {
        queryBuilder.append(" ").append(condition).append(" ");
    }
}

