/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus.migration;

import com.google.common.annotations.VisibleForTesting;
import java.util.Date;
import org.apache.atlas.model.impexp.MigrationStatus;
import org.apache.atlas.repository.Constants;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderStatusManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReaderStatusManager.class);
    private static final String MIGRATION_STATUS_TYPE_NAME = "__MigrationStatus";
    private static final String CURRENT_INDEX_PROPERTY = "currentIndex";
    private static final String CURRENT_COUNTER_PROPERTY = "currentCounter";
    private static final String OPERATION_STATUS_PROPERTY = "operationStatus";
    private static final String START_TIME_PROPERTY = "startTime";
    private static final String END_TIME_PROPERTY = "endTime";
    private static final String TOTAL_COUNT_PROPERTY = "totalCount";
    public static final String STATUS_NOT_STARTED = "NOT_STARTED";
    public static final String STATUS_IN_PROGRESS = "IN_PROGRESS";
    public static final String STATUS_SUCCESS = "SUCCESS";
    public static final String STATUS_FAILED = "FAILED";
    @VisibleForTesting
    Object migrationStatusId = null;
    private Vertex migrationStatus = null;

    public ReaderStatusManager(Graph graph, Graph bulkLoadGraph) {
        this.init(graph, bulkLoadGraph);
    }

    public void init(Graph graph, Graph bulkLoadGraph) {
        this.migrationStatus = ReaderStatusManager.fetchUsingTypeName(bulkLoadGraph.traversal());
        if (this.migrationStatus == null) {
            this.createAndCommit(graph);
            this.migrationStatus = this.fetchUsingId(bulkLoadGraph.traversal());
        }
        if (this.migrationStatus == null) {
            this.migrationStatus = this.fetchUsingId(bulkLoadGraph.traversal());
        }
    }

    public void end(Graph bGraph, Long counter, String status) {
        this.migrationStatus.property(END_TIME_PROPERTY, (Object)new Date());
        this.migrationStatus.property(TOTAL_COUNT_PROPERTY, (Object)counter);
        this.update(bGraph, counter, status);
    }

    public void update(Graph graph, Long counter, boolean stageEnd) {
        this.migrationStatus.property(CURRENT_COUNTER_PROPERTY, (Object)counter);
        if (stageEnd) {
            this.migrationStatus.property(CURRENT_INDEX_PROPERTY, (Object)counter);
        }
        if (graph.features().graph().supportsTransactions()) {
            graph.tx().commit();
        }
    }

    public void update(Graph graph, Long counter, String status) {
        this.migrationStatus.property(OPERATION_STATUS_PROPERTY, (Object)status);
        this.update(graph, counter, true);
    }

    public void clear() {
        this.migrationStatus = null;
    }

    public long getStartIndex() {
        return (Long)this.migrationStatus.property(CURRENT_INDEX_PROPERTY).value();
    }

    private Vertex fetchUsingId(GraphTraversalSource g) {
        return (Vertex)g.V(new Object[]{this.migrationStatusId}).next();
    }

    private static Vertex fetchUsingTypeName(GraphTraversalSource g) {
        GraphTraversal src = g.V(new Object[0]).has(Constants.ENTITY_TYPE_PROPERTY_KEY, (Object)MIGRATION_STATUS_TYPE_NAME);
        return src.hasNext() ? (Vertex)src.next() : null;
    }

    private void createAndCommit(Graph rGraph) {
        Vertex v = rGraph.addVertex(new Object[0]);
        long longValue = 0L;
        v.property(Constants.ENTITY_TYPE_PROPERTY_KEY, (Object)MIGRATION_STATUS_TYPE_NAME);
        v.property(CURRENT_COUNTER_PROPERTY, (Object)longValue);
        v.property(CURRENT_INDEX_PROPERTY, (Object)longValue);
        v.property(TOTAL_COUNT_PROPERTY, (Object)longValue);
        v.property(OPERATION_STATUS_PROPERTY, (Object)STATUS_NOT_STARTED);
        v.property(START_TIME_PROPERTY, (Object)new Date());
        v.property(END_TIME_PROPERTY, (Object)new Date());
        this.migrationStatusId = v.id();
        if (rGraph.features().graph().supportsTransactions()) {
            rGraph.tx().commit();
        }
        LOG.info("migrationStatus vertex created! v[{}]", this.migrationStatusId);
    }

    public static MigrationStatus get(Graph graph) {
        MigrationStatus ms;
        block2: {
            ms = new MigrationStatus();
            try {
                ReaderStatusManager.setValues(ms, ReaderStatusManager.fetchUsingTypeName(graph.traversal()));
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.error("get: failed!", (Throwable)ex);
            }
        }
        return ms;
    }

    private static void setValues(MigrationStatus ms, Vertex vertex) {
        ms.setStartTime((Date)vertex.property(START_TIME_PROPERTY).value());
        ms.setEndTime((Date)vertex.property(END_TIME_PROPERTY).value());
        ms.setCurrentIndex(((Long)vertex.property(CURRENT_INDEX_PROPERTY).value()).longValue());
        ms.setCurrentCounter(((Long)vertex.property(CURRENT_COUNTER_PROPERTY).value()).longValue());
        ms.setOperationStatus((String)vertex.property(OPERATION_STATUS_PROPERTY).value());
        ms.setTotalCount(((Long)vertex.property(TOTAL_COUNT_PROPERTY).value()).longValue());
    }
}

