/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.commons.configuration.Configuration;

public enum AtlasConfiguration {
    WEBSERVER_MIN_THREADS("atlas.webserver.minthreads", 10),
    WEBSERVER_MAX_THREADS("atlas.webserver.maxthreads", 100),
    WEBSERVER_KEEPALIVE_SECONDS("atlas.webserver.keepalivetimesecs", 60),
    WEBSERVER_QUEUE_SIZE("atlas.webserver.queuesize", 100),
    WEBSERVER_REQUEST_BUFFER_SIZE("atlas.jetty.request.buffer.size", 16192),
    QUERY_PARAM_MAX_LENGTH("atlas.query.param.max.length", 4096),
    REST_API_ENABLE_DELETE_TYPE_OVERRIDE("atlas.rest.enable.delete.type.override", false),
    NOTIFICATION_RELATIONSHIPS_ENABLED("atlas.notification.relationships.enabled", false),
    NOTIFICATION_HOOK_TOPIC_NAME("atlas.notification.hook.topic.name", "ATLAS_HOOK"),
    NOTIFICATION_ENTITIES_TOPIC_NAME("atlas.notification.entities.topic.name", "ATLAS_ENTITIES"),
    NOTIFICATION_MESSAGE_MAX_LENGTH_BYTES("atlas.notification.message.max.length.bytes", 1000000),
    NOTIFICATION_MESSAGE_COMPRESSION_ENABLED("atlas.notification.message.compression.enabled", true),
    NOTIFICATION_SPLIT_MESSAGE_SEGMENTS_WAIT_TIME_SECONDS("atlas.notification.split.message.segments.wait.time.seconds", 900),
    NOTIFICATION_SPLIT_MESSAGE_BUFFER_PURGE_INTERVAL_SECONDS("atlas.notification.split.message.buffer.purge.interval.seconds", 300),
    GRAPHSTORE_INDEXED_STRING_SAFE_LENGTH("atlas.graphstore.indexed.string.safe.length", (short)Short.MAX_VALUE),
    SEARCH_MAX_LIMIT("atlas.search.maxlimit", 10000),
    SEARCH_DEFAULT_LIMIT("atlas.search.defaultlimit", 100);

    private static final Configuration APPLICATION_PROPERTIES;
    private final String propertyName;
    private final Object defaultValue;

    private AtlasConfiguration(String propertyName, Object defaultValue) {
        this.propertyName = propertyName;
        this.defaultValue = defaultValue;
    }

    public int getInt() {
        return APPLICATION_PROPERTIES.getInt(this.propertyName, Integer.valueOf(this.defaultValue.toString()).intValue());
    }

    public long getLong() {
        return APPLICATION_PROPERTIES.getLong(this.propertyName, Long.valueOf(this.defaultValue.toString()).longValue());
    }

    public boolean getBoolean() {
        return APPLICATION_PROPERTIES.getBoolean(this.propertyName, Boolean.valueOf(this.defaultValue.toString()).booleanValue());
    }

    public String getString() {
        return APPLICATION_PROPERTIES.getString(this.propertyName, this.defaultValue.toString());
    }

    public Object get() {
        Object value = APPLICATION_PROPERTIES.getProperty(this.propertyName);
        return value == null ? this.defaultValue : value;
    }

    static {
        try {
            APPLICATION_PROPERTIES = ApplicationProperties.get();
        }
        catch (AtlasException e) {
            throw new RuntimeException(e);
        }
    }
}

