/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBusinessMetadataType;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasStructType
extends AtlasType {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasStructType.class);
    public static final String UNIQUE_ATTRIBUTE_SHADE_PROPERTY_PREFIX = "__u_";
    private final AtlasStructDef structDef;
    protected Map<String, AtlasAttribute> allAttributes = Collections.emptyMap();
    protected Map<String, AtlasAttribute> uniqAttributes = Collections.emptyMap();

    public AtlasStructType(AtlasStructDef structDef) {
        super(structDef);
        this.structDef = structDef;
    }

    public AtlasStructType(AtlasStructDef structDef, AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super(structDef);
        this.structDef = structDef;
        this.resolveReferences(typeRegistry);
    }

    public AtlasStructDef getStructDef() {
        return this.structDef;
    }

    public AtlasType getAttributeType(String attributeName) {
        AtlasAttribute attribute = this.getAttribute(attributeName);
        return attribute != null ? attribute.getAttributeType() : null;
    }

    public AtlasStructDef.AtlasAttributeDef getAttributeDef(String attributeName) {
        AtlasAttribute attribute = this.getAttribute(attributeName);
        return attribute != null ? attribute.getAttributeDef() : null;
    }

    @Override
    void resolveReferences(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        HashMap<String, AtlasAttribute> a = new HashMap<String, AtlasAttribute>();
        for (AtlasStructDef.AtlasAttributeDef attributeDef : this.structDef.getAttributeDefs()) {
            AtlasType attrType = typeRegistry.getType(attributeDef.getTypeName());
            AtlasAttribute attribute = new AtlasAttribute(this, attributeDef, attrType);
            AtlasStructDef.AtlasAttributeDef.Cardinality cardinality = attributeDef.getCardinality();
            if (cardinality == AtlasStructDef.AtlasAttributeDef.Cardinality.LIST || cardinality == AtlasStructDef.AtlasAttributeDef.Cardinality.SET) {
                if (!(attrType instanceof AtlasArrayType)) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_ATTRIBUTE_TYPE_FOR_CARDINALITY, this.getTypeName(), attributeDef.getName());
                }
                AtlasArrayType arrayType = (AtlasArrayType)attrType;
                arrayType.setMinCount(attributeDef.getValuesMinCount());
                arrayType.setMaxCount(attributeDef.getValuesMaxCount());
                arrayType.setCardinality(cardinality);
            }
            if (attrType instanceof AtlasArrayType) {
                attrType = ((AtlasArrayType)attrType).getElementType();
            } else if (attrType instanceof AtlasMapType) {
                attrType = ((AtlasMapType)attrType).getValueType();
            }
            if (attrType instanceof AtlasClassificationType) {
                throw new AtlasBaseException(AtlasErrorCode.ATTRIBUTE_TYPE_INVALID, this.getTypeName(), attributeDef.getName());
            }
            if (attrType instanceof AtlasBusinessMetadataType) {
                throw new AtlasBaseException(AtlasErrorCode.ATTRIBUTE_TYPE_INVALID, this.getTypeName(), attributeDef.getName());
            }
            a.put(attributeDef.getName(), attribute);
        }
        this.resolveConstraints(typeRegistry);
        this.allAttributes = Collections.unmodifiableMap(a);
        this.uniqAttributes = this.getUniqueAttributes(this.allAttributes);
    }

    private void resolveConstraints(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        for (AtlasStructDef.AtlasAttributeDef attributeDef : this.getStructDef().getAttributeDefs()) {
            if (CollectionUtils.isEmpty(attributeDef.getConstraints())) continue;
            for (AtlasStructDef.AtlasConstraintDef constraint : attributeDef.getConstraints()) {
                AtlasEntityType attrType;
                if (constraint.isConstraintType("ownedRef")) {
                    attrType = this.getReferencedEntityType(typeRegistry.getType(attributeDef.getTypeName()));
                    if (attrType != null) continue;
                    throw new AtlasBaseException(AtlasErrorCode.CONSTRAINT_OWNED_REF_ATTRIBUTE_INVALID_TYPE, this.getTypeName(), attributeDef.getName(), "ownedRef", attributeDef.getTypeName());
                }
                if (!constraint.isConstraintType("inverseRef")) continue;
                attrType = this.getReferencedEntityType(typeRegistry.getType(attributeDef.getTypeName()));
                if (attrType == null) {
                    throw new AtlasBaseException(AtlasErrorCode.CONSTRAINT_INVERSE_REF_ATTRIBUTE_INVALID_TYPE, this.getTypeName(), attributeDef.getName(), "inverseRef", attributeDef.getTypeName());
                }
                String inverseRefAttrName = AtlasTypeUtil.getStringValue(constraint.getParams(), "attribute");
                if (StringUtils.isBlank((String)inverseRefAttrName)) {
                    throw new AtlasBaseException(AtlasErrorCode.CONSTRAINT_MISSING_PARAMS, this.getTypeName(), attributeDef.getName(), "attribute", "inverseRef", String.valueOf(constraint.getParams()));
                }
                AtlasStructDef.AtlasAttributeDef inverseRefAttrDef = attrType.getStructDef().getAttribute(inverseRefAttrName);
                if (inverseRefAttrDef == null) {
                    throw new AtlasBaseException(AtlasErrorCode.CONSTRAINT_INVERSE_REF_INVERSE_ATTRIBUTE_NON_EXISTING, this.getTypeName(), attributeDef.getName(), "inverseRef", attrType.getTypeName(), inverseRefAttrName);
                }
                AtlasEntityType inverseRefAttrType = this.getReferencedEntityType(typeRegistry.getType(inverseRefAttrDef.getTypeName()));
                if (inverseRefAttrType != null) continue;
                throw new AtlasBaseException(AtlasErrorCode.CONSTRAINT_INVERSE_REF_INVERSE_ATTRIBUTE_INVALID_TYPE, this.getTypeName(), attributeDef.getName(), "inverseRef", attrType.getTypeName(), inverseRefAttrName);
            }
        }
    }

    @Override
    void resolveReferencesPhase2(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super.resolveReferencesPhase2(typeRegistry);
        for (AtlasAttribute attribute : this.allAttributes.values()) {
            if (attribute.getInverseRefAttributeName() == null) continue;
            AtlasType referencedType = typeRegistry.getType(attribute.getAttributeDef().getTypeName());
            AtlasEntityType referencedEntityType = this.getReferencedEntityType(referencedType);
            AtlasAttribute inverseReference = referencedEntityType.getAttribute(attribute.getInverseRefAttributeName());
            attribute.setInverseRefAttribute(inverseReference);
        }
    }

    @Override
    public AtlasStruct createDefaultValue() {
        AtlasStruct ret = new AtlasStruct(this.structDef.getName());
        this.populateDefaultValues(ret);
        return ret;
    }

    @Override
    public Object createDefaultValue(Object defaultValue) {
        AtlasStruct ret = new AtlasStruct(this.structDef.getName());
        this.populateDefaultValues(ret);
        return ret;
    }

    public Map<String, AtlasAttribute> getAllAttributes() {
        return this.allAttributes;
    }

    public Map<String, AtlasAttribute> getUniqAttributes() {
        return this.uniqAttributes;
    }

    public AtlasAttribute getAttribute(String attributeName) {
        AtlasAttribute ret = this.allAttributes.get(attributeName);
        if (ret == null) {
            ret = this.getSystemAttribute(attributeName);
        }
        if (ret == null) {
            ret = this.getBusinesAAttribute(attributeName);
        }
        return ret;
    }

    public AtlasAttribute getSystemAttribute(String attributeName) {
        return null;
    }

    public AtlasAttribute getBusinesAAttribute(String attributeName) {
        return null;
    }

    @Override
    public boolean isValidValue(Object obj) {
        if (obj != null) {
            if (obj instanceof AtlasStruct) {
                AtlasStruct structObj = (AtlasStruct)obj;
                for (AtlasStructDef.AtlasAttributeDef attributeDef : this.structDef.getAttributeDefs()) {
                    if (this.isAssignableValue(structObj.getAttribute(attributeDef.getName()), attributeDef)) continue;
                    return false;
                }
            } else if (obj instanceof Map) {
                Map map = AtlasTypeUtil.toStructAttributes((Map)obj);
                for (AtlasStructDef.AtlasAttributeDef attributeDef : this.structDef.getAttributeDefs()) {
                    if (this.isAssignableValue(map.get(attributeDef.getName()), attributeDef)) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean areEqualValues(Object val1, Object val2, Map<String, String> guidAssignments) {
        boolean ret = true;
        if (val1 == null) {
            ret = val2 == null;
        } else if (val2 == null) {
            ret = false;
        } else {
            AtlasStruct structVal1 = this.getStructFromValue(val1);
            if (structVal1 == null) {
                ret = false;
            } else {
                AtlasStruct structVal2 = this.getStructFromValue(val2);
                if (structVal2 == null) {
                    ret = false;
                } else if (!StringUtils.equalsIgnoreCase((String)structVal1.getTypeName(), (String)structVal2.getTypeName())) {
                    ret = false;
                } else {
                    for (AtlasAttribute attribute : this.getAllAttributes().values()) {
                        Object attrValue1 = structVal1.getAttribute(attribute.getName());
                        Object attrValue2 = structVal2.getAttribute(attribute.getName());
                        if (attribute.getAttributeType().areEqualValues(attrValue1, attrValue2, guidAssignments)) continue;
                        ret = false;
                        break;
                    }
                }
            }
        }
        return ret;
    }

    @Override
    public boolean isValidValueForUpdate(Object obj) {
        if (obj != null) {
            Map attributes;
            if (obj instanceof AtlasStruct) {
                AtlasStruct structObj = (AtlasStruct)obj;
                attributes = structObj.getAttributes();
            } else if (obj instanceof Map) {
                attributes = AtlasTypeUtil.toStructAttributes((Map)obj);
            } else {
                return false;
            }
            if (MapUtils.isNotEmpty((Map)attributes)) {
                for (Map.Entry e : attributes.entrySet()) {
                    String attrName = (String)e.getKey();
                    Object attrValue = e.getValue();
                    AtlasStructDef.AtlasAttributeDef attrDef = this.structDef.getAttribute(attrName);
                    if (attrValue == null || attrDef == null || this.isAssignableValueForUpdate(attrValue, attrDef)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public Object getNormalizedValue(Object obj) {
        Object ret = null;
        if (obj != null && this.isValidValue(obj)) {
            if (obj instanceof AtlasStruct) {
                this.normalizeAttributeValues((AtlasStruct)obj);
                ret = obj;
            } else if (obj instanceof Map) {
                this.normalizeAttributeValues((Map)obj);
                ret = obj;
            }
        }
        return ret;
    }

    @Override
    public Object getNormalizedValueForUpdate(Object obj) {
        Object ret = null;
        if (obj != null && this.isValidValueForUpdate(obj)) {
            if (obj instanceof AtlasStruct) {
                this.normalizeAttributeValuesForUpdate((AtlasStruct)obj);
                ret = obj;
            } else if (obj instanceof Map) {
                this.normalizeAttributeValuesForUpdate((Map)obj);
                ret = obj;
            }
        }
        return ret;
    }

    @Override
    public boolean validateValue(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            if (obj instanceof AtlasStruct) {
                AtlasStruct structObj = (AtlasStruct)obj;
                for (AtlasStructDef.AtlasAttributeDef attributeDef : this.structDef.getAttributeDefs()) {
                    String attrName = attributeDef.getName();
                    AtlasAttribute attribute = this.allAttributes.get(attributeDef.getName());
                    if (attribute == null) continue;
                    AtlasType dataType = attribute.getAttributeType();
                    Object value = structObj.getAttribute(attrName);
                    String fieldName = objName + "." + attrName;
                    if (value != null) {
                        ret = dataType.validateValue(value, fieldName, messages) && ret;
                        continue;
                    }
                    if (attributeDef.getIsOptional()) continue;
                    if (structObj instanceof AtlasEntity) {
                        AtlasEntity entityObj = (AtlasEntity)structObj;
                        if (entityObj.getRelationshipAttribute(attrName) != null) continue;
                        ret = false;
                        messages.add(fieldName + ": mandatory attribute value missing in type " + this.getTypeName());
                        continue;
                    }
                    ret = false;
                    messages.add(fieldName + ": mandatory attribute value missing in type " + this.getTypeName());
                }
            } else if (obj instanceof Map) {
                Map attributes = AtlasTypeUtil.toStructAttributes((Map)obj);
                Map relationshipAttributes = AtlasTypeUtil.toRelationshipAttributes((Map)obj);
                for (AtlasStructDef.AtlasAttributeDef attributeDef : this.structDef.getAttributeDefs()) {
                    String attrName = attributeDef.getName();
                    AtlasAttribute attribute = this.allAttributes.get(attributeDef.getName());
                    if (attribute == null) continue;
                    AtlasType dataType = attribute.getAttributeType();
                    Object value = attributes.get(attrName);
                    String fieldName = objName + "." + attrName;
                    if (value != null) {
                        ret = dataType.validateValue(value, fieldName, messages) && ret;
                        continue;
                    }
                    if (attributeDef.getIsOptional() || !MapUtils.isEmpty((Map)relationshipAttributes) && relationshipAttributes.containsKey(attrName)) continue;
                    ret = false;
                    messages.add(fieldName + ": mandatory attribute value missing in type " + this.getTypeName());
                }
            } else {
                ret = false;
                messages.add(objName + "=" + obj + ": invalid value for type " + this.getTypeName());
            }
        }
        return ret;
    }

    @Override
    public boolean validateValueForUpdate(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        Map attributes = null;
        if (obj != null) {
            if (obj instanceof AtlasStruct) {
                AtlasStruct structObj = (AtlasStruct)obj;
                attributes = structObj.getAttributes();
            } else if (obj instanceof Map) {
                attributes = AtlasTypeUtil.toStructAttributes((Map)obj);
            } else {
                ret = false;
                messages.add(objName + "=" + obj + ": invalid value for type " + this.getTypeName());
            }
            if (MapUtils.isNotEmpty((Map)attributes)) {
                for (Map.Entry e : attributes.entrySet()) {
                    String fieldName;
                    String attrName = (String)e.getKey();
                    Object attrValue = e.getValue();
                    AtlasAttribute attribute = this.allAttributes.get(attrName);
                    if (attrValue == null || attribute == null) continue;
                    AtlasType dataType = attribute.getAttributeType();
                    ret = dataType.validateValueForUpdate(attrValue, fieldName = objName + "." + attrName, messages) && ret;
                }
            }
        }
        return ret;
    }

    public void normalizeAttributeValues(AtlasStruct obj) {
        if (obj != null) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : this.structDef.getAttributeDefs()) {
                String attributeName = attributeDef.getName();
                if (obj.hasAttribute(attributeName)) {
                    Object attributeValue = this.getNormalizedValue(obj.getAttribute(attributeName), attributeDef);
                    obj.setAttribute(attributeName, attributeValue);
                    continue;
                }
                if (attributeDef.getIsOptional()) continue;
                obj.setAttribute(attributeName, this.createDefaultValue(attributeDef));
            }
        }
    }

    public void normalizeAttributeValuesForUpdate(AtlasStruct obj) {
        if (obj != null) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : this.structDef.getAttributeDefs()) {
                String attributeName = attributeDef.getName();
                if (!obj.hasAttribute(attributeName)) continue;
                Object attributeValue = this.getNormalizedValueForUpdate(obj.getAttribute(attributeName), attributeDef);
                obj.setAttribute(attributeName, attributeValue);
            }
        }
    }

    public void normalizeAttributeValues(Map<String, Object> obj) {
        if (obj != null) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : this.structDef.getAttributeDefs()) {
                String attributeName = attributeDef.getName();
                if (obj.containsKey(attributeName)) {
                    Object attributeValue = this.getNormalizedValue(obj.get(attributeName), attributeDef);
                    obj.put(attributeName, attributeValue);
                    continue;
                }
                if (attributeDef.getIsOptional()) continue;
                obj.put(attributeName, this.createDefaultValue(attributeDef));
            }
        }
    }

    public void normalizeAttributeValuesForUpdate(Map<String, Object> obj) {
        if (obj != null) {
            for (AtlasStructDef.AtlasAttributeDef attrDef : this.structDef.getAttributeDefs()) {
                String attrName = attrDef.getName();
                Object attrValue = obj.get(attrName);
                if (!obj.containsKey(attrName)) continue;
                attrValue = this.getNormalizedValueForUpdate(attrValue, attrDef);
                obj.put(attrName, attrValue);
            }
        }
    }

    public void populateDefaultValues(AtlasStruct obj) {
        if (obj != null) {
            Map<String, Object> attributes = obj.getAttributes();
            if (attributes == null) {
                attributes = new HashMap<String, Object>();
            }
            for (AtlasStructDef.AtlasAttributeDef attributeDef : this.structDef.getAttributeDefs()) {
                if (attributeDef.getIsOptional()) continue;
                attributes.put(attributeDef.getName(), this.createDefaultValue(attributeDef));
            }
            obj.setAttributes(attributes);
        }
    }

    private Object createDefaultValue(AtlasStructDef.AtlasAttributeDef attributeDef) {
        AtlasAttribute attribute;
        Object ret = null;
        if (attributeDef != null && (attribute = this.allAttributes.get(attributeDef.getName())) != null) {
            AtlasType dataType = attribute.getAttributeType();
            ret = dataType.createDefaultValue(attributeDef.getDefaultValue());
        }
        return ret;
    }

    private boolean isAssignableValue(Object value, AtlasStructDef.AtlasAttributeDef attributeDef) {
        boolean ret = true;
        if (value != null) {
            AtlasType attrType;
            AtlasAttribute attribute = this.allAttributes.get(attributeDef.getName());
            if (attribute != null && !(attrType = attribute.getAttributeType()).isValidValue(value)) {
                ret = false;
            }
        } else if (!attributeDef.getIsOptional()) {
            ret = false;
        }
        return ret;
    }

    private boolean isAssignableValueForUpdate(Object value, AtlasStructDef.AtlasAttributeDef attributeDef) {
        AtlasType attrType;
        AtlasAttribute attribute;
        boolean ret = true;
        if (value != null && (attribute = this.allAttributes.get(attributeDef.getName())) != null && !(attrType = attribute.getAttributeType()).isValidValueForUpdate(value)) {
            ret = false;
        }
        return ret;
    }

    private Object getNormalizedValue(Object value, AtlasStructDef.AtlasAttributeDef attributeDef) {
        AtlasAttribute attribute = this.allAttributes.get(attributeDef.getName());
        if (attribute != null) {
            AtlasType attrType = attribute.getAttributeType();
            if (value == null) {
                if (!attributeDef.getIsOptional()) {
                    return attrType.createDefaultValue();
                }
            } else {
                return attrType.getNormalizedValue(value);
            }
        }
        return null;
    }

    private Object getNormalizedValueForUpdate(Object value, AtlasStructDef.AtlasAttributeDef attributeDef) {
        AtlasAttribute attribute = this.allAttributes.get(attributeDef.getName());
        if (attribute != null) {
            AtlasType attrType = attribute.getAttributeType();
            if (value != null) {
                return attrType.getNormalizedValueForUpdate(value);
            }
        }
        return null;
    }

    public String getVertexPropertyName(String attrName) throws AtlasBaseException {
        AtlasAttribute attribute = this.getAttribute(attrName);
        if (attribute != null) {
            return attribute.getVertexPropertyName();
        }
        throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_ATTRIBUTE, attrName, this.structDef.getName());
    }

    public String getQualifiedAttributePropertyKey(String attrName) throws AtlasBaseException {
        if (this.allAttributes.containsKey(attrName)) {
            return this.allAttributes.get(attrName).getVertexPropertyName();
        }
        throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_ATTRIBUTE, attrName, this.structDef.getName());
    }

    AtlasEntityType getReferencedEntityType(AtlasType type) {
        if (type instanceof AtlasArrayType) {
            type = ((AtlasArrayType)type).getElementType();
        }
        if (type instanceof AtlasMapType) {
            type = ((AtlasMapType)type).getValueType();
        }
        return type instanceof AtlasEntityType ? (AtlasEntityType)type : null;
    }

    protected Map<String, AtlasAttribute> getUniqueAttributes(Map<String, AtlasAttribute> attributes) {
        HashMap<String, AtlasAttribute> ret = new HashMap<String, AtlasAttribute>();
        if (MapUtils.isNotEmpty(attributes)) {
            for (AtlasAttribute attribute : attributes.values()) {
                if (!attribute.getAttributeDef().getIsUnique()) continue;
                ret.put(attribute.getName(), attribute);
            }
        }
        return Collections.unmodifiableMap(ret);
    }

    private AtlasStruct getStructFromValue(Object val) {
        Map map;
        Object ret = val instanceof AtlasStruct ? (AtlasStruct)val : (val instanceof Map ? new AtlasStruct((Map)val) : (val instanceof String ? ((map = AtlasType.fromJson(val.toString(), Map.class)) == null ? null : new AtlasStruct((Map)val)) : null));
        return ret;
    }

    public static class AtlasAttribute {
        public static final Object VERTEX_PROPERTY_PREFIX_STRING_INDEX_TYPE = "__s_";
        private final AtlasStructType definedInType;
        private final AtlasType attributeType;
        private final AtlasStructDef.AtlasAttributeDef attributeDef;
        private final String qualifiedName;
        private final String vertexPropertyName;
        private final String vertexUniquePropertyName;
        private final boolean isOwnedRef;
        private final boolean isObjectRef;
        private final String inverseRefAttributeName;
        private AtlasAttribute inverseRefAttribute;
        private String relationshipName;
        private String relationshipEdgeLabel;
        private AtlasRelationshipEdgeDirection relationshipEdgeDirection;
        private boolean isLegacyAttribute;
        private String indexFieldName;
        private boolean isDynAttribute = false;
        private boolean isDynAttributeEvalTrigger = false;
        private static String[][] RESERVED_CHAR_ENCODE_MAP = new String[][]{{"{", "_o"}, {"}", "_c"}, {"\"", "_q"}, {"$", "_d"}, {"%", "_p"}};
        private static final char[] IDX_QRY_OFFENDING_CHARS = new char[]{'@', '/', ' ', '-'};
        private static final char BRACE_OPEN_CHAR = '(';
        private static final char BRACE_CLOSE_CHAR = ')';
        private static final char DOUBLE_QUOTE_CHAR = '\"';
        private static final char SPACE_CHAR = ' ';

        public AtlasAttribute(AtlasStructType definedInType, AtlasStructDef.AtlasAttributeDef attrDef, AtlasType attributeType, String relationshipName, String relationshipLabel) {
            this.definedInType = definedInType;
            this.attributeDef = attrDef;
            this.attributeType = attributeType.getTypeForAttribute();
            this.qualifiedName = AtlasAttribute.getQualifiedAttributeName(definedInType.getStructDef(), this.attributeDef.getName());
            this.vertexPropertyName = AtlasAttribute.generateVertexPropertyName(definedInType.getStructDef(), this.attributeDef, this.qualifiedName);
            this.vertexUniquePropertyName = attrDef.getIsUnique() ? AtlasAttribute.encodePropertyKey(AtlasAttribute.getQualifiedAttributeName(definedInType.getStructDef(), AtlasStructType.UNIQUE_ATTRIBUTE_SHADE_PROPERTY_PREFIX + this.attributeDef.getName())) : null;
            this.relationshipName = relationshipName;
            this.relationshipEdgeLabel = this.getRelationshipEdgeLabel(relationshipLabel);
            boolean isOwnedRef = false;
            String inverseRefAttribute = null;
            LOG.debug("Attribute {} will use the vertext property name {}.", (Object)this.qualifiedName, (Object)this.vertexPropertyName);
            if (CollectionUtils.isNotEmpty(this.attributeDef.getConstraints())) {
                for (AtlasStructDef.AtlasConstraintDef constraint : this.attributeDef.getConstraints()) {
                    Object val;
                    if (constraint.isConstraintType("ownedRef")) {
                        isOwnedRef = true;
                    }
                    if (!constraint.isConstraintType("inverseRef") || (val = constraint.getParam("attribute")) == null) continue;
                    inverseRefAttribute = val.toString();
                }
            }
            this.isOwnedRef = isOwnedRef;
            this.inverseRefAttributeName = inverseRefAttribute;
            this.relationshipEdgeDirection = AtlasRelationshipEdgeDirection.OUT;
            switch (this.attributeType.getTypeCategory()) {
                case OBJECT_ID_TYPE: {
                    this.isObjectRef = true;
                    break;
                }
                case MAP: {
                    AtlasMapType mapType = (AtlasMapType)this.attributeType;
                    this.isObjectRef = mapType.getValueType().getTypeCategory() == TypeCategory.OBJECT_ID_TYPE;
                    break;
                }
                case ARRAY: {
                    AtlasArrayType arrayType = (AtlasArrayType)this.attributeType;
                    this.isObjectRef = arrayType.getElementType().getTypeCategory() == TypeCategory.OBJECT_ID_TYPE;
                    break;
                }
                default: {
                    this.isObjectRef = false;
                }
            }
        }

        public AtlasAttribute(AtlasStructType definedInType, AtlasStructDef.AtlasAttributeDef attrDef, AtlasType attributeType) {
            this(definedInType, attrDef, attributeType, null, null);
        }

        public AtlasAttribute(AtlasAttribute other) {
            this.definedInType = other.definedInType;
            this.attributeType = other.attributeType;
            this.attributeDef = other.attributeDef;
            this.qualifiedName = other.qualifiedName;
            this.vertexPropertyName = other.vertexPropertyName;
            this.vertexUniquePropertyName = other.vertexUniquePropertyName;
            this.isOwnedRef = other.isOwnedRef;
            this.isObjectRef = other.isObjectRef;
            this.inverseRefAttributeName = other.inverseRefAttributeName;
            this.inverseRefAttribute = other.inverseRefAttribute;
            this.relationshipName = other.relationshipName;
            this.relationshipEdgeLabel = other.relationshipEdgeLabel;
            this.relationshipEdgeDirection = other.relationshipEdgeDirection;
            this.isLegacyAttribute = other.isLegacyAttribute;
            this.indexFieldName = other.indexFieldName;
            this.isDynAttribute = false;
            this.isDynAttributeEvalTrigger = false;
        }

        public AtlasStructType getDefinedInType() {
            return this.definedInType;
        }

        public AtlasStructDef getDefinedInDef() {
            return this.definedInType.getStructDef();
        }

        public AtlasType getAttributeType() {
            return this.attributeType;
        }

        public AtlasStructDef.AtlasAttributeDef getAttributeDef() {
            return this.attributeDef;
        }

        public String getName() {
            return this.attributeDef.getName();
        }

        public String getTypeName() {
            return this.attributeDef.getTypeName();
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        public String getVertexPropertyName() {
            return this.vertexPropertyName;
        }

        public String getVertexUniquePropertyName() {
            return this.vertexUniquePropertyName;
        }

        public boolean isOwnedRef() {
            return this.isOwnedRef;
        }

        public boolean isObjectRef() {
            return this.isObjectRef;
        }

        public String getInverseRefAttributeName() {
            return this.inverseRefAttributeName;
        }

        public AtlasAttribute getInverseRefAttribute() {
            return this.inverseRefAttribute;
        }

        public void setInverseRefAttribute(AtlasAttribute inverseAttr) {
            this.inverseRefAttribute = inverseAttr;
        }

        public String getRelationshipName() {
            return this.relationshipName;
        }

        public void setRelationshipName(String relationshipName) {
            this.relationshipName = relationshipName;
        }

        public String getRelationshipEdgeLabel() {
            return this.relationshipEdgeLabel;
        }

        public void setRelationshipEdgeLabel(String relationshipEdgeLabel) {
            this.relationshipEdgeLabel = relationshipEdgeLabel;
        }

        public AtlasRelationshipEdgeDirection getRelationshipEdgeDirection() {
            return this.relationshipEdgeDirection;
        }

        public void setRelationshipEdgeDirection(AtlasRelationshipEdgeDirection relationshipEdgeDirection) {
            this.relationshipEdgeDirection = relationshipEdgeDirection;
        }

        public boolean isLegacyAttribute() {
            return this.isLegacyAttribute;
        }

        public void setLegacyAttribute(boolean legacyAttribute) {
            this.isLegacyAttribute = legacyAttribute;
        }

        public String getIndexFieldName() {
            return this.indexFieldName;
        }

        public void setIndexFieldName(String indexFieldName) {
            this.indexFieldName = indexFieldName;
        }

        public int getSearchWeight() {
            return this.attributeDef.getSearchWeight();
        }

        public AtlasStructDef.AtlasAttributeDef.IndexType getIndexType() {
            return this.attributeDef.getIndexType();
        }

        public boolean getIsDynAttribute() {
            return this.isDynAttribute;
        }

        public void setIsDynAttribute(boolean isDynAttribute) {
            this.isDynAttribute = isDynAttribute;
        }

        public boolean getIsDynAttributeEvalTrigger() {
            return this.isDynAttributeEvalTrigger;
        }

        public void setIsDynAttributeEvalTrigger(boolean isDynAttributeEvalTrigger) {
            this.isDynAttributeEvalTrigger = isDynAttributeEvalTrigger;
        }

        public Set<String> getOptionSet(String optionName) {
            String strValue = this.attributeDef.getOption(optionName);
            Set ret = StringUtils.isBlank((String)strValue) ? null : AtlasType.fromJson(strValue, Set.class);
            return ret;
        }

        public Integer getOptionInt(String optionName) {
            String strValue = this.attributeDef.getOption(optionName);
            Integer ret = StringUtils.isBlank((String)strValue) ? null : Integer.valueOf(Integer.parseInt(strValue));
            return ret;
        }

        public String getOptionString(String optionName) {
            String strValue = this.attributeDef.getOption(optionName);
            String ret = StringUtils.isBlank((String)strValue) ? null : strValue;
            return ret;
        }

        public static String getEdgeLabel(String property) {
            return "__" + property;
        }

        public static String encodePropertyKey(String key) {
            if (StringUtils.isBlank((String)key)) {
                return key;
            }
            for (String[] strMap : RESERVED_CHAR_ENCODE_MAP) {
                key = key.replace(strMap[0], strMap[1]);
            }
            return key;
        }

        public static String decodePropertyKey(String key) {
            if (StringUtils.isBlank((String)key)) {
                return key;
            }
            for (String[] strMap : RESERVED_CHAR_ENCODE_MAP) {
                key = key.replace(strMap[1], strMap[0]);
            }
            return key;
        }

        public static String escapeIndexQueryValue(Collection<String> values) {
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            if (CollectionUtils.isNotEmpty(values)) {
                Iterator<String> iter = values.iterator();
                sb.append(AtlasAttribute.escapeIndexQueryValue(iter.next()));
                while (iter.hasNext()) {
                    sb.append(' ').append(AtlasAttribute.escapeIndexQueryValue(iter.next()));
                }
            }
            sb.append(')');
            return sb.toString();
        }

        public static String escapeIndexQueryValue(String value) {
            String ret = value;
            if (StringUtils.containsAny((String)value, (char[])IDX_QRY_OFFENDING_CHARS)) {
                boolean isQuoteAtEnd;
                boolean isQuoteAtStart = value.charAt(0) == '\"';
                boolean bl = isQuoteAtEnd = value.charAt(value.length() - 1) == '\"';
                if (!isQuoteAtStart) {
                    ret = !isQuoteAtEnd ? '\"' + value + '\"' : '\"' + value;
                } else if (!isQuoteAtEnd) {
                    ret = value + '\"';
                }
            }
            return ret;
        }

        private String getRelationshipEdgeLabel(String relationshipLabel) {
            return relationshipLabel == null ? AtlasAttribute.getEdgeLabel(this.qualifiedName) : relationshipLabel;
        }

        public static String getQualifiedAttributeName(AtlasStructDef structDef, String attrName) {
            if (AtlasAttribute.isRootType(structDef)) {
                return attrName;
            }
            return attrName.contains(".") ? attrName : String.format("%s.%s", structDef.getName(), attrName);
        }

        public static String generateVertexPropertyName(AtlasStructDef structDef, AtlasStructDef.AtlasAttributeDef attrDef, String qualifiedName) {
            String vertexPropertyName = qualifiedName;
            String attrName = attrDef.getName();
            if (AtlasAttribute.isRootType(structDef)) {
                return attrName;
            }
            if (!attrDef.getName().contains(".") && AtlasStructDef.AtlasAttributeDef.IndexType.STRING.equals((Object)attrDef.getIndexType()) && "string".equalsIgnoreCase(attrDef.getTypeName())) {
                vertexPropertyName = String.format("%s.%s%s", structDef.getName(), VERTEX_PROPERTY_PREFIX_STRING_INDEX_TYPE, attrDef.getName());
            }
            return AtlasAttribute.encodePropertyKey(vertexPropertyName);
        }

        private static boolean isRootType(AtlasStructDef structDef) {
            return StringUtils.equals((String)structDef.getName(), (String)AtlasEntityType.ENTITY_ROOT.getTypeName()) || StringUtils.equals((String)structDef.getName(), (String)AtlasClassificationType.CLASSIFICATION_ROOT.getTypeName());
        }

        public static enum AtlasRelationshipEdgeDirection {
            IN,
            OUT,
            BOTH;

        }
    }
}

