/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.instance;

import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.ModelTestUtil;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasClassification {
    @Test
    public void testClassificationSerDe() throws AtlasBaseException {
        AtlasClassificationDef classificationDef = ModelTestUtil.getClassificationDef();
        AtlasTypeRegistry typeRegistry = ModelTestUtil.getTypesRegistry();
        AtlasClassificationType classificationType = typeRegistry.getClassificationTypeByName(classificationDef.getName());
        Assert.assertNotNull((Object)classificationType);
        AtlasClassification ent1 = ModelTestUtil.newClassification(classificationDef, typeRegistry);
        String jsonString = AtlasType.toJson((Object)ent1);
        AtlasClassification ent2 = (AtlasClassification)AtlasType.fromJson((String)jsonString, AtlasClassification.class);
        classificationType.normalizeAttributeValues(ent2);
        Assert.assertEquals((Object)ent2, (Object)ent1, (String)"Incorrect serialization/deserialization of AtlasClassification");
    }

    @Test
    public void testClassificationSerDeWithSuperType() throws AtlasBaseException {
        AtlasClassificationDef classificationDef = ModelTestUtil.getClassificationDefWithSuperType();
        AtlasTypeRegistry typeRegistry = ModelTestUtil.getTypesRegistry();
        AtlasClassificationType classificationType = typeRegistry.getClassificationTypeByName(classificationDef.getName());
        Assert.assertNotNull((Object)classificationType);
        AtlasClassification ent1 = classificationType.createDefaultValue();
        String jsonString = AtlasType.toJson((Object)ent1);
        AtlasClassification ent2 = (AtlasClassification)AtlasType.fromJson((String)jsonString, AtlasClassification.class);
        classificationType.normalizeAttributeValues(ent2);
        Assert.assertEquals((Object)ent2, (Object)ent1, (String)"Incorrect serialization/deserialization of AtlasClassification with superType");
    }

    @Test
    public void testClassificationSerDeWithSuperTypes() throws AtlasBaseException {
        AtlasClassificationDef classificationDef = ModelTestUtil.getClassificationDefWithSuperTypes();
        AtlasTypeRegistry typeRegistry = ModelTestUtil.getTypesRegistry();
        AtlasClassificationType classificationType = typeRegistry.getClassificationTypeByName(classificationDef.getName());
        Assert.assertNotNull((Object)classificationType);
        AtlasClassification ent1 = classificationType.createDefaultValue();
        String jsonString = AtlasType.toJson((Object)ent1);
        AtlasClassification ent2 = (AtlasClassification)AtlasType.fromJson((String)jsonString, AtlasClassification.class);
        classificationType.normalizeAttributeValues(ent2);
        Assert.assertEquals((Object)ent2, (Object)ent1, (String)"Incorrect serialization/deserialization of AtlasClassification with superTypes");
    }
}

