/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import org.apache.atlas.type.AtlasBuiltInTypes;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasBuiltInTypesFloatDouble {
    @Test
    public void floatRangeCheck() {
        this.assertFloatChecks(String.valueOf("-1.E-45"), true);
        this.assertFloatChecks(String.valueOf(Float.MAX_VALUE), true);
        this.assertFloatChecks("3.4028235E32", true);
        this.assertFloatChecks("-3.4028235E32", true);
        this.assertFloatChecks(String.valueOf(Float.MIN_VALUE), true);
        this.assertFloatChecks("4028235e+555", false);
        this.assertFloatChecks("-4028235e+555", false);
    }

    @Test
    public void doubleRangeCheck() {
        this.assertDoubleChecks(String.valueOf(Double.MAX_VALUE), true);
        this.assertDoubleChecks("3.4028235E32", true);
        this.assertDoubleChecks(String.valueOf(Double.MIN_VALUE), true);
        this.assertDoubleChecks("4028235e+55555", false);
        this.assertDoubleChecks("-4028235e+55555", false);
    }

    private void assertFloatChecks(String v, boolean notNull) {
        this.assertNullNotNull(notNull, new AtlasBuiltInTypes.AtlasFloatType().getNormalizedValue((Object)v));
    }

    private void assertDoubleChecks(String v, boolean notNull) {
        this.assertNullNotNull(notNull, new AtlasBuiltInTypes.AtlasDoubleType().getNormalizedValue((Object)v));
    }

    private void assertNullNotNull(boolean notNull, Object f) {
        if (notNull) {
            Assert.assertNotNull((Object)f);
        } else {
            Assert.assertNull((Object)f);
        }
    }
}

