/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasDoubleType {
    private final AtlasBuiltInTypes.AtlasDoubleType doubleType = new AtlasBuiltInTypes.AtlasDoubleType();
    private final Object[] validValues = new Object[]{null, (byte)1, (short)1, 1, 1L, Float.valueOf(1.0f), 1.0, BigInteger.valueOf(1L), BigDecimal.valueOf(1L), "1"};
    private final Object[] validValuesLimitCheck = new Object[]{(byte)-128, (byte)127, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Long.MIN_VALUE, Long.MAX_VALUE, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Double.MIN_VALUE, Double.MAX_VALUE};
    private final Object[] negativeValues = new Object[]{(byte)-1, (short)-1, -1, -1L, Float.valueOf(-1.0f), -1.0, BigInteger.valueOf(-1L), BigDecimal.valueOf(-1L), "-1"};
    private final Object[] negativeValuesLimitCheck = new Object[]{-4.9E-324, -1.7976931348623157E308, Float.valueOf(-1.4E-45f), Float.valueOf(-3.4028235E38f)};
    private final Object[] invalidValues = new Object[]{"", "12ab", "abcd", "-12ab", Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};

    @Test
    public void testDoubleTypeDefaultValue() {
        Double defValue = this.doubleType.createDefaultValue();
        Assert.assertEquals((Object)defValue, (Object)0.0);
    }

    @Test
    public void testDoubleTypeIsValidValue() {
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.doubleType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.validValuesLimitCheck) {
            Assert.assertTrue((boolean)this.doubleType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.negativeValues) {
            Assert.assertTrue((boolean)this.doubleType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.negativeValuesLimitCheck) {
            Assert.assertTrue((boolean)this.doubleType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.doubleType.isValidValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testDoubleTypeGetNormalizedValue() {
        double d;
        Double normalizedValue;
        Assert.assertNull((Object)this.doubleType.getNormalizedValue(null), (String)("value=" + null));
        for (Object value : this.validValues) {
            if (value == null) continue;
            normalizedValue = this.doubleType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
            Assert.assertEquals((Object)normalizedValue, (Object)1.0, (String)("value=" + value));
        }
        for (Object value : this.validValuesLimitCheck) {
            if (value == null) continue;
            normalizedValue = this.doubleType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
            if (value instanceof Float) {
                d = ((Float)value).doubleValue();
                Assert.assertEquals((Object)normalizedValue, (Object)d, (String)("value=" + value));
                continue;
            }
            if (value instanceof Double) {
                d = (Double)value;
                Assert.assertEquals((Object)normalizedValue, (Object)d, (String)("value=" + value));
                continue;
            }
            Assert.assertEquals((Object)normalizedValue, (Object)Double.valueOf(value.toString()), (String)("value=" + value));
        }
        for (Object value : this.negativeValues) {
            normalizedValue = this.doubleType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
            Assert.assertEquals((Object)normalizedValue, (Object)-1.0, (String)("value=" + value));
        }
        for (Object value : this.negativeValuesLimitCheck) {
            normalizedValue = this.doubleType.getNormalizedValue(value);
            if (value instanceof Float) {
                d = ((Float)value).doubleValue();
                Assert.assertEquals((Object)normalizedValue, (Object)d, (String)("value=" + value));
                continue;
            }
            if (!(value instanceof Double)) continue;
            d = (Double)value;
            Assert.assertEquals((Object)normalizedValue, (Object)d, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertNull((Object)this.doubleType.getNormalizedValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testDoubleTypeValidateValue() {
        ArrayList messages = new ArrayList();
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.doubleType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.negativeValues) {
            Assert.assertTrue((boolean)this.doubleType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.doubleType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)1, (String)("value=" + value));
            messages.clear();
        }
    }
}

