/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.v1.model.typedef.AttributeDefinition;
import org.apache.atlas.v1.model.typedef.Multiplicity;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMultiplicity {
    @Test
    public void verify() {
        this.assertMultiplicity(AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, false, 1, 1);
        this.assertMultiplicity(AtlasStructDef.AtlasAttributeDef.Cardinality.LIST, false, 1, Integer.MAX_VALUE);
        this.assertMultiplicity(AtlasStructDef.AtlasAttributeDef.Cardinality.SET, true, 0, Integer.MAX_VALUE);
    }

    private void assertMultiplicity(AtlasStructDef.AtlasAttributeDef.Cardinality cardinality, boolean optionality, int expectedLower, int expectedUpper) {
        AtlasStructDef.AtlasAttributeDef attributeDef = new AtlasStructDef.AtlasAttributeDef();
        attributeDef.setCardinality(cardinality);
        attributeDef.setIsOptional(optionality);
        Multiplicity multiplicity = AtlasTypeUtil.getMultiplicity((AtlasStructDef.AtlasAttributeDef)attributeDef);
        Assert.assertNotNull((Object)multiplicity);
        Assert.assertEquals((int)multiplicity.getLower(), (int)expectedLower);
        Assert.assertEquals((int)multiplicity.getUpper(), (int)expectedUpper);
        AttributeDefinition attributeDefinition = new AttributeDefinition();
        attributeDefinition.setMultiplicity(multiplicity);
        Assert.assertNotNull((Object)AtlasType.toJson((Object)attributeDefinition));
    }
}

