/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hook;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class FailedMessagesLogger {
    public static final String PATTERN_SPEC_TIMESTAMP_MESSAGE_NEWLINE = "%d{ISO8601} %m%n";
    public static final String DATE_PATTERN = ".yyyy-MM-dd";
    private final Logger logger = Logger.getLogger((String)"org.apache.atlas.hook.FailedMessagesLogger");
    private String failedMessageFile;

    public FailedMessagesLogger(String failedMessageFile) {
        this.failedMessageFile = failedMessageFile;
    }

    void init() {
        String rootLoggerDirectory = this.getRootLoggerDirectory();
        if (rootLoggerDirectory == null) {
            return;
        }
        String absolutePath = new File(rootLoggerDirectory, this.failedMessageFile).getAbsolutePath();
        try {
            DailyRollingFileAppender failedLogFilesAppender = new DailyRollingFileAppender((Layout)new PatternLayout(PATTERN_SPEC_TIMESTAMP_MESSAGE_NEWLINE), absolutePath, DATE_PATTERN);
            this.logger.addAppender((Appender)failedLogFilesAppender);
            this.logger.setLevel(Level.ERROR);
            this.logger.setAdditivity(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getRootLoggerDirectory() {
        String rootLoggerDirectory = null;
        Logger rootLogger = Logger.getRootLogger();
        Enumeration allAppenders = rootLogger.getAllAppenders();
        if (allAppenders != null) {
            while (allAppenders.hasMoreElements()) {
                Appender appender = (Appender)allAppenders.nextElement();
                if (!(appender instanceof FileAppender)) continue;
                FileAppender fileAppender = (FileAppender)appender;
                String rootLoggerFile = fileAppender.getFile();
                rootLoggerDirectory = rootLoggerFile != null ? new File(rootLoggerFile).getParent() : null;
                break;
            }
        }
        return rootLoggerDirectory;
    }

    void log(String message) {
        this.logger.error((Object)message);
    }
}

