/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hook;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.hook.FailedMessagesLogger;
import org.apache.atlas.kafka.NotificationProvider;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.atlas.notification.NotificationException;
import org.apache.atlas.notification.NotificationInterface;
import org.apache.atlas.utils.AtlasConfigurationUtil;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AtlasHook {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasHook.class);
    public static final String ATLAS_NOTIFICATION_ASYNCHRONOUS = "atlas.notification.hook.asynchronous";
    public static final String ATLAS_NOTIFICATION_ASYNCHRONOUS_MIN_THREADS = "atlas.notification.hook.asynchronous.minThreads";
    public static final String ATLAS_NOTIFICATION_ASYNCHRONOUS_MAX_THREADS = "atlas.notification.hook.asynchronous.maxThreads";
    public static final String ATLAS_NOTIFICATION_ASYNCHRONOUS_KEEP_ALIVE_TIME_MS = "atlas.notification.hook.asynchronous.keepAliveTimeMs";
    public static final String ATLAS_NOTIFICATION_ASYNCHRONOUS_QUEUE_SIZE = "atlas.notification.hook.asynchronous.queueSize";
    public static final String ATLAS_NOTIFICATION_MAX_RETRIES = "atlas.notification.hook.retry.maxRetries";
    public static final String ATLAS_NOTIFICATION_RETRY_INTERVAL = "atlas.notification.hook.retry.interval";
    public static final String ATLAS_NOTIFICATION_FAILED_MESSAGES_FILENAME_KEY = "atlas.notification.failed.messages.filename";
    public static final String ATLAS_NOTIFICATION_LOG_FAILED_MESSAGES_ENABLED_KEY = "atlas.notification.log.failed.messages";
    public static final String ATLAS_HOOK_FAILED_MESSAGES_LOG_DEFAULT_NAME = "atlas_hook_failed_messages.log";
    public static final String CONF_METADATA_NAMESPACE = "atlas.metadata.namespace";
    public static final String CLUSTER_NAME_KEY = "atlas.cluster.name";
    public static final String DEFAULT_CLUSTER_NAME = "primary";
    protected static Configuration atlasProperties;
    protected static NotificationInterface notificationInterface;
    private static final String metadataNamespace;
    private static final int SHUTDOWN_HOOK_WAIT_TIME_MS = 3000;
    private static final boolean logFailedMessages;
    private static final FailedMessagesLogger failedMessagesLogger;
    private static final int notificationMaxRetries;
    private static final int notificationRetryInterval;
    private static ExecutorService executor;

    public AtlasHook() {
        notificationInterface.init(this.getClass().getSimpleName(), failedMessagesLogger);
    }

    public AtlasHook(String name) {
        LOG.info("AtlasHook: Spool name: Passed from caller.: {}", (Object)name);
        notificationInterface.init(name, failedMessagesLogger);
    }

    public static void notifyEntities(final List<HookNotification> messages, final UserGroupInformation ugi, final int maxRetries) {
        if (executor == null) {
            AtlasHook.notifyEntitiesInternal(messages, maxRetries, ugi, notificationInterface, logFailedMessages, failedMessagesLogger);
        } else {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    AtlasHook.notifyEntitiesInternal(messages, maxRetries, ugi, notificationInterface, logFailedMessages, failedMessagesLogger);
                }
            });
        }
    }

    @VisibleForTesting
    static void notifyEntitiesInternal(final List<HookNotification> messages, int maxRetries, UserGroupInformation ugi, final NotificationInterface notificationInterface, boolean shouldLogFailedMessages, FailedMessagesLogger logger) {
        if (messages == null || messages.isEmpty()) {
            return;
        }
        int maxAttempts = maxRetries < 1 ? 1 : maxRetries;
        Exception notificationFailure = null;
        for (int numAttempt = 1; numAttempt <= maxAttempts; ++numAttempt) {
            if (numAttempt > 1) {
                try {
                    LOG.debug("Sleeping for {} ms before retry", (Object)notificationRetryInterval);
                    Thread.sleep(notificationRetryInterval);
                }
                catch (InterruptedException ie) {
                    LOG.error("Notification hook thread sleep interrupted");
                    break;
                }
            }
            try {
                if (ugi == null) {
                    notificationInterface.send(NotificationInterface.NotificationType.HOOK, messages);
                } else {
                    PrivilegedExceptionAction<Object> privilegedNotify = new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            notificationInterface.send(NotificationInterface.NotificationType.HOOK, messages);
                            return messages;
                        }
                    };
                    ugi.doAs((PrivilegedExceptionAction)privilegedNotify);
                }
                notificationFailure = null;
                break;
            }
            catch (Exception e) {
                notificationFailure = e;
                LOG.error("Failed to send notification - attempt #{}; error={}", (Object)numAttempt, (Object)e.getMessage());
                continue;
            }
        }
        if (notificationFailure != null) {
            if (shouldLogFailedMessages && notificationFailure instanceof NotificationException) {
                List<String> failedMessages = ((NotificationException)((Object)notificationFailure)).getFailedMessages();
                for (String msg : failedMessages) {
                    logger.log(msg);
                }
            }
            LOG.error("Giving up after {} failed attempts to send notification to Atlas: {}", new Object[]{maxAttempts, messages.toString(), notificationFailure});
        }
    }

    protected void notifyEntities(List<HookNotification> messages, UserGroupInformation ugi) {
        AtlasHook.notifyEntities(messages, ugi, notificationMaxRetries);
    }

    public static String getUser() {
        return AtlasHook.getUser(null, null);
    }

    public static String getUser(String userName) {
        return AtlasHook.getUser(userName, null);
    }

    public static String getUser(String userName, UserGroupInformation ugi) {
        if (StringUtils.isNotEmpty((String)userName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Returning userName {}", (Object)userName);
            }
            return userName;
        }
        if (ugi != null && StringUtils.isNotEmpty((String)ugi.getShortUserName())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Returning ugi.getShortUserName {}", (Object)userName);
            }
            return ugi.getShortUserName();
        }
        try {
            return UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException e) {
            LOG.warn("Failed for UserGroupInformation.getCurrentUser() ", (Throwable)e);
            return System.getProperty("user.name");
        }
    }

    private static String getMetadataNamespace(Configuration config) {
        return AtlasConfigurationUtil.getRecentString((Configuration)config, (String)CONF_METADATA_NAMESPACE, (String)AtlasHook.getClusterName(config));
    }

    private static String getClusterName(Configuration config) {
        return config.getString(CLUSTER_NAME_KEY, DEFAULT_CLUSTER_NAME);
    }

    public String getMetadataNamespace() {
        return metadataNamespace;
    }

    static {
        executor = null;
        try {
            atlasProperties = ApplicationProperties.get();
        }
        catch (Exception e) {
            LOG.info("Failed to load application properties", (Throwable)e);
        }
        String failedMessageFile = atlasProperties.getString(ATLAS_NOTIFICATION_FAILED_MESSAGES_FILENAME_KEY, ATLAS_HOOK_FAILED_MESSAGES_LOG_DEFAULT_NAME);
        logFailedMessages = atlasProperties.getBoolean(ATLAS_NOTIFICATION_LOG_FAILED_MESSAGES_ENABLED_KEY, true);
        if (logFailedMessages) {
            failedMessagesLogger = new FailedMessagesLogger(failedMessageFile);
            failedMessagesLogger.init();
        } else {
            failedMessagesLogger = null;
        }
        metadataNamespace = AtlasHook.getMetadataNamespace(atlasProperties);
        notificationMaxRetries = atlasProperties.getInt(ATLAS_NOTIFICATION_MAX_RETRIES, 3);
        notificationRetryInterval = atlasProperties.getInt(ATLAS_NOTIFICATION_RETRY_INTERVAL, 1000);
        notificationInterface = NotificationProvider.get();
        String currentUser = "";
        try {
            currentUser = AtlasHook.getUser();
        }
        catch (Exception excp) {
            LOG.warn("Error in determining current user", (Throwable)excp);
        }
        notificationInterface.setCurrentUser(currentUser);
        boolean isAsync = atlasProperties.getBoolean(ATLAS_NOTIFICATION_ASYNCHRONOUS, Boolean.TRUE);
        if (isAsync) {
            int minThreads = atlasProperties.getInt(ATLAS_NOTIFICATION_ASYNCHRONOUS_MIN_THREADS, 1);
            int maxThreads = atlasProperties.getInt(ATLAS_NOTIFICATION_ASYNCHRONOUS_MAX_THREADS, 1);
            long keepAliveTimeMs = atlasProperties.getLong(ATLAS_NOTIFICATION_ASYNCHRONOUS_KEEP_ALIVE_TIME_MS, 10000L);
            int queueSize = atlasProperties.getInt(ATLAS_NOTIFICATION_ASYNCHRONOUS_QUEUE_SIZE, 10000);
            executor = new ThreadPoolExecutor(minThreads, maxThreads, keepAliveTimeMs, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(queueSize), new ThreadFactoryBuilder().setNameFormat("Atlas Notifier %d").setDaemon(true).build());
            ShutdownHookManager.get().addShutdownHook((Runnable)new Thread(){

                @Override
                public void run() {
                    try {
                        LOG.info("==> Shutdown of Atlas Hook");
                        notificationInterface.close();
                        executor.shutdown();
                        executor.awaitTermination(3000L, TimeUnit.MILLISECONDS);
                        executor = null;
                    }
                    catch (InterruptedException excp) {
                        LOG.info("Interrupt received in shutdown.", (Throwable)excp);
                    }
                    finally {
                        LOG.info("<== Shutdown of Atlas Hook");
                    }
                }
            }, 30);
        }
        LOG.info("Created Atlas Hook");
    }
}

