/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification.spool.utils.local;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.atlas.notification.spool.utils.local.FileOpRead;
import org.apache.atlas.notification.spool.utils.local.FileOperation;
import org.apache.commons.lang.StringUtils;

public class FileOpCompaction
extends FileOperation {
    private final FileOpRead fileOpLoad;

    public FileOpCompaction(String source) {
        super(source);
        this.fileOpLoad = new FileOpRead(source);
    }

    @Override
    public FileLock run(RandomAccessFile file, FileChannel channel, String json) throws IOException {
        FileLock lock = file.getChannel().tryLock();
        this.fileOpLoad.perform(this.getFile(), "");
        file.getChannel().truncate(0L);
        String[] rawItems = this.fileOpLoad.getItems();
        if (rawItems != null) {
            for (String record : rawItems) {
                if (!StringUtils.isNotBlank((String)record)) continue;
                file.writeBytes(record);
            }
        }
        return lock;
    }
}

