/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import java.lang.reflect.Method;
import javax.inject.Inject;
import org.aopalliance.aop.Advice;
import org.apache.atlas.GraphTransactionInterceptor;
import org.apache.atlas.annotation.GraphTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.stereotype.Component;

@Component
public class GraphTransactionAdvisor
extends AbstractPointcutAdvisor {
    private static final Logger LOG = LoggerFactory.getLogger(GraphTransactionAdvisor.class);
    private final StaticMethodMatcherPointcut pointcut = new StaticMethodMatcherPointcut(){

        public boolean matches(Method method, Class<?> targetClass) {
            boolean annotationPresent = method.isAnnotationPresent(GraphTransaction.class);
            if (annotationPresent) {
                LOG.info("GraphTransaction intercept for {}.{}", (Object)targetClass.getName(), (Object)method.getName());
            }
            return annotationPresent;
        }
    };
    private final GraphTransactionInterceptor interceptor;

    @Inject
    public GraphTransactionAdvisor(GraphTransactionInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this.interceptor;
    }
}

