/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasEntityAccessRequest;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.discovery.AtlasLineageService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.lineage.AtlasLineageInfo;
import org.apache.atlas.model.lineage.LineageOnDemandConstraints;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.util.AtlasGremlinQueryProvider;
import org.apache.atlas.v1.model.lineage.SchemaResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EntityLineageService
implements AtlasLineageService {
    private static final Logger LOG = LoggerFactory.getLogger(EntityLineageService.class);
    private static final String PROCESS_INPUTS_EDGE = "__Process.inputs";
    private static final String PROCESS_OUTPUTS_EDGE = "__Process.outputs";
    private static final String COLUMNS = "columns";
    private static final boolean LINEAGE_USING_GREMLIN = AtlasConfiguration.LINEAGE_USING_GREMLIN.getBoolean();
    private static final Integer DEFAULT_LINEAGE_MAX_NODE_COUNT = 9000;
    private static final int LINEAGE_ON_DEMAND_DEFAULT_DEPTH = 3;
    private static final int LINEAGE_ON_DEMAND_DEFAULT_NODE_COUNT = AtlasConfiguration.LINEAGE_ON_DEMAND_DEFAULT_NODE_COUNT.getInt();
    private static final String SEPARATOR = "->";
    private final AtlasGraph graph;
    private final AtlasGremlinQueryProvider gremlinQueryProvider;
    private final EntityGraphRetriever entityRetriever;
    private final AtlasTypeRegistry atlasTypeRegistry;

    @Inject
    EntityLineageService(AtlasTypeRegistry typeRegistry, AtlasGraph atlasGraph) {
        this.graph = atlasGraph;
        this.gremlinQueryProvider = AtlasGremlinQueryProvider.INSTANCE;
        this.entityRetriever = new EntityGraphRetriever(atlasGraph, typeRegistry);
        this.atlasTypeRegistry = typeRegistry;
    }

    @Override
    @GraphTransaction
    public AtlasLineageInfo getAtlasLineageInfo(String guid, AtlasLineageInfo.LineageDirection direction, int depth) throws AtlasBaseException {
        boolean isDataSet = this.validateEntityTypeAndCheckIfDataSet(guid);
        AtlasLineageInfo ret = LINEAGE_USING_GREMLIN ? this.getLineageInfoV1(guid, direction, depth, isDataSet) : this.getLineageInfoV2(guid, direction, depth, isDataSet);
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasLineageInfo getAtlasLineageInfo(String guid, Map<String, LineageOnDemandConstraints> lineageConstraintsMap) throws AtlasBaseException {
        if (MapUtils.isEmpty(lineageConstraintsMap)) {
            lineageConstraintsMap = new HashMap<String, LineageOnDemandConstraints>();
            lineageConstraintsMap.put(guid, this.getDefaultLineageConstraints(guid));
        }
        boolean isDataSet = this.validateEntityTypeAndCheckIfDataSet(guid);
        AtlasLineageInfo ret = this.getLineageInfoOnDemand(guid, lineageConstraintsMap, isDataSet);
        this.appendLineageOnDemandPayload(ret, lineageConstraintsMap);
        this.cleanupRelationsOnDemand(ret);
        return ret;
    }

    private boolean validateEntityTypeAndCheckIfDataSet(String guid) throws AtlasBaseException {
        boolean isProcess;
        AtlasEntityHeader entity = this.entityRetriever.toAtlasEntityHeaderWithClassifications(guid);
        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.atlasTypeRegistry, AtlasPrivilege.ENTITY_READ, entity), (Object[])new Object[]{"read entity lineage: guid=", guid});
        AtlasEntityType entityType = this.atlasTypeRegistry.getEntityTypeByName(entity.getTypeName());
        if (entityType == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{entity.getTypeName()});
        }
        boolean isDataSet = entityType.getTypeAndAllSuperTypes().contains("DataSet");
        if (!isDataSet && !(isProcess = entityType.getTypeAndAllSuperTypes().contains("Process"))) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_LINEAGE_ENTITY_TYPE, new String[]{guid, entity.getTypeName()});
        }
        return isDataSet;
    }

    private void appendLineageOnDemandPayload(AtlasLineageInfo lineageInfo, Map<String, LineageOnDemandConstraints> lineageConstraintsMap) {
        if (lineageInfo == null || MapUtils.isEmpty(lineageConstraintsMap)) {
            return;
        }
        lineageInfo.setLineageOnDemandPayload(lineageConstraintsMap);
    }

    private void cleanupRelationsOnDemand(AtlasLineageInfo lineageInfo) {
        if (lineageInfo != null && MapUtils.isNotEmpty((Map)lineageInfo.getRelationsOnDemand())) {
            lineageInfo.getRelationsOnDemand().entrySet().removeIf(x -> !((AtlasLineageInfo.LineageInfoOnDemand)x.getValue()).hasMoreInputs() && !((AtlasLineageInfo.LineageInfoOnDemand)x.getValue()).hasMoreOutputs());
        }
    }

    @Override
    @GraphTransaction
    public SchemaResponse.SchemaDetails getSchemaForHiveTableByName(String datasetName) throws AtlasBaseException {
        if (StringUtils.isEmpty((String)datasetName)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[0]);
        }
        AtlasEntityType hive_table = this.atlasTypeRegistry.getEntityTypeByName("hive_table");
        HashMap<String, Object> lookupAttributes = new HashMap<String, Object>();
        lookupAttributes.put("qualifiedName", datasetName);
        String guid = AtlasGraphUtilsV2.getGuidByUniqueAttributes(hive_table, lookupAttributes);
        return this.getSchemaForHiveTableByGuid(guid);
    }

    @Override
    @GraphTransaction
    public SchemaResponse.SchemaDetails getSchemaForHiveTableByGuid(String guid) throws AtlasBaseException {
        if (StringUtils.isEmpty((String)guid)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[0]);
        }
        SchemaResponse.SchemaDetails ret = new SchemaResponse.SchemaDetails();
        AtlasEntityType hive_column = this.atlasTypeRegistry.getEntityTypeByName("hive_column");
        ret.setDataType(AtlasTypeUtil.toClassTypeDefinition((AtlasEntityType)hive_column));
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.entityRetriever.toAtlasEntityWithExtInfo(guid);
        AtlasEntity entity = entityWithExtInfo.getEntity();
        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.atlasTypeRegistry, AtlasPrivilege.ENTITY_READ, new AtlasEntityHeader(entity)), (Object[])new Object[]{"read entity schema: guid=", guid});
        Map referredEntities = entityWithExtInfo.getReferredEntities();
        List<String> columnIds = this.getColumnIds(entity);
        if (MapUtils.isNotEmpty((Map)referredEntities)) {
            List rows = referredEntities.entrySet().stream().filter(e -> this.isColumn(columnIds, (Map.Entry<String, AtlasEntity>)e)).map(e -> AtlasTypeUtil.toMap((AtlasEntity)((AtlasEntity)e.getValue()))).collect(Collectors.toList());
            ret.setRows(rows);
        }
        return ret;
    }

    private List<String> getColumnIds(AtlasEntity entity) {
        ArrayList<String> ret = new ArrayList<String>();
        Object columnObjs = entity.getAttribute(COLUMNS);
        if (columnObjs instanceof List) {
            for (Object pkObj : (List)columnObjs) {
                if (!(pkObj instanceof AtlasObjectId)) continue;
                ret.add(((AtlasObjectId)pkObj).getGuid());
            }
        }
        return ret;
    }

    private boolean isColumn(List<String> columnIds, Map.Entry<String, AtlasEntity> e) {
        return columnIds.contains(e.getValue().getGuid());
    }

    private AtlasLineageInfo getLineageInfoV1(String guid, AtlasLineageInfo.LineageDirection direction, int depth, boolean isDataSet) throws AtlasBaseException {
        AtlasLineageInfo ret = direction.equals((Object)AtlasLineageInfo.LineageDirection.INPUT) ? this.getLineageInfo(guid, AtlasLineageInfo.LineageDirection.INPUT, depth, isDataSet) : (direction.equals((Object)AtlasLineageInfo.LineageDirection.OUTPUT) ? this.getLineageInfo(guid, AtlasLineageInfo.LineageDirection.OUTPUT, depth, isDataSet) : this.getBothLineageInfoV1(guid, depth, isDataSet));
        return ret;
    }

    private AtlasLineageInfo getLineageInfo(String guid, AtlasLineageInfo.LineageDirection direction, int depth, boolean isDataSet) throws AtlasBaseException {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        String lineageQuery = this.getLineageQuery(guid, direction, depth, isDataSet, bindings);
        List results = this.executeGremlinScript(bindings, lineageQuery);
        HashMap<String, AtlasEntityHeader> entities = new HashMap<String, AtlasEntityHeader>();
        HashSet<AtlasLineageInfo.LineageRelation> relations = new HashSet<AtlasLineageInfo.LineageRelation>();
        if (CollectionUtils.isNotEmpty((Collection)results)) {
            for (Object result : results) {
                if (result instanceof Map) {
                    for (Map.Entry o : ((Map)result).entrySet()) {
                        Map.Entry entry = o;
                        Object value = entry.getValue();
                        if (value instanceof List) {
                            for (Object elem : (List)value) {
                                if (elem instanceof AtlasEdge) {
                                    this.processEdge((AtlasEdge)elem, entities, relations);
                                    continue;
                                }
                                LOG.warn("Invalid value of type {} found, ignoring", (Object)(elem != null ? elem.getClass().getSimpleName() : "null"));
                            }
                            continue;
                        }
                        if (value instanceof AtlasEdge) {
                            this.processEdge((AtlasEdge)value, entities, relations);
                            continue;
                        }
                        LOG.warn("Invalid value of type {} found, ignoring", (Object)(value != null ? value.getClass().getSimpleName() : "null"));
                    }
                    continue;
                }
                if (!(result instanceof AtlasEdge)) continue;
                this.processEdge((AtlasEdge)result, entities, relations);
            }
        }
        return new AtlasLineageInfo(guid, entities, relations, direction, depth);
    }

    private AtlasLineageInfo getLineageInfoV2(String guid, AtlasLineageInfo.LineageDirection direction, int depth, boolean isDataSet) throws AtlasBaseException {
        AtlasLineageInfo ret = this.initializeLineageInfo(guid, direction, depth);
        if (depth == 0) {
            depth = -1;
        }
        if (isDataSet) {
            AtlasVertex datasetVertex = AtlasGraphUtilsV2.findByGuid(this.graph, guid);
            if (direction == AtlasLineageInfo.LineageDirection.INPUT || direction == AtlasLineageInfo.LineageDirection.BOTH) {
                this.traverseEdges(datasetVertex, true, depth, ret);
            }
            if (direction == AtlasLineageInfo.LineageDirection.OUTPUT || direction == AtlasLineageInfo.LineageDirection.BOTH) {
                this.traverseEdges(datasetVertex, false, depth, ret);
            }
        } else {
            AtlasVertex datasetVertex;
            Iterable processEdges;
            AtlasVertex processVertex = AtlasGraphUtilsV2.findByGuid(this.graph, guid);
            if (direction == AtlasLineageInfo.LineageDirection.INPUT || direction == AtlasLineageInfo.LineageDirection.BOTH) {
                processEdges = processVertex.getEdges(AtlasEdgeDirection.OUT, PROCESS_INPUTS_EDGE);
                for (AtlasEdge processEdge : processEdges) {
                    this.addEdgeToResult(processEdge, ret);
                    datasetVertex = processEdge.getInVertex();
                    this.traverseEdges(datasetVertex, true, depth - 1, ret);
                }
            }
            if (direction == AtlasLineageInfo.LineageDirection.OUTPUT || direction == AtlasLineageInfo.LineageDirection.BOTH) {
                processEdges = processVertex.getEdges(AtlasEdgeDirection.OUT, PROCESS_OUTPUTS_EDGE);
                for (AtlasEdge processEdge : processEdges) {
                    this.addEdgeToResult(processEdge, ret);
                    datasetVertex = processEdge.getInVertex();
                    this.traverseEdges(datasetVertex, false, depth - 1, ret);
                }
            }
        }
        return ret;
    }

    private LineageOnDemandConstraints getDefaultLineageConstraints(String guid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("No lineage on-demand constraints provided for guid: {}, configuring with default values direction: {}, inputRelationsLimit: {}, outputRelationsLimit: {}, depth: {}", new Object[]{guid, AtlasLineageInfo.LineageDirection.BOTH, LINEAGE_ON_DEMAND_DEFAULT_NODE_COUNT, LINEAGE_ON_DEMAND_DEFAULT_NODE_COUNT, 3});
        }
        return new LineageOnDemandConstraints();
    }

    private LineageOnDemandConstraints getAndValidateLineageConstraintsByGuid(String guid, Map<String, LineageOnDemandConstraints> lineageConstraintsMap) {
        if (lineageConstraintsMap == null || !lineageConstraintsMap.containsKey(guid)) {
            return this.getDefaultLineageConstraints(guid);
        }
        LineageOnDemandConstraints lineageConstraintsByGuid = lineageConstraintsMap.get(guid);
        if (lineageConstraintsByGuid == null) {
            return this.getDefaultLineageConstraints(guid);
        }
        if (Objects.isNull(lineageConstraintsByGuid.getDirection())) {
            LOG.info("No lineage on-demand direction provided for guid: {}, configuring with default value {}", (Object)guid, (Object)AtlasLineageInfo.LineageDirection.BOTH);
            lineageConstraintsByGuid.setDirection(AtlasLineageInfo.LineageDirection.BOTH);
        }
        if (lineageConstraintsByGuid.getInputRelationsLimit() == 0) {
            LOG.info("No lineage on-demand inputRelationsLimit provided for guid: {}, configuring with default value {}", (Object)guid, (Object)LINEAGE_ON_DEMAND_DEFAULT_NODE_COUNT);
            lineageConstraintsByGuid.setInputRelationsLimit(LINEAGE_ON_DEMAND_DEFAULT_NODE_COUNT);
        }
        if (lineageConstraintsByGuid.getOutputRelationsLimit() == 0) {
            LOG.info("No lineage on-demand outputRelationsLimit provided for guid: {}, configuring with default value {}", (Object)guid, (Object)LINEAGE_ON_DEMAND_DEFAULT_NODE_COUNT);
            lineageConstraintsByGuid.setOutputRelationsLimit(LINEAGE_ON_DEMAND_DEFAULT_NODE_COUNT);
        }
        if (lineageConstraintsByGuid.getDepth() == 0) {
            LOG.info("No lineage on-demand depth provided for guid: {}, configuring with default value {}", (Object)guid, (Object)3);
            lineageConstraintsByGuid.setDepth(3);
        }
        return lineageConstraintsByGuid;
    }

    private AtlasLineageInfo getLineageInfoOnDemand(String guid, Map<String, LineageOnDemandConstraints> lineageConstraintsMap, boolean isDataSet) throws AtlasBaseException {
        LineageOnDemandConstraints lineageConstraintsByGuid = this.getAndValidateLineageConstraintsByGuid(guid, lineageConstraintsMap);
        if (lineageConstraintsByGuid == null) {
            throw new AtlasBaseException(AtlasErrorCode.NO_LINEAGE_CONSTRAINTS_FOR_GUID, new String[]{guid});
        }
        AtlasLineageInfo.LineageDirection direction = lineageConstraintsByGuid.getDirection();
        int depth = lineageConstraintsByGuid.getDepth();
        AtlasLineageInfo ret = this.initializeLineageInfo(guid, direction, depth);
        if (depth == 0) {
            depth = -1;
        }
        if (isDataSet) {
            AtlasVertex datasetVertex = AtlasGraphUtilsV2.findByGuid(this.graph, guid);
            if (!ret.getRelationsOnDemand().containsKey(guid)) {
                ret.getRelationsOnDemand().put(guid, new AtlasLineageInfo.LineageInfoOnDemand(lineageConstraintsByGuid));
            }
            if (direction == AtlasLineageInfo.LineageDirection.INPUT || direction == AtlasLineageInfo.LineageDirection.BOTH) {
                this.traverseEdgesOnDemand(datasetVertex, true, depth, new HashSet<String>(), lineageConstraintsMap, ret);
            }
            if (direction == AtlasLineageInfo.LineageDirection.OUTPUT || direction == AtlasLineageInfo.LineageDirection.BOTH) {
                this.traverseEdgesOnDemand(datasetVertex, false, depth, new HashSet<String>(), lineageConstraintsMap, ret);
            }
        } else {
            Iterable processEdges;
            AtlasVertex processVertex = AtlasGraphUtilsV2.findByGuid(this.graph, guid);
            if (direction == AtlasLineageInfo.LineageDirection.INPUT || direction == AtlasLineageInfo.LineageDirection.BOTH) {
                processEdges = processVertex.getEdges(AtlasEdgeDirection.OUT, PROCESS_INPUTS_EDGE);
                this.traverseEdgesOnDemand(processEdges, true, depth, lineageConstraintsMap, ret);
            }
            if (direction == AtlasLineageInfo.LineageDirection.OUTPUT || direction == AtlasLineageInfo.LineageDirection.BOTH) {
                processEdges = processVertex.getEdges(AtlasEdgeDirection.OUT, PROCESS_OUTPUTS_EDGE);
                this.traverseEdgesOnDemand(processEdges, false, depth, lineageConstraintsMap, ret);
            }
        }
        return ret;
    }

    private void traverseEdges(AtlasVertex datasetVertex, boolean isInput, int depth, AtlasLineageInfo ret) throws AtlasBaseException {
        this.traverseEdges(datasetVertex, isInput, depth, new HashSet<String>(), ret);
    }

    private void traverseEdges(AtlasVertex datasetVertex, boolean isInput, int depth, Set<String> visitedVertices, AtlasLineageInfo ret) throws AtlasBaseException {
        if (depth != 0) {
            visitedVertices.add(EntityLineageService.getId(datasetVertex));
            Iterable incomingEdges = datasetVertex.getEdges(AtlasEdgeDirection.IN, isInput ? PROCESS_OUTPUTS_EDGE : PROCESS_INPUTS_EDGE);
            for (AtlasEdge incomingEdge : incomingEdges) {
                AtlasVertex processVertex = incomingEdge.getOutVertex();
                Iterable outgoingEdges = processVertex.getEdges(AtlasEdgeDirection.OUT, isInput ? PROCESS_INPUTS_EDGE : PROCESS_OUTPUTS_EDGE);
                for (AtlasEdge outgoingEdge : outgoingEdges) {
                    AtlasVertex entityVertex = outgoingEdge.getInVertex();
                    if (entityVertex == null) continue;
                    this.addEdgeToResult(incomingEdge, ret);
                    this.addEdgeToResult(outgoingEdge, ret);
                    if (visitedVertices.contains(EntityLineageService.getId(entityVertex))) continue;
                    this.traverseEdges(entityVertex, isInput, depth - 1, visitedVertices, ret);
                }
            }
        }
    }

    private void traverseEdgesOnDemand(Iterable<AtlasEdge> processEdges, boolean isInput, int depth, Map<String, LineageOnDemandConstraints> lineageConstraintsMap, AtlasLineageInfo ret) throws AtlasBaseException {
        for (AtlasEdge processEdge : processEdges) {
            boolean isInputEdge;
            if (this.incrementAndCheckIfRelationsLimitReached(processEdge, isInputEdge = processEdge.getLabel().equalsIgnoreCase(PROCESS_INPUTS_EDGE), lineageConstraintsMap, ret)) break;
            this.addEdgeToResult(processEdge, ret);
            AtlasVertex datasetVertex = processEdge.getInVertex();
            String inGuid = AtlasGraphUtilsV2.getIdFromVertex(datasetVertex);
            LineageOnDemandConstraints inGuidLineageConstrains = this.getAndValidateLineageConstraintsByGuid(inGuid, lineageConstraintsMap);
            if (!ret.getRelationsOnDemand().containsKey(inGuid)) {
                ret.getRelationsOnDemand().put(inGuid, new AtlasLineageInfo.LineageInfoOnDemand(inGuidLineageConstrains));
            }
            this.traverseEdgesOnDemand(datasetVertex, isInput, depth - 1, new HashSet<String>(), lineageConstraintsMap, ret);
        }
    }

    private void traverseEdgesOnDemand(AtlasVertex datasetVertex, boolean isInput, int depth, Set<String> visitedVertices, Map<String, LineageOnDemandConstraints> lineageConstraintsMap, AtlasLineageInfo ret) throws AtlasBaseException {
        if (depth != 0) {
            AtlasEdge incomingEdge;
            visitedVertices.add(EntityLineageService.getId(datasetVertex));
            Iterable incomingEdges = datasetVertex.getEdges(AtlasEdgeDirection.IN, isInput ? PROCESS_OUTPUTS_EDGE : PROCESS_INPUTS_EDGE);
            Iterator iterator = incomingEdges.iterator();
            while (iterator.hasNext() && !this.incrementAndCheckIfRelationsLimitReached(incomingEdge = (AtlasEdge)iterator.next(), !isInput, lineageConstraintsMap, ret)) {
                AtlasEdge outgoingEdge;
                this.addEdgeToResult(incomingEdge, ret);
                AtlasVertex processVertex = incomingEdge.getOutVertex();
                Iterable outgoingEdges = processVertex.getEdges(AtlasEdgeDirection.OUT, isInput ? PROCESS_INPUTS_EDGE : PROCESS_OUTPUTS_EDGE);
                Iterator iterator2 = outgoingEdges.iterator();
                while (iterator2.hasNext() && !this.incrementAndCheckIfRelationsLimitReached(outgoingEdge = (AtlasEdge)iterator2.next(), isInput, lineageConstraintsMap, ret)) {
                    this.addEdgeToResult(outgoingEdge, ret);
                    AtlasVertex entityVertex = outgoingEdge.getInVertex();
                    if (entityVertex == null || visitedVertices.contains(EntityLineageService.getId(entityVertex))) continue;
                    this.traverseEdgesOnDemand(entityVertex, isInput, depth - 1, visitedVertices, lineageConstraintsMap, ret);
                }
            }
        }
    }

    private boolean incrementAndCheckIfRelationsLimitReached(AtlasEdge atlasEdge, boolean isInput, Map<String, LineageOnDemandConstraints> lineageConstraintsMap, AtlasLineageInfo ret) {
        AtlasLineageInfo.LineageInfoOnDemand outLineageInfo;
        if (this.lineageContainsEdge(ret, atlasEdge)) {
            return false;
        }
        boolean hasRelationsLimitReached = false;
        AtlasVertex inVertex = isInput ? atlasEdge.getOutVertex() : atlasEdge.getInVertex();
        String inGuid = AtlasGraphUtilsV2.getIdFromVertex(inVertex);
        LineageOnDemandConstraints inGuidLineageConstraints = this.getAndValidateLineageConstraintsByGuid(inGuid, lineageConstraintsMap);
        AtlasVertex outVertex = isInput ? atlasEdge.getInVertex() : atlasEdge.getOutVertex();
        String outGuid = AtlasGraphUtilsV2.getIdFromVertex(outVertex);
        LineageOnDemandConstraints outGuidLineageConstraints = this.getAndValidateLineageConstraintsByGuid(outGuid, lineageConstraintsMap);
        AtlasLineageInfo.LineageInfoOnDemand inLineageInfo = ret.getRelationsOnDemand().containsKey(inGuid) ? (AtlasLineageInfo.LineageInfoOnDemand)ret.getRelationsOnDemand().get(inGuid) : new AtlasLineageInfo.LineageInfoOnDemand(inGuidLineageConstraints);
        AtlasLineageInfo.LineageInfoOnDemand lineageInfoOnDemand = outLineageInfo = ret.getRelationsOnDemand().containsKey(outGuid) ? (AtlasLineageInfo.LineageInfoOnDemand)ret.getRelationsOnDemand().get(outGuid) : new AtlasLineageInfo.LineageInfoOnDemand(outGuidLineageConstraints);
        if (inLineageInfo.isInputRelationsReachedLimit()) {
            inLineageInfo.setHasMoreInputs(true);
            hasRelationsLimitReached = true;
        } else {
            inLineageInfo.incrementInputRelationsCount();
        }
        if (outLineageInfo.isOutputRelationsReachedLimit()) {
            outLineageInfo.setHasMoreOutputs(true);
            hasRelationsLimitReached = true;
        } else {
            outLineageInfo.incrementOutputRelationsCount();
        }
        if (!hasRelationsLimitReached) {
            ret.getRelationsOnDemand().put(inGuid, inLineageInfo);
            ret.getRelationsOnDemand().put(outGuid, outLineageInfo);
        }
        return hasRelationsLimitReached;
    }

    private void addEdgeToResult(AtlasEdge edge, AtlasLineageInfo lineageInfo) throws AtlasBaseException {
        if (!this.lineageContainsEdge(lineageInfo, edge) && !this.lineageMaxNodeCountReached(lineageInfo.getRelations())) {
            this.processEdge(edge, lineageInfo);
        }
    }

    private int getLineageMaxNodeAllowedCount() {
        return Math.min(DEFAULT_LINEAGE_MAX_NODE_COUNT, AtlasConfiguration.LINEAGE_MAX_NODE_COUNT.getInt());
    }

    private boolean lineageMaxNodeCountReached(Set<AtlasLineageInfo.LineageRelation> relations) {
        return CollectionUtils.isNotEmpty(relations) && relations.size() > this.getLineageMaxNodeAllowedCount();
    }

    private String getVisitedEdgeLabel(String inGuid, String outGuid, String relationGuid) {
        if (this.isLineageOnDemandEnabled()) {
            return inGuid + SEPARATOR + outGuid;
        }
        return relationGuid;
    }

    private boolean lineageContainsEdge(AtlasLineageInfo lineageInfo, AtlasEdge edge) {
        boolean ret = false;
        if (edge != null && lineageInfo != null && CollectionUtils.isNotEmpty((Collection)lineageInfo.getVisitedEdges())) {
            String visitedEdgeLabel;
            String inGuid = AtlasGraphUtilsV2.getIdFromVertex(edge.getInVertex());
            String outGuid = AtlasGraphUtilsV2.getIdFromVertex(edge.getOutVertex());
            String relationGuid = AtlasGraphUtilsV2.getEncodedProperty(edge, Constants.RELATIONSHIP_GUID_PROPERTY_KEY, String.class);
            boolean isInputEdge = edge.getLabel().equalsIgnoreCase(PROCESS_INPUTS_EDGE);
            String string = visitedEdgeLabel = isInputEdge ? this.getVisitedEdgeLabel(inGuid, outGuid, relationGuid) : this.getVisitedEdgeLabel(outGuid, inGuid, relationGuid);
            if (lineageInfo.getVisitedEdges().contains(visitedEdgeLabel)) {
                ret = true;
            }
        }
        return ret;
    }

    private void processEdge(AtlasEdge edge, AtlasLineageInfo lineageInfo) throws AtlasBaseException {
        this.processEdge(edge, lineageInfo.getGuidEntityMap(), lineageInfo.getRelations(), lineageInfo.getVisitedEdges());
    }

    private AtlasLineageInfo initializeLineageInfo(String guid, AtlasLineageInfo.LineageDirection direction, int depth) {
        return new AtlasLineageInfo(guid, new HashMap(), new HashSet(), new HashSet(), new HashMap(), direction, depth);
    }

    private static String getId(AtlasVertex vertex) {
        return vertex.getIdForDisplay();
    }

    private List executeGremlinScript(Map<String, Object> bindings, String lineageQuery) throws AtlasBaseException {
        List ret;
        ScriptEngine engine = this.graph.getGremlinScriptEngine();
        try {
            ret = (List)this.graph.executeGremlinScript(engine, bindings, lineageQuery, false);
        }
        catch (ScriptException e) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_LINEAGE_QUERY_FAILED, new String[]{lineageQuery});
        }
        finally {
            this.graph.releaseGremlinScriptEngine(engine);
        }
        return ret;
    }

    private void processEdge(AtlasEdge edge, Map<String, AtlasEntityHeader> entities, Set<AtlasLineageInfo.LineageRelation> relations) throws AtlasBaseException {
        this.processEdge(edge, entities, relations, null);
    }

    private void processEdge(AtlasEdge edge, Map<String, AtlasEntityHeader> entities, Set<AtlasLineageInfo.LineageRelation> relations, Set<String> visitedEdges) throws AtlasBaseException {
        AtlasEntityHeader entityHeader;
        AtlasVertex inVertex = edge.getInVertex();
        AtlasVertex outVertex = edge.getOutVertex();
        String inGuid = AtlasGraphUtilsV2.getIdFromVertex(inVertex);
        String outGuid = AtlasGraphUtilsV2.getIdFromVertex(outVertex);
        String relationGuid = AtlasGraphUtilsV2.getEncodedProperty(edge, Constants.RELATIONSHIP_GUID_PROPERTY_KEY, String.class);
        boolean isInputEdge = edge.getLabel().equalsIgnoreCase(PROCESS_INPUTS_EDGE);
        if (!entities.containsKey(inGuid)) {
            entityHeader = this.entityRetriever.toAtlasEntityHeader(inVertex);
            entities.put(inGuid, entityHeader);
        }
        if (!entities.containsKey(outGuid)) {
            entityHeader = this.entityRetriever.toAtlasEntityHeader(outVertex);
            entities.put(outGuid, entityHeader);
        }
        if (isInputEdge) {
            relations.add(new AtlasLineageInfo.LineageRelation(inGuid, outGuid, relationGuid));
        } else {
            relations.add(new AtlasLineageInfo.LineageRelation(outGuid, inGuid, relationGuid));
        }
        if (visitedEdges != null) {
            String visitedEdgeLabel = isInputEdge ? this.getVisitedEdgeLabel(inGuid, outGuid, relationGuid) : this.getVisitedEdgeLabel(outGuid, inGuid, relationGuid);
            visitedEdges.add(visitedEdgeLabel);
        }
    }

    private AtlasLineageInfo getBothLineageInfoV1(String guid, int depth, boolean isDataSet) throws AtlasBaseException {
        AtlasLineageInfo inputLineage = this.getLineageInfo(guid, AtlasLineageInfo.LineageDirection.INPUT, depth, isDataSet);
        AtlasLineageInfo outputLineage = this.getLineageInfo(guid, AtlasLineageInfo.LineageDirection.OUTPUT, depth, isDataSet);
        AtlasLineageInfo ret = inputLineage;
        ret.getRelations().addAll(outputLineage.getRelations());
        ret.getGuidEntityMap().putAll(outputLineage.getGuidEntityMap());
        ret.setLineageDirection(AtlasLineageInfo.LineageDirection.BOTH);
        return ret;
    }

    private String getLineageQuery(String entityGuid, AtlasLineageInfo.LineageDirection direction, int depth, boolean isDataSet, Map<String, Object> bindings) {
        String incomingFrom = null;
        String outgoingTo = null;
        if (direction.equals((Object)AtlasLineageInfo.LineageDirection.INPUT)) {
            incomingFrom = PROCESS_OUTPUTS_EDGE;
            outgoingTo = PROCESS_INPUTS_EDGE;
        } else if (direction.equals((Object)AtlasLineageInfo.LineageDirection.OUTPUT)) {
            incomingFrom = PROCESS_INPUTS_EDGE;
            outgoingTo = PROCESS_OUTPUTS_EDGE;
        }
        bindings.put("guid", entityGuid);
        bindings.put("incomingEdgeLabel", incomingFrom);
        bindings.put("outgoingEdgeLabel", outgoingTo);
        bindings.put("dataSetDepth", depth);
        bindings.put("processDepth", depth - 1);
        String ret = depth < 1 ? (isDataSet ? this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.FULL_LINEAGE_DATASET) : this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.FULL_LINEAGE_PROCESS)) : (isDataSet ? this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.PARTIAL_LINEAGE_DATASET) : this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.PARTIAL_LINEAGE_PROCESS));
        return ret;
    }

    public boolean isLineageOnDemandEnabled() {
        return AtlasConfiguration.LINEAGE_ON_DEMAND_ENABLED.getBoolean();
    }
}

