/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.discovery.SearchProcessor;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasIndexQuery;
import org.apache.atlas.repository.graphdb.AtlasIndexQueryParameter;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.graphdb.GraphIndexQueryParameters;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeTextSearchProcessor
extends SearchProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(FreeTextSearchProcessor.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"FreeTextSearchProcessor");
    public static final String SOLR_QT_PARAMETER = "qt";
    public static final String SOLR_REQUEST_HANDLER_NAME = "/freetext";
    private static final boolean IS_SOLR_INDEX_BACKEND = FreeTextSearchProcessor.isSolrIndexBackend();
    private final AtlasIndexQuery indexQuery;

    public FreeTextSearchProcessor(SearchContext context) {
        super(context);
        SearchParameters searchParameters = context.getSearchParameters();
        StringBuilder queryString = new StringBuilder();
        queryString.append(searchParameters.getQuery());
        if (CollectionUtils.isNotEmpty(context.getEntityTypeNames()) && context.getEntityTypesQryStr().length() <= MAX_QUERY_STR_LENGTH_TYPES) {
            queryString.append(" AND ").append(context.getEntityTypesQryStr());
        }
        this.graphIndexQueryBuilder.addActiveStateQueryFilter(queryString);
        if (CollectionUtils.isNotEmpty(context.getClassificationTypeNames()) && context.getClassificationTypesQryStr().length() <= MAX_QUERY_STR_LENGTH_TYPES) {
            queryString.append(" AND ").append(context.getClassificationTypesQryStr());
        }
        LOG.debug("Using query string  '{}'.", (Object)queryString);
        this.indexQuery = context.getGraph().indexQuery(this.prepareGraphIndexQueryParameters(context, queryString));
    }

    private GraphIndexQueryParameters prepareGraphIndexQueryParameters(SearchContext context, StringBuilder queryString) {
        ArrayList<AtlasIndexQueryParameter> parameters = new ArrayList<AtlasIndexQueryParameter>();
        if (IS_SOLR_INDEX_BACKEND) {
            parameters.add(context.getGraph().indexQueryParameter(SOLR_QT_PARAMETER, SOLR_REQUEST_HANDLER_NAME));
        }
        return new GraphIndexQueryParameters("vertex_index", queryString.toString(), 0, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AtlasVertex> execute() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> FreeTextSearchProcessor.execute({})", (Object)this.context);
        }
        ArrayList<AtlasVertex> ret = new ArrayList<AtlasVertex>();
        AtlasPerfTracer perf = null;
        if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
            perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("FreeTextSearchProcessor.execute(" + this.context + ")"));
        }
        try {
            int qryOffset;
            int limit = this.context.getSearchParameters().getLimit();
            Integer marker = this.context.getMarker();
            int startIdx = marker != null ? marker.intValue() : this.context.getSearchParameters().getOffset();
            int resultIdx = qryOffset = marker != null ? marker : 0;
            LinkedHashMap<Integer, AtlasVertex> offsetEntityVertexMap = new LinkedHashMap<Integer, AtlasVertex>();
            while (ret.size() < limit) {
                offsetEntityVertexMap.clear();
                if (this.context.terminateSearch()) {
                    LOG.warn("query terminated: {}", (Object)this.context.getSearchParameters());
                    break;
                }
                Iterator<AtlasIndexQuery.Result> idxQueryResult = FreeTextSearchProcessor.executeIndexQuery(this.context, this.indexQuery, qryOffset, limit);
                int resultCount = 0;
                while (idxQueryResult.hasNext()) {
                    List<String> entityClassifications;
                    AtlasVertex vertex = idxQueryResult.next().getVertex();
                    ++resultCount;
                    String entityTypeName = AtlasGraphUtilsV2.getTypeName((AtlasElement)vertex);
                    if (StringUtils.isEmpty((String)entityTypeName) || StringUtils.isEmpty((String)AtlasGraphUtilsV2.getIdFromVertex(vertex))) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("FreeTextSearchProcessor.execute(): ignoring non-entity vertex (id={})", vertex.getId());
                        continue;
                    }
                    AtlasEntityType entityType = this.context.getTypeRegistry().getEntityTypeByName(entityTypeName);
                    if (entityType != null && entityType.isInternalType() || !this.context.includeEntityType(entityTypeName) || CollectionUtils.isNotEmpty(this.context.getClassificationTypes()) && !this.context.includeClassificationTypes(entityClassifications = GraphHelper.getAllTraitNames(vertex))) continue;
                    offsetEntityVertexMap.put(qryOffset + resultCount - 1, vertex);
                }
                boolean isLastResultPage = resultCount < limit;
                offsetEntityVertexMap = super.filter(offsetEntityVertexMap);
                resultIdx = this.collectResultVertices(ret, startIdx, limit, resultIdx, offsetEntityVertexMap, marker);
                if (isLastResultPage) {
                    resultIdx = -2;
                    break;
                }
                qryOffset += limit;
            }
            if (marker != null) {
                this.nextOffset = resultIdx + 1;
            }
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== FreeTextSearchProcessor.execute({}): ret.size()={}", (Object)this.context, (Object)ret.size());
        }
        return ret;
    }

    @Override
    public long getResultCount() {
        return this.indexQuery.vertexTotals();
    }

    private static boolean isSolrIndexBackend() {
        try {
            String indexBackEnd = ApplicationProperties.get().getString("atlas.graph.index.search.backend");
            return "solr".equalsIgnoreCase(indexBackEnd);
        }
        catch (AtlasException e) {
            LOG.error("Failed to get application property {}. Assuming Solr index backend", (Object)"solr", (Object)e);
            return true;
        }
    }
}

