/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.entitytransform;

import java.util.Arrays;
import java.util.List;
import org.apache.atlas.entitytransform.AtlasEntityTransformer;
import org.apache.atlas.entitytransform.BaseEntityHandler;
import org.apache.atlas.entitytransform.EntityAttribute;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.commons.lang.StringUtils;

public class HiveTableEntityHandler
extends BaseEntityHandler {
    static final List<String> CUSTOM_TRANSFORM_ATTRIBUTES = Arrays.asList("hive_db.name", "hive_table.name", "hive_db.clusterName");

    public HiveTableEntityHandler(List<AtlasEntityTransformer> transformers) {
        super(transformers);
    }

    @Override
    public BaseEntityHandler.AtlasTransformableEntity getTransformableEntity(AtlasEntity entity) {
        return this.isHiveTableEntity(entity) ? new HiveTableEntity(entity) : null;
    }

    private boolean isHiveTableEntity(AtlasEntity entity) {
        return StringUtils.equals((String)entity.getTypeName(), (String)"hive_table");
    }

    private static class HiveTableEntity
    extends BaseEntityHandler.AtlasTransformableEntity {
        private final String qualifiedName;
        private String databaseName;
        private String tableName;
        private String clusterName;
        private boolean isCustomAttributeUpdated = false;
        private final boolean tableNameFromQualifiedNameDifferent;
        private final String tableNameFromQualifiedName;

        public HiveTableEntity(AtlasEntity entity) {
            super(entity);
            this.tableName = (String)entity.getAttribute("name");
            this.qualifiedName = (String)entity.getAttribute("qualifiedName");
            if (this.qualifiedName != null) {
                int databaseSeparatorIdx = this.qualifiedName.indexOf(46);
                int clusterSeparatorIdx = this.qualifiedName.lastIndexOf(64);
                this.databaseName = databaseSeparatorIdx != -1 ? this.qualifiedName.substring(0, databaseSeparatorIdx) : "";
                this.clusterName = clusterSeparatorIdx != -1 ? this.qualifiedName.substring(clusterSeparatorIdx + 1) : "";
                this.tableNameFromQualifiedName = clusterSeparatorIdx != -1 ? this.qualifiedName.substring(databaseSeparatorIdx + 1, clusterSeparatorIdx) : "";
                this.tableNameFromQualifiedNameDifferent = !this.tableNameFromQualifiedName.equals(this.tableName);
            } else {
                this.databaseName = "";
                this.clusterName = "";
                this.tableNameFromQualifiedName = "";
                this.tableNameFromQualifiedNameDifferent = false;
            }
        }

        @Override
        public Object getAttribute(EntityAttribute attribute) {
            switch (attribute.getAttributeKey()) {
                case "hive_table.name": {
                    return this.tableName;
                }
                case "hive_db.name": {
                    return this.databaseName;
                }
                case "hive_db.clusterName": {
                    return this.clusterName;
                }
            }
            return super.getAttribute(attribute);
        }

        @Override
        public void setAttribute(EntityAttribute attribute, String attributeValue) {
            switch (attribute.getAttributeKey()) {
                case "hive_table.name": {
                    this.tableName = attributeValue;
                    this.isCustomAttributeUpdated = true;
                    break;
                }
                case "hive_db.name": {
                    this.databaseName = attributeValue;
                    this.isCustomAttributeUpdated = true;
                    break;
                }
                case "hive_db.clusterName": {
                    this.clusterName = attributeValue;
                    this.isCustomAttributeUpdated = true;
                    break;
                }
                default: {
                    super.setAttribute(attribute, attributeValue);
                }
            }
        }

        @Override
        public void transformComplete() {
            if (this.isCustomAttributeUpdated) {
                this.entity.setAttribute("name", (Object)this.tableName);
                this.entity.setAttribute("qualifiedName", (Object)this.toQualifiedName());
            }
        }

        private String toQualifiedName() {
            String tableName = this.tableNameFromQualifiedNameDifferent ? this.tableNameFromQualifiedName : this.tableName;
            return String.format("%s.%s@%s", this.databaseName, tableName, this.clusterName);
        }
    }
}

