/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.glossary;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.SortOrder;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.bulkimport.BulkImportResponse;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.glossary.GlossaryCategoryUtils;
import org.apache.atlas.glossary.GlossaryTermUtils;
import org.apache.atlas.glossary.GlossaryUtils;
import org.apache.atlas.model.glossary.AtlasGlossary;
import org.apache.atlas.model.glossary.AtlasGlossaryCategory;
import org.apache.atlas.model.glossary.AtlasGlossaryTerm;
import org.apache.atlas.model.glossary.relations.AtlasRelatedCategoryHeader;
import org.apache.atlas.model.glossary.relations.AtlasRelatedTermHeader;
import org.apache.atlas.model.glossary.relations.AtlasTermCategorizationHeader;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.ogm.DataAccess;
import org.apache.atlas.repository.ogm.glossary.AtlasGlossaryDTO;
import org.apache.atlas.repository.store.graph.AtlasRelationshipStore;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityChangeNotifier;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.util.FileUtils;
import org.apache.atlas.utils.AtlasJson;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GlossaryService {
    private static final Logger LOG = LoggerFactory.getLogger(GlossaryService.class);
    private static final boolean DEBUG_ENABLED = LOG.isDebugEnabled();
    private static final String ATLAS_GLOSSARY_TERM = "AtlasGlossaryTerm";
    private static final String NAME_ATTR = "name";
    private static final String QUALIFIED_NAME_ATTR = "qualifiedName";
    private static final String GLOSSARY_QUALIFIED_NAME_PROPERTY = "AtlasGlossary.qualifiedName";
    private static final String GLOSSARY_CATEGORY_NAME_PROPERTY = "AtlasGlossaryCategory.name";
    private static final String GLOSSARY_TERM_NAME_PROPERTY = "AtlasGlossaryTerm.name";
    private static final String GLOSSARY_TERM_QUALIFIED_NAME_PROPERTY = "AtlasGlossaryTerm.qualifiedName";
    private static final String TERM_UNIQUE_QUALIFIED_NAME_PROPERTY = "AtlasGlossaryTerm.__u_qualifiedName";
    private static final String GLOSSARY_TERM_ANCHOR_EDGE_LABEL = "r:AtlasGlossaryTermAnchor";
    private final DataAccess dataAccess;
    private final GlossaryTermUtils glossaryTermUtils;
    private final GlossaryCategoryUtils glossaryCategoryUtils;
    private final AtlasTypeRegistry atlasTypeRegistry;
    private final AtlasEntityChangeNotifier entityChangeNotifier;
    private final AtlasGlossaryDTO glossaryDTO;
    private static final char[] invalidNameChars = new char[]{'@', '.'};
    private static final Map<String, String> glossaryGuidQualifiedNameCache = new HashMap<String, String>();
    private static final Map<String, String> categoryGuidNameCache = new HashMap<String, String>();

    @Inject
    public GlossaryService(DataAccess dataAccess, AtlasRelationshipStore relationshipStore, AtlasTypeRegistry typeRegistry, AtlasEntityChangeNotifier entityChangeNotifier, AtlasGlossaryDTO glossaryDTO) {
        this.dataAccess = dataAccess;
        this.atlasTypeRegistry = typeRegistry;
        this.glossaryTermUtils = new GlossaryTermUtils(relationshipStore, typeRegistry, dataAccess);
        this.glossaryCategoryUtils = new GlossaryCategoryUtils(relationshipStore, typeRegistry, dataAccess);
        this.entityChangeNotifier = entityChangeNotifier;
        this.glossaryDTO = glossaryDTO;
    }

    @GraphTransaction
    public List<AtlasGlossary> getGlossaries(int limit, int offset, SortOrder sortOrder) throws AtlasBaseException {
        List<AtlasGlossary> ret;
        List<String> glossaryGuids;
        PaginationHelper<String> paginationHelper;
        List<String> guidsToLoad;
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.getGlossaries({}, {}, {})", new Object[]{limit, offset, sortOrder});
        }
        if (CollectionUtils.isNotEmpty(guidsToLoad = (paginationHelper = new PaginationHelper<String>(glossaryGuids = AtlasGraphUtilsV2.findEntityGUIDsByType("AtlasGlossary", sortOrder), offset, limit)).getPaginatedList())) {
            AtlasEntity.AtlasEntitiesWithExtInfo glossaryEntities = this.dataAccess.getAtlasEntityStore().getByIds(guidsToLoad, true, false);
            ret = new ArrayList<AtlasGlossary>();
            for (AtlasEntity glossaryEntity : glossaryEntities.getEntities()) {
                AtlasGlossary glossary = this.glossaryDTO.from(glossaryEntity);
                ret.add(glossary);
            }
        } else {
            ret = Collections.emptyList();
        }
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.getGlossaries() : {}", ret);
        }
        return ret;
    }

    @GraphTransaction
    public AtlasGlossary createGlossary(AtlasGlossary atlasGlossary) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.createGlossary({})", (Object)atlasGlossary);
        }
        if (Objects.isNull(atlasGlossary)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"Glossary definition missing"});
        }
        if (StringUtils.isEmpty((String)atlasGlossary.getQualifiedName())) {
            if (StringUtils.isEmpty((String)atlasGlossary.getName())) {
                throw new AtlasBaseException(AtlasErrorCode.GLOSSARY_QUALIFIED_NAME_CANT_BE_DERIVED, new String[0]);
            }
            if (GlossaryService.isNameInvalid(atlasGlossary.getName())) {
                throw new AtlasBaseException(AtlasErrorCode.INVALID_DISPLAY_NAME, new String[0]);
            }
            atlasGlossary.setQualifiedName(atlasGlossary.getName());
        }
        if (this.glossaryExists(atlasGlossary)) {
            throw new AtlasBaseException(AtlasErrorCode.GLOSSARY_ALREADY_EXISTS, new String[]{atlasGlossary.getName()});
        }
        AtlasGlossary storeObject = this.dataAccess.save(atlasGlossary);
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.createGlossary() : {}", (Object)storeObject);
        }
        return storeObject;
    }

    @GraphTransaction
    public AtlasGlossary getGlossary(String glossaryGuid) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.getGlossary({})", (Object)glossaryGuid);
        }
        if (Objects.isNull(glossaryGuid)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"glossaryGuid is null/empty"});
        }
        AtlasGlossary atlasGlossary = GlossaryUtils.getGlossarySkeleton(glossaryGuid);
        AtlasGlossary ret = this.dataAccess.load(atlasGlossary);
        this.setInfoForRelations(ret);
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.getGlossary() : {}", (Object)ret);
        }
        return ret;
    }

    @GraphTransaction
    public AtlasGlossary.AtlasGlossaryExtInfo getDetailedGlossary(String glossaryGuid) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.getGlossary({})", (Object)glossaryGuid);
        }
        if (Objects.isNull(glossaryGuid)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"glossaryGuid is null/empty"});
        }
        AtlasGlossary atlasGlossary = GlossaryUtils.getGlossarySkeleton(glossaryGuid);
        AtlasGlossary glossary = this.dataAccess.load(atlasGlossary);
        AtlasGlossary.AtlasGlossaryExtInfo ret = new AtlasGlossary.AtlasGlossaryExtInfo(glossary);
        if (CollectionUtils.isNotEmpty((Collection)ret.getTerms())) {
            List termsToLoad = ret.getTerms().stream().map(id -> GlossaryUtils.getAtlasGlossaryTermSkeleton(id.getTermGuid())).collect(Collectors.toList());
            List<AtlasGlossaryTerm> glossaryTerms = this.dataAccess.load(termsToLoad);
            glossaryTerms.forEach(arg_0 -> ((AtlasGlossary.AtlasGlossaryExtInfo)ret).addTermInfo(arg_0));
        }
        if (CollectionUtils.isNotEmpty((Collection)ret.getCategories())) {
            List categoriesToLoad = ret.getCategories().stream().map(id -> GlossaryUtils.getAtlasGlossaryCategorySkeleton(id.getCategoryGuid())).collect(Collectors.toList());
            List<AtlasGlossaryCategory> glossaryCategories = this.dataAccess.load(categoriesToLoad);
            glossaryCategories.forEach(arg_0 -> ((AtlasGlossary.AtlasGlossaryExtInfo)ret).addCategoryInfo(arg_0));
        }
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.getGlossary() : {}", (Object)ret);
        }
        return ret;
    }

    @GraphTransaction
    public AtlasGlossary updateGlossary(AtlasGlossary atlasGlossary) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.updateGlossary({})", (Object)atlasGlossary);
        }
        if (Objects.isNull(atlasGlossary)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"Glossary is null/empty"});
        }
        if (StringUtils.isEmpty((String)atlasGlossary.getName())) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"DisplayName can't be null/empty"});
        }
        if (GlossaryService.isNameInvalid(atlasGlossary.getName())) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_DISPLAY_NAME, new String[0]);
        }
        AtlasGlossary storeObject = this.dataAccess.load(atlasGlossary);
        if (!storeObject.equals((Object)atlasGlossary)) {
            atlasGlossary.setGuid(storeObject.getGuid());
            atlasGlossary.setQualifiedName(storeObject.getQualifiedName());
            storeObject = this.dataAccess.save(atlasGlossary);
            this.setInfoForRelations(storeObject);
        }
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.updateGlossary() : {}", (Object)storeObject);
        }
        return storeObject;
    }

    @GraphTransaction
    public void deleteGlossary(String glossaryGuid) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.deleteGlossary({})", (Object)glossaryGuid);
        }
        if (Objects.isNull(glossaryGuid)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"glossaryGuid is null/empty"});
        }
        AtlasGlossary storeObject = this.dataAccess.load(GlossaryUtils.getGlossarySkeleton(glossaryGuid));
        Set terms = storeObject.getTerms();
        this.deleteTerms(storeObject, terms);
        Set categories = storeObject.getCategories();
        this.deleteCategories(storeObject, categories);
        this.dataAccess.delete(glossaryGuid);
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.deleteGlossary()");
        }
    }

    @GraphTransaction
    public AtlasGlossaryTerm getTerm(String termGuid) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.getTerm({})", (Object)termGuid);
        }
        if (Objects.isNull(termGuid)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"termGuid is null/empty"});
        }
        AtlasGlossaryTerm atlasGlossary = GlossaryUtils.getAtlasGlossaryTermSkeleton(termGuid);
        AtlasGlossaryTerm ret = this.dataAccess.load(atlasGlossary);
        this.setInfoForRelations(ret);
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.getTerm() : {}", (Object)ret);
        }
        return ret;
    }

    @GraphTransaction
    public AtlasGlossaryTerm createTerm(AtlasGlossaryTerm term) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.create({})", (Object)term);
        }
        if (Objects.isNull(term)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"GlossaryTerm definition missing"});
        }
        if (Objects.isNull(term.getAnchor())) {
            throw new AtlasBaseException(AtlasErrorCode.MISSING_MANDATORY_ANCHOR, new String[0]);
        }
        if (StringUtils.isEmpty((String)term.getName())) {
            throw new AtlasBaseException(AtlasErrorCode.GLOSSARY_TERM_QUALIFIED_NAME_CANT_BE_DERIVED, new String[0]);
        }
        if (GlossaryService.isNameInvalid(term.getName())) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_DISPLAY_NAME, new String[0]);
        }
        String anchorGlossaryGuid = term.getAnchor().getGlossaryGuid();
        String glossaryQualifiedName = this.getGlossaryQualifiedName(anchorGlossaryGuid);
        if (StringUtils.isEmpty((String)glossaryQualifiedName)) {
            throw new AtlasBaseException(AtlasErrorCode.GLOSSARY_QUALIFIED_NAME_CANT_BE_DERIVED, new String[0]);
        }
        term.setQualifiedName(term.getName() + "@" + glossaryQualifiedName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Derived qualifiedName = {}", (Object)term.getQualifiedName());
        }
        if (this.termExists2(term)) {
            throw new AtlasBaseException(AtlasErrorCode.GLOSSARY_TERM_ALREADY_EXISTS, new String[]{term.getQualifiedName()});
        }
        AtlasGlossaryTerm storeGlossaryTerm = this.dataAccess.save(term);
        this.glossaryTermUtils.processTermRelations(storeGlossaryTerm, term, GlossaryUtils.RelationshipOperation.CREATE);
        storeGlossaryTerm = this.dataAccess.load(term);
        this.setInfoForRelations(storeGlossaryTerm);
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.create() : {}", (Object)storeGlossaryTerm);
        }
        return storeGlossaryTerm;
    }

    @GraphTransaction
    public List<AtlasGlossaryTerm> createTerms(List<AtlasGlossaryTerm> glossaryTerms) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.create({})", glossaryTerms);
        }
        if (Objects.isNull(glossaryTerms)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"glossaryTerm(s) is null/empty"});
        }
        ArrayList<AtlasGlossaryTerm> ret = new ArrayList<AtlasGlossaryTerm>();
        for (AtlasGlossaryTerm glossaryTerm : glossaryTerms) {
            AtlasGlossaryTerm term = this.createTerm(glossaryTerm);
            ret.add(term);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== GlossaryService.createTerms() : {}", ret);
        }
        return ret;
    }

    public AtlasGlossaryTerm updateTerm(AtlasGlossaryTerm atlasGlossaryTerm) throws AtlasBaseException {
        return this.updateTerm(atlasGlossaryTerm, true);
    }

    @GraphTransaction
    public AtlasGlossaryTerm updateTerm(AtlasGlossaryTerm atlasGlossaryTerm, boolean ignoreUpdateIfTermExists) throws AtlasBaseException {
        String qualifiedName;
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.updateTerm({})", (Object)atlasGlossaryTerm);
        }
        if (Objects.isNull(atlasGlossaryTerm)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"atlasGlossaryTerm is null/empty"});
        }
        if (StringUtils.isEmpty((String)atlasGlossaryTerm.getName())) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"DisplayName can't be null/empty"});
        }
        if (GlossaryService.isNameInvalid(atlasGlossaryTerm.getName())) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_DISPLAY_NAME, new String[0]);
        }
        if (ignoreUpdateIfTermExists && StringUtils.isNotEmpty((String)(qualifiedName = this.getDuplicateGlossaryRelatedTerm(atlasGlossaryTerm)))) {
            throw new AtlasBaseException(AtlasErrorCode.GLOSSARY_TERM_ALREADY_EXISTS, new String[]{qualifiedName});
        }
        AtlasGlossaryTerm storeObject = this.dataAccess.load(atlasGlossaryTerm);
        if (!storeObject.equals((Object)atlasGlossaryTerm)) {
            atlasGlossaryTerm.setGuid(storeObject.getGuid());
            atlasGlossaryTerm.setQualifiedName(storeObject.getQualifiedName());
            storeObject = this.dataAccess.save(atlasGlossaryTerm);
            this.glossaryTermUtils.processTermRelations(storeObject, atlasGlossaryTerm, GlossaryUtils.RelationshipOperation.UPDATE);
            if (StringUtils.equals((String)storeObject.getQualifiedName(), (String)atlasGlossaryTerm.getQualifiedName())) {
                storeObject = this.dataAccess.load(atlasGlossaryTerm);
            } else {
                atlasGlossaryTerm.setQualifiedName(storeObject.getQualifiedName());
                if (this.termExists(atlasGlossaryTerm)) {
                    throw new AtlasBaseException(AtlasErrorCode.GLOSSARY_TERM_ALREADY_EXISTS, new String[]{atlasGlossaryTerm.getQualifiedName()});
                }
                storeObject = this.dataAccess.save(atlasGlossaryTerm);
            }
        }
        this.setInfoForRelations(storeObject);
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.updateTerm() : {}", (Object)storeObject);
        }
        return storeObject;
    }

    @GraphTransaction
    public void deleteTerm(String termGuid) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.deleteTerm({})", (Object)termGuid);
        }
        if (Objects.isNull(termGuid)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"termGuid is null/empty"});
        }
        AtlasGlossaryTerm storeObject = this.dataAccess.load(GlossaryUtils.getAtlasGlossaryTermSkeleton(termGuid));
        if (CollectionUtils.isNotEmpty((Collection)storeObject.getAssignedEntities())) {
            throw new AtlasBaseException(AtlasErrorCode.TERM_HAS_ENTITY_ASSOCIATION, new String[]{storeObject.getGuid(), String.valueOf(storeObject.getAssignedEntities().size())});
        }
        this.glossaryTermUtils.processTermRelations(storeObject, storeObject, GlossaryUtils.RelationshipOperation.DELETE);
        this.dataAccess.delete(termGuid);
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.deleteTerm()");
        }
    }

    @GraphTransaction
    public void assignTermToEntities(String termGuid, List<AtlasRelatedObjectId> relatedObjectIds) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.assignTermToEntities({}, {})", (Object)termGuid, relatedObjectIds);
        }
        AtlasGlossaryTerm glossaryTerm = this.dataAccess.load(GlossaryUtils.getAtlasGlossaryTermSkeleton(termGuid));
        this.glossaryTermUtils.processTermAssignments(glossaryTerm, relatedObjectIds);
        this.entityChangeNotifier.onTermAddedToEntities(glossaryTerm, relatedObjectIds);
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.assignTermToEntities()");
        }
    }

    @GraphTransaction
    public void removeTermFromEntities(String termGuid, List<AtlasRelatedObjectId> relatedObjectIds) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.removeTermFromEntities({}, {})", (Object)termGuid, relatedObjectIds);
        }
        AtlasGlossaryTerm glossaryTerm = this.dataAccess.load(GlossaryUtils.getAtlasGlossaryTermSkeleton(termGuid));
        this.glossaryTermUtils.processTermDissociation(glossaryTerm, relatedObjectIds);
        this.entityChangeNotifier.onTermDeletedFromEntities(glossaryTerm, relatedObjectIds);
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.removeTermFromEntities()");
        }
    }

    @GraphTransaction
    public AtlasGlossaryCategory getCategory(String categoryGuid) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.getCategory({})", (Object)categoryGuid);
        }
        if (Objects.isNull(categoryGuid)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"categoryGuid is null/empty"});
        }
        AtlasGlossaryCategory atlasGlossary = GlossaryUtils.getAtlasGlossaryCategorySkeleton(categoryGuid);
        AtlasGlossaryCategory ret = this.dataAccess.load(atlasGlossary);
        this.setInfoForRelations(ret);
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.getCategory() : {}", (Object)ret);
        }
        return ret;
    }

    @GraphTransaction
    public AtlasGlossaryCategory createCategory(AtlasGlossaryCategory glossaryCategory) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.createCategory({})", (Object)glossaryCategory);
        }
        if (Objects.isNull(glossaryCategory)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"GlossaryCategory definition missing"});
        }
        if (Objects.isNull(glossaryCategory.getAnchor())) {
            throw new AtlasBaseException(AtlasErrorCode.MISSING_MANDATORY_ANCHOR, new String[0]);
        }
        if (StringUtils.isEmpty((String)glossaryCategory.getName())) {
            throw new AtlasBaseException(AtlasErrorCode.GLOSSARY_CATEGORY_QUALIFIED_NAME_CANT_BE_DERIVED, new String[0]);
        }
        if (GlossaryService.isNameInvalid(glossaryCategory.getName())) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_DISPLAY_NAME, new String[0]);
        }
        String anchorGlossaryGuid = glossaryCategory.getAnchor().getGlossaryGuid();
        AtlasGlossary glossary = this.dataAccess.load(GlossaryUtils.getGlossarySkeleton(anchorGlossaryGuid));
        glossaryCategory.setQualifiedName(glossaryCategory.getName() + "@" + glossary.getQualifiedName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Derived qualifiedName = {}", (Object)glossaryCategory.getQualifiedName());
        }
        if (this.categoryExists(glossaryCategory)) {
            throw new AtlasBaseException(AtlasErrorCode.GLOSSARY_CATEGORY_ALREADY_EXISTS, new String[]{glossaryCategory.getQualifiedName()});
        }
        AtlasGlossaryCategory storeObject = this.dataAccess.save(glossaryCategory);
        Map<String, AtlasGlossaryCategory> impactedCategories = this.glossaryCategoryUtils.processCategoryRelations(storeObject, glossaryCategory, GlossaryUtils.RelationshipOperation.CREATE);
        if (StringUtils.equals((String)glossaryCategory.getQualifiedName(), (String)storeObject.getQualifiedName())) {
            storeObject = this.dataAccess.load(glossaryCategory);
        } else {
            glossaryCategory.setQualifiedName(storeObject.getQualifiedName());
            if (this.categoryExists(glossaryCategory)) {
                throw new AtlasBaseException(AtlasErrorCode.GLOSSARY_CATEGORY_ALREADY_EXISTS, new String[]{glossaryCategory.getQualifiedName()});
            }
            storeObject = this.dataAccess.save(glossaryCategory);
        }
        this.dataAccess.save(impactedCategories.values());
        this.setInfoForRelations(storeObject);
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.createCategory() : {}", (Object)storeObject);
        }
        return storeObject;
    }

    @GraphTransaction
    public List<AtlasGlossaryCategory> createCategories(List<AtlasGlossaryCategory> glossaryCategory) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.createCategories({})", glossaryCategory);
        }
        if (Objects.isNull(glossaryCategory)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"glossaryCategory is null/empty"});
        }
        ArrayList<AtlasGlossaryCategory> ret = new ArrayList<AtlasGlossaryCategory>();
        for (AtlasGlossaryCategory category : glossaryCategory) {
            ret.add(this.createCategory(category));
        }
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.createCategories() : {}", ret);
        }
        return ret;
    }

    @GraphTransaction
    public AtlasGlossaryCategory updateCategory(AtlasGlossaryCategory glossaryCategory) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.updateCategory({})", (Object)glossaryCategory);
        }
        if (Objects.isNull(glossaryCategory)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"GlossaryCategory is null/empty"});
        }
        if (StringUtils.isEmpty((String)glossaryCategory.getName())) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"DisplayName can't be null/empty"});
        }
        if (GlossaryService.isNameInvalid(glossaryCategory.getName())) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_DISPLAY_NAME, new String[0]);
        }
        AtlasGlossaryCategory storeObject = this.dataAccess.load(glossaryCategory);
        if (!storeObject.equals((Object)glossaryCategory)) {
            try {
                glossaryCategory.setGuid(storeObject.getGuid());
                glossaryCategory.setQualifiedName(storeObject.getQualifiedName());
                storeObject = this.dataAccess.save(glossaryCategory);
            }
            catch (AtlasBaseException e) {
                LOG.debug("No immediate attribute update. Exception: {}", (Object)e.getMessage());
            }
            Map<String, AtlasGlossaryCategory> impactedCategories = this.glossaryCategoryUtils.processCategoryRelations(storeObject, glossaryCategory, GlossaryUtils.RelationshipOperation.UPDATE);
            if (StringUtils.equals((String)glossaryCategory.getQualifiedName(), (String)storeObject.getQualifiedName())) {
                storeObject = this.dataAccess.load(glossaryCategory);
            } else {
                glossaryCategory.setQualifiedName(storeObject.getQualifiedName());
                if (this.categoryExists(glossaryCategory)) {
                    throw new AtlasBaseException(AtlasErrorCode.GLOSSARY_CATEGORY_ALREADY_EXISTS, new String[]{glossaryCategory.getQualifiedName()});
                }
                storeObject = this.dataAccess.save(glossaryCategory);
            }
            this.dataAccess.save(impactedCategories.values());
        }
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.updateCategory() : {}", (Object)storeObject);
        }
        this.setInfoForRelations(storeObject);
        return storeObject;
    }

    @GraphTransaction
    public void deleteCategory(String categoryGuid) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.deleteCategory({})", (Object)categoryGuid);
        }
        if (Objects.isNull(categoryGuid)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"Category guid is null/empty"});
        }
        AtlasGlossaryCategory storeObject = this.dataAccess.load(GlossaryUtils.getAtlasGlossaryCategorySkeleton(categoryGuid));
        this.glossaryCategoryUtils.processCategoryRelations(storeObject, storeObject, GlossaryUtils.RelationshipOperation.DELETE);
        this.dataAccess.delete(categoryGuid);
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.deleteCategory()");
        }
    }

    @GraphTransaction
    public List<AtlasRelatedTermHeader> getGlossaryTermsHeaders(String glossaryGuid, int offset, int limit, SortOrder sortOrder) throws AtlasBaseException {
        List<Object> ret;
        AtlasGlossary glossary;
        if (Objects.isNull(glossaryGuid)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"glossaryGuid is null/empty"});
        }
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.getGlossaryTermsHeaders({}, {}, {}, {})", new Object[]{glossaryGuid, offset, limit, sortOrder});
        }
        if (CollectionUtils.isNotEmpty((Collection)(glossary = this.getGlossary(glossaryGuid)).getTerms())) {
            ArrayList terms = new ArrayList(glossary.getTerms());
            if (sortOrder != null) {
                terms.sort((o1, o2) -> sortOrder == SortOrder.ASCENDING ? o1.getDisplayText().compareTo(o2.getDisplayText()) : o2.getDisplayText().compareTo(o1.getDisplayText()));
            }
            ret = new PaginationHelper(terms, offset, limit).getPaginatedList();
        } else {
            ret = Collections.emptyList();
        }
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.getGlossaryTermsHeaders() : {}", ret);
        }
        return ret;
    }

    @GraphTransaction
    public List<AtlasGlossaryTerm> getGlossaryTerms(String glossaryGuid, int offset, int limit, SortOrder sortOrder) throws AtlasBaseException {
        if (Objects.isNull(glossaryGuid)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"glossaryGuid is null/empty"});
        }
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.getGlossaryTerms({}, {}, {}, {})", new Object[]{glossaryGuid, offset, limit, sortOrder});
        }
        ArrayList<AtlasGlossaryTerm> ret = new ArrayList<AtlasGlossaryTerm>();
        List<AtlasRelatedTermHeader> termHeaders = this.getGlossaryTermsHeaders(glossaryGuid, offset, limit, sortOrder);
        for (AtlasRelatedTermHeader header : termHeaders) {
            ret.add(this.dataAccess.load(GlossaryUtils.getAtlasGlossaryTermSkeleton(header.getTermGuid())));
        }
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.getGlossaryTerms() : {}", ret);
        }
        return ret;
    }

    @GraphTransaction
    public List<AtlasRelatedCategoryHeader> getGlossaryCategoriesHeaders(String glossaryGuid, int offset, int limit, SortOrder sortOrder) throws AtlasBaseException {
        List<Object> ret;
        AtlasGlossary glossary;
        if (Objects.isNull(glossaryGuid)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"glossaryGuid is null/empty"});
        }
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.getGlossaryCategoriesHeaders({}, {}, {}, {})", new Object[]{glossaryGuid, offset, limit, sortOrder});
        }
        if (CollectionUtils.isNotEmpty((Collection)(glossary = this.getGlossary(glossaryGuid)).getCategories())) {
            ArrayList categories = new ArrayList(glossary.getCategories());
            if (sortOrder != null) {
                categories.sort((o1, o2) -> sortOrder == SortOrder.ASCENDING ? o1.getDisplayText().compareTo(o2.getDisplayText()) : o2.getDisplayText().compareTo(o1.getDisplayText()));
            }
            ret = new PaginationHelper(categories, offset, limit).getPaginatedList();
        } else {
            ret = Collections.emptyList();
        }
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.getGlossaryCategoriesHeaders() : {}", ret);
        }
        return ret;
    }

    @GraphTransaction
    public List<AtlasGlossaryCategory> getGlossaryCategories(String glossaryGuid, int offset, int limit, SortOrder sortOrder) throws AtlasBaseException {
        if (Objects.isNull(glossaryGuid)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"glossaryGuid is null/empty"});
        }
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.getGlossaryCategories({}, {}, {}, {})", new Object[]{glossaryGuid, offset, limit, sortOrder});
        }
        ArrayList<AtlasGlossaryCategory> ret = new ArrayList<AtlasGlossaryCategory>();
        List<AtlasRelatedCategoryHeader> categoryHeaders = this.getGlossaryCategoriesHeaders(glossaryGuid, offset, limit, sortOrder);
        for (AtlasRelatedCategoryHeader header : categoryHeaders) {
            ret.add(this.dataAccess.load(GlossaryUtils.getAtlasGlossaryCategorySkeleton(header.getCategoryGuid())));
        }
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.getGlossaryCategories() : {}", ret);
        }
        return ret;
    }

    @GraphTransaction
    public List<AtlasRelatedTermHeader> getCategoryTerms(String categoryGuid, int offset, int limit, SortOrder sortOrder) throws AtlasBaseException {
        List<Object> ret;
        AtlasGlossaryCategory glossaryCategory;
        if (Objects.isNull(categoryGuid)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"categoryGuid is null/empty"});
        }
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.getCategoryTerms({}, {}, {}, {})", new Object[]{categoryGuid, offset, limit, sortOrder});
        }
        if (CollectionUtils.isNotEmpty((Collection)(glossaryCategory = this.getCategory(categoryGuid)).getTerms())) {
            ArrayList terms = new ArrayList(glossaryCategory.getTerms());
            if (sortOrder != null) {
                terms.sort((o1, o2) -> sortOrder == SortOrder.ASCENDING ? o1.getDisplayText().compareTo(o2.getDisplayText()) : o2.getDisplayText().compareTo(o1.getDisplayText()));
            }
            ret = new PaginationHelper(terms, offset, limit).getPaginatedList();
        } else {
            ret = Collections.emptyList();
        }
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.getCategoryTerms() : {}", ret);
        }
        return ret;
    }

    @GraphTransaction
    public Map<AtlasGlossaryTerm.Relation, Set<AtlasRelatedTermHeader>> getRelatedTerms(String termGuid, int offset, int limit, SortOrder sortOrder) throws AtlasBaseException {
        AtlasGlossaryTerm glossaryTerm;
        if (Objects.isNull(termGuid)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"termGuid is null/empty"});
        }
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.getRelatedTerms({}, {}, {}, {})", new Object[]{termGuid, offset, limit, sortOrder});
        }
        Map ret = (glossaryTerm = this.getTerm(termGuid)).hasTerms() ? glossaryTerm.getRelatedTerms() : Collections.emptyMap();
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.getRelatedTerms() : {}", (Object)ret);
        }
        return ret;
    }

    @GraphTransaction
    public Map<String, List<AtlasRelatedCategoryHeader>> getRelatedCategories(String categoryGuid, int offset, int limit, SortOrder sortOrder) throws AtlasBaseException {
        if (Objects.isNull(categoryGuid)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"categoryGuid is null/empty"});
        }
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryService.getRelatedCategories({}, {}, {}, {})", new Object[]{categoryGuid, offset, limit, sortOrder});
        }
        final AtlasGlossaryCategory glossaryCategory = this.getCategory(categoryGuid);
        HashMap<String, List<AtlasRelatedCategoryHeader>> ret = new HashMap<String, List<AtlasRelatedCategoryHeader>>();
        if (glossaryCategory.getParentCategory() != null) {
            ret.put("parent", new ArrayList<AtlasRelatedCategoryHeader>(){
                {
                    this.add(glossaryCategory.getParentCategory());
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)glossaryCategory.getChildrenCategories())) {
            ret.put("children", new ArrayList(glossaryCategory.getChildrenCategories()));
        }
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryService.getRelatedCategories() : {}", ret);
        }
        return ret;
    }

    @GraphTransaction
    public List<AtlasRelatedObjectId> getAssignedEntities(String termGuid, int offset, int limit, SortOrder sortOrder) throws AtlasBaseException {
        List<Object> ret;
        if (Objects.isNull(termGuid)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"termGuid is null/empty"});
        }
        AtlasGlossaryTerm glossaryTerm = this.dataAccess.load(GlossaryUtils.getAtlasGlossaryTermSkeleton(termGuid));
        Set assignedEntities = glossaryTerm.getAssignedEntities();
        if (CollectionUtils.isNotEmpty((Collection)assignedEntities)) {
            ret = new ArrayList<AtlasRelatedObjectId>(assignedEntities);
            if (sortOrder != null) {
                ret.sort((o1, o2) -> sortOrder == SortOrder.ASCENDING ? o1.getDisplayText().compareTo(o2.getDisplayText()) : o2.getDisplayText().compareTo(o1.getDisplayText()));
            }
            ret = new PaginationHelper(assignedEntities, offset, limit).getPaginatedList();
        } else {
            ret = Collections.emptyList();
        }
        return ret;
    }

    private boolean glossaryExists(final AtlasGlossary atlasGlossary) {
        AtlasVertex vertex = AtlasGraphUtilsV2.findByUniqueAttributes(this.atlasTypeRegistry.getEntityTypeByName("AtlasGlossary"), (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(GlossaryService.QUALIFIED_NAME_ATTR, atlasGlossary.getQualifiedName());
            }
        });
        return Objects.nonNull(vertex);
    }

    private String getGlossaryQualifiedName(String glossaryGuid) {
        AtlasVertex vertex;
        String ret = glossaryGuidQualifiedNameCache.get(glossaryGuid);
        if (StringUtils.isEmpty((String)ret) && (vertex = AtlasGraphUtilsV2.findByGuid(glossaryGuid)) != null) {
            ret = (String)vertex.getProperty(GLOSSARY_QUALIFIED_NAME_PROPERTY, String.class);
            glossaryGuidQualifiedNameCache.put(glossaryGuid, ret);
        }
        return ret;
    }

    private String getGlossaryCategoryName(String glossaryCategoryGuid) {
        AtlasVertex vertex;
        String ret = categoryGuidNameCache.get(glossaryCategoryGuid);
        if (StringUtils.isEmpty((String)ret) && (vertex = AtlasGraphUtilsV2.findByGuid(glossaryCategoryGuid)) != null) {
            ret = (String)vertex.getProperty(GLOSSARY_CATEGORY_NAME_PROPERTY, String.class);
            categoryGuidNameCache.put(glossaryCategoryGuid, ret);
        }
        return ret;
    }

    private boolean termExists(final AtlasGlossaryTerm term) {
        AtlasVertex vertex = AtlasGraphUtilsV2.findByUniqueAttributes(this.atlasTypeRegistry.getEntityTypeByName(ATLAS_GLOSSARY_TERM), (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(GlossaryService.QUALIFIED_NAME_ATTR, term.getQualifiedName());
            }
        });
        return Objects.nonNull(vertex);
    }

    private boolean termExists2(AtlasGlossaryTerm term) {
        boolean ret = false;
        AtlasVertex glossaryVertex = AtlasGraphUtilsV2.findByGuid(term.getAnchor().getGlossaryGuid());
        Iterable glossaryTermEdges = glossaryVertex.getEdges(AtlasEdgeDirection.OUT, GLOSSARY_TERM_ANCHOR_EDGE_LABEL);
        Iterator iter = glossaryTermEdges.iterator();
        while (iter.hasNext()) {
            AtlasVertex termVertex = ((AtlasEdge)iter.next()).getInVertex();
            String termQualifiedName = (String)termVertex.getProperty(TERM_UNIQUE_QUALIFIED_NAME_PROPERTY, String.class);
            if (!StringUtils.equals((String)termQualifiedName, (String)term.getQualifiedName())) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private boolean categoryExists(final AtlasGlossaryCategory category) {
        AtlasVertex vertex = AtlasGraphUtilsV2.findByUniqueAttributes(this.atlasTypeRegistry.getEntityTypeByName("AtlasGlossaryCategory"), (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(GlossaryService.QUALIFIED_NAME_ATTR, category.getQualifiedName());
            }
        });
        return Objects.nonNull(vertex);
    }

    private void deleteCategories(AtlasGlossary storeObject, Collection<AtlasRelatedCategoryHeader> categories) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(categories)) {
            if (DEBUG_ENABLED) {
                LOG.debug("Deleting categories within glossary guid = {}", (Object)storeObject.getGuid());
            }
            for (AtlasRelatedCategoryHeader category : categories) {
                this.deleteCategory(category.getCategoryGuid());
            }
        }
    }

    private void deleteTerms(AtlasGlossary storeObject, Collection<AtlasRelatedTermHeader> terms) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(terms)) {
            if (DEBUG_ENABLED) {
                LOG.debug("Deleting terms within glossary guid = {}", (Object)storeObject.getGuid());
            }
            for (AtlasRelatedTermHeader term : terms) {
                this.deleteTerm(term.getTermGuid());
            }
        }
    }

    private void setInfoForRelations(AtlasGlossary ret) throws AtlasBaseException {
        if (Objects.nonNull(ret.getTerms())) {
            this.setDisplayNameForTerms(ret.getTerms());
        }
        if (Objects.nonNull(ret.getCategories())) {
            this.setInfoForRelatedCategories(ret.getCategories());
        }
    }

    private void setInfoForRelations(AtlasGlossaryTerm glossaryTerm) throws AtlasBaseException {
        this.setDisplayNameForCategories(glossaryTerm.getCategories());
        if (Objects.nonNull(glossaryTerm.getRelatedTerms())) {
            for (Map.Entry entry : glossaryTerm.getRelatedTerms().entrySet()) {
                this.setDisplayNameForTerms((Collection)entry.getValue());
                this.setQualifiedNameForTerms((Collection)entry.getValue());
            }
        }
    }

    private void setInfoForRelations(AtlasGlossaryCategory glossaryCategory) throws AtlasBaseException {
        if (Objects.nonNull(glossaryCategory.getChildrenCategories())) {
            this.setInfoForRelatedCategories(glossaryCategory.getChildrenCategories());
        }
        if (Objects.nonNull(glossaryCategory.getTerms())) {
            this.setDisplayNameForTerms(glossaryCategory.getTerms());
        }
    }

    private void setDisplayNameForCategories(Set<AtlasTermCategorizationHeader> categorizationHeaders) throws AtlasBaseException {
        if (CollectionUtils.isEmpty(categorizationHeaders)) {
            return;
        }
        for (AtlasTermCategorizationHeader termCategorizationHeader : categorizationHeaders) {
            String categoryGuid = termCategorizationHeader.getCategoryGuid();
            String categoryName = this.getGlossaryCategoryName(categoryGuid);
            if (!StringUtils.isNotEmpty((String)categoryName)) continue;
            termCategorizationHeader.setDisplayText(categoryName);
        }
    }

    private void setInfoForRelatedCategories(Collection<AtlasRelatedCategoryHeader> categoryHeaders) throws AtlasBaseException {
        List categories = categoryHeaders.stream().map(id -> GlossaryUtils.getAtlasGlossaryCategorySkeleton(id.getCategoryGuid())).collect(Collectors.toList());
        HashMap categoryMap = new HashMap();
        this.dataAccess.load(categories).forEach(c -> categoryMap.put(c.getGuid(), c));
        for (AtlasRelatedCategoryHeader c2 : categoryHeaders) {
            AtlasGlossaryCategory category = (AtlasGlossaryCategory)categoryMap.get(c2.getCategoryGuid());
            c2.setDisplayText(category.getName());
            if (!Objects.nonNull(category.getParentCategory())) continue;
            c2.setParentCategoryGuid(category.getParentCategory().getCategoryGuid());
        }
    }

    private void setDisplayNameForTerms(Collection<AtlasRelatedTermHeader> termHeaders) throws AtlasBaseException {
        for (AtlasRelatedTermHeader termHeader : termHeaders) {
            String termGuid = termHeader.getTermGuid();
            AtlasVertex termVertex = AtlasGraphUtilsV2.findByGuid(termGuid);
            String termDisplayText = (String)termVertex.getProperty(GLOSSARY_TERM_NAME_PROPERTY, String.class);
            if (!StringUtils.isNotEmpty((String)termDisplayText)) continue;
            termHeader.setDisplayText(termDisplayText);
        }
    }

    private void setQualifiedNameForTerms(Collection<AtlasRelatedTermHeader> termHeaders) throws AtlasBaseException {
        for (AtlasRelatedTermHeader termHeader : termHeaders) {
            String termGuid = termHeader.getTermGuid();
            AtlasVertex termVertex = AtlasGraphUtilsV2.findByGuid(termGuid);
            String termQualifiedName = (String)termVertex.getProperty(GLOSSARY_TERM_QUALIFIED_NAME_PROPERTY, String.class);
            if (!StringUtils.isNotEmpty((String)termQualifiedName)) continue;
            termHeader.setQualifiedName(termQualifiedName);
        }
    }

    public static boolean isNameInvalid(String name) {
        return StringUtils.containsAny((String)name, (char[])invalidNameChars);
    }

    private String getDuplicateGlossaryRelatedTerm(AtlasGlossaryTerm atlasGlossaryTerm) throws AtlasBaseException {
        Map relatedTermsMap = atlasGlossaryTerm.getRelatedTerms();
        for (Map.Entry relatedTermsMapEntry : relatedTermsMap.entrySet()) {
            List duplicateTermHeaders;
            Set termHeaders = (Set)relatedTermsMapEntry.getValue();
            if (!CollectionUtils.isNotEmpty((Collection)termHeaders) || !CollectionUtils.isNotEmpty(duplicateTermHeaders = termHeaders.stream().collect(Collectors.groupingBy(AtlasRelatedTermHeader::getTermGuid)).values().stream().filter(duplicates -> duplicates.size() > 1).flatMap(Collection::stream).collect(Collectors.toList())) || duplicateTermHeaders.size() <= 0) continue;
            String dupTermGuid = ((AtlasRelatedTermHeader)duplicateTermHeaders.get(0)).getTermGuid();
            AtlasGlossaryTerm glossaryTerm = this.getTerm(dupTermGuid);
            return glossaryTerm.getQualifiedName();
        }
        return "";
    }

    private String getDisplayText(AtlasGlossaryTerm term) {
        return term != null ? term.getName() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GraphTransaction
    public BulkImportResponse importGlossaryData(InputStream inputStream, String fileName) throws AtlasBaseException {
        BulkImportResponse ret = new BulkImportResponse();
        if (StringUtils.isBlank((String)fileName)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_FILE_TYPE, new String[]{fileName});
        }
        try {
            List<String[]> fileData = FileUtils.readFileData(fileName, inputStream);
            List<AtlasGlossaryTerm> glossaryTermsWithoutRelations = this.glossaryTermUtils.getGlossaryTermDataWithoutRelations(fileData, ret);
            this.createGlossaryTerms(glossaryTermsWithoutRelations, ret);
            List<AtlasGlossaryTerm> glossaryTermsWithRelations = this.glossaryTermUtils.getGlossaryTermDataWithRelations(fileData, ret);
            this.updateGlossaryTermsRelation(glossaryTermsWithRelations, ret);
        }
        finally {
            this.glossaryTermUtils.clearImportCache();
        }
        return ret;
    }

    private void createGlossaryTerms(List<AtlasGlossaryTerm> glossaryTerms, BulkImportResponse bulkImportResponse) throws AtlasBaseException {
        for (AtlasGlossaryTerm glossaryTerm : glossaryTerms) {
            String glossaryTermName = glossaryTerm.getName();
            String glossaryName = this.getGlossaryName(glossaryTerm);
            try {
                AtlasGlossaryTerm createdTerm = this.createTerm(glossaryTerm);
                bulkImportResponse.addToSuccessImportInfoList(new BulkImportResponse.ImportInfo(glossaryName, glossaryTermName, BulkImportResponse.ImportStatus.SUCCESS, AtlasJson.toJson((Object)createdTerm.getGlossaryTermHeader())));
            }
            catch (AtlasBaseException e) {
                LOG.error(AtlasErrorCode.FAILED_TO_CREATE_GLOSSARY_TERM.toString(), (Object)glossaryTermName, (Object)e);
                bulkImportResponse.addToFailedImportInfoList(new BulkImportResponse.ImportInfo(glossaryName, glossaryTermName, BulkImportResponse.ImportStatus.FAILED, e.getMessage()));
            }
        }
        this.checkForSuccessImports(bulkImportResponse);
    }

    private void updateGlossaryTermsRelation(List<AtlasGlossaryTerm> glossaryTerms, BulkImportResponse bulkImportResponse) {
        for (AtlasGlossaryTerm glossaryTerm : glossaryTerms) {
            this.glossaryTermUtils.updateGlossaryTermRelations(glossaryTerm);
            if (!glossaryTerm.hasTerms()) continue;
            String glossaryTermName = glossaryTerm.getName();
            String glossaryName = this.getGlossaryName(glossaryTerm);
            try {
                this.updateTerm(glossaryTerm, false);
            }
            catch (AtlasBaseException e) {
                LOG.error(AtlasErrorCode.FAILED_TO_UPDATE_GLOSSARY_TERM.toString(), (Object)glossaryTermName, (Object)e);
                bulkImportResponse.addToFailedImportInfoList(new BulkImportResponse.ImportInfo(glossaryName, glossaryTermName, BulkImportResponse.ImportStatus.FAILED, e.getMessage()));
            }
        }
    }

    private String getGlossaryName(AtlasGlossaryTerm glossaryTerm) {
        String ret = "";
        String glossaryTermQName = glossaryTerm.getQualifiedName();
        if (StringUtils.isNotBlank((String)glossaryTermQName)) {
            String[] glossaryQnameSplit = glossaryTermQName.split("@");
            ret = glossaryQnameSplit.length == 2 ? glossaryQnameSplit[1] : "";
        }
        return ret;
    }

    private void checkForSuccessImports(BulkImportResponse bulkImportResponse) throws AtlasBaseException {
        if (CollectionUtils.isEmpty((Collection)bulkImportResponse.getSuccessImportInfoList())) {
            throw new AtlasBaseException(AtlasErrorCode.GLOSSARY_IMPORT_FAILED, new String[0]);
        }
    }

    static class PaginationHelper<T> {
        private int pageStart;
        private int pageEnd;
        private int maxSize;
        private List<T> items;

        PaginationHelper(Collection<T> items, int offset, int limit) {
            Objects.requireNonNull(items, "items can't be empty/null");
            this.items = new ArrayList<T>(items);
            this.maxSize = items.size();
            int adjustedLimit = limit < 0 ? this.maxSize : Integer.min(this.maxSize, limit);
            this.pageStart = Integer.max(0, offset);
            this.pageEnd = Integer.min(adjustedLimit + this.pageStart, this.maxSize);
        }

        List<T> getPaginatedList() {
            List ret = this.isValidOffset() ? (this.isPagingNeeded() ? this.items.subList(this.pageStart, this.pageEnd) : this.items) : Collections.emptyList();
            return ret;
        }

        private boolean isPagingNeeded() {
            return (this.pageStart != 0 || this.pageEnd != this.maxSize) && this.pageStart <= this.pageEnd;
        }

        private boolean isValidOffset() {
            return this.pageStart <= this.maxSize;
        }
    }
}

