/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.glossary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.bulkimport.BulkImportResponse;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.glossary.GlossaryService;
import org.apache.atlas.glossary.GlossaryUtils;
import org.apache.atlas.model.glossary.AtlasGlossary;
import org.apache.atlas.model.glossary.AtlasGlossaryTerm;
import org.apache.atlas.model.glossary.relations.AtlasGlossaryHeader;
import org.apache.atlas.model.glossary.relations.AtlasRelatedTermHeader;
import org.apache.atlas.model.glossary.relations.AtlasTermCategorizationHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.ogm.DataAccess;
import org.apache.atlas.repository.store.graph.AtlasRelationshipStore;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryTermUtils
extends GlossaryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(GlossaryTermUtils.class);
    private static final boolean DEBUG_ENABLED = LOG.isDebugEnabled();
    private static final int INDEX_FOR_GLOSSARY_AT_RECORD = 0;
    private static final int INDEX_FOR_TERM_AT_RECORD = 1;
    private static final ThreadLocal<Map<String, String>> glossaryNameGuidCache = ThreadLocal.withInitial(() -> new LinkedHashMap());
    private static final ThreadLocal<Map<String, Integer>> glossaryTermOrderCache = ThreadLocal.withInitial(() -> new HashMap());
    private static final ThreadLocal<Map<String, String>> glossaryTermQNameGuidCache = ThreadLocal.withInitial(() -> new HashMap());

    protected GlossaryTermUtils(AtlasRelationshipStore relationshipStore, AtlasTypeRegistry typeRegistry, DataAccess dataAccess) {
        super(relationshipStore, typeRegistry, dataAccess);
    }

    public void processTermRelations(AtlasGlossaryTerm storeObject, AtlasGlossaryTerm updatedTerm, GlossaryUtils.RelationshipOperation op) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryTermUtils.processTermRelations({}, {}, {})", new Object[]{storeObject, updatedTerm, op});
        }
        this.processTermAnchor(storeObject, updatedTerm, op);
        this.processRelatedTerms(storeObject, updatedTerm, op);
        this.processAssociatedCategories(storeObject, updatedTerm, op);
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryTermUtils.processTermRelations()");
        }
    }

    public void processTermAssignments(AtlasGlossaryTerm glossaryTerm, Collection<AtlasRelatedObjectId> relatedObjectIds) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryTermUtils.processTermAssignments({}, {})", (Object)glossaryTerm, relatedObjectIds);
        }
        Objects.requireNonNull(glossaryTerm);
        Set assignedEntities = glossaryTerm.getAssignedEntities();
        for (AtlasRelatedObjectId objectId : relatedObjectIds) {
            if (CollectionUtils.isNotEmpty((Collection)assignedEntities) && assignedEntities.contains(objectId) && DEBUG_ENABLED) {
                LOG.debug("Skipping already assigned entity {}", (Object)objectId);
                continue;
            }
            if (DEBUG_ENABLED) {
                LOG.debug("Assigning term guid={}, to entity guid = {}", (Object)glossaryTerm.getGuid(), (Object)objectId.getGuid());
            }
            this.createRelationship(this.defineTermAssignment(glossaryTerm.getGuid(), objectId));
        }
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryTermUtils.processTermAssignments()");
        }
    }

    public void processTermDissociation(AtlasGlossaryTerm glossaryTerm, Collection<AtlasRelatedObjectId> relatedObjectIds) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryTermUtils.processTermDissociation({}, {}, {})", new Object[]{glossaryTerm.getGuid(), relatedObjectIds, glossaryTerm});
        }
        Objects.requireNonNull(glossaryTerm);
        Set assignedEntities = glossaryTerm.getAssignedEntities();
        HashMap<String, AtlasRelatedObjectId> assignedEntityMap = new HashMap<String, AtlasRelatedObjectId>();
        if (CollectionUtils.isNotEmpty((Collection)assignedEntities)) {
            for (AtlasRelatedObjectId relatedObjectId : assignedEntities) {
                assignedEntityMap.put(relatedObjectId.getGuid(), relatedObjectId);
            }
        }
        if (CollectionUtils.isNotEmpty(relatedObjectIds)) {
            for (AtlasRelatedObjectId relatedObjectId : relatedObjectIds) {
                if (DEBUG_ENABLED) {
                    LOG.debug("Removing term guid={}, from entity guid = {}", (Object)glossaryTerm.getGuid(), (Object)relatedObjectId.getGuid());
                }
                if (Objects.isNull(relatedObjectId.getRelationshipGuid())) {
                    throw new AtlasBaseException(AtlasErrorCode.TERM_DISSOCIATION_MISSING_RELATION_GUID, new String[0]);
                }
                AtlasRelatedObjectId existingTermRelation = (AtlasRelatedObjectId)assignedEntityMap.get(relatedObjectId.getGuid());
                if (CollectionUtils.isNotEmpty((Collection)assignedEntities) && this.isRelationshipGuidSame(existingTermRelation, relatedObjectId)) {
                    this.relationshipStore.deleteById(relatedObjectId.getRelationshipGuid(), true);
                    continue;
                }
                throw new AtlasBaseException(AtlasErrorCode.INVALID_TERM_DISSOCIATION, new String[]{relatedObjectId.getRelationshipGuid(), glossaryTerm.getGuid(), relatedObjectId.getGuid()});
            }
        }
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryTermUtils.processTermDissociation()");
        }
    }

    public void clearImportCache() {
        glossaryNameGuidCache.get().clear();
        glossaryTermOrderCache.get().clear();
        glossaryTermQNameGuidCache.get().clear();
    }

    private boolean isRelationshipGuidSame(AtlasRelatedObjectId storeObject, AtlasRelatedObjectId relatedObjectId) {
        return StringUtils.equals((String)relatedObjectId.getRelationshipGuid(), (String)storeObject.getRelationshipGuid());
    }

    private void processTermAnchor(AtlasGlossaryTerm currentTerm, AtlasGlossaryTerm updatedTerm, GlossaryUtils.RelationshipOperation op) throws AtlasBaseException {
        if (Objects.isNull(updatedTerm.getAnchor()) && op != GlossaryUtils.RelationshipOperation.DELETE) {
            throw new AtlasBaseException(AtlasErrorCode.MISSING_MANDATORY_ANCHOR, new String[0]);
        }
        AtlasGlossaryHeader currentTermGlossary = currentTerm.getAnchor();
        AtlasGlossaryHeader updatedTermGlossary = updatedTerm.getAnchor();
        String updatedTermGlossaryGuid = updatedTermGlossary.getGlossaryGuid();
        String currentTermGlossaryGuid = currentTermGlossary.getGlossaryGuid();
        switch (op) {
            case CREATE: {
                if (Objects.isNull(updatedTermGlossaryGuid)) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_NEW_ANCHOR_GUID, new String[0]);
                }
                if (DEBUG_ENABLED) {
                    LOG.debug("Creating new term anchor, category = {}, glossary = {}", (Object)currentTerm.getGuid(), (Object)updatedTerm.getAnchor().getGlossaryGuid());
                }
                if (StringUtils.equals((String)updatedTermGlossaryGuid, (String)currentTermGlossaryGuid)) break;
                this.createRelationship(this.defineTermAnchorRelation(updatedTermGlossaryGuid, currentTerm.getGuid()));
                break;
            }
            case UPDATE: {
                if (Objects.equals(updatedTermGlossary, currentTermGlossary)) break;
                if (Objects.isNull(updatedTermGlossaryGuid)) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_NEW_ANCHOR_GUID, new String[0]);
                }
                if (DEBUG_ENABLED) {
                    LOG.debug("Updating term anchor, currAnchor = {}, newAnchor = {} and term = {}", new Object[]{currentTermGlossaryGuid, updatedTermGlossaryGuid, currentTerm.getName()});
                }
                this.relationshipStore.deleteById(currentTermGlossary.getRelationGuid(), true);
                String anchorGlossaryGuid = updatedTermGlossaryGuid;
                AtlasGlossary glossary = this.dataAccess.load(GlossaryTermUtils.getGlossarySkeleton(anchorGlossaryGuid));
                currentTerm.setQualifiedName(currentTerm.getName() + "@" + glossary.getQualifiedName());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Derived qualifiedName = {}", (Object)currentTerm.getQualifiedName());
                }
                this.createRelationship(this.defineTermAnchorRelation(updatedTermGlossaryGuid, currentTerm.getGuid()));
                break;
            }
            case DELETE: {
                if (!Objects.nonNull(currentTermGlossary)) break;
                if (DEBUG_ENABLED) {
                    LOG.debug("Deleting term anchor");
                }
                this.relationshipStore.deleteById(currentTermGlossary.getRelationGuid(), true);
            }
        }
    }

    private void processRelatedTerms(AtlasGlossaryTerm storeObject, AtlasGlossaryTerm updatedTerm, GlossaryUtils.RelationshipOperation op) throws AtlasBaseException {
        Map newRelatedTerms = updatedTerm.getRelatedTerms();
        Map existingRelatedTerms = storeObject.getRelatedTerms();
        switch (op) {
            case CREATE: {
                for (Map.Entry entry : newRelatedTerms.entrySet()) {
                    AtlasGlossaryTerm.Relation relation = (AtlasGlossaryTerm.Relation)entry.getKey();
                    Set terms = (Set)entry.getValue();
                    if (!Objects.nonNull(terms)) continue;
                    if (DEBUG_ENABLED) {
                        LOG.debug("{} relation {} for term = {}", new Object[]{op, relation, storeObject.getGuid()});
                        LOG.debug("Related Term count = {}", (Object)terms.size());
                    }
                    this.createTermRelationships(storeObject, relation, terms);
                }
                break;
            }
            case UPDATE: {
                for (AtlasGlossaryTerm.Relation relation : AtlasGlossaryTerm.Relation.values()) {
                    Map<String, AtlasRelatedTermHeader> existingTermHeaders = this.getRelatedTermHeaders(existingRelatedTerms, relation);
                    Map<String, AtlasRelatedTermHeader> newTermHeaders = this.getRelatedTermHeaders(newRelatedTerms, relation);
                    if (MapUtils.isEmpty(existingTermHeaders)) {
                        if (DEBUG_ENABLED) {
                            LOG.debug("Creating new term relations, relation = {}, terms = {}", (Object)relation, Objects.nonNull(newTermHeaders) ? Integer.valueOf(newTermHeaders.size()) : "none");
                        }
                        this.createTermRelationships(storeObject, relation, newTermHeaders.values());
                        continue;
                    }
                    if (MapUtils.isEmpty(newTermHeaders)) {
                        if (DEBUG_ENABLED) {
                            LOG.debug("Deleting existing term relations, relation = {}, terms = {}", (Object)relation, (Object)existingTermHeaders.size());
                        }
                        this.deleteTermRelationships(relation, existingTermHeaders.values());
                        continue;
                    }
                    Set<AtlasRelatedTermHeader> toCreate = newTermHeaders.values().stream().filter(t -> !existingTermHeaders.containsKey(t.getTermGuid())).collect(Collectors.toSet());
                    Set<AtlasRelatedTermHeader> toUpdate = newTermHeaders.values().stream().filter(t -> this.updatedExistingTermRelation(existingTermHeaders, (AtlasRelatedTermHeader)t)).collect(Collectors.toSet());
                    Set<AtlasRelatedTermHeader> toDelete = existingTermHeaders.values().stream().filter(t -> !newTermHeaders.containsKey(t.getTermGuid())).collect(Collectors.toSet());
                    this.createTermRelationships(storeObject, relation, toCreate);
                    this.updateTermRelationships(relation, toUpdate);
                    this.deleteTermRelationships(relation, toDelete);
                }
                break;
            }
            case DELETE: {
                for (AtlasGlossaryTerm.Relation relation : AtlasGlossaryTerm.Relation.values()) {
                    Set existingTermHeaders = (Set)existingRelatedTerms.get(relation);
                    this.deleteTermRelationships(relation, existingTermHeaders);
                }
                break;
            }
        }
    }

    private Map<String, AtlasRelatedTermHeader> getRelatedTermHeaders(Map<AtlasGlossaryTerm.Relation, Set<AtlasRelatedTermHeader>> relatedTerms, AtlasGlossaryTerm.Relation relation) {
        if (Objects.nonNull(relatedTerms.get(relation))) {
            HashMap<String, AtlasRelatedTermHeader> map = new HashMap<String, AtlasRelatedTermHeader>();
            for (AtlasRelatedTermHeader t : relatedTerms.get(relation)) {
                AtlasRelatedTermHeader header = (AtlasRelatedTermHeader)map.get(t.getTermGuid());
                if (header != null && (!StringUtils.isEmpty((String)header.getRelationGuid()) || !StringUtils.isNotEmpty((String)t.getRelationGuid()))) continue;
                map.put(t.getTermGuid(), t);
            }
            return map;
        }
        return Collections.emptyMap();
    }

    private boolean updatedExistingTermRelation(Map<String, AtlasRelatedTermHeader> existingTermHeaders, AtlasRelatedTermHeader header) {
        return Objects.nonNull(header.getRelationGuid()) && !header.equals((Object)existingTermHeaders.get(header.getTermGuid()));
    }

    private void processAssociatedCategories(AtlasGlossaryTerm storeObject, AtlasGlossaryTerm updatedTerm, GlossaryUtils.RelationshipOperation op) throws AtlasBaseException {
        Map<String, AtlasTermCategorizationHeader> newCategories = this.getAssociatedCategories(updatedTerm);
        Map<String, AtlasTermCategorizationHeader> existingCategories = this.getAssociatedCategories(storeObject);
        switch (op) {
            case CREATE: {
                if (!Objects.nonNull(newCategories)) break;
                if (DEBUG_ENABLED) {
                    LOG.debug("Creating new term categorization, term = {}, categories = {}", (Object)storeObject.getGuid(), (Object)newCategories.size());
                }
                this.createTermCategorizationRelationships(storeObject, newCategories.values());
                break;
            }
            case UPDATE: {
                if (MapUtils.isEmpty(existingCategories)) {
                    if (DEBUG_ENABLED) {
                        LOG.debug("Creating new term categorization, term = {}, categories = {}", (Object)storeObject.getGuid(), Objects.nonNull(newCategories) ? Integer.valueOf(newCategories.size()) : "none");
                    }
                    this.createTermCategorizationRelationships(storeObject, newCategories.values());
                    break;
                }
                if (MapUtils.isEmpty(newCategories)) {
                    if (DEBUG_ENABLED) {
                        LOG.debug("Deleting term categorization, term = {}, categories = {}", (Object)storeObject.getGuid(), (Object)existingCategories.size());
                    }
                    this.deleteCategorizationRelationship(existingCategories.values());
                    break;
                }
                Set<AtlasTermCategorizationHeader> toCreate = newCategories.values().stream().filter(c -> !existingCategories.containsKey(c.getCategoryGuid())).collect(Collectors.toSet());
                this.createTermCategorizationRelationships(storeObject, toCreate);
                Set<AtlasTermCategorizationHeader> toUpdate = newCategories.values().stream().filter(c -> this.updatedExistingCategorizationRelation(existingCategories, (AtlasTermCategorizationHeader)c)).collect(Collectors.toSet());
                this.updateTermCategorizationRelationships(storeObject, toUpdate);
                Set<AtlasTermCategorizationHeader> toDelete = existingCategories.values().stream().filter(c -> !newCategories.containsKey(c.getCategoryGuid())).collect(Collectors.toSet());
                this.deleteCategorizationRelationship(toDelete);
                break;
            }
            case DELETE: {
                this.deleteCategorizationRelationship(existingCategories.values());
            }
        }
    }

    private boolean updatedExistingCategorizationRelation(Map<String, AtlasTermCategorizationHeader> existingCategories, AtlasTermCategorizationHeader header) {
        return Objects.nonNull(header.getRelationGuid()) && !header.equals((Object)existingCategories.get(header.getCategoryGuid()));
    }

    private Map<String, AtlasTermCategorizationHeader> getAssociatedCategories(AtlasGlossaryTerm term) {
        if (Objects.nonNull(term.getCategories())) {
            HashMap<String, AtlasTermCategorizationHeader> map = new HashMap<String, AtlasTermCategorizationHeader>();
            for (AtlasTermCategorizationHeader c : term.getCategories()) {
                AtlasTermCategorizationHeader header = (AtlasTermCategorizationHeader)map.get(c.getCategoryGuid());
                if (header != null && (!StringUtils.isEmpty((String)header.getRelationGuid()) || !StringUtils.isNotEmpty((String)c.getRelationGuid()))) continue;
                map.put(c.getCategoryGuid(), c);
            }
            return map;
        }
        return Collections.emptyMap();
    }

    private void createTermCategorizationRelationships(AtlasGlossaryTerm storeObject, Collection<AtlasTermCategorizationHeader> categories) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(categories)) {
            Set existingCategories = storeObject.getCategories();
            for (AtlasTermCategorizationHeader categorizationHeader : categories) {
                if (Objects.nonNull(existingCategories) && existingCategories.contains(categorizationHeader)) {
                    if (!DEBUG_ENABLED) continue;
                    LOG.debug("Skipping existing category guid={}", (Object)categorizationHeader.getCategoryGuid());
                    continue;
                }
                if (DEBUG_ENABLED) {
                    LOG.debug("Creating relation between term = {} and category = {}", (Object)storeObject.getGuid(), (Object)categorizationHeader.getDisplayText());
                }
                this.createRelationship(this.defineCategorizedTerm(categorizationHeader, storeObject.getGuid()));
            }
        }
    }

    private void updateTermCategorizationRelationships(AtlasGlossaryTerm storeObject, Collection<AtlasTermCategorizationHeader> toUpdate) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(toUpdate)) {
            for (AtlasTermCategorizationHeader categorizationHeader : toUpdate) {
                if (DEBUG_ENABLED) {
                    LOG.debug("Updating relation between term = {} and category = {}", (Object)storeObject.getGuid(), (Object)categorizationHeader.getDisplayText());
                }
                AtlasRelationship relationship = this.relationshipStore.getById(categorizationHeader.getRelationGuid());
                this.updateRelationshipAttributes(relationship, categorizationHeader);
                this.relationshipStore.update(relationship);
            }
        }
    }

    private void deleteCategorizationRelationship(Collection<AtlasTermCategorizationHeader> existingCategories) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(existingCategories)) {
            for (AtlasTermCategorizationHeader categorizationHeader : existingCategories) {
                if (DEBUG_ENABLED) {
                    LOG.debug("Deleting relation guid = {}, text = {}", (Object)categorizationHeader.getRelationGuid(), (Object)categorizationHeader.getDisplayText());
                }
                this.relationshipStore.deleteById(categorizationHeader.getRelationGuid(), true);
            }
        }
    }

    private void createTermRelationships(AtlasGlossaryTerm storeObject, AtlasGlossaryTerm.Relation relation, Collection<AtlasRelatedTermHeader> terms) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(terms)) {
            Map existingRelations;
            if (Objects.nonNull(storeObject.getRelatedTerms()) && Objects.nonNull(storeObject.getRelatedTerms().get(relation))) {
                HashMap<String, AtlasRelatedTermHeader> map = new HashMap<String, AtlasRelatedTermHeader>();
                for (AtlasRelatedTermHeader t : (Set)storeObject.getRelatedTerms().get(relation)) {
                    AtlasRelatedTermHeader header = (AtlasRelatedTermHeader)map.get(t.getTermGuid());
                    if (header != null && (!StringUtils.isEmpty((String)header.getRelationGuid()) || !StringUtils.isNotEmpty((String)t.getRelationGuid()))) continue;
                    map.put(t.getTermGuid(), t);
                }
                existingRelations = map;
            } else {
                existingRelations = Collections.emptyMap();
            }
            for (AtlasRelatedTermHeader term : terms) {
                if (existingRelations.containsKey(term.getTermGuid())) {
                    if (!DEBUG_ENABLED) continue;
                    LOG.debug("Skipping existing term relation termGuid={}", (Object)term.getTermGuid());
                    continue;
                }
                if (storeObject.getGuid().equals(term.getTermGuid())) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_TERM_RELATION_TO_SELF, new String[0]);
                }
                if (DEBUG_ENABLED) {
                    LOG.debug("Creating new term relation = {}, terms = {}", (Object)relation, (Object)term.getDisplayText());
                }
                this.createRelationship(this.defineTermRelation(relation, storeObject.getGuid(), term));
            }
        }
    }

    private void updateTermRelationships(AtlasGlossaryTerm.Relation relation, Collection<AtlasRelatedTermHeader> terms) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(terms)) {
            for (AtlasRelatedTermHeader term : terms) {
                if (DEBUG_ENABLED) {
                    LOG.debug("Updating term relation = {}, terms = {}", (Object)relation, (Object)term.getDisplayText());
                }
                AtlasRelationship relationship = this.relationshipStore.getById(term.getRelationGuid());
                this.updateRelationshipAttributes(relationship, term);
                this.relationshipStore.update(relationship);
            }
        }
    }

    private void deleteTermRelationships(AtlasGlossaryTerm.Relation relation, Collection<AtlasRelatedTermHeader> terms) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(terms)) {
            for (AtlasRelatedTermHeader termHeader : terms) {
                if (DEBUG_ENABLED) {
                    LOG.debug("Deleting term relation = {}, terms = {}", (Object)relation, (Object)termHeader.getDisplayText());
                }
                this.relationshipStore.deleteById(termHeader.getRelationGuid(), true);
            }
        }
    }

    private AtlasRelationship defineTermAnchorRelation(String glossaryGuid, String termGuid) {
        AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName("AtlasGlossaryTermAnchor");
        AtlasStruct defaultAttrs = relationshipType.createDefaultValue();
        return new AtlasRelationship("AtlasGlossaryTermAnchor", new AtlasObjectId(glossaryGuid), new AtlasObjectId(termGuid), defaultAttrs.getAttributes());
    }

    private AtlasRelationship defineTermRelation(AtlasGlossaryTerm.Relation relation, String end1TermGuid, AtlasRelatedTermHeader end2RelatedTerm) {
        AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName(relation.getName());
        AtlasStruct defaultAttrs = relationshipType.createDefaultValue();
        AtlasRelationship relationship = relation.isEnd2Attr() ? new AtlasRelationship(relation.getName(), new AtlasObjectId(end2RelatedTerm.getTermGuid()), new AtlasObjectId(end1TermGuid), defaultAttrs.getAttributes()) : new AtlasRelationship(relation.getName(), new AtlasObjectId(end1TermGuid), new AtlasObjectId(end2RelatedTerm.getTermGuid()), defaultAttrs.getAttributes());
        this.updateRelationshipAttributes(relationship, end2RelatedTerm);
        return relationship;
    }

    private AtlasRelationship defineCategorizedTerm(AtlasTermCategorizationHeader relatedCategoryId, String termId) {
        AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName("AtlasGlossaryTermCategorization");
        AtlasStruct defaultAttrs = relationshipType.createDefaultValue();
        AtlasRelationship relationship = new AtlasRelationship("AtlasGlossaryTermCategorization", new AtlasObjectId(relatedCategoryId.getCategoryGuid()), new AtlasObjectId(termId), defaultAttrs.getAttributes());
        this.updateRelationshipAttributes(relationship, relatedCategoryId);
        return relationship;
    }

    private AtlasRelationship defineTermAssignment(String termGuid, AtlasRelatedObjectId relatedObjectId) {
        AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName("AtlasGlossarySemanticAssignment");
        AtlasStruct defaultAttrs = relationshipType.createDefaultValue();
        AtlasObjectId end1 = new AtlasObjectId(termGuid);
        AtlasRelationship relationship = new AtlasRelationship("AtlasGlossarySemanticAssignment", end1, (AtlasObjectId)relatedObjectId, defaultAttrs.getAttributes());
        this.updateRelationshipAttributes(relationship, relatedObjectId);
        return relationship;
    }

    private void updateRelationshipAttributes(AtlasRelationship relationship, AtlasTermCategorizationHeader categorizationHeader) {
        if (Objects.nonNull(relationship)) {
            relationship.setAttribute("description", (Object)categorizationHeader.getDescription());
            if (Objects.nonNull(categorizationHeader.getStatus())) {
                relationship.setAttribute("status", (Object)categorizationHeader.getStatus().name());
            }
        }
    }

    private void updateRelationshipAttributes(AtlasRelationship relationship, AtlasRelatedObjectId relatedObjectId) {
        AtlasStruct relationshipAttributes = relatedObjectId.getRelationshipAttributes();
        if (Objects.nonNull(relationshipAttributes)) {
            for (Map.Entry attrEntry : relationshipAttributes.getAttributes().entrySet()) {
                relationship.setAttribute((String)attrEntry.getKey(), attrEntry.getValue());
            }
        }
    }

    protected List<AtlasGlossaryTerm> getGlossaryTermDataWithoutRelations(List<String[]> fileData, BulkImportResponse bulkImportResponse) throws AtlasBaseException {
        ArrayList<AtlasGlossaryTerm> glossaryTerms = new ArrayList<AtlasGlossaryTerm>();
        int rowCount = 1;
        for (Object[] objectArray : fileData) {
            ArrayList<String> failedTermMsgs = new ArrayList<String>();
            AtlasGlossaryTerm glossaryTerm = new AtlasGlossaryTerm();
            Object glossaryName = "";
            if (ArrayUtils.isEmpty((Object[])objectArray) || StringUtils.isBlank((String)objectArray[0])) {
                LOG.error("The GlossaryName is blank for the record : ", (Object)Arrays.toString(objectArray));
                failedTermMsgs.add("The GlossaryName is blank for the record : " + Arrays.toString(objectArray));
            } else {
                glossaryName = objectArray[0];
                String glossaryGuid = glossaryNameGuidCache.get().get(glossaryName);
                if (StringUtils.isEmpty((String)glossaryGuid)) {
                    glossaryGuid = this.getGlossaryGUIDFromGraphDB((String)glossaryName);
                    if (StringUtils.isEmpty((String)glossaryGuid)) {
                        glossaryGuid = this.createGlossary((String)glossaryName, failedTermMsgs);
                    }
                    glossaryNameGuidCache.get().put((String)glossaryName, glossaryGuid);
                }
                if (StringUtils.isNotEmpty((String)glossaryGuid)) {
                    glossaryTerm = this.populateGlossaryTermObject(failedTermMsgs, (String[])objectArray, glossaryGuid, false);
                    glossaryTerm.setQualifiedName(this.getGlossaryTermQualifiedName(glossaryTerm.getName(), (String)glossaryName));
                    glossaryTermOrderCache.get().put(glossaryTerm.getQualifiedName(), rowCount);
                    glossaryTerms.add(glossaryTerm);
                }
            }
            if (failedTermMsgs.size() > 0) {
                String failedTermMsg = StringUtils.join(failedTermMsgs, (String)System.lineSeparator());
                String glossaryTermName = glossaryTerm.getName();
                bulkImportResponse.addToFailedImportInfoList(new BulkImportResponse.ImportInfo((String)glossaryName, glossaryTermName, BulkImportResponse.ImportStatus.FAILED, failedTermMsg, Integer.valueOf(rowCount)));
            }
            ++rowCount;
        }
        return glossaryTerms;
    }

    protected List<AtlasGlossaryTerm> getGlossaryTermDataWithRelations(List<String[]> fileData, BulkImportResponse bulkImportResponse) throws AtlasBaseException {
        ArrayList<AtlasGlossaryTerm> glossaryTerms = new ArrayList<AtlasGlossaryTerm>();
        int rowCount = 1;
        for (Object[] objectArray : fileData) {
            ArrayList<String> failedTermMsgs = new ArrayList<String>();
            if (ArrayUtils.isNotEmpty((Object[])objectArray) && StringUtils.isNotBlank((String)objectArray[0])) {
                AtlasGlossaryTerm glossaryTerm = new AtlasGlossaryTerm();
                Object glossaryName = objectArray[0];
                String glossaryGuid = glossaryNameGuidCache.get().get(glossaryName);
                if (StringUtils.isNotEmpty((String)glossaryGuid)) {
                    glossaryTerm = this.populateGlossaryTermObject(failedTermMsgs, (String[])objectArray, glossaryGuid, true);
                    glossaryTerm.setQualifiedName(this.getGlossaryTermQualifiedName(glossaryTerm.getName(), (String)glossaryName));
                    glossaryTerms.add(glossaryTerm);
                }
                if (failedTermMsgs.size() > 0) {
                    String failedTermMsg = StringUtils.join(failedTermMsgs, (String)System.lineSeparator());
                    String glossaryTermName = glossaryTerm.getName();
                    bulkImportResponse.addToFailedImportInfoList(new BulkImportResponse.ImportInfo((String)glossaryName, glossaryTermName, BulkImportResponse.ImportStatus.FAILED, failedTermMsg, Integer.valueOf(rowCount)));
                }
            }
            ++rowCount;
        }
        return glossaryTerms;
    }

    public static String getGlossaryTermHeaders() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("GlossaryName");
        ret.add("TermName");
        ret.add("ShortDescription");
        ret.add("LongDescription");
        ret.add("Examples");
        ret.add("Abbreviation");
        ret.add("Usage");
        ret.add("AdditionalAttributes");
        ret.add("TranslationTerms");
        ret.add("ValidValuesFor");
        ret.add("Synonyms");
        ret.add("ReplacedBy");
        ret.add("ValidValues");
        ret.add("ReplacementTerms");
        ret.add("SeeAlso");
        ret.add("TranslatedTerms");
        ret.add("IsA");
        ret.add("Antonyms");
        ret.add("Classifies");
        ret.add("PreferredToTerms");
        ret.add("PreferredTerms");
        return String.join((CharSequence)", ", ret);
    }

    public void updateGlossaryTermRelations(AtlasGlossaryTerm updatedGlossaryTerm) {
        block3: {
            if (glossaryTermQNameGuidCache.get().containsKey(updatedGlossaryTerm.getQualifiedName())) {
                try {
                    AtlasGlossaryTerm glossaryTermFromDB = this.getGlossaryTem(glossaryTermQNameGuidCache.get().get(updatedGlossaryTerm.getQualifiedName()));
                    this.copyRelations(updatedGlossaryTerm, glossaryTermFromDB);
                }
                catch (AtlasBaseException e) {
                    if (!DEBUG_ENABLED) break block3;
                    LOG.debug("Error occurred while loading glossary Term", (Throwable)e);
                }
            }
        }
    }

    protected Map getMapValue(String csvRecord, List<String> failedTermMsgs, boolean populateRelations) {
        HashMap<String, String> ret = null;
        if (StringUtils.isNotBlank((String)csvRecord)) {
            String[] csvRecordArray;
            ret = new HashMap<String, String>();
            for (String record : csvRecordArray = csvRecord.split("\\|")) {
                String[] recordArray = record.split(":");
                if (recordArray.length % 2 == 0) {
                    ret.put(recordArray[0], recordArray[1]);
                    continue;
                }
                if (populateRelations) continue;
                failedTermMsgs.add("The Data in the uploaded file is incorrectly specified  : " + csvRecord + System.lineSeparator() + "AdditionalAttributes needs to be a key:value pair");
            }
        }
        return ret;
    }

    protected List getListValue(String csvRecord) {
        List<String> ret = null;
        if (StringUtils.isNotBlank((String)csvRecord)) {
            ret = Arrays.asList(csvRecord.split("\\|"));
        }
        return ret;
    }

    protected Set getAtlasRelatedTermHeaderSet(String csvRecord, String termName, String glossaryName, List<String> failedTermMsgs) {
        HashSet<AtlasRelatedTermHeader> ret = null;
        if (StringUtils.isNotBlank((String)csvRecord)) {
            String[] csvRecordArray;
            ret = new HashSet<AtlasRelatedTermHeader>();
            for (String data : csvRecordArray = csvRecord.split("\\|")) {
                AtlasVertex vertex = null;
                String[] dataArray = data.split("\\:");
                if (dataArray.length == 2) {
                    String currTermQualifiedName;
                    String relatedTermQualifiedName = dataArray[1] + invalidNameChars[0] + dataArray[0];
                    if (relatedTermQualifiedName.equalsIgnoreCase(currTermQualifiedName = termName + invalidNameChars[0] + glossaryName)) {
                        failedTermMsgs.add("Invalid relationship specified for Term. Term cannot have a relationship with self");
                        continue;
                    }
                    vertex = AtlasGraphUtilsV2.findByTypeAndUniquePropertyName("AtlasGlossaryTerm", "AtlasGlossaryTerm" + invalidNameChars[1] + "qualifiedName", relatedTermQualifiedName);
                    if (vertex != null) {
                        String glossaryTermGuid = AtlasGraphUtilsV2.getIdFromVertex(vertex);
                        AtlasRelatedTermHeader relatedTermHeader = new AtlasRelatedTermHeader();
                        relatedTermHeader.setTermGuid(glossaryTermGuid);
                        this.cacheRelatedTermQNameGuid(currTermQualifiedName, relatedTermQualifiedName, glossaryTermGuid);
                        ret.add(relatedTermHeader);
                        continue;
                    }
                    failedTermMsgs.add("The provided Reference " + dataArray[1] + "@" + dataArray[0] + " does not exist at Atlas referred at record with TermName  : " + termName + " and GlossaryName : " + glossaryName);
                    continue;
                }
                failedTermMsgs.add("Incorrect relation data specified for the term : " + termName + "@" + glossaryName);
            }
        }
        return ret;
    }

    protected AtlasGlossaryTerm populateGlossaryTermObject(List<String> failedTermMsgList, String[] record, String glossaryGuid, boolean populateRelations) {
        int length = record.length;
        int i = 1;
        AtlasGlossaryTerm ret = new AtlasGlossaryTerm();
        if (length > i) {
            ret.setName(record[i]);
        }
        if (StringUtils.isBlank((String)ret.getName())) {
            if (!populateRelations) {
                failedTermMsgList.add("The TermName is blank for provided record: " + Arrays.toString(record));
            }
        } else {
            ret.setAnchor(new AtlasGlossaryHeader(glossaryGuid));
            ret.setShortDescription(length > ++i ? record[i] : null);
            ret.setLongDescription(length > ++i ? record[i] : null);
            ret.setExamples(length > ++i ? this.getListValue(record[i]) : null);
            ret.setAbbreviation(length > ++i ? record[i] : null);
            ret.setUsage(length > ++i ? record[i] : null);
            ret.setAdditionalAttributes(length > ++i ? this.getMapValue(record[i], failedTermMsgList, populateRelations) : null);
            if (populateRelations) {
                ret.setTranslationTerms(length > ++i ? this.getAtlasRelatedTermHeaderSet(record[i], ret.getName(), record[0], failedTermMsgList) : null);
                ret.setValidValuesFor(length > ++i ? this.getAtlasRelatedTermHeaderSet(record[i], ret.getName(), record[0], failedTermMsgList) : null);
                ret.setSynonyms(length > ++i ? this.getAtlasRelatedTermHeaderSet(record[i], ret.getName(), record[0], failedTermMsgList) : null);
                ret.setReplacedBy(length > ++i ? this.getAtlasRelatedTermHeaderSet(record[i], ret.getName(), record[0], failedTermMsgList) : null);
                ret.setValidValues(length > ++i ? this.getAtlasRelatedTermHeaderSet(record[i], ret.getName(), record[0], failedTermMsgList) : null);
                ret.setReplacementTerms(length > ++i ? this.getAtlasRelatedTermHeaderSet(record[i], ret.getName(), record[0], failedTermMsgList) : null);
                ret.setSeeAlso(length > ++i ? this.getAtlasRelatedTermHeaderSet(record[i], ret.getName(), record[0], failedTermMsgList) : null);
                ret.setTranslatedTerms(length > ++i ? this.getAtlasRelatedTermHeaderSet(record[i], ret.getName(), record[0], failedTermMsgList) : null);
                ret.setIsA(length > ++i ? this.getAtlasRelatedTermHeaderSet(record[i], ret.getName(), record[0], failedTermMsgList) : null);
                ret.setAntonyms(length > ++i ? this.getAtlasRelatedTermHeaderSet(record[i], ret.getName(), record[0], failedTermMsgList) : null);
                ret.setClassifies(length > ++i ? this.getAtlasRelatedTermHeaderSet(record[i], ret.getName(), record[0], failedTermMsgList) : null);
                ret.setPreferredToTerms(length > ++i ? this.getAtlasRelatedTermHeaderSet(record[i], ret.getName(), record[0], failedTermMsgList) : null);
                ret.setPreferredTerms(length > ++i ? this.getAtlasRelatedTermHeaderSet(record[i], ret.getName(), record[0], failedTermMsgList) : null);
            }
        }
        return ret;
    }

    private String getGlossaryTermQualifiedName(String glossaryTermName, String glossaryName) throws AtlasBaseException {
        return glossaryTermName + "@" + glossaryName;
    }

    private String getGlossaryGUIDFromGraphDB(String glossaryName) {
        AtlasVertex vertex = AtlasGraphUtilsV2.findByTypeAndUniquePropertyName("AtlasGlossary", "AtlasGlossary.qualifiedName", glossaryName);
        return vertex != null ? AtlasGraphUtilsV2.getIdFromVertex(vertex) : null;
    }

    private String createGlossary(String glossaryName, List<String> failedTermMsgs) throws AtlasBaseException {
        String ret = null;
        if (GlossaryService.isNameInvalid(glossaryName)) {
            LOG.error("The provided Glossary Name is invalid : " + glossaryName);
            failedTermMsgs.add("The provided Glossary Name {" + glossaryName + "} is invalid : " + AtlasErrorCode.INVALID_DISPLAY_NAME.getFormattedErrorMessage(new String[0]));
        } else {
            AtlasGlossary glossary = new AtlasGlossary();
            glossary.setQualifiedName(glossaryName);
            glossary.setName(glossaryName);
            glossary = this.dataAccess.save(glossary);
            ret = glossary.getGuid();
        }
        return ret;
    }

    private void cacheRelatedTermQNameGuid(String currTermQualifiedName, String relatedTermQualifiedName, String termGuid) {
        if (!glossaryTermQNameGuidCache.get().containsKey(relatedTermQualifiedName) && glossaryTermOrderCache.get().containsKey(currTermQualifiedName) && glossaryTermOrderCache.get().containsKey(relatedTermQualifiedName) && glossaryTermOrderCache.get().get(currTermQualifiedName) < glossaryTermOrderCache.get().get(relatedTermQualifiedName)) {
            glossaryTermQNameGuidCache.get().put(relatedTermQualifiedName, termGuid);
        }
    }

    private AtlasGlossaryTerm getGlossaryTem(String termGuid) throws AtlasBaseException {
        AtlasGlossaryTerm ret = null;
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryTemUtils.getGlossaryTem({})", (Object)termGuid);
        }
        if (!Objects.isNull(termGuid)) {
            AtlasGlossaryTerm atlasGlossary = GlossaryTermUtils.getAtlasGlossaryTermSkeleton(termGuid);
            ret = this.dataAccess.load(atlasGlossary);
            if (DEBUG_ENABLED) {
                LOG.debug("<== GlossaryTemUtils.getGlossaryTem() : {}", (Object)ret);
            }
        }
        return ret;
    }

    private void copyRelations(AtlasGlossaryTerm toGlossaryTerm, AtlasGlossaryTerm fromGlossaryTerm) {
        if (CollectionUtils.isNotEmpty((Collection)fromGlossaryTerm.getSeeAlso())) {
            if (CollectionUtils.isNotEmpty((Collection)toGlossaryTerm.getSeeAlso())) {
                toGlossaryTerm.getSeeAlso().addAll(fromGlossaryTerm.getSeeAlso());
            } else {
                toGlossaryTerm.setSeeAlso(fromGlossaryTerm.getSeeAlso());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)fromGlossaryTerm.getSynonyms())) {
            if (CollectionUtils.isNotEmpty((Collection)toGlossaryTerm.getSynonyms())) {
                toGlossaryTerm.getSynonyms().addAll(fromGlossaryTerm.getSynonyms());
            } else {
                toGlossaryTerm.setSynonyms(fromGlossaryTerm.getSynonyms());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)fromGlossaryTerm.getAntonyms())) {
            if (CollectionUtils.isNotEmpty((Collection)toGlossaryTerm.getAntonyms())) {
                toGlossaryTerm.getAntonyms().addAll(fromGlossaryTerm.getAntonyms());
            } else {
                toGlossaryTerm.setAntonyms(fromGlossaryTerm.getAntonyms());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)fromGlossaryTerm.getPreferredTerms())) {
            if (CollectionUtils.isNotEmpty((Collection)toGlossaryTerm.getPreferredTerms())) {
                toGlossaryTerm.getPreferredTerms().addAll(fromGlossaryTerm.getPreferredTerms());
            } else {
                toGlossaryTerm.setPreferredTerms(fromGlossaryTerm.getPreferredTerms());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)fromGlossaryTerm.getPreferredToTerms())) {
            if (CollectionUtils.isNotEmpty((Collection)toGlossaryTerm.getPreferredToTerms())) {
                toGlossaryTerm.getPreferredToTerms().addAll(fromGlossaryTerm.getPreferredToTerms());
            } else {
                toGlossaryTerm.setPreferredToTerms(fromGlossaryTerm.getPreferredToTerms());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)fromGlossaryTerm.getReplacementTerms())) {
            if (CollectionUtils.isNotEmpty((Collection)toGlossaryTerm.getReplacementTerms())) {
                toGlossaryTerm.getReplacementTerms().addAll(fromGlossaryTerm.getReplacementTerms());
            } else {
                toGlossaryTerm.setReplacementTerms(fromGlossaryTerm.getReplacementTerms());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)fromGlossaryTerm.getReplacedBy())) {
            if (CollectionUtils.isNotEmpty((Collection)toGlossaryTerm.getReplacedBy())) {
                toGlossaryTerm.getReplacedBy().addAll(fromGlossaryTerm.getReplacedBy());
            } else {
                toGlossaryTerm.setReplacedBy(fromGlossaryTerm.getReplacedBy());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)fromGlossaryTerm.getTranslationTerms())) {
            if (CollectionUtils.isNotEmpty((Collection)toGlossaryTerm.getTranslationTerms())) {
                toGlossaryTerm.getTranslationTerms().addAll(fromGlossaryTerm.getTranslationTerms());
            } else {
                toGlossaryTerm.setTranslationTerms(fromGlossaryTerm.getTranslationTerms());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)fromGlossaryTerm.getTranslatedTerms())) {
            if (CollectionUtils.isNotEmpty((Collection)toGlossaryTerm.getTranslatedTerms())) {
                toGlossaryTerm.getTranslatedTerms().addAll(fromGlossaryTerm.getTranslatedTerms());
            } else {
                toGlossaryTerm.setTranslatedTerms(fromGlossaryTerm.getTranslatedTerms());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)fromGlossaryTerm.getIsA())) {
            if (CollectionUtils.isNotEmpty((Collection)toGlossaryTerm.getIsA())) {
                toGlossaryTerm.getIsA().addAll(fromGlossaryTerm.getIsA());
            } else {
                toGlossaryTerm.setIsA(fromGlossaryTerm.getIsA());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)fromGlossaryTerm.getClassifies())) {
            if (CollectionUtils.isNotEmpty((Collection)toGlossaryTerm.getClassifies())) {
                toGlossaryTerm.getClassifies().addAll(fromGlossaryTerm.getClassifies());
            } else {
                toGlossaryTerm.setClassifies(fromGlossaryTerm.getClassifies());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)fromGlossaryTerm.getValidValues())) {
            if (CollectionUtils.isNotEmpty((Collection)toGlossaryTerm.getValidValues())) {
                toGlossaryTerm.getValidValues().addAll(fromGlossaryTerm.getValidValues());
            } else {
                toGlossaryTerm.setValidValues(fromGlossaryTerm.getValidValues());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)fromGlossaryTerm.getValidValuesFor())) {
            if (CollectionUtils.isNotEmpty((Collection)toGlossaryTerm.getValidValuesFor())) {
                toGlossaryTerm.getValidValuesFor().addAll(fromGlossaryTerm.getValidValuesFor());
            } else {
                toGlossaryTerm.setValidValuesFor(fromGlossaryTerm.getValidValuesFor());
            }
        }
    }
}

