/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query;

import java.util.Objects;
import org.apache.atlas.query.AtlasDSL;
import org.apache.atlas.query.GremlinClauseList;
import org.apache.atlas.query.SelectClauseComposer;
import org.apache.atlas.repository.graphdb.AtlasGraphTraversal;

public class GremlinQuery {
    private final String queryStr;
    private final AtlasDSL.QueryMetadata queryMetadata;
    private final GremlinClauseList clauses;
    private final SelectClauseComposer selectComposer;
    private AtlasGraphTraversal traversal;

    public GremlinQuery(String gremlinQuery, AtlasDSL.QueryMetadata queryMetadata, GremlinClauseList clauses, SelectClauseComposer selectComposer) {
        this.queryStr = gremlinQuery;
        this.queryMetadata = queryMetadata;
        this.clauses = clauses;
        this.selectComposer = selectComposer;
    }

    public String queryStr() {
        return this.queryStr;
    }

    public GremlinClauseList getClauses() {
        return this.clauses;
    }

    public SelectClauseComposer getSelectComposer() {
        return this.selectComposer;
    }

    public boolean hasValidSelectClause() {
        return Objects.nonNull(this.selectComposer) && !this.selectComposer.getIsSelectNoop();
    }

    public AtlasDSL.QueryMetadata getQueryMetadata() {
        return this.queryMetadata;
    }

    public void setResult(AtlasGraphTraversal traversal) {
        this.traversal = traversal;
    }

    public AtlasGraphTraversal getTraversal() {
        return this.traversal;
    }

    public boolean hasSelectList() {
        return this.queryMetadata.hasSelect();
    }
}

