/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query;

import com.google.common.annotations.VisibleForTesting;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.glossary.GlossaryUtils;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.query.AtlasDSL;
import org.apache.atlas.query.GremlinClause;
import org.apache.atlas.query.GremlinClauseList;
import org.apache.atlas.query.IdentifierHelper;
import org.apache.atlas.query.Lookup;
import org.apache.atlas.query.RegistryBasedLookup;
import org.apache.atlas.query.SelectClauseComposer;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class GremlinQueryComposer {
    private static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String ISO8601_DATE_FORMAT = "yyyy-MM-dd";
    private static final String REGEX_ALPHA_NUMERIC_PATTERN = "[a-zA-Z0-9]+";
    private static final String EMPTY_STRING = "";
    private static final int DEFAULT_QUERY_RESULT_LIMIT = 25;
    private static final int DEFAULT_QUERY_RESULT_OFFSET = 0;
    private static final ThreadLocal<DateFormat[]> DSL_DATE_FORMAT = ThreadLocal.withInitial(() -> {
        String[] formats = new String[]{ISO8601_FORMAT, ISO8601_DATE_FORMAT};
        DateFormat[] dfs = new DateFormat[formats.length];
        for (int i = 0; i < formats.length; ++i) {
            dfs[i] = new SimpleDateFormat(formats[i]);
            dfs[i].setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return dfs;
    });
    private final GremlinClauseList queryClauses = new GremlinClauseList();
    private final Set<String> attributesProcessed = new HashSet<String>();
    private final Lookup lookup;
    private final AtlasDSL.QueryMetadata queryMetadata;
    private final int providedLimit;
    private final int providedOffset;
    private final Context context;
    private final GremlinQueryComposer parent;
    private boolean hasTrait = false;

    public GremlinQueryComposer(Lookup registryLookup, Context context, AtlasDSL.QueryMetadata qmd, int limit, int offset, GremlinQueryComposer parent) {
        this.lookup = registryLookup;
        this.context = context;
        this.queryMetadata = qmd;
        this.providedLimit = limit;
        this.providedOffset = offset;
        this.parent = parent;
        this.init();
    }

    public GremlinQueryComposer(Lookup registryLookup, AtlasDSL.QueryMetadata qmd, int limit, int offset) {
        this(registryLookup, new Context(registryLookup), qmd, limit, offset, null);
    }

    public GremlinQueryComposer(AtlasTypeRegistry typeRegistry, AtlasDSL.QueryMetadata qmd, int limit, int offset) {
        this(new RegistryBasedLookup(typeRegistry), qmd, limit, offset);
    }

    @VisibleForTesting
    GremlinQueryComposer(Lookup lookup, Context context, AtlasDSL.QueryMetadata qmd) {
        this(lookup, context, qmd, 25, 0, null);
    }

    public void addFrom(String typeName) {
        IdentifierHelper.Info typeInfo = this.createInfo(typeName);
        if (this.context.shouldRegister(typeInfo.get())) {
            this.context.registerActive(typeInfo.get());
            IdentifierHelper.Info ia = this.createInfo(typeInfo.get());
            if (ia.isTrait()) {
                String traitName = ia.get();
                if (traitName.equals("_CLASSIFIED")) {
                    this.addTrait(GremlinClause.ANY_TRAIT, ia);
                } else if (traitName.equals("_NOT_CLASSIFIED")) {
                    this.addTrait(GremlinClause.NO_TRAIT, ia);
                } else {
                    this.addTrait(GremlinClause.TRAIT, ia);
                }
            } else if (ia.hasSubtypes()) {
                this.add(GremlinClause.HAS_TYPE_WITHIN, ia.getSubTypes());
            } else {
                this.add(GremlinClause.HAS_TYPE, ia);
            }
        } else {
            IdentifierHelper.Info ia = this.createInfo(typeInfo.get());
            this.introduceType(ia);
        }
    }

    public void addFromProperty(String typeName, String attribute) {
        if (!this.isNestedQuery()) {
            this.addFrom(typeName);
        }
        this.add(GremlinClause.HAS_PROPERTY, this.createInfo(attribute));
    }

    public void addIsA(String typeName, String traitName) {
        if (!this.isNestedQuery()) {
            this.addFrom(typeName);
        }
        IdentifierHelper.Info traitInfo = this.createInfo(traitName);
        if (StringUtils.equals((String)traitName, (String)"_CLASSIFIED")) {
            this.addTrait(GremlinClause.ANY_TRAIT, traitInfo);
        } else if (StringUtils.equals((String)traitName, (String)"_NOT_CLASSIFIED")) {
            this.addTrait(GremlinClause.NO_TRAIT, traitInfo);
        } else {
            this.addTrait(GremlinClause.TRAIT, traitInfo);
        }
    }

    public void addHasTerm(String typeName, String termName) {
        String attributeToSearch;
        String qualifiedAttributeSeperator = String.valueOf(GlossaryUtils.invalidNameChars[0]);
        String[] terms = termName.split(qualifiedAttributeSeperator);
        if (terms.length > 1) {
            attributeToSearch = "qualifiedName";
        } else {
            termName = terms[0];
            attributeToSearch = "name";
        }
        this.add(GremlinClause.TERM, attributeToSearch, IdentifierHelper.removeQuotes(termName));
    }

    public void addWhere(String lhs, String operator, String rhs) {
        String currentType = this.context.getActiveTypeName();
        if (currentType != null && this.lookup.isTraitType(currentType)) {
            this.context.setActiveTypeToUnknown();
        }
        IdentifierHelper.Info org = null;
        IdentifierHelper.Info lhsI = this.createInfo(lhs);
        boolean rhsIsNotDateOrNumOrBool = false;
        if (!lhsI.isPrimitive()) {
            this.introduceType(lhsI);
            org = lhsI;
            lhsI = this.createInfo(lhs);
            lhsI.setTypeName(org.getTypeName());
            if (org.isTrait()) {
                this.setHasTrait();
            }
        }
        if (!this.context.validator.isValidQualifiedName(lhsI.getQualifiedName(), lhsI.getRaw())) {
            return;
        }
        if (lhsI.isDate()) {
            rhs = this.parseDate(rhs);
        } else if (lhsI.isNumeric()) {
            if (!StringUtils.equals((String)lhsI.getAttributeName(), (String)Constants.IS_INCOMPLETE_PROPERTY_KEY)) {
                rhs = this.parseNumber(rhs, this.context);
            }
        } else if (!IdentifierHelper.isTrueOrFalse(rhs)) {
            rhsIsNotDateOrNumOrBool = true;
        }
        rhs = this.addQuotesIfNecessary(lhsI, rhs);
        SearchParameters.Operator op = SearchParameters.Operator.fromString((String)operator);
        if (StringUtils.equals((String)lhsI.getAttributeName(), (String)Constants.IS_INCOMPLETE_PROPERTY_KEY)) {
            this.addForIsIncompleteClause(lhsI, op, rhs);
        } else if (op == SearchParameters.Operator.LIKE) {
            AtlasStructType.AtlasAttribute attribute = this.context.getActiveEntityType().getAttribute(lhsI.getAttributeName());
            AtlasStructDef.AtlasAttributeDef.IndexType indexType = attribute.getAttributeDef().getIndexType();
            if (indexType == AtlasStructDef.AtlasAttributeDef.IndexType.STRING || !this.containsNumberAndLettersOnly(rhs)) {
                String escapeRhs = IdentifierHelper.escapeCharacters(IdentifierHelper.getFixedRegEx(rhs));
                this.add(GremlinClause.STRING_CONTAINS, this.getPropertyForClause(lhsI), escapeRhs);
            } else {
                this.add(GremlinClause.TEXT_CONTAINS, this.getPropertyForClause(lhsI), IdentifierHelper.getFixedRegEx(rhs));
            }
        } else if (op == SearchParameters.Operator.IN) {
            this.add(GremlinClause.HAS_OPERATOR, this.getPropertyForClause(lhsI), "within", rhs);
        } else if (op == SearchParameters.Operator.NEQ && rhsIsNotDateOrNumOrBool) {
            String propertyName = this.getPropertyForClause(lhsI);
            Object normalizedRhs = this.getNormalizedAttrVal(lhsI, IdentifierHelper.removeQuotes(rhs));
            this.add(GremlinClause.HAS_NOT_OPERATOR, propertyName, normalizedRhs.toString(), propertyName);
        } else {
            Object normalizedRhs = this.getNormalizedAttrVal(lhsI, IdentifierHelper.removeQuotes(rhs));
            this.addWithNormalizedValue(GremlinClause.HAS_OPERATOR, this.getPropertyForClause(lhsI), op.getSymbols()[1], normalizedRhs, rhs);
        }
        this.attributesProcessed.add(lhsI.getQualifiedName());
        if (org != null && org.isReferredType()) {
            this.add(GremlinClause.DEDUP, new String[0]);
            if (org.getEdgeDirection() != null) {
                GremlinClause gremlinClauseForEdgeLabel = org.getEdgeDirection().equals((Object)AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.IN) ? GremlinClause.OUT : GremlinClause.IN;
                this.add(gremlinClauseForEdgeLabel, org.getEdgeLabel());
            } else {
                this.add(GremlinClause.OUT, org.getEdgeLabel());
            }
            this.context.registerActive(currentType);
        }
    }

    private void setHasTrait() {
        this.hasTrait = true;
    }

    private void addForIsIncompleteClause(IdentifierHelper.Info lhsI, SearchParameters.Operator op, String rhs) {
        GremlinClause clause = GremlinClause.HAS_OPERATOR;
        rhs = rhs.replace("'", EMPTY_STRING).replace("\"", EMPTY_STRING);
        switch (op) {
            case EQ: {
                if (IdentifierHelper.isCompleteValue(rhs)) {
                    clause = GremlinClause.HAS_NOT_PROPERTY;
                    break;
                }
                if (!IdentifierHelper.isInCompleteValue(rhs)) break;
                rhs = Constants.INCOMPLETE_ENTITY_VALUE.toString();
                break;
            }
            case NEQ: {
                if (IdentifierHelper.isCompleteValue(rhs)) {
                    op = SearchParameters.Operator.EQ;
                    rhs = Constants.INCOMPLETE_ENTITY_VALUE.toString();
                    break;
                }
                if (!IdentifierHelper.isInCompleteValue(rhs)) break;
                clause = GremlinClause.HAS_NOT_PROPERTY;
            }
        }
        Object normalizedRhs = this.getNormalizedAttrVal(lhsI, IdentifierHelper.removeQuotes(rhs));
        this.addWithNormalizedValue(clause, this.getPropertyForClause(lhsI), op.getSymbols()[1], normalizedRhs, rhs);
    }

    private Object getNormalizedAttrVal(IdentifierHelper.Info attrInfo, String attrVal) {
        String attrName;
        AtlasType attributeType;
        Object ret = attrVal;
        AtlasEntityType entityType = this.context.getActiveEntityType();
        if (entityType != null && StringUtils.isNotEmpty((String)attrVal) && (attributeType = entityType.getAttributeType(attrName = attrInfo.getAttributeName())) != null) {
            Object normalizedValue = attributeType.getNormalizedValue((Object)attrVal);
            ret = normalizedValue != null && attributeType instanceof AtlasBuiltInTypes.AtlasDateType ? Long.valueOf(((Date)normalizedValue).getTime()) : normalizedValue;
        }
        return ret;
    }

    private boolean containsNumberAndLettersOnly(String rhs) {
        return Pattern.matches(REGEX_ALPHA_NUMERIC_PATTERN, IdentifierHelper.removeWildcards(rhs));
    }

    private String parseNumber(String rhs, Context context) {
        return rhs.replace("'", EMPTY_STRING).replace("\"", EMPTY_STRING) + context.getNumericTypeFormatter();
    }

    public void addAndClauses(List<GremlinQueryComposer> queryComposers) {
        List<String> clauses = this.addToSubClause(queryComposers);
        this.add(GremlinClause.AND, String.join((CharSequence)",", clauses));
    }

    public void addOrClauses(List<GremlinQueryComposer> queryComposers) {
        List<String> clauses = this.addToSubClause(queryComposers);
        this.add(GremlinClause.OR, String.join((CharSequence)",", clauses));
    }

    public Set<String> getAttributesProcessed() {
        return this.attributesProcessed;
    }

    public void addProcessedAttributes(Set<String> attributesProcessed) {
        this.attributesProcessed.addAll(attributesProcessed);
    }

    public void addSelect(SelectClauseComposer selectClauseComposer) {
        this.process(selectClauseComposer);
        if (!this.queryMetadata.hasOrderBy() || !this.queryMetadata.hasGroupBy()) {
            this.addSelectTransformation(selectClauseComposer, null, false);
        }
        this.context.setSelectClauseComposer(selectClauseComposer);
    }

    public GremlinQueryComposer createNestedProcessor() {
        return new GremlinQueryComposer(this.lookup, this.context, this.queryMetadata, this.providedLimit, this.providedOffset, this);
    }

    public GremlinQueryComposer newInstance() {
        return new GremlinQueryComposer(this.lookup, new Context(this.lookup), this.queryMetadata, this.providedLimit, this.providedOffset, null);
    }

    public void addFromAlias(String typeName, String alias) {
        this.addFrom(typeName);
        this.addAsClause(alias);
        this.context.registerAlias(alias);
    }

    public void addAsClause(String alias) {
        this.add(GremlinClause.AS, alias);
    }

    public void addGroupBy(String item) {
        this.addGroupByClause(item);
    }

    public void addLimit(String limit, String offset) {
        SelectClauseComposer scc = this.context.getSelectClauseComposer();
        if (scc == null) {
            this.addLimitHelper(limit, offset);
        } else if (!scc.hasAggregators()) {
            this.addLimitHelper(limit, offset);
        }
    }

    public void addDefaultLimit() {
        this.addLimit(Integer.toString(this.providedLimit), Integer.toString(this.providedOffset));
    }

    public String get() {
        this.close();
        boolean mustTransform = !this.isNestedQuery() && this.queryMetadata.needTransformation();
        CharSequence[] items = this.getFormattedClauses(mustTransform);
        String s = mustTransform ? this.getTransformedClauses((String[])items) : String.join((CharSequence)".", items);
        return s;
    }

    public List<String> getErrorList() {
        return this.context.getErrorList();
    }

    public void addOrderBy(String name, boolean isDesc) {
        IdentifierHelper.Info ia = this.createInfo(name);
        if (this.queryMetadata.hasSelect() && this.queryMetadata.hasGroupBy()) {
            this.addSelectTransformation(this.context.selectClauseComposer, this.getPropertyForClause(ia), isDesc);
        } else if (this.queryMetadata.hasGroupBy()) {
            this.addOrderByClause(ia, isDesc);
            this.moveToLast(GremlinClause.GROUP_BY);
        } else {
            this.addOrderByClause(ia, isDesc);
        }
    }

    public boolean hasFromClause() {
        return this.queryClauses.contains(GremlinClause.HAS_TYPE) != -1 || this.queryClauses.contains(GremlinClause.HAS_TYPE_WITHIN) != -1;
    }

    private void addWithNormalizedValue(GremlinClause clause, String propertyForClause, String symbol, Object normalizedRhs, String strValue) {
        this.queryClauses.add(new GremlinClauseValue(clause, propertyForClause, symbol, normalizedRhs, strValue));
    }

    private long getDateFormat(String s) {
        for (DateFormat dateFormat : DSL_DATE_FORMAT.get()) {
            try {
                return dateFormat.parse(s).getTime();
            }
            catch (ParseException parseException) {
            }
        }
        this.context.validator.check(false, AtlasErrorCode.INVALID_DSL_INVALID_DATE, s);
        return -1L;
    }

    private List<String> addToSubClause(List<GremlinQueryComposer> clauses) {
        for (GremlinQueryComposer entry : clauses) {
            this.addSubClauses(this.queryClauses.size(), entry.getQueryClauses());
        }
        return clauses.stream().map(x -> x.get()).collect(Collectors.toList());
    }

    private String getPropertyForClause(IdentifierHelper.Info ia) {
        String vertexPropertyName = this.lookup.getVertexPropertyName(ia.getTypeName(), ia.getAttributeName());
        if (StringUtils.isNotEmpty((String)vertexPropertyName)) {
            return vertexPropertyName;
        }
        if (StringUtils.isNotEmpty((String)ia.getQualifiedName())) {
            return ia.getQualifiedName();
        }
        return ia.getRaw();
    }

    private void process(SelectClauseComposer scc) {
        if (scc.getItems() == null) {
            return;
        }
        for (int i = 0; i < scc.getItems().length; ++i) {
            IdentifierHelper.Info ia = this.createInfo(scc.getItem(i));
            if (StringUtils.isEmpty((String)ia.getQualifiedName())) {
                this.context.getErrorList().add("Unable to find qualified name for " + ia.getAttributeName());
                continue;
            }
            if (scc.isAggregatorWithArgument(i) && !ia.isPrimitive()) {
                this.context.check(false, AtlasErrorCode.INVALID_DSL_SELECT_INVALID_AGG, ia.getQualifiedName());
                return;
            }
            if (!scc.getItem(i).equals(scc.getLabel(i))) {
                this.context.addAlias(scc.getLabel(i), ia.getQualifiedName());
            }
            if (scc.updateAsApplicable(i, this.getPropertyForClause(ia), ia.getQualifiedName())) continue;
            scc.setIsSelectNoop(this.hasNoopCondition(ia));
            if (scc.getIsSelectNoop()) {
                return;
            }
            if (this.introduceType(ia)) {
                scc.incrementTypesIntroduced();
                scc.setIsSelectNoop(!ia.hasParts());
                if (!ia.hasParts()) continue;
                scc.assign(i, this.getPropertyForClause(this.createInfo(ia.get())), GremlinClause.INLINE_GET_PROPERTY);
                continue;
            }
            scc.assign(i, this.getPropertyForClause(ia), GremlinClause.INLINE_GET_PROPERTY);
            scc.setIsPrimitiveAttr(i);
        }
        this.context.validator.check(!scc.hasMultipleReferredTypes(), AtlasErrorCode.INVALID_DSL_SELECT_REFERRED_ATTR, Integer.toString(scc.getIntroducedTypesCount()));
        this.context.validator.check(!scc.hasMixedAttributes(), AtlasErrorCode.INVALID_DSL_SELECT_ATTR_MIXING, new String[0]);
    }

    private boolean hasNoopCondition(IdentifierHelper.Info ia) {
        return !ia.isPrimitive() && !ia.isAttribute() && this.context.hasAlias(ia.getRaw());
    }

    private void addLimitHelper(String limit, String offset) {
        if (offset.equalsIgnoreCase("0")) {
            this.add(GremlinClause.LIMIT, limit, limit);
        } else {
            this.addRangeClause(offset, limit);
        }
    }

    private String getTransformedClauses(String[] items) {
        String body = String.join((CharSequence)".", Stream.of(items).filter(Objects::nonNull).collect(Collectors.toList()));
        String inlineFn = this.queryClauses.getValue(this.queryClauses.size() - 1);
        String funCall = String.format(inlineFn, body);
        String ret = this.isNestedQuery() ? String.join((CharSequence)".", this.queryClauses.getValue(0), funCall) : this.queryClauses.getValue(0) + funCall;
        return ret;
    }

    private String[] getFormattedClauses(boolean needTransformation) {
        String[] items = new String[this.queryClauses.size()];
        int startIdx = needTransformation ? 1 : 0;
        int endIdx = needTransformation ? this.queryClauses.size() - 1 : this.queryClauses.size();
        for (int i = startIdx; i < endIdx; ++i) {
            items[i] = this.queryClauses.getValue(i);
        }
        return items;
    }

    private void addSelectTransformation(SelectClauseComposer selectClauseComposer, String orderByQualifiedAttrName, boolean isDesc) {
        GremlinClause gremlinClause;
        if (selectClauseComposer.getIsSelectNoop()) {
            gremlinClause = GremlinClause.SELECT_NOOP_FN;
        } else if (this.queryMetadata.hasGroupBy()) {
            gremlinClause = selectClauseComposer.onlyAggregators() ? GremlinClause.SELECT_ONLY_AGG_GRP_FN : GremlinClause.SELECT_MULTI_ATTR_GRP_FN;
        } else {
            GremlinClause gremlinClause2 = gremlinClause = selectClauseComposer.onlyAggregators() ? GremlinClause.SELECT_ONLY_AGG_FN : GremlinClause.SELECT_FN;
        }
        if (StringUtils.isEmpty((String)orderByQualifiedAttrName)) {
            this.add(0, gremlinClause, selectClauseComposer.getLabelHeader(), selectClauseComposer.getAssignmentExprString(), selectClauseComposer.getItemsString(), EMPTY_STRING);
        } else {
            int itemIdx = selectClauseComposer.getAttrIndex(orderByQualifiedAttrName);
            GremlinClause sortClause = GremlinClause.INLINE_DEFAULT_TUPLE_SORT;
            if (itemIdx != -1) {
                sortClause = isDesc ? GremlinClause.INLINE_TUPLE_SORT_DESC : GremlinClause.INLINE_TUPLE_SORT_ASC;
            }
            String idxStr = String.valueOf(itemIdx);
            this.add(0, gremlinClause, selectClauseComposer.getLabelHeader(), selectClauseComposer.getAssignmentExprString(), selectClauseComposer.getItemsString(), sortClause.get(idxStr, idxStr));
        }
        this.add(GremlinClause.INLINE_TRANSFORM_CALL, new String[0]);
    }

    private String addQuotesIfNecessary(IdentifierHelper.Info rhsI, String rhs) {
        if (rhsI.isNumeric()) {
            return rhs;
        }
        if (IdentifierHelper.isTrueOrFalse(rhs)) {
            return rhs;
        }
        if (IdentifierHelper.isQuoted(rhs)) {
            return rhs;
        }
        return IdentifierHelper.getQuoted(rhs);
    }

    private String parseDate(String rhs) {
        String s = IdentifierHelper.isQuoted(rhs) ? IdentifierHelper.removeQuotes(rhs) : rhs;
        return String.format("'%d'", this.getDateFormat(s));
    }

    private void close() {
        if (this.isNestedQuery()) {
            return;
        }
        if (this.queryClauses.size() > 2) {
            this.add(GremlinClause.DEDUP, new String[0]);
            this.moveToLast(GremlinClause.RANGE);
            this.moveToLast(GremlinClause.LIMIT);
        }
        if (!this.queryMetadata.hasLimitOffset()) {
            this.addDefaultLimit();
        }
        if (this.queryClauses.isEmpty()) {
            this.queryClauses.clear();
            return;
        }
        this.moveToLast(GremlinClause.LIMIT);
        this.add(GremlinClause.TO_LIST, new String[0]);
        this.moveToLast(GremlinClause.INLINE_TRANSFORM_CALL);
    }

    private boolean isNestedQuery() {
        return this.parent != null;
    }

    private void addSubClauses(int index, GremlinClauseList queryClauses) {
        this.queryClauses.addSubClauses(index, queryClauses);
    }

    private void moveToLast(GremlinClause clause) {
        int index = this.queryClauses.contains(clause);
        if (-1 == index) {
            return;
        }
        GremlinClauseValue gcv = this.queryClauses.remove(index);
        this.queryClauses.add(gcv);
    }

    public void remove(GremlinClause clause) {
        int index = this.queryClauses.contains(clause);
        if (-1 == index) {
            return;
        }
        this.queryClauses.remove(index);
    }

    public GremlinClauseList getQueryClauses() {
        return this.queryClauses;
    }

    private void init() {
        if (!this.isNestedQuery()) {
            this.add(GremlinClause.G, new String[0]);
            this.add(GremlinClause.V, new String[0]);
        } else {
            this.add(GremlinClause.NESTED_START, new String[0]);
        }
    }

    private boolean introduceType(IdentifierHelper.Info ia) {
        if (ia.isReferredType()) {
            if (ia.getEdgeDirection() != null) {
                GremlinClause gremlinClauseForEdgeLabel = ia.getEdgeDirection().equals((Object)AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.OUT) ? GremlinClause.OUT : GremlinClause.IN;
                this.add(gremlinClauseForEdgeLabel, ia.getEdgeLabel());
            } else {
                this.add(GremlinClause.OUT, ia.getEdgeLabel());
            }
            this.context.registerActive(ia);
        }
        return ia.isReferredType();
    }

    private IdentifierHelper.Info createInfo(String actualTypeName) {
        return IdentifierHelper.create(this.context, this.lookup, actualTypeName);
    }

    private void addRangeClause(String startIndex, String endIndex) {
        if (this.queryMetadata.hasSelect()) {
            this.add(this.queryClauses.size() - 1, GremlinClause.RANGE, startIndex, startIndex, endIndex, startIndex, startIndex, endIndex);
        } else {
            this.add(GremlinClause.RANGE, startIndex, startIndex, endIndex, startIndex, startIndex, endIndex);
        }
    }

    private void addOrderByClause(IdentifierHelper.Info ia, boolean descr) {
        this.add(!descr ? GremlinClause.ORDER_BY : GremlinClause.ORDER_BY_DESC, ia);
    }

    private void addGroupByClause(String name) {
        IdentifierHelper.Info ia = this.createInfo(name);
        this.add(GremlinClause.GROUP_BY, ia);
    }

    private void add(GremlinClause clause, IdentifierHelper.Info idInfo) {
        if (this.context != null && !this.context.validator.isValid(this.context, clause, idInfo)) {
            return;
        }
        this.add(clause, this.getPropertyForClause(idInfo));
    }

    private void add(GremlinClause clause, String ... args) {
        this.queryClauses.add(new GremlinClauseValue(clause, args));
    }

    public void add(GremlinClauseValue gv) {
        this.queryClauses.add(gv);
    }

    public void addAll(GremlinClauseList gcList) {
        List<GremlinClauseValue> list;
        if (gcList != null && CollectionUtils.isNotEmpty(list = gcList.getList())) {
            this.queryClauses.clear();
            for (GremlinClauseValue value : list) {
                this.queryClauses.add(value);
            }
        }
    }

    private void add(int idx, GremlinClause clause, String ... args) {
        this.queryClauses.add(idx, new GremlinClauseValue(clause, args));
    }

    private void addTrait(GremlinClause clause, IdentifierHelper.Info idInfo) {
        if (this.context != null && !this.context.validator.isValid(this.context, clause, idInfo)) {
            return;
        }
        this.add(clause, idInfo.get(), idInfo.get());
    }

    public GremlinClauseList clauses() {
        return this.queryClauses;
    }

    public SelectClauseComposer getSelectComposer() {
        return this.context.selectClauseComposer;
    }

    public boolean hasAnyTraitAttributeClause() {
        return this.hasTrait;
    }

    private static class ClauseValidator {
        final List<String> errorList = new ArrayList<String>();

        public boolean isValid(Context ctx, GremlinClause clause, IdentifierHelper.Info ia) {
            switch (clause) {
                case TRAIT: 
                case ANY_TRAIT: 
                case NO_TRAIT: {
                    return this.check(ia.isTrait(), AtlasErrorCode.INVALID_DSL_UNKNOWN_CLASSIFICATION, ia.getRaw());
                }
                case HAS_TYPE: {
                    TypeCategory typeCategory = ctx.getActiveType().getTypeCategory();
                    return this.check(StringUtils.isNotEmpty((String)ia.getTypeName()) && typeCategory == TypeCategory.CLASSIFICATION || typeCategory == TypeCategory.ENTITY, AtlasErrorCode.INVALID_DSL_UNKNOWN_TYPE, ia.getRaw());
                }
                case HAS_PROPERTY: {
                    return this.check(ia.isPrimitive(), AtlasErrorCode.INVALID_DSL_HAS_PROPERTY, ia.getRaw());
                }
                case ORDER_BY: {
                    return this.check(ia.isPrimitive(), AtlasErrorCode.INVALID_DSL_ORDERBY, ia.getRaw());
                }
                case GROUP_BY: {
                    return this.check(ia.isPrimitive(), AtlasErrorCode.INVALID_DSL_SELECT_INVALID_AGG, ia.getRaw());
                }
            }
            return this.getErrorList().size() == 0;
        }

        public boolean check(Exception ex, AtlasErrorCode vm, String ... args) {
            String[] extraArgs = this.getExtraSlotArgs(args, ex.getMessage());
            return this.check(false, vm, extraArgs);
        }

        public boolean check(boolean condition, AtlasErrorCode vm, String ... args) {
            if (!condition) {
                this.addError(vm, args);
            }
            return condition;
        }

        public void addError(AtlasErrorCode ec, String ... messages) {
            this.errorList.add(ec.getFormattedErrorMessage(messages));
        }

        public List<String> getErrorList() {
            return this.errorList;
        }

        public boolean isValidQualifiedName(String qualifiedName, String raw) {
            return this.check(StringUtils.isNotEmpty((String)qualifiedName), AtlasErrorCode.INVALID_DSL_QUALIFIED_NAME, raw);
        }

        private String[] getExtraSlotArgs(String[] args, String s) {
            String[] argsPlus1 = new String[args.length + 1];
            System.arraycopy(args, 0, argsPlus1, 0, args.length);
            argsPlus1[args.length] = s;
            return argsPlus1;
        }
    }

    @VisibleForTesting
    static class Context {
        private static final AtlasStructType UNKNOWN_TYPE = new AtlasStructType(new AtlasStructDef());
        private final Lookup lookup;
        private final ClauseValidator validator;
        private final Map<String, String> aliasMap = new HashMap<String, String>();
        private AtlasType activeType;
        private SelectClauseComposer selectClauseComposer;
        private String numericTypeFormatter = "";

        public Context(Lookup lookup) {
            this.lookup = lookup;
            this.validator = new ClauseValidator();
        }

        public void registerActive(String typeName) {
            if (this.shouldRegister(typeName)) {
                try {
                    this.activeType = this.lookup.getType(typeName);
                    this.aliasMap.put(typeName, typeName);
                }
                catch (AtlasBaseException e) {
                    this.validator.check((Exception)((Object)e), AtlasErrorCode.INVALID_DSL_UNKNOWN_TYPE, typeName);
                    this.activeType = UNKNOWN_TYPE;
                }
            }
        }

        public void setActiveTypeToUnknown() {
            this.activeType = UNKNOWN_TYPE;
        }

        public void registerActive(IdentifierHelper.Info info) {
            if (this.validator.check(StringUtils.isNotEmpty((String)info.getTypeName()), AtlasErrorCode.INVALID_DSL_UNKNOWN_TYPE, info.getRaw())) {
                this.registerActive(info.getTypeName());
            } else {
                this.activeType = UNKNOWN_TYPE;
            }
        }

        public AtlasEntityType getActiveEntityType() {
            return this.activeType instanceof AtlasEntityType ? (AtlasEntityType)this.activeType : null;
        }

        public String getActiveTypeName() {
            return this.activeType.getTypeName();
        }

        public AtlasType getActiveType() {
            return this.activeType;
        }

        public boolean shouldRegister(String typeName) {
            return this.activeType == null || this.activeType != null && !StringUtils.equals((String)this.getActiveTypeName(), (String)typeName) && this.activeType != null && !this.lookup.hasAttribute(this, typeName);
        }

        public void registerAlias(String alias) {
            this.addAlias(alias, this.getActiveTypeName());
        }

        public boolean hasAlias(String alias) {
            return this.aliasMap.containsKey(alias);
        }

        public String getTypeNameFromAlias(String alias) {
            return this.aliasMap.get(alias);
        }

        public boolean isEmpty() {
            return this.activeType == null;
        }

        public SelectClauseComposer getSelectClauseComposer() {
            return this.selectClauseComposer;
        }

        public void setSelectClauseComposer(SelectClauseComposer selectClauseComposer) {
            this.selectClauseComposer = selectClauseComposer;
        }

        public void addAlias(String alias, String typeName) {
            if (this.aliasMap.containsKey(alias)) {
                this.check(false, AtlasErrorCode.INVALID_DSL_DUPLICATE_ALIAS, alias, this.getActiveTypeName());
                return;
            }
            this.aliasMap.put(alias, typeName);
        }

        public List<String> getErrorList() {
            return this.validator.getErrorList();
        }

        public boolean error(AtlasBaseException e, AtlasErrorCode ec, String t, String name) {
            return this.validator.check((Exception)((Object)e), ec, t, name);
        }

        public boolean check(boolean condition, AtlasErrorCode vm, String ... args) {
            return this.validator.check(condition, vm, args);
        }

        public void setNumericTypeFormatter(String formatter) {
            this.numericTypeFormatter = formatter;
        }

        public String getNumericTypeFormatter() {
            return this.numericTypeFormatter;
        }
    }

    public static class GremlinClauseValue {
        private final GremlinClause clause;
        private final String value;
        private final String[] values;
        private final Object rawValue;

        public GremlinClauseValue(GremlinClause clause, String property, String operator, Object rawValue, String str) {
            this.clause = clause;
            this.value = clause.get(property, operator, str);
            this.values = new String[]{property, operator, str};
            this.rawValue = rawValue;
        }

        public GremlinClauseValue(GremlinClause clause, String ... values) {
            this.clause = clause;
            this.value = clause.get(values);
            this.values = values;
            this.rawValue = null;
        }

        public GremlinClause getClause() {
            return this.clause;
        }

        public String getClauseWithValue() {
            return this.value;
        }

        public String[] getValues() {
            return this.values;
        }

        public Object getRawValue() {
            return this.rawValue;
        }

        public String toString() {
            return String.format("%s", new Object[]{this.clause});
        }
    }
}

