/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.atlas.query.GremlinClause;

public class SelectClauseComposer {
    private static final String COUNT_STR = "count";
    private static final String MIN_STR = "min";
    private static final String MAX_STR = "max";
    private static final String SUM_STR = "sum";
    private final String[] labels;
    private final String[] attributes;
    private final String[] items;
    private final int countIdx;
    private final int sumIdx;
    private final int minIdx;
    private final int maxIdx;
    private final int aggCount;
    private final Map<Integer, AggregatorFlag> aggregatorFlags = new HashMap<Integer, AggregatorFlag>();
    private final Set<Integer> isNumericAggregator = new HashSet<Integer>();
    private final Set<Integer> isPrimitiveAttr = new HashSet<Integer>();
    private final Map<String, String> itemAssignmentExprs = new LinkedHashMap<String, String>();
    private boolean isSelectNoop = false;
    private int introducedTypesCount = 0;

    public SelectClauseComposer(String[] labels, String[] attributes, String[] items, int countIdx, int sumIdx, int minIdx, int maxIdx) {
        this.labels = labels;
        this.attributes = Arrays.copyOf(attributes, attributes.length);
        this.items = Arrays.copyOf(items, items.length);
        this.countIdx = countIdx;
        this.sumIdx = sumIdx;
        this.minIdx = minIdx;
        this.maxIdx = maxIdx;
        int aggCount = 0;
        if (countIdx != -1) {
            this.aggregatorFlags.put(countIdx, AggregatorFlag.COUNT);
            ++aggCount;
        }
        if (sumIdx != -1) {
            this.aggregatorFlags.put(sumIdx, AggregatorFlag.SUM);
            ++aggCount;
        }
        if (maxIdx != -1) {
            this.aggregatorFlags.put(maxIdx, AggregatorFlag.MAX);
            ++aggCount;
        }
        if (minIdx != -1) {
            this.aggregatorFlags.put(minIdx, AggregatorFlag.MIN);
            ++aggCount;
        }
        this.aggCount = aggCount;
    }

    public static boolean isKeyword(String s) {
        return COUNT_STR.equals(s) || MIN_STR.equals(s) || MAX_STR.equals(s) || SUM_STR.equals(s);
    }

    public String[] getItems() {
        return this.items;
    }

    public boolean updateAsApplicable(int currentIndex, String propertyForClause, String qualifiedName) {
        boolean ret = false;
        if (currentIndex == this.getCountIdx()) {
            ret = this.assign(currentIndex, COUNT_STR, GremlinClause.INLINE_COUNT.get(), GremlinClause.INLINE_ASSIGNMENT);
            this.isNumericAggregator.add(currentIndex);
        } else if (currentIndex == this.getMinIdx()) {
            ret = this.assign(currentIndex, MIN_STR, propertyForClause, GremlinClause.INLINE_ASSIGNMENT, GremlinClause.INLINE_MIN);
            this.isNumericAggregator.add(currentIndex);
        } else if (currentIndex == this.getMaxIdx()) {
            ret = this.assign(currentIndex, MAX_STR, propertyForClause, GremlinClause.INLINE_ASSIGNMENT, GremlinClause.INLINE_MAX);
            this.isNumericAggregator.add(currentIndex);
        } else if (currentIndex == this.getSumIdx()) {
            ret = this.assign(currentIndex, SUM_STR, propertyForClause, GremlinClause.INLINE_ASSIGNMENT, GremlinClause.INLINE_SUM);
            this.isNumericAggregator.add(currentIndex);
        }
        this.attributes[currentIndex] = qualifiedName;
        return ret;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public boolean assign(int i, String qualifiedName, GremlinClause clause) {
        this.items[i] = clause.get(qualifiedName, qualifiedName);
        return true;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public boolean onlyAggregators() {
        return this.hasAggregators() && this.aggCount == this.items.length;
    }

    public boolean hasAggregators() {
        return this.aggCount > 0;
    }

    public String getLabelHeader() {
        return this.getJoinedQuotedStr(this.getLabels());
    }

    public String getItemsString() {
        return String.join((CharSequence)",", this.getItems());
    }

    public String getAssignmentExprString() {
        return !this.itemAssignmentExprs.isEmpty() ? String.join((CharSequence)" ", this.itemAssignmentExprs.values()) : "";
    }

    public String getItem(int i) {
        return this.items[i];
    }

    public String getAttribute(int i) {
        return this.attributes[i];
    }

    public String getLabel(int i) {
        return this.labels[i];
    }

    public int getAttrIndex(String attr) {
        int ret = -1;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (!this.attributes[i].equals(attr)) continue;
            ret = i;
            break;
        }
        return ret;
    }

    public int getCountIdx() {
        return this.countIdx;
    }

    public int getSumIdx() {
        return this.sumIdx;
    }

    public int getMaxIdx() {
        return this.maxIdx;
    }

    public int getMinIdx() {
        return this.minIdx;
    }

    public boolean isAggregatorWithArgument(int i) {
        return i == this.getMaxIdx() || i == this.getMinIdx() || i == this.getSumIdx();
    }

    public void incrementTypesIntroduced() {
        ++this.introducedTypesCount;
    }

    public int getIntroducedTypesCount() {
        return this.introducedTypesCount;
    }

    public boolean hasMultipleReferredTypes() {
        return this.getIntroducedTypesCount() > 1;
    }

    public boolean hasMixedAttributes() {
        return this.getIntroducedTypesCount() > 0 && this.getPrimitiveTypeCount() > 0;
    }

    private int getPrimitiveTypeCount() {
        return this.isPrimitiveAttr.size();
    }

    public boolean getIsSelectNoop() {
        return this.isSelectNoop;
    }

    public void setIsSelectNoop(boolean isSelectNoop) {
        this.isSelectNoop = isSelectNoop;
    }

    public boolean isSumIdx(int idx) {
        return this.aggregatorFlags.get(idx) == AggregatorFlag.SUM;
    }

    public boolean isMinIdx(int idx) {
        return this.aggregatorFlags.get(idx) == AggregatorFlag.MIN;
    }

    public boolean isMaxIdx(int idx) {
        return this.aggregatorFlags.get(idx) == AggregatorFlag.MAX;
    }

    public boolean isCountIdx(int idx) {
        return this.aggregatorFlags.get(idx) == AggregatorFlag.COUNT;
    }

    public boolean isNumericAggregator(int idx) {
        return this.isNumericAggregator.contains(idx);
    }

    public boolean isPrimitiveAttribute(int idx) {
        return this.isPrimitiveAttr.contains(idx);
    }

    public void setIsPrimitiveAttr(int i) {
        this.isPrimitiveAttr.add(i);
    }

    private boolean assign(String item, String assignExpr) {
        this.itemAssignmentExprs.put(item, assignExpr);
        return true;
    }

    private boolean assign(int i, String s, String p1, GremlinClause clause) {
        this.items[i] = s;
        return this.assign(this.items[i], clause.get(s, p1));
    }

    private boolean assign(int i, String s, String p1, GremlinClause inline, GremlinClause clause) {
        this.items[i] = s;
        return this.assign(this.items[i], inline.get(s, clause.get(p1, p1)));
    }

    private String getJoinedQuotedStr(String[] elements) {
        StringJoiner joiner = new StringJoiner(",");
        Arrays.stream(elements).map(x -> x.contains("'") ? "\"" + x + "\"" : "'" + x + "'").forEach(joiner::add);
        return joiner.toString();
    }

    public static enum AggregatorFlag {
        NONE,
        COUNT,
        MIN,
        MAX,
        SUM;

    }
}

