/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query.executors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.query.AtlasDSL;
import org.apache.atlas.query.GremlinQuery;
import org.apache.atlas.query.QueryParams;
import org.apache.atlas.query.executors.DSLQueryExecutor;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEngineBasedExecutor
implements DSLQueryExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptEngineBasedExecutor.class);
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasGraph graph;
    private final EntityGraphRetriever entityRetriever;

    public ScriptEngineBasedExecutor(AtlasTypeRegistry typeRegistry, AtlasGraph graph, EntityGraphRetriever entityRetriever) {
        this.typeRegistry = typeRegistry;
        this.graph = graph;
        this.entityRetriever = entityRetriever;
    }

    @Override
    public AtlasSearchResult execute(String dslQuery, int limit, int offset) throws AtlasBaseException {
        AtlasSearchResult ret = new AtlasSearchResult(dslQuery, AtlasSearchResult.AtlasQueryType.DSL);
        GremlinQuery gremlinQuery = this.toGremlinQuery(dslQuery, limit, offset);
        String queryStr = gremlinQuery.queryStr();
        Object result = this.graph.executeGremlinScript(queryStr, false);
        if (result instanceof List && CollectionUtils.isNotEmpty((Collection)((List)result))) {
            List queryResult = (List)result;
            Object firstElement = queryResult.get(0);
            if (firstElement instanceof AtlasVertex) {
                for (Object element : queryResult) {
                    if (element instanceof AtlasVertex) {
                        ret.addEntity(this.entityRetriever.toAtlasEntityHeaderWithClassifications((AtlasVertex)element));
                        continue;
                    }
                    LOG.warn("searchUsingDslQuery({}): expected an AtlasVertex; found unexpected entry in result {}", (Object)dslQuery, element);
                }
            } else if (gremlinQuery.hasSelectList()) {
                ret.setAttributes(this.toAttributesResult(queryResult, gremlinQuery));
            } else if (firstElement instanceof Map) {
                for (Object element : queryResult) {
                    if (!(element instanceof Map)) continue;
                    Map map = (Map)element;
                    for (Object key : map.keySet()) {
                        Object value = map.get(key);
                        if (!(value instanceof List) || !CollectionUtils.isNotEmpty((Collection)((List)value))) continue;
                        for (Object o : (List)value) {
                            Object entry = o;
                            if (!(entry instanceof AtlasVertex)) continue;
                            ret.addEntity(this.entityRetriever.toAtlasEntityHeader((AtlasVertex)entry));
                        }
                    }
                }
            } else {
                LOG.warn("searchUsingDslQuery({}/{}): found unexpected entry in result {}", new Object[]{dslQuery, dslQuery, gremlinQuery.queryStr()});
            }
        }
        return ret;
    }

    private GremlinQuery toGremlinQuery(String query, int limit, int offset) throws AtlasBaseException {
        QueryParams params = QueryParams.getNormalizedParams(limit, offset);
        GremlinQuery gremlinQuery = new AtlasDSL.Translator(query, this.typeRegistry, params.offset(), params.limit()).translate();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translated Gremlin Query: {}", (Object)gremlinQuery.queryStr());
        }
        return gremlinQuery;
    }

    private AtlasSearchResult.AttributeSearchResult toAttributesResult(List results, GremlinQuery query) {
        AtlasSearchResult.AttributeSearchResult ret = new AtlasSearchResult.AttributeSearchResult();
        List names = (List)results.get(0);
        List<List<Object>> values = this.extractValues(results.subList(1, results.size()));
        ret.setName(names);
        ret.setValues(values);
        return ret;
    }

    private List<List<Object>> extractValues(List results) {
        ArrayList<List<Object>> values = new ArrayList<List<Object>>();
        for (Object obj : results) {
            List list;
            if (obj instanceof Map) {
                Map map = (Map)obj;
                ArrayList list2 = new ArrayList();
                if (!MapUtils.isNotEmpty((Map)map)) continue;
                for (Object key : map.keySet()) {
                    Object vals = map.get(key);
                    if (!(vals instanceof List)) continue;
                    List l = (List)vals;
                    list2.addAll(l);
                }
                values.add(list2);
                continue;
            }
            if (!(obj instanceof List) || !CollectionUtils.isNotEmpty((Collection)(list = (List)obj))) continue;
            values.add(list);
        }
        return values;
    }
}

