/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.audit;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.listener.ChangedTypeDefs;
import org.apache.atlas.listener.TypeDefChangeListener;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.audit.AtlasAuditEntry;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.repository.audit.AtlasAuditService;
import org.apache.atlas.utils.AtlasJson;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=2)
public class TypeDefAuditListener
implements TypeDefChangeListener {
    AtlasAuditService auditService;

    @Inject
    TypeDefAuditListener(AtlasAuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    public void onChange(ChangedTypeDefs changedTypeDefs) throws AtlasBaseException {
        this.createAuditEntry(changedTypeDefs);
    }

    @Override
    public void onLoadCompletion() throws AtlasBaseException {
    }

    private void createAuditEntry(ChangedTypeDefs changedTypeDefs) throws AtlasBaseException {
        List<AtlasBaseTypeDef> createdTypes = changedTypeDefs.getCreatedTypeDefs();
        List<AtlasBaseTypeDef> updatedTypes = changedTypeDefs.getUpdatedTypeDefs();
        List<AtlasBaseTypeDef> deletedTypes = changedTypeDefs.getDeletedTypeDefs();
        updatedTypes = this.removeDuplicateEntries(createdTypes, updatedTypes);
        this.createAuditEntry(createdTypes, AtlasAuditEntry.AuditOperation.TYPE_DEF_CREATE);
        this.createAuditEntry(updatedTypes, AtlasAuditEntry.AuditOperation.TYPE_DEF_UPDATE);
        this.createAuditEntry(deletedTypes, AtlasAuditEntry.AuditOperation.TYPE_DEF_DELETE);
    }

    private List<AtlasBaseTypeDef> removeDuplicateEntries(List<AtlasBaseTypeDef> createdTypes, List<AtlasBaseTypeDef> updatedTypes) {
        if (CollectionUtils.isNotEmpty(createdTypes)) {
            List createdTypeNames = createdTypes.stream().map(obj -> obj.getName()).collect(Collectors.toList());
            updatedTypes.removeIf(obj -> createdTypeNames.contains(obj.getName()));
        }
        if (CollectionUtils.isNotEmpty(updatedTypes)) {
            Set baseTypeDefs = updatedTypes.stream().collect(Collectors.toCollection(() -> new TreeSet<AtlasBaseTypeDef>(Comparator.comparing(AtlasBaseTypeDef::getName))));
            updatedTypes = new ArrayList<AtlasBaseTypeDef>(baseTypeDefs);
        }
        return updatedTypes;
    }

    private void createAuditEntry(List<AtlasBaseTypeDef> baseTypeDefList, AtlasAuditEntry.AuditOperation auditOperation) throws AtlasBaseException {
        if (CollectionUtils.isEmpty(baseTypeDefList)) {
            return;
        }
        Map<TypeCategory, List<AtlasBaseTypeDef>> groupByCategoryMap = baseTypeDefList.stream().collect(Collectors.groupingBy(AtlasBaseTypeDef::getCategory));
        ArrayList<String> categories = new ArrayList<String>();
        for (TypeCategory category : groupByCategoryMap.keySet()) {
            categories.add(category.name());
        }
        String typeDefJson = AtlasJson.toJson(groupByCategoryMap);
        this.auditService.add(auditOperation, String.join((CharSequence)",", categories), typeDefJson, baseTypeDefList.size());
    }
}

