/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.converters;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.repository.converters.AtlasArrayFormatConverter;
import org.apache.atlas.repository.converters.AtlasClassificationFormatConverter;
import org.apache.atlas.repository.converters.AtlasEntityFormatConverter;
import org.apache.atlas.repository.converters.AtlasEnumFormatConverter;
import org.apache.atlas.repository.converters.AtlasFormatConverter;
import org.apache.atlas.repository.converters.AtlasMapFormatConverter;
import org.apache.atlas.repository.converters.AtlasObjectIdConverter;
import org.apache.atlas.repository.converters.AtlasPrimitiveFormatConverter;
import org.apache.atlas.repository.converters.AtlasStructFormatConverter;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.springframework.stereotype.Component;

@Singleton
@Component
public class AtlasFormatConverters {
    private final Map<TypeCategory, AtlasFormatConverter> registry = new HashMap<TypeCategory, AtlasFormatConverter>();

    @Inject
    public AtlasFormatConverters(AtlasTypeRegistry typeRegistry) {
        this.registerConverter(new AtlasPrimitiveFormatConverter(this, typeRegistry));
        this.registerConverter(new AtlasEnumFormatConverter(this, typeRegistry));
        this.registerConverter(new AtlasStructFormatConverter(this, typeRegistry));
        this.registerConverter(new AtlasClassificationFormatConverter(this, typeRegistry));
        this.registerConverter(new AtlasEntityFormatConverter(this, typeRegistry));
        this.registerConverter(new AtlasArrayFormatConverter(this, typeRegistry));
        this.registerConverter(new AtlasMapFormatConverter(this, typeRegistry));
        this.registerConverter(new AtlasObjectIdConverter(this, typeRegistry));
    }

    private void registerConverter(AtlasFormatConverter converter) {
        this.registry.put(converter.getTypeCategory(), converter);
        if (converter.getTypeCategory() == TypeCategory.ENTITY) {
            this.registry.put(TypeCategory.OBJECT_ID_TYPE, converter);
        }
    }

    public AtlasFormatConverter getConverter(TypeCategory typeCategory) throws AtlasBaseException {
        AtlasFormatConverter ret = this.registry.get(typeCategory);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.INTERNAL_ERROR, new String[]{"Could not find the converter for this type " + typeCategory});
        }
        return ret;
    }
}

