/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.converters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.repository.converters.AtlasAbstractFormatConverter;
import org.apache.atlas.repository.converters.AtlasFormatConverter;
import org.apache.atlas.repository.converters.AtlasFormatConverters;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasEntityUtil;
import org.apache.atlas.v1.model.instance.Struct;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasStructFormatConverter
extends AtlasAbstractFormatConverter {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasStructFormatConverter.class);
    public static final String ATTRIBUTES_PROPERTY_KEY = "attributes";
    public static final String RELATIONSHIP_ATTRIBUTES_PROPERTY_KEY = "relationshipAttributes";

    public AtlasStructFormatConverter(AtlasFormatConverters registry, AtlasTypeRegistry typeRegistry) {
        this(registry, typeRegistry, TypeCategory.STRUCT);
    }

    protected AtlasStructFormatConverter(AtlasFormatConverters registry, AtlasTypeRegistry typeRegistry, TypeCategory typeCategory) {
        super(registry, typeRegistry, typeCategory);
    }

    @Override
    public boolean isValidValueV1(Object v1Obj, AtlasType type) {
        boolean ret;
        boolean bl = ret = v1Obj == null || v1Obj instanceof Map || v1Obj instanceof Struct;
        if (LOG.isDebugEnabled()) {
            LOG.debug("AtlasStructFormatConverter.isValidValueV1(type={}, value={}): {}", new Object[]{v1Obj != null ? v1Obj.getClass().getCanonicalName() : null, v1Obj, ret});
        }
        return ret;
    }

    @Override
    public Object fromV1ToV2(Object v1Obj, AtlasType type, AtlasFormatConverter.ConverterContext converterContext) throws AtlasBaseException {
        AtlasStruct ret = null;
        if (v1Obj != null) {
            AtlasStructType structType = (AtlasStructType)type;
            if (v1Obj instanceof Map) {
                Map v1Map = (Map)v1Obj;
                Map v1Attribs = (Map)v1Map.get(ATTRIBUTES_PROPERTY_KEY);
                ret = MapUtils.isNotEmpty((Map)v1Attribs) ? new AtlasStruct(type.getTypeName(), this.fromV1ToV2(structType, v1Attribs, converterContext)) : new AtlasStruct(type.getTypeName());
            } else if (v1Obj instanceof Struct) {
                Struct struct = (Struct)v1Obj;
                ret = new AtlasStruct(type.getTypeName(), this.fromV1ToV2(structType, struct.getValues(), converterContext));
            } else {
                throw new AtlasBaseException(AtlasErrorCode.UNEXPECTED_TYPE, new String[]{"Map or Struct", v1Obj.getClass().getCanonicalName()});
            }
        }
        return ret;
    }

    @Override
    public Object fromV2ToV1(Object v2Obj, AtlasType type, AtlasFormatConverter.ConverterContext converterContext) throws AtlasBaseException {
        Struct ret = null;
        if (v2Obj != null) {
            AtlasStructType structType = (AtlasStructType)type;
            if (v2Obj instanceof Map) {
                Map v2Map = (Map)v2Obj;
                Map v2Attribs = v2Map.containsKey(ATTRIBUTES_PROPERTY_KEY) ? (Map)v2Map.get(ATTRIBUTES_PROPERTY_KEY) : v2Map;
                ret = MapUtils.isNotEmpty((Map)v2Attribs) ? new Struct(type.getTypeName(), this.fromV2ToV1(structType, v2Attribs, converterContext)) : new Struct(type.getTypeName());
            } else if (v2Obj instanceof AtlasStruct) {
                AtlasStruct struct = (AtlasStruct)v2Obj;
                ret = new Struct(type.getTypeName(), this.fromV2ToV1(structType, struct.getAttributes(), converterContext));
            } else {
                throw new AtlasBaseException(AtlasErrorCode.UNEXPECTED_TYPE, new String[]{"Map or AtlasStruct", v2Obj.getClass().getCanonicalName()});
            }
        }
        return ret;
    }

    protected Map<String, Object> fromV2ToV1(AtlasStructType structType, Map<String, Object> attributes, AtlasFormatConverter.ConverterContext context) throws AtlasBaseException {
        HashMap<String, Object> ret = null;
        boolean isEntityType = structType instanceof AtlasEntityType;
        if (MapUtils.isNotEmpty(attributes)) {
            ret = new HashMap<String, Object>();
            for (String attrName : attributes.keySet()) {
                ArrayList<AtlasEntity> v2Value = attributes.get(attrName);
                AtlasStructType.AtlasAttribute attr = structType.getAttribute(attrName);
                if (attr == null) {
                    if (isEntityType) {
                        attr = ((AtlasEntityType)structType).getRelationshipAttribute(attrName, AtlasEntityUtil.getRelationshipType((Object)v2Value));
                    }
                    if (attr == null) {
                        LOG.warn("ignored unknown attribute {}.{}", (Object)structType.getTypeName(), (Object)attrName);
                        continue;
                    }
                }
                AtlasType attrType = attr.getAttributeType();
                AtlasFormatConverter attrConverter = this.converterRegistry.getConverter(attrType.getTypeCategory());
                if (v2Value != null && isEntityType && attr.isOwnedRef()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{}: is ownedRef, attrType={}", (Object)attr.getQualifiedName(), (Object)attrType.getTypeName());
                    }
                    if (attrType instanceof AtlasArrayType) {
                        AtlasArrayType arrayType = (AtlasArrayType)attrType;
                        AtlasType elemType = arrayType.getElementType();
                        String elemTypeName = elemType instanceof AtlasBuiltInTypes.AtlasObjectIdType ? ((AtlasBuiltInTypes.AtlasObjectIdType)elemType).getObjectType() : elemType.getTypeName();
                        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(elemTypeName);
                        if (entityType != null) {
                            Collection arrayValue = v2Value;
                            ArrayList<AtlasEntity> entities = new ArrayList<AtlasEntity>(arrayValue.size());
                            for (Object arrayElem : arrayValue) {
                                AtlasEntity entity;
                                String entityGuid = this.getGuid(arrayElem);
                                AtlasEntity atlasEntity = entity = StringUtils.isNotEmpty((CharSequence)entityGuid) ? context.getById(entityGuid) : null;
                                if (entity != null) {
                                    entities.add(entity);
                                    continue;
                                }
                                LOG.warn("{}: not replacing objIdList with entityList - entity not found guid={}", (Object)attr.getQualifiedName(), (Object)entityGuid);
                                entities = null;
                                break;
                            }
                            if (entities != null) {
                                v2Value = entities;
                                attrType = new AtlasArrayType((AtlasType)entityType, arrayType.getMinCount(), arrayType.getMaxCount(), arrayType.getCardinality());
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("{}: replaced objIdList with entityList", (Object)attr.getQualifiedName());
                                }
                            }
                        } else {
                            LOG.warn("{}: not replacing objIdList with entityList - elementType {} is not an entityType", (Object)attr.getQualifiedName(), (Object)elemTypeName);
                        }
                    } else if (attrType instanceof AtlasBuiltInTypes.AtlasObjectIdType) {
                        AtlasEntityType entityType;
                        String entityGuid = this.getGuid(v2Value);
                        AtlasEntity entity = StringUtils.isNotEmpty((CharSequence)entityGuid) ? context.getById(entityGuid) : null;
                        AtlasEntityType atlasEntityType = entityType = entity != null ? this.typeRegistry.getEntityTypeByName(entity.getTypeName()) : null;
                        if (entity != null && entityType != null) {
                            v2Value = entity;
                            attrType = entityType;
                            attrConverter = this.converterRegistry.getConverter(attrType.getTypeCategory());
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{}: replaced objId with entity guid={}", (Object)attr.getQualifiedName(), (Object)entityGuid);
                            }
                        } else {
                            LOG.warn("{}: not replacing objId with entity - entity not found guid={}", (Object)attr.getQualifiedName(), (Object)entityGuid);
                        }
                    } else {
                        LOG.warn("{}: not replacing objId with entity - unexpected attribute-type {}", (Object)attr.getQualifiedName(), (Object)attrType.getTypeName());
                    }
                }
                Object v1Value = attrConverter.fromV2ToV1(v2Value, attrType, context);
                ret.put(attr.getName(), v1Value);
            }
        }
        return ret;
    }

    private String getGuid(Object obj) {
        String ret;
        if (obj instanceof AtlasObjectId) {
            AtlasObjectId objId = (AtlasObjectId)obj;
            ret = objId.getGuid();
        } else if (obj instanceof Map) {
            Map v2Map = (Map)obj;
            ret = (String)v2Map.get("guid");
        } else {
            ret = null;
        }
        return ret;
    }

    protected Map<String, Object> fromV1ToV2(AtlasStructType structType, Map attributes, AtlasFormatConverter.ConverterContext context) throws AtlasBaseException {
        AtlasEntityType entityType;
        HashMap<String, Object> ret = null;
        AtlasEntityType atlasEntityType = entityType = structType instanceof AtlasEntityType ? (AtlasEntityType)structType : null;
        if (MapUtils.isNotEmpty((Map)attributes)) {
            ret = new HashMap<String, Object>();
            for (Object attribKey : attributes.keySet()) {
                AtlasType attrType;
                AtlasFormatConverter attrConverter;
                String attrName = attribKey.toString();
                Object v1Value = attributes.get(attrName);
                AtlasStructType.AtlasAttribute attr = structType.getAttribute(attrName);
                if (attr == null) {
                    if (entityType != null) {
                        attr = entityType.getRelationshipAttribute(attrName, null);
                    }
                    if (attr == null) {
                        LOG.warn("ignored unknown attribute {}.{}", (Object)structType.getTypeName(), (Object)attrName);
                        continue;
                    }
                }
                if ((attrConverter = this.converterRegistry.getConverter((attrType = attr.getAttributeType()).getTypeCategory())).isValidValueV1(v1Value, attrType)) {
                    Object v2Value = attrConverter.fromV1ToV2(v1Value, attrType, context);
                    ret.put(attrName, v2Value);
                    continue;
                }
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_CRUD_INVALID_PARAMS, new String[]{attrName + "=" + v1Value});
            }
        }
        return ret;
    }
}

