/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graph;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.repository.graph.IFullTextMapper;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FullTextMapperV2
implements IFullTextMapper {
    private static final Logger LOG = LoggerFactory.getLogger(FullTextMapperV2.class);
    private static final String FULL_TEXT_DELIMITER = " ";
    private static final String FULL_TEXT_FOLLOW_REFERENCES = "atlas.search.fulltext.followReferences";
    private static final String FULL_TEXT_EXCLUDE_ATTRIBUTE_PROPERTY = "atlas.search.fulltext.type";
    private final AtlasTypeRegistry typeRegistry;
    private final Configuration configuration;
    private final EntityGraphRetriever entityGraphRetriever;
    private final boolean followReferences;
    private final Map<String, Set<String>> excludeAttributesCache = new HashMap<String, Set<String>>();

    @Inject
    public FullTextMapperV2(AtlasGraph atlasGraph, AtlasTypeRegistry typeRegistry, Configuration configuration) {
        this.typeRegistry = typeRegistry;
        this.configuration = configuration;
        this.followReferences = this.configuration != null && this.configuration.getBoolean(FULL_TEXT_FOLLOW_REFERENCES, false);
        this.entityGraphRetriever = new EntityGraphRetriever(atlasGraph, typeRegistry, !this.followReferences);
    }

    @Override
    public String getIndexTextForClassifications(String guid, List<AtlasClassification> classifications) throws AtlasBaseException {
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo;
        String ret = null;
        if (this.followReferences) {
            entityWithExtInfo = this.getAndCacheEntityWithExtInfo(guid);
        } else {
            AtlasEntity entity = this.getAndCacheEntity(guid);
            AtlasEntity.AtlasEntityWithExtInfo atlasEntityWithExtInfo = entityWithExtInfo = entity != null ? new AtlasEntity.AtlasEntityWithExtInfo(entity) : null;
        }
        if (entityWithExtInfo != null) {
            StringBuilder sb = new StringBuilder();
            if (CollectionUtils.isNotEmpty(classifications)) {
                for (AtlasClassification classification : classifications) {
                    AtlasClassificationType classificationType = this.typeRegistry.getClassificationTypeByName(classification.getTypeName());
                    Set<String> excludeAttributes = this.getExcludeAttributesForIndexText(classification.getTypeName());
                    sb.append(classification.getTypeName()).append(FULL_TEXT_DELIMITER);
                    this.mapAttributes((AtlasStructType)classificationType, classification.getAttributes(), (AtlasEntity.AtlasEntityExtInfo)entityWithExtInfo, sb, new HashSet<String>(), excludeAttributes, false);
                }
            }
            ret = sb.toString();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("FullTextMapperV2.map({}): {}", (Object)guid, ret);
        }
        return ret;
    }

    @Override
    public String getIndexTextForEntity(String guid) throws AtlasBaseException {
        AtlasEntity.AtlasEntityWithExtInfo entityExtInfo;
        AtlasEntity entity;
        String ret = null;
        if (this.followReferences) {
            AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.getAndCacheEntityWithExtInfo(guid);
            entity = entityWithExtInfo != null ? entityWithExtInfo.getEntity() : null;
            entityExtInfo = entityWithExtInfo;
        } else {
            entity = this.getAndCacheEntity(guid, false);
            entityExtInfo = null;
        }
        if (entity != null) {
            StringBuilder sb = new StringBuilder();
            this.map(entity, (AtlasEntity.AtlasEntityExtInfo)entityExtInfo, sb, new HashSet<String>(), false);
            ret = sb.toString();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("FullTextMapperV2.map({}): {}", (Object)guid, ret);
        }
        return ret;
    }

    @Override
    public String getClassificationTextForEntity(AtlasEntity entity) throws AtlasBaseException {
        String ret = null;
        if (entity != null) {
            StringBuilder sb = new StringBuilder();
            this.map(entity, null, sb, new HashSet<String>(), true);
            ret = sb.toString();
        }
        if (LOG.isDebugEnabled()) {
            LOG.info("FullTextMapperV2.getClassificationTextForEntity({}): {}", (Object)entity.getGuid(), ret);
        }
        return ret;
    }

    private void map(AtlasEntity entity, AtlasEntity.AtlasEntityExtInfo entityExtInfo, StringBuilder sb, Set<String> processedGuids, boolean isClassificationOnly) throws AtlasBaseException {
        List classifications;
        if (entity == null || processedGuids.contains(entity.getGuid())) {
            return;
        }
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
        Set<String> excludeAttributes = this.getExcludeAttributesForIndexText(entity.getTypeName());
        processedGuids.add(entity.getGuid());
        if (!isClassificationOnly) {
            sb.append(entity.getTypeName()).append(FULL_TEXT_DELIMITER);
            this.mapAttributes((AtlasStructType)entityType, entity.getAttributes(), entityExtInfo, sb, processedGuids, excludeAttributes, isClassificationOnly);
        }
        if (CollectionUtils.isNotEmpty((Collection)(classifications = entity.getClassifications()))) {
            for (AtlasClassification classification : classifications) {
                AtlasClassificationType classificationType = this.typeRegistry.getClassificationTypeByName(classification.getTypeName());
                Set<String> excludeClassificationAttributes = this.getExcludeAttributesForIndexText(classification.getTypeName());
                sb.append(classification.getTypeName()).append(FULL_TEXT_DELIMITER);
                this.mapAttributes((AtlasStructType)classificationType, classification.getAttributes(), entityExtInfo, sb, processedGuids, excludeClassificationAttributes, isClassificationOnly);
            }
        }
    }

    private void mapAttributes(AtlasStructType structType, Map<String, Object> attributes, AtlasEntity.AtlasEntityExtInfo entityExtInfo, StringBuilder sb, Set<String> processedGuids, Set<String> excludeAttributes, boolean isClassificationOnly) throws AtlasBaseException {
        if (MapUtils.isEmpty(attributes)) {
            return;
        }
        for (Map.Entry<String, Object> attributeEntry : attributes.entrySet()) {
            String attribKey = attributeEntry.getKey();
            Object attrValue = attributeEntry.getValue();
            if (attrValue == null || excludeAttributes.contains(attribKey)) continue;
            if (!this.followReferences) {
                AtlasStructType.AtlasAttribute attribute = structType != null ? structType.getAttribute(attribKey) : null;
                AtlasType attributeType = attribute != null ? attribute.getAttributeType() : null;
                if (attributeType == null) continue;
                if (attributeType instanceof AtlasArrayType) {
                    attributeType = ((AtlasArrayType)attributeType).getElementType();
                }
                if (attributeType instanceof AtlasEntityType || attributeType instanceof AtlasBuiltInTypes.AtlasObjectIdType) continue;
            }
            sb.append(attribKey).append(FULL_TEXT_DELIMITER);
            this.mapAttribute(attrValue, entityExtInfo, sb, processedGuids, isClassificationOnly);
        }
    }

    private void mapAttribute(Object value, AtlasEntity.AtlasEntityExtInfo entityExtInfo, StringBuilder sb, Set<String> processedGuids, boolean isClassificationOnly) throws AtlasBaseException {
        if (value instanceof AtlasObjectId) {
            AtlasObjectId objectId;
            AtlasEntity entity;
            if (this.followReferences && entityExtInfo != null && (entity = entityExtInfo.getEntity((objectId = (AtlasObjectId)value).getGuid())) != null) {
                this.map(entity, entityExtInfo, sb, processedGuids, isClassificationOnly);
            }
        } else if (value instanceof List) {
            List valueList = (List)value;
            for (Object listElement : valueList) {
                this.mapAttribute(listElement, entityExtInfo, sb, processedGuids, isClassificationOnly);
            }
        } else if (value instanceof Map) {
            Map valueMap = (Map)value;
            for (Object key : valueMap.keySet()) {
                this.mapAttribute(key, entityExtInfo, sb, processedGuids, isClassificationOnly);
                this.mapAttribute(valueMap.get(key), entityExtInfo, sb, processedGuids, isClassificationOnly);
            }
        } else if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            sb.append(enumValue.name()).append(FULL_TEXT_DELIMITER);
        } else if (value instanceof AtlasStruct) {
            AtlasStruct atlasStruct = (AtlasStruct)value;
            for (Map.Entry entry : atlasStruct.getAttributes().entrySet()) {
                sb.append((String)entry.getKey()).append(FULL_TEXT_DELIMITER);
                this.mapAttribute(entry.getValue(), entityExtInfo, sb, processedGuids, isClassificationOnly);
            }
        } else {
            sb.append(String.valueOf(value)).append(FULL_TEXT_DELIMITER);
        }
    }

    @Override
    public AtlasEntity getAndCacheEntity(String guid) throws AtlasBaseException {
        return this.getAndCacheEntity(guid, true);
    }

    @Override
    public AtlasEntity getAndCacheEntity(String guid, boolean includeReferences) throws AtlasBaseException {
        RequestContext context = RequestContext.get();
        AtlasEntity entity = context.getEntity(guid);
        if (entity == null && (entity = this.entityGraphRetriever.toAtlasEntity(guid, includeReferences)) != null) {
            context.cache(entity);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cache miss -> GUID = {}", (Object)guid);
            }
        }
        return entity;
    }

    @Override
    public AtlasEntity.AtlasEntityWithExtInfo getAndCacheEntityWithExtInfo(String guid) throws AtlasBaseException {
        RequestContext context = RequestContext.get();
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = context.getEntityWithExtInfo(guid);
        if (entityWithExtInfo == null && (entityWithExtInfo = this.entityGraphRetriever.toAtlasEntityWithExtInfo(guid, !this.followReferences)) != null) {
            context.cache(entityWithExtInfo);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cache miss -> GUID = {}", (Object)guid);
            }
        }
        return entityWithExtInfo;
    }

    private Set<String> getExcludeAttributesForIndexText(String typeName) {
        Set<Object> ret;
        if (this.excludeAttributesCache.containsKey(typeName)) {
            ret = this.excludeAttributesCache.get(typeName);
        } else if (this.configuration != null) {
            Object[] excludeAttributes = this.configuration.getStringArray("atlas.search.fulltext.type." + typeName + ".attributes.exclude");
            ret = ArrayUtils.isNotEmpty((Object[])excludeAttributes) ? new HashSet<Object>(Arrays.asList(excludeAttributes)) : Collections.emptySet();
            this.excludeAttributesCache.put(typeName, ret);
        } else {
            ret = Collections.emptySet();
        }
        return ret;
    }
}

