/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graph;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.AtlasException;
import org.apache.atlas.discovery.SearchIndexer;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.ha.HAConfiguration;
import org.apache.atlas.listener.ActiveStateChangeHandler;
import org.apache.atlas.listener.ChangedTypeDefs;
import org.apache.atlas.listener.TypeDefChangeListener;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.IndexException;
import org.apache.atlas.repository.RepositoryException;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graph.IAtlasGraphProvider;
import org.apache.atlas.repository.graph.IndexChangeListener;
import org.apache.atlas.repository.graph.SolrIndexHelper;
import org.apache.atlas.repository.graphdb.AtlasCardinality;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasEdgeLabel;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphIndex;
import org.apache.atlas.repository.graphdb.AtlasGraphManagement;
import org.apache.atlas.repository.graphdb.AtlasPropertyKey;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBusinessMetadataType;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasEnumType;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class GraphBackedSearchIndexer
implements SearchIndexer,
ActiveStateChangeHandler,
TypeDefChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(GraphBackedSearchIndexer.class);
    private static final String VERTEX_ID_IN_IMPORT_KEY = "__vIdInImport";
    private static final String EDGE_ID_IN_IMPORT_KEY = "__eIdInImport";
    private static final List<Class> INDEX_EXCLUSION_CLASSES = new ArrayList(){
        {
            this.add(Boolean.class);
            this.add(BigDecimal.class);
            this.add(BigInteger.class);
        }
    };
    private final AtlasTypeRegistry typeRegistry;
    private final List<IndexChangeListener> indexChangeListeners = new ArrayList<IndexChangeListener>();
    private IAtlasGraphProvider provider;
    private boolean recomputeIndexedKeys = true;
    private boolean recomputeEdgeIndexedKeys = true;
    private Set<String> vertexIndexKeys = new HashSet<String>();
    private Set<String> edgeIndexKeys = new HashSet<String>();

    public static boolean isValidSearchWeight(int searchWeight) {
        return searchWeight == -1 || searchWeight >= 1 && searchWeight <= 10;
    }

    public static boolean isStringAttribute(AtlasStructType.AtlasAttribute attribute) {
        return "string".equals(attribute.getTypeName());
    }

    @Inject
    public GraphBackedSearchIndexer(AtlasTypeRegistry typeRegistry) throws AtlasException {
        this(new AtlasGraphProvider(), ApplicationProperties.get(), typeRegistry);
    }

    @VisibleForTesting
    GraphBackedSearchIndexer(IAtlasGraphProvider provider, Configuration configuration, AtlasTypeRegistry typeRegistry) throws IndexException, RepositoryException {
        this.provider = provider;
        this.typeRegistry = typeRegistry;
        this.addIndexListener(new SolrIndexHelper(typeRegistry));
        if (!HAConfiguration.isHAEnabled((Configuration)configuration)) {
            this.initialize(provider.get());
        }
        this.notifyInitializationStart();
    }

    public void addIndexListener(IndexChangeListener listener) {
        this.indexChangeListeners.add(listener);
    }

    public void instanceIsActive() throws AtlasException {
        LOG.info("Reacting to active: initializing index");
        try {
            this.initialize();
        }
        catch (IndexException | RepositoryException e) {
            throw new AtlasException("Error in reacting to active on initialization", (Throwable)e);
        }
    }

    public void instanceIsPassive() {
        LOG.info("Reacting to passive state: No action right now.");
    }

    public int getHandlerOrder() {
        return ActiveStateChangeHandler.HandlerOrder.GRAPH_BACKED_SEARCH_INDEXER.getOrder();
    }

    @Override
    public void onChange(ChangedTypeDefs changedTypeDefs) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing changed typedefs {}", (Object)changedTypeDefs);
        }
        AtlasGraphManagement management = null;
        try {
            management = this.provider.get().getManagementSystem();
            if (CollectionUtils.isNotEmpty(changedTypeDefs.getCreatedTypeDefs())) {
                for (AtlasBaseTypeDef atlasBaseTypeDef : changedTypeDefs.getCreatedTypeDefs()) {
                    this.updateIndexForTypeDef(management, atlasBaseTypeDef);
                }
            }
            if (CollectionUtils.isNotEmpty(changedTypeDefs.getUpdatedTypeDefs())) {
                for (AtlasBaseTypeDef atlasBaseTypeDef : changedTypeDefs.getUpdatedTypeDefs()) {
                    this.updateIndexForTypeDef(management, atlasBaseTypeDef);
                }
            }
            if (CollectionUtils.isNotEmpty(changedTypeDefs.getDeletedTypeDefs())) {
                for (AtlasBaseTypeDef atlasBaseTypeDef : changedTypeDefs.getDeletedTypeDefs()) {
                    this.deleteIndexForType(management, atlasBaseTypeDef);
                }
            }
            this.resolveIndexFieldNames(management, changedTypeDefs);
            this.createEdgeLabels(management, changedTypeDefs.getCreatedTypeDefs());
            this.createEdgeLabels(management, changedTypeDefs.getUpdatedTypeDefs());
            this.commit(management);
        }
        catch (IndexException | RepositoryException e) {
            LOG.error("Failed to update indexes for changed typedefs", (Throwable)e);
            this.attemptRollback(changedTypeDefs, management);
        }
        this.notifyChangeListeners(changedTypeDefs);
    }

    @Override
    public void onLoadCompletion() throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Type definition load completed. Informing the completion to IndexChangeListeners.");
        }
        ArrayList typeDefs = new ArrayList();
        typeDefs.addAll(this.typeRegistry.getAllEntityDefs());
        typeDefs.addAll(this.typeRegistry.getAllBusinessMetadataDefs());
        ChangedTypeDefs changedTypeDefs = new ChangedTypeDefs(null, new ArrayList(typeDefs), null);
        AtlasGraphManagement management = null;
        try {
            management = this.provider.get().getManagementSystem();
            this.resolveIndexFieldNames(management, changedTypeDefs);
            this.commit(management);
            this.notifyInitializationCompletion(changedTypeDefs);
        }
        catch (IndexException | RepositoryException e) {
            LOG.error("Failed to update indexes for changed typedefs", (Throwable)e);
            this.attemptRollback(changedTypeDefs, management);
        }
    }

    public Set<String> getVertexIndexKeys() {
        block8: {
            if (this.recomputeIndexedKeys) {
                AtlasGraphManagement management = null;
                try {
                    management = this.provider.get().getManagementSystem();
                    if (management != null) {
                        AtlasGraphIndex vertexIndex = management.getGraphIndex("vertex_index");
                        if (vertexIndex != null) {
                            this.recomputeIndexedKeys = false;
                            HashSet<String> indexKeys = new HashSet<String>();
                            for (AtlasPropertyKey fieldKey : vertexIndex.getFieldKeys()) {
                                indexKeys.add(fieldKey.getName());
                            }
                            this.vertexIndexKeys = indexKeys;
                        }
                        management.commit();
                    }
                }
                catch (Exception excp) {
                    LOG.error("getVertexIndexKeys(): failed to get indexedKeys from graph", (Throwable)excp);
                    if (management == null) break block8;
                    try {
                        management.rollback();
                    }
                    catch (Exception e) {
                        LOG.error("getVertexIndexKeys(): rollback failed", (Throwable)e);
                    }
                }
            }
        }
        return this.vertexIndexKeys;
    }

    public Set<String> getEdgeIndexKeys() {
        block8: {
            if (this.recomputeEdgeIndexedKeys) {
                AtlasGraphManagement management = null;
                try {
                    management = this.provider.get().getManagementSystem();
                    if (management != null) {
                        AtlasGraphIndex edgeIndex = management.getGraphIndex("edge_index");
                        if (edgeIndex != null) {
                            this.recomputeEdgeIndexedKeys = false;
                            HashSet<String> indexKeys = new HashSet<String>();
                            for (AtlasPropertyKey fieldKey : edgeIndex.getFieldKeys()) {
                                indexKeys.add(fieldKey.getName());
                            }
                            this.edgeIndexKeys = indexKeys;
                        }
                        management.commit();
                    }
                }
                catch (Exception excp) {
                    LOG.error("getEdgeIndexKeys(): failed to get indexedKeys from graph", (Throwable)excp);
                    if (management == null) break block8;
                    try {
                        management.rollback();
                    }
                    catch (Exception e) {
                        LOG.error("getEdgeIndexKeys(): rollback failed", (Throwable)e);
                    }
                }
            }
        }
        return this.edgeIndexKeys;
    }

    private void initialize() throws RepositoryException, IndexException {
        this.initialize(this.provider.get());
    }

    private void initialize(AtlasGraph graph) throws RepositoryException, IndexException {
        AtlasGraphManagement management = graph.getManagementSystem();
        try {
            LOG.info("Creating indexes for graph.");
            if (management.getGraphIndex("vertex_index") == null) {
                management.createVertexMixedIndex("vertex_index", "search", Collections.emptyList());
                LOG.info("Created index : {}", (Object)"vertex_index");
            }
            if (management.getGraphIndex("edge_index") == null) {
                management.createEdgeMixedIndex("edge_index", "search", Collections.emptyList());
                LOG.info("Created index : {}", (Object)"edge_index");
            }
            if (management.getGraphIndex("fulltext_index") == null) {
                management.createFullTextMixedIndex("fulltext_index", "search", Collections.emptyList());
                LOG.info("Created index : {}", (Object)"fulltext_index");
            }
            this.createCommonVertexIndex(management, Constants.GUID_PROPERTY_KEY, UniqueKind.GLOBAL_UNIQUE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.HISTORICAL_GUID_PROPERTY_KEY, UniqueKind.GLOBAL_UNIQUE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.TYPENAME_PROPERTY_KEY, UniqueKind.GLOBAL_UNIQUE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.TYPESERVICETYPE_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.VERTEX_TYPE_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, VERTEX_ID_IN_IMPORT_KEY, UniqueKind.NONE, Long.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.ENTITY_TYPE_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.SUPER_TYPES_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SET, true, false);
            this.createCommonVertexIndex(management, Constants.TIMESTAMP_PROPERTY_KEY, UniqueKind.NONE, Long.class, AtlasCardinality.SINGLE, false, false);
            this.createCommonVertexIndex(management, Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, UniqueKind.NONE, Long.class, AtlasCardinality.SINGLE, false, false);
            this.createCommonVertexIndex(management, Constants.STATE_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, false, false);
            this.createCommonVertexIndex(management, Constants.CREATED_BY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, false, false, true);
            this.createCommonVertexIndex(management, Constants.CLASSIFICATION_TEXT_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, false, false);
            this.createCommonVertexIndex(management, Constants.MODIFIED_BY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, false, false, true);
            this.createCommonVertexIndex(management, Constants.CLASSIFICATION_NAMES_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.PROPAGATED_CLASSIFICATION_NAMES_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.TRAIT_NAMES_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SET, true, true);
            this.createCommonVertexIndex(management, Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.LIST, true, true);
            this.createCommonVertexIndex(management, org.apache.atlas.type.Constants.PENDING_TASKS_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SET, true, false);
            this.createCommonVertexIndex(management, Constants.IS_INCOMPLETE_PROPERTY_KEY, UniqueKind.NONE, Integer.class, AtlasCardinality.SINGLE, true, true);
            this.createCommonVertexIndex(management, Constants.CUSTOM_ATTRIBUTES_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.LABELS_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.ENTITY_DELETED_TIMESTAMP_PROPERTY_KEY, UniqueKind.NONE, Long.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.PATCH_ID_PROPERTY_KEY, UniqueKind.GLOBAL_UNIQUE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.PATCH_DESCRIPTION_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.PATCH_TYPE_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.PATCH_ACTION_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.PATCH_STATE_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.TASK_GUID, UniqueKind.GLOBAL_UNIQUE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.TASK_TYPE_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.TASK_CREATED_TIME, UniqueKind.NONE, Long.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.TASK_STATUS, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, Constants.PROPERTY_KEY_INDEX_RECOVERY_NAME, UniqueKind.GLOBAL_UNIQUE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, " __AtlasMetricsStat.metricsId", UniqueKind.GLOBAL_UNIQUE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, " __AtlasMetricsStat.__u_metricsId", UniqueKind.GLOBAL_UNIQUE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, " __AtlasMetricsStat.metrics", UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, " __AtlasMetricsStat.collectionTime", UniqueKind.GLOBAL_UNIQUE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createCommonVertexIndex(management, " __AtlasMetricsStat.timeToLiveMillis", UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createVertexCentricIndex(management, "classifiedAs", AtlasEdgeDirection.BOTH, Constants.CLASSIFICATION_EDGE_NAME_PROPERTY_KEY, String.class, AtlasCardinality.SINGLE);
            this.createVertexCentricIndex(management, "classifiedAs", AtlasEdgeDirection.BOTH, Constants.CLASSIFICATION_EDGE_IS_PROPAGATED_PROPERTY_KEY, Boolean.class, AtlasCardinality.SINGLE);
            this.createVertexCentricIndex(management, "classifiedAs", AtlasEdgeDirection.BOTH, Arrays.asList(Constants.CLASSIFICATION_EDGE_NAME_PROPERTY_KEY, Constants.CLASSIFICATION_EDGE_IS_PROPAGATED_PROPERTY_KEY));
            this.createEdgeIndex(management, Constants.RELATIONSHIP_GUID_PROPERTY_KEY, String.class, AtlasCardinality.SINGLE, true);
            this.createEdgeIndex(management, EDGE_ID_IN_IMPORT_KEY, String.class, AtlasCardinality.SINGLE, true);
            this.createEdgeIndex(management, Constants.RELATIONSHIP_TYPE_PROPERTY_KEY, String.class, AtlasCardinality.SINGLE, true);
            this.createFullTextIndex(management, Constants.ENTITY_TEXT_PROPERTY_KEY, String.class, AtlasCardinality.SINGLE);
            this.createPropertyKey(management, Constants.IS_PROXY_KEY, Boolean.class, AtlasCardinality.SINGLE);
            this.createPropertyKey(management, Constants.PROVENANCE_TYPE_KEY, Integer.class, AtlasCardinality.SINGLE);
            this.createPropertyKey(management, Constants.HOME_ID_KEY, String.class, AtlasCardinality.SINGLE);
            this.commit(management);
            LOG.info("Index creation for global keys complete.");
        }
        catch (Throwable t) {
            LOG.error("GraphBackedSearchIndexer.initialize() failed", t);
            this.rollback(management);
            throw new RepositoryException(t);
        }
    }

    private void resolveIndexFieldNames(AtlasGraphManagement managementSystem, ChangedTypeDefs changedTypeDefs) {
        List<? extends AtlasBaseTypeDef> updatedTypeDefs;
        List<? extends AtlasBaseTypeDef> createdTypeDefs = changedTypeDefs.getCreatedTypeDefs();
        if (createdTypeDefs != null) {
            this.resolveIndexFieldNames(managementSystem, createdTypeDefs);
        }
        if ((updatedTypeDefs = changedTypeDefs.getUpdatedTypeDefs()) != null) {
            this.resolveIndexFieldNames(managementSystem, updatedTypeDefs);
        }
    }

    private void resolveIndexFieldNames(AtlasGraphManagement managementSystem, List<? extends AtlasBaseTypeDef> typeDefs) {
        for (AtlasBaseTypeDef atlasBaseTypeDef : typeDefs) {
            if (TypeCategory.ENTITY.equals((Object)atlasBaseTypeDef.getCategory())) {
                AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(atlasBaseTypeDef.getName());
                this.resolveIndexFieldNames(managementSystem, (AtlasStructType)entityType);
                continue;
            }
            if (TypeCategory.BUSINESS_METADATA.equals((Object)atlasBaseTypeDef.getCategory())) {
                AtlasBusinessMetadataType businessMetadataType = this.typeRegistry.getBusinessMetadataTypeByName(atlasBaseTypeDef.getName());
                this.resolveIndexFieldNames(managementSystem, (AtlasStructType)businessMetadataType);
                continue;
            }
            LOG.debug("Ignoring type definition {}", (Object)atlasBaseTypeDef.getName());
        }
    }

    private void resolveIndexFieldNames(AtlasGraphManagement managementSystem, AtlasStructType structType) {
        for (AtlasStructType.AtlasAttribute attribute : structType.getAllAttributes().values()) {
            this.resolveIndexFieldName(managementSystem, attribute);
        }
    }

    private void resolveIndexFieldName(AtlasGraphManagement managementSystem, AtlasStructType.AtlasAttribute attribute) {
        try {
            if (attribute.getIndexFieldName() == null && TypeCategory.PRIMITIVE.equals((Object)attribute.getAttributeType().getTypeCategory())) {
                AtlasStructType.AtlasAttribute baseInstance;
                AtlasStructType definedInType = attribute.getDefinedInType();
                AtlasStructType.AtlasAttribute atlasAttribute = baseInstance = definedInType != null ? definedInType.getAttribute(attribute.getName()) : null;
                if (baseInstance != null && baseInstance.getIndexFieldName() != null) {
                    attribute.setIndexFieldName(baseInstance.getIndexFieldName());
                } else if (this.isIndexApplicable(this.getPrimitiveClass(attribute.getTypeName()), this.toAtlasCardinality(attribute.getAttributeDef().getCardinality()))) {
                    AtlasPropertyKey propertyKey = managementSystem.getPropertyKey(attribute.getVertexPropertyName());
                    boolean isStringField = AtlasStructDef.AtlasAttributeDef.IndexType.STRING.equals((Object)attribute.getIndexType());
                    if (propertyKey != null) {
                        String indexFieldName = managementSystem.getIndexFieldName("vertex_index", propertyKey, isStringField);
                        attribute.setIndexFieldName(indexFieldName);
                        if (baseInstance != null) {
                            baseInstance.setIndexFieldName(indexFieldName);
                        }
                        this.typeRegistry.addIndexFieldName(attribute.getVertexPropertyName(), indexFieldName);
                        LOG.info("Property {} is mapped to index field name {}", (Object)attribute.getQualifiedName(), (Object)attribute.getIndexFieldName());
                    } else {
                        LOG.warn("resolveIndexFieldName(attribute={}): propertyKey is null for vertextPropertyName={}", (Object)attribute.getQualifiedName(), (Object)attribute.getVertexPropertyName());
                    }
                }
            }
        }
        catch (Exception excp) {
            LOG.warn("resolveIndexFieldName(attribute={}) failed.", (Object)attribute.getQualifiedName(), (Object)excp);
        }
    }

    private void createCommonVertexIndex(AtlasGraphManagement management, String propertyName, UniqueKind uniqueKind, Class propertyClass, AtlasCardinality cardinality, boolean createCompositeIndex, boolean createCompositeIndexWithTypeAndSuperTypes) {
        this.createCommonVertexIndex(management, propertyName, uniqueKind, propertyClass, cardinality, createCompositeIndex, createCompositeIndexWithTypeAndSuperTypes, false);
    }

    private void createCommonVertexIndex(AtlasGraphManagement management, String propertyName, UniqueKind uniqueKind, Class propertyClass, AtlasCardinality cardinality, boolean createCompositeIndex, boolean createCompositeIndexWithTypeAndSuperTypes, boolean isStringField) {
        String indexFieldName;
        if (isStringField && String.class.equals((Object)propertyClass)) {
            propertyName = AtlasStructType.AtlasAttribute.VERTEX_PROPERTY_PREFIX_STRING_INDEX_TYPE + propertyName;
            LOG.debug("Creating the common attribute '{}' as string field.", (Object)propertyName);
        }
        if ((indexFieldName = this.createVertexIndex(management, propertyName, uniqueKind, propertyClass, cardinality, createCompositeIndex, createCompositeIndexWithTypeAndSuperTypes, isStringField)) != null) {
            this.typeRegistry.addIndexFieldName(propertyName, indexFieldName);
        }
    }

    private void addIndexForType(AtlasGraphManagement management, AtlasBaseTypeDef typeDef) {
        if (typeDef instanceof AtlasEnumDef) {
            return;
        }
        if (typeDef instanceof AtlasStructDef) {
            AtlasStructDef structDef = (AtlasStructDef)typeDef;
            List attributeDefs = structDef.getAttributeDefs();
            if (CollectionUtils.isNotEmpty((Collection)attributeDefs)) {
                for (AtlasStructDef.AtlasAttributeDef attributeDef : attributeDefs) {
                    this.createIndexForAttribute(management, structDef, attributeDef);
                }
            }
        } else if (!AtlasTypeUtil.isBuiltInType((String)typeDef.getName())) {
            throw new IllegalArgumentException("bad data type" + typeDef.getName());
        }
    }

    private void deleteIndexForType(AtlasGraphManagement management, AtlasBaseTypeDef typeDef) {
        AtlasStructDef structDef;
        List attributeDefs;
        Preconditions.checkNotNull((Object)typeDef, (Object)"Cannot process null typedef");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting indexes for type {}", (Object)typeDef.getName());
        }
        if (typeDef instanceof AtlasStructDef && CollectionUtils.isNotEmpty((Collection)(attributeDefs = (structDef = (AtlasStructDef)typeDef).getAttributeDefs()))) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : attributeDefs) {
                this.deleteIndexForAttribute(management, typeDef.getName(), attributeDef);
            }
        }
        LOG.info("Completed deleting indexes for type {}", (Object)typeDef.getName());
    }

    private void createIndexForAttribute(AtlasGraphManagement management, AtlasStructDef structDef, AtlasStructDef.AtlasAttributeDef attributeDef) {
        String qualifiedName = AtlasStructType.AtlasAttribute.getQualifiedAttributeName((AtlasStructDef)structDef, (String)attributeDef.getName());
        String propertyName = AtlasStructType.AtlasAttribute.generateVertexPropertyName((AtlasStructDef)structDef, (AtlasStructDef.AtlasAttributeDef)attributeDef, (String)qualifiedName);
        AtlasCardinality cardinality = this.toAtlasCardinality(attributeDef.getCardinality());
        boolean isUnique = attributeDef.getIsUnique();
        boolean isIndexable = attributeDef.getIsIndexable();
        String attribTypeName = attributeDef.getTypeName();
        boolean isBuiltInType = AtlasTypeUtil.isBuiltInType((String)attribTypeName);
        boolean isArrayType = AtlasTypeUtil.isArrayType((String)attribTypeName);
        boolean isMapType = AtlasTypeUtil.isMapType((String)attribTypeName);
        String uniqPropName = isUnique ? AtlasGraphUtilsV2.encodePropertyKey(structDef.getName() + "." + "__u_" + attributeDef.getName()) : null;
        AtlasStructDef.AtlasAttributeDef.IndexType indexType = attributeDef.getIndexType();
        try {
            boolean isReference;
            AtlasType atlasType = this.typeRegistry.getType(structDef.getName());
            AtlasType attributeType = this.typeRegistry.getType(attribTypeName);
            if (this.isClassificationType(attributeType)) {
                LOG.warn("Ignoring non-indexable attribute {}", (Object)attribTypeName);
            }
            if (isArrayType) {
                this.createLabelIfNeeded(management, propertyName, attribTypeName);
                AtlasArrayType arrayType = (AtlasArrayType)attributeType;
                isReference = AtlasGraphUtilsV2.isReference(arrayType.getElementType());
                if (!isReference) {
                    this.createPropertyKey(management, propertyName, ArrayList.class, AtlasCardinality.SINGLE);
                }
            }
            if (isMapType) {
                this.createLabelIfNeeded(management, propertyName, attribTypeName);
                AtlasMapType mapType = (AtlasMapType)attributeType;
                isReference = AtlasGraphUtilsV2.isReference(mapType.getValueType());
                if (!isReference) {
                    this.createPropertyKey(management, propertyName, HashMap.class, AtlasCardinality.SINGLE);
                }
            }
            if (this.isEntityType(attributeType)) {
                this.createEdgeLabel(management, propertyName);
            } else if (isBuiltInType) {
                if (this.isRelationshipType(atlasType)) {
                    this.createEdgeIndex(management, propertyName, this.getPrimitiveClass(attribTypeName), cardinality, isIndexable);
                } else {
                    Class primitiveClassType = this.getPrimitiveClass(attribTypeName);
                    boolean isStringField = false;
                    if (primitiveClassType == String.class) {
                        isStringField = AtlasStructDef.AtlasAttributeDef.IndexType.STRING.equals((Object)indexType);
                    }
                    this.createVertexIndex(management, propertyName, UniqueKind.NONE, this.getPrimitiveClass(attribTypeName), cardinality, isIndexable, false, isStringField);
                    if (uniqPropName != null) {
                        this.createVertexIndex(management, uniqPropName, UniqueKind.PER_TYPE_UNIQUE, this.getPrimitiveClass(attribTypeName), cardinality, isIndexable, true, isStringField);
                    }
                }
            } else if (this.isEnumType(attributeType)) {
                if (this.isRelationshipType(atlasType)) {
                    this.createEdgeIndex(management, propertyName, String.class, cardinality, false);
                } else {
                    this.createVertexIndex(management, propertyName, UniqueKind.NONE, String.class, cardinality, isIndexable, false, false);
                    if (uniqPropName != null) {
                        this.createVertexIndex(management, uniqPropName, UniqueKind.PER_TYPE_UNIQUE, String.class, cardinality, isIndexable, true, false);
                    }
                }
            } else if (this.isStructType(attributeType)) {
                AtlasStructDef attribureStructDef = this.typeRegistry.getStructDefByName(attribTypeName);
                this.updateIndexForTypeDef(management, (AtlasBaseTypeDef)attribureStructDef);
            }
        }
        catch (AtlasBaseException e) {
            LOG.error("No type exists for {}", (Object)attribTypeName, (Object)e);
        }
    }

    private void deleteIndexForAttribute(AtlasGraphManagement management, String typeName, AtlasStructDef.AtlasAttributeDef attributeDef) {
        String propertyName = AtlasGraphUtilsV2.encodePropertyKey(typeName + "." + attributeDef.getName());
        try {
            if (management.containsPropertyKey(propertyName)) {
                LOG.info("Deleting propertyKey {}, for attribute {}.{}", new Object[]{propertyName, typeName, attributeDef.getName()});
                management.deletePropertyKey(propertyName);
            }
        }
        catch (Exception excp) {
            LOG.warn("Failed to delete propertyKey {}, for attribute {}.{}", new Object[]{propertyName, typeName, attributeDef.getName()});
        }
    }

    public static String getEncodedPropertyName(AtlasStructDef baseTypeDef, AtlasStructDef.AtlasAttributeDef attributeDef) {
        return AtlasStructType.AtlasAttribute.getQualifiedAttributeName((AtlasStructDef)baseTypeDef, (String)attributeDef.getName());
    }

    private void createLabelIfNeeded(AtlasGraphManagement management, String propertyName, String attribTypeName) {
        for (String typeName : AtlasTypeUtil.getReferencedTypeNames((String)attribTypeName)) {
            if (this.typeRegistry.getEntityDefByName(typeName) == null && this.typeRegistry.getStructDefByName(typeName) == null) continue;
            this.createEdgeLabel(management, propertyName);
        }
    }

    private boolean isEntityType(AtlasType type) {
        return type instanceof AtlasEntityType;
    }

    private boolean isClassificationType(AtlasType type) {
        return type instanceof AtlasClassificationType;
    }

    private boolean isEnumType(AtlasType type) {
        return type instanceof AtlasEnumType;
    }

    private boolean isStructType(AtlasType type) {
        return type instanceof AtlasStructType;
    }

    private boolean isRelationshipType(AtlasType type) {
        return type instanceof AtlasRelationshipType;
    }

    public Class getPrimitiveClass(String attribTypeName) {
        String attributeTypeName;
        switch (attributeTypeName = attribTypeName.toLowerCase()) {
            case "boolean": {
                return Boolean.class;
            }
            case "byte": {
                return Byte.class;
            }
            case "short": {
                return Short.class;
            }
            case "int": {
                return Integer.class;
            }
            case "long": 
            case "date": {
                return Long.class;
            }
            case "float": {
                return Float.class;
            }
            case "double": {
                return Double.class;
            }
            case "biginteger": {
                return BigInteger.class;
            }
            case "bigdecimal": {
                return BigDecimal.class;
            }
            case "string": {
                return String.class;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown primitive typename %s", attribTypeName));
    }

    public AtlasCardinality toAtlasCardinality(AtlasStructDef.AtlasAttributeDef.Cardinality cardinality) {
        switch (cardinality) {
            case SINGLE: {
                return AtlasCardinality.SINGLE;
            }
            case LIST: {
                return AtlasCardinality.LIST;
            }
            case SET: {
                return AtlasCardinality.SET;
            }
        }
        throw new IllegalArgumentException(String.format("Bad cardinality %s", cardinality));
    }

    private void createEdgeLabel(AtlasGraphManagement management, String propertyName) {
        String label = "__" + propertyName;
        this.createEdgeLabelUsingLabelName(management, label);
    }

    private void createEdgeLabelUsingLabelName(AtlasGraphManagement management, String label) {
        if (StringUtils.isEmpty((String)label)) {
            return;
        }
        AtlasEdgeLabel edgeLabel = management.getEdgeLabel(label);
        if (edgeLabel == null) {
            management.makeEdgeLabel(label);
            LOG.info("Created edge label {} ", (Object)label);
        }
    }

    private AtlasPropertyKey createPropertyKey(AtlasGraphManagement management, String propertyName, Class propertyClass, AtlasCardinality cardinality) {
        AtlasPropertyKey propertyKey = management.getPropertyKey(propertyName);
        if (propertyKey == null) {
            propertyKey = management.makePropertyKey(propertyName, propertyClass, cardinality);
        }
        return propertyKey;
    }

    public String createVertexIndex(AtlasGraphManagement management, String propertyName, UniqueKind uniqueKind, Class propertyClass, AtlasCardinality cardinality, boolean createCompositeIndex, boolean createCompositeIndexWithTypeAndSuperTypes, boolean isStringField) {
        String indexFieldName = null;
        if (propertyName != null) {
            AtlasPropertyKey propertyKey = management.getPropertyKey(propertyName);
            if (propertyKey == null) {
                propertyKey = management.makePropertyKey(propertyName, propertyClass, cardinality);
                if (this.isIndexApplicable(propertyClass, cardinality)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Creating backing index for vertex property {} of type {} ", (Object)propertyName, (Object)propertyClass.getName());
                    }
                    indexFieldName = management.addMixedIndex("vertex_index", propertyKey, isStringField);
                    LOG.info("Created backing index for vertex property {} of type {} ", (Object)propertyName, (Object)propertyClass.getName());
                }
            }
            if (indexFieldName == null && this.isIndexApplicable(propertyClass, cardinality)) {
                indexFieldName = management.getIndexFieldName("vertex_index", propertyKey, isStringField);
            }
            if (propertyKey != null) {
                if (createCompositeIndex || uniqueKind == UniqueKind.GLOBAL_UNIQUE || uniqueKind == UniqueKind.PER_TYPE_UNIQUE) {
                    this.createVertexCompositeIndex(management, propertyClass, propertyKey, uniqueKind == UniqueKind.GLOBAL_UNIQUE);
                }
                if (createCompositeIndexWithTypeAndSuperTypes) {
                    this.createVertexCompositeIndexWithTypeName(management, propertyClass, propertyKey, uniqueKind == UniqueKind.PER_TYPE_UNIQUE);
                    this.createVertexCompositeIndexWithSuperTypeName(management, propertyClass, propertyKey);
                }
            } else {
                LOG.warn("Index not created for {}: propertyKey is null", (Object)propertyName);
            }
        }
        return indexFieldName;
    }

    private void createVertexCentricIndex(AtlasGraphManagement management, String edgeLabel, AtlasEdgeDirection edgeDirection, String propertyName, Class propertyClass, AtlasCardinality cardinality) {
        String indexName;
        AtlasPropertyKey propertyKey = management.getPropertyKey(propertyName);
        if (propertyKey == null) {
            propertyKey = management.makePropertyKey(propertyName, propertyClass, cardinality);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating vertex-centric index for edge label: {} direction: {} for property: {} of type: {} ", new Object[]{edgeLabel, edgeDirection.name(), propertyName, propertyClass.getName()});
        }
        if (!management.edgeIndexExist(edgeLabel, indexName = edgeLabel + propertyKey.getName())) {
            management.createEdgeIndex(edgeLabel, indexName, edgeDirection, Collections.singletonList(propertyKey));
            LOG.info("Created vertex-centric index for edge label: {} direction: {} for property: {} of type: {}", new Object[]{edgeLabel, edgeDirection.name(), propertyName, propertyClass.getName()});
        }
    }

    private void createVertexCentricIndex(AtlasGraphManagement management, String edgeLabel, AtlasEdgeDirection edgeDirection, List<String> propertyNames) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating vertex-centric index for edge label: {} direction: {} for properties: {}", new Object[]{edgeLabel, edgeDirection.name(), propertyNames});
        }
        String indexName = edgeLabel;
        ArrayList<AtlasPropertyKey> propertyKeys = new ArrayList<AtlasPropertyKey>();
        for (String propertyName : propertyNames) {
            AtlasPropertyKey propertyKey = management.getPropertyKey(propertyName);
            if (propertyKey == null) continue;
            propertyKeys.add(propertyKey);
            indexName = indexName + propertyKey.getName();
        }
        if (!management.edgeIndexExist(edgeLabel, indexName) && CollectionUtils.isNotEmpty(propertyKeys)) {
            management.createEdgeIndex(edgeLabel, indexName, edgeDirection, propertyKeys);
            LOG.info("Created vertex-centric index for edge label: {} direction: {} for properties: {}", new Object[]{edgeLabel, edgeDirection.name(), propertyNames});
        }
    }

    public void createEdgeIndex(AtlasGraphManagement management, String propertyName, Class propertyClass, AtlasCardinality cardinality, boolean createCompositeIndex) {
        if (propertyName != null) {
            AtlasPropertyKey propertyKey = management.getPropertyKey(propertyName);
            if (propertyKey == null) {
                propertyKey = management.makePropertyKey(propertyName, propertyClass, cardinality);
                if (this.isIndexApplicable(propertyClass, cardinality)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Creating backing index for edge property {} of type {} ", (Object)propertyName, (Object)propertyClass.getName());
                    }
                    management.addMixedIndex("edge_index", propertyKey, false);
                    LOG.info("Created backing index for edge property {} of type {} ", (Object)propertyName, (Object)propertyClass.getName());
                }
            }
            if (propertyKey != null) {
                if (createCompositeIndex) {
                    this.createEdgeCompositeIndex(management, propertyClass, propertyKey);
                }
            } else {
                LOG.warn("Index not created for {}: propertyKey is null", (Object)propertyName);
            }
        }
    }

    private AtlasPropertyKey createFullTextIndex(AtlasGraphManagement management, String propertyName, Class propertyClass, AtlasCardinality cardinality) {
        AtlasPropertyKey propertyKey = management.getPropertyKey(propertyName);
        if (propertyKey == null) {
            propertyKey = management.makePropertyKey(propertyName, propertyClass, cardinality);
            if (this.isIndexApplicable(propertyClass, cardinality)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating backing index for vertex property {} of type {} ", (Object)propertyName, (Object)propertyClass.getName());
                }
                management.addMixedIndex("fulltext_index", propertyKey, false);
                LOG.info("Created backing index for vertex property {} of type {} ", (Object)propertyName, (Object)propertyClass.getName());
            }
            LOG.info("Created index {}", (Object)"fulltext_index");
        }
        return propertyKey;
    }

    private void createVertexCompositeIndex(AtlasGraphManagement management, Class propertyClass, AtlasPropertyKey propertyKey, boolean enforceUniqueness) {
        AtlasGraphIndex existingIndex;
        String propertyName = propertyKey.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating composite index for property {} of type {}; isUnique={} ", new Object[]{propertyName, propertyClass.getName(), enforceUniqueness});
        }
        if ((existingIndex = management.getGraphIndex(propertyName)) == null) {
            management.createVertexCompositeIndex(propertyName, enforceUniqueness, Collections.singletonList(propertyKey));
            LOG.info("Created composite index for property {} of type {}; isUnique={} ", new Object[]{propertyName, propertyClass.getName(), enforceUniqueness});
        }
    }

    private void createEdgeCompositeIndex(AtlasGraphManagement management, Class propertyClass, AtlasPropertyKey propertyKey) {
        AtlasGraphIndex existingIndex;
        String propertyName = propertyKey.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating composite index for property {} of type {}", (Object)propertyName, (Object)propertyClass.getName());
        }
        if ((existingIndex = management.getGraphIndex(propertyName)) == null) {
            management.createEdgeCompositeIndex(propertyName, false, Collections.singletonList(propertyKey));
            LOG.info("Created composite index for property {} of type {}", (Object)propertyName, (Object)propertyClass.getName());
        }
    }

    private void createVertexCompositeIndexWithTypeName(AtlasGraphManagement management, Class propertyClass, AtlasPropertyKey propertyKey, boolean isUnique) {
        this.createVertexCompositeIndexWithSystemProperty(management, propertyClass, propertyKey, Constants.ENTITY_TYPE_PROPERTY_KEY, AtlasCardinality.SINGLE, isUnique);
    }

    private void createVertexCompositeIndexWithSuperTypeName(AtlasGraphManagement management, Class propertyClass, AtlasPropertyKey propertyKey) {
        this.createVertexCompositeIndexWithSystemProperty(management, propertyClass, propertyKey, Constants.SUPER_TYPES_PROPERTY_KEY, AtlasCardinality.SET, false);
    }

    private void createVertexCompositeIndexWithSystemProperty(AtlasGraphManagement management, Class propertyClass, AtlasPropertyKey propertyKey, String systemPropertyKey, AtlasCardinality cardinality, boolean isUnique) {
        String indexName;
        AtlasGraphIndex existingIndex;
        AtlasPropertyKey typePropertyKey;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating composite index for property {} of type {} and {}", new Object[]{propertyKey.getName(), propertyClass.getName(), systemPropertyKey});
        }
        if ((typePropertyKey = management.getPropertyKey(systemPropertyKey)) == null) {
            typePropertyKey = management.makePropertyKey(systemPropertyKey, String.class, cardinality);
        }
        if ((existingIndex = management.getGraphIndex(indexName = propertyKey.getName() + systemPropertyKey)) == null) {
            ArrayList<AtlasPropertyKey> keys = new ArrayList<AtlasPropertyKey>(2);
            keys.add(typePropertyKey);
            keys.add(propertyKey);
            management.createVertexCompositeIndex(indexName, isUnique, keys);
            LOG.info("Created composite index for property {} of type {} and {}", new Object[]{propertyKey.getName(), propertyClass.getName(), systemPropertyKey});
        }
    }

    private boolean isIndexApplicable(Class propertyClass, AtlasCardinality cardinality) {
        return !INDEX_EXCLUSION_CLASSES.contains(propertyClass) && !cardinality.isMany();
    }

    public void commit(AtlasGraphManagement management) throws IndexException {
        try {
            management.commit();
            this.recomputeIndexedKeys = true;
        }
        catch (Exception e) {
            LOG.error("Index commit failed", (Throwable)e);
            throw new IndexException("Index commit failed ", e);
        }
    }

    public void rollback(AtlasGraphManagement management) throws IndexException {
        try {
            management.rollback();
            this.recomputeIndexedKeys = true;
        }
        catch (Exception e) {
            LOG.error("Index rollback failed ", (Throwable)e);
            throw new IndexException("Index rollback failed ", e);
        }
    }

    private void attemptRollback(ChangedTypeDefs changedTypeDefs, AtlasGraphManagement management) throws AtlasBaseException {
        if (null != management) {
            try {
                this.rollback(management);
            }
            catch (IndexException e) {
                LOG.error("Index rollback has failed", (Throwable)((Object)e));
                throw new AtlasBaseException(AtlasErrorCode.INDEX_ROLLBACK_FAILED, (Throwable)((Object)e), new String[]{changedTypeDefs.toString()});
            }
        }
    }

    private void updateIndexForTypeDef(AtlasGraphManagement management, AtlasBaseTypeDef typeDef) {
        Preconditions.checkNotNull((Object)typeDef, (Object)"Cannot index on null typedefs");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating indexes for type name={}, definition={}", (Object)typeDef.getName(), typeDef.getClass());
        }
        this.addIndexForType(management, typeDef);
        LOG.info("Index creation for type {} complete", (Object)typeDef.getName());
    }

    private void notifyChangeListeners(ChangedTypeDefs changedTypeDefs) {
        for (IndexChangeListener indexChangeListener : this.indexChangeListeners) {
            try {
                indexChangeListener.onChange(changedTypeDefs);
            }
            catch (Throwable t) {
                LOG.error("Error encountered in notifying the index change listener {}.", (Object)indexChangeListener.getClass().getName(), (Object)t);
                throw new RuntimeException("Error encountered in notifying the index change listener " + indexChangeListener.getClass().getName(), t);
            }
        }
    }

    private void notifyInitializationStart() {
        for (IndexChangeListener indexChangeListener : this.indexChangeListeners) {
            try {
                indexChangeListener.onInitStart();
            }
            catch (Throwable t) {
                LOG.error("Error encountered in notifying the index change listener {}.", (Object)indexChangeListener.getClass().getName(), (Object)t);
                throw new RuntimeException("Error encountered in notifying the index change listener " + indexChangeListener.getClass().getName(), t);
            }
        }
    }

    private void notifyInitializationCompletion(ChangedTypeDefs changedTypeDefs) {
        for (IndexChangeListener indexChangeListener : this.indexChangeListeners) {
            try {
                indexChangeListener.onInitCompletion(changedTypeDefs);
            }
            catch (Throwable t) {
                LOG.error("Error encountered in notifying the index change listener {}.", (Object)indexChangeListener.getClass().getName(), (Object)t);
                throw new RuntimeException("Error encountered in notifying the index change listener " + indexChangeListener.getClass().getName(), t);
            }
        }
    }

    private void createEdgeLabels(AtlasGraphManagement management, List<? extends AtlasBaseTypeDef> typeDefs) {
        if (CollectionUtils.isEmpty(typeDefs)) {
            return;
        }
        for (AtlasBaseTypeDef atlasBaseTypeDef : typeDefs) {
            if (atlasBaseTypeDef instanceof AtlasEntityDef) {
                AtlasEntityDef entityDef = (AtlasEntityDef)atlasBaseTypeDef;
                this.createEdgeLabelsForStruct(management, entityDef);
                continue;
            }
            if (!(atlasBaseTypeDef instanceof AtlasRelationshipDef)) continue;
            this.createEdgeLabels(management, (AtlasRelationshipDef)atlasBaseTypeDef);
        }
    }

    private void createEdgeLabelsForStruct(AtlasGraphManagement management, AtlasEntityDef entityDef) {
        try {
            AtlasType type = this.typeRegistry.getType(entityDef.getName());
            if (!(type instanceof AtlasEntityType)) {
                return;
            }
            AtlasEntityType entityType = (AtlasEntityType)type;
            for (AtlasStructDef.AtlasAttributeDef attributeDef : entityDef.getAttributeDefs()) {
                AtlasStructType.AtlasAttribute attribute = entityType.getAttribute(attributeDef.getName());
                if (attribute.getAttributeType().getTypeCategory() != TypeCategory.STRUCT) continue;
                String relationshipLabel = attribute.getRelationshipEdgeLabel();
                this.createEdgeLabelUsingLabelName(management, relationshipLabel);
            }
        }
        catch (AtlasBaseException e) {
            LOG.error("Error fetching type: {}", (Object)entityDef.getName(), (Object)e);
        }
    }

    private void createEdgeLabels(AtlasGraphManagement management, AtlasRelationshipDef relationshipDef) {
        String relationshipTypeName = relationshipDef.getName();
        AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName(relationshipTypeName);
        String relationshipLabel = relationshipType.getRelationshipLabel();
        this.createEdgeLabelUsingLabelName(management, relationshipLabel);
    }

    public static enum UniqueKind {
        NONE,
        GLOBAL_UNIQUE,
        PER_TYPE_UNIQUE;

    }
}

