/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.impexp.ExportService;
import org.apache.atlas.repository.impexp.ExtractStrategy;
import org.apache.atlas.repository.impexp.IncrementalExportEntityProvider;
import org.apache.atlas.repository.impexp.RelationshipAttributesExtractor;
import org.apache.atlas.repository.impexp.VertexExtractor;
import org.apache.atlas.type.AtlasTypeRegistry;

public class EntitiesExtractor {
    static final String PROPERTY_GUID = "__guid";
    private static final String VERTEX_BASED_EXTRACT = "default";
    private static final String INCREMENTAL_EXTRACT = "incremental";
    private static final String RELATION_BASED_EXTRACT = "relationship";
    private Map<String, ExtractStrategy> extractors = new HashMap<String, ExtractStrategy>();
    private ExtractStrategy extractor;

    public EntitiesExtractor(AtlasGraph atlasGraph, AtlasTypeRegistry typeRegistry) {
        this.extractors.put(VERTEX_BASED_EXTRACT, new VertexExtractor(atlasGraph, typeRegistry));
        this.extractors.put(INCREMENTAL_EXTRACT, new IncrementalExportEntityProvider(atlasGraph));
        this.extractors.put(RELATION_BASED_EXTRACT, new RelationshipAttributesExtractor(typeRegistry));
    }

    public void get(AtlasEntity entity, ExportService.ExportContext context) {
        if (this.extractor == null) {
            this.extractor = this.extractors.get(VERTEX_BASED_EXTRACT);
        }
        switch (context.fetchType) {
            case CONNECTED: {
                this.extractor.connectedFetch(entity, context);
                break;
            }
            case INCREMENTAL: {
                if (context.isHiveDBIncrementalSkipLineage()) {
                    this.extractors.get(INCREMENTAL_EXTRACT).fullFetch(entity, context);
                    break;
                }
                if (context.isHiveTableIncrementalSkipLineage()) {
                    this.extractors.get(INCREMENTAL_EXTRACT).connectedFetch(entity, context);
                    break;
                }
            }
            default: {
                this.extractor.fullFetch(entity, context);
            }
        }
    }

    public void setExtractor(AtlasEntityDef atlasEntityDef) {
        this.extractor = this.extractUsing(atlasEntityDef);
    }

    public void close() {
        for (ExtractStrategy es : this.extractors.values()) {
            es.close();
        }
    }

    private ExtractStrategy extractUsing(AtlasEntityDef atlasEntityDef) {
        return atlasEntityDef == null || atlasEntityDef.getRelationshipAttributeDefs().size() == 0 ? this.extractors.get(VERTEX_BASED_EXTRACT) : this.extractors.get(RELATION_BASED_EXTRACT);
    }
}

