/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.annotation.AtlasService;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.impexp.ExportImportAuditEntry;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.repository.ogm.DataAccess;
import org.apache.atlas.repository.ogm.ExportImportAuditEntryDTO;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@AtlasService
public class ExportImportAuditService {
    private static final Logger LOG = LoggerFactory.getLogger(ExportImportAuditService.class);
    private static final String ENTITY_TYPE_NAME = "__ExportImportAuditEntry";
    private final DataAccess dataAccess;
    private AtlasDiscoveryService discoveryService;

    @Inject
    public ExportImportAuditService(DataAccess dataAccess, AtlasDiscoveryService discoveryService) {
        this.dataAccess = dataAccess;
        this.discoveryService = discoveryService;
    }

    @GraphTransaction
    public void save(ExportImportAuditEntry entry) throws AtlasBaseException {
        this.dataAccess.saveNoLoad(entry);
    }

    public ExportImportAuditEntry get(ExportImportAuditEntry entry) throws AtlasBaseException {
        if (entry.getGuid() == null) {
            throw new AtlasBaseException("entity does not have GUID set. load cannot proceed.");
        }
        return this.dataAccess.load(entry);
    }

    public List<ExportImportAuditEntry> get(String userName, String operation, String cluster, String startTime, String endTime, int limit, int offset) throws AtlasBaseException {
        SearchParameters.FilterCriteria criteria = new SearchParameters.FilterCriteria();
        criteria.setCondition(SearchParameters.FilterCriteria.Condition.AND);
        criteria.setCriterion(new ArrayList());
        this.addSearchParameters(criteria, userName, operation, cluster, startTime, endTime);
        SearchParameters searchParameters = this.getSearchParameters(limit, offset, criteria);
        searchParameters.setAttributes(this.getAuditEntityAttributes());
        AtlasSearchResult result = this.discoveryService.searchWithParameters(searchParameters);
        return this.toExportImportAuditEntry(result);
    }

    private Set<String> getAuditEntityAttributes() {
        return ExportImportAuditEntryDTO.getAttributes();
    }

    private List<ExportImportAuditEntry> toExportImportAuditEntry(AtlasSearchResult result) {
        ArrayList<ExportImportAuditEntry> ret = new ArrayList<ExportImportAuditEntry>();
        if (CollectionUtils.isEmpty((Collection)result.getEntities())) {
            return ret;
        }
        for (AtlasEntityHeader entityHeader : result.getEntities()) {
            ExportImportAuditEntry entry = ExportImportAuditEntryDTO.from(entityHeader.getGuid(), entityHeader.getAttributes());
            if (entry == null) continue;
            ret.add(entry);
        }
        return ret;
    }

    private SearchParameters getSearchParameters(int limit, int offset, SearchParameters.FilterCriteria criteria) {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setTypeName(ENTITY_TYPE_NAME);
        searchParameters.setEntityFilters(criteria);
        searchParameters.setLimit(limit);
        searchParameters.setOffset(offset);
        return searchParameters;
    }

    private void addSearchParameters(SearchParameters.FilterCriteria criteria, String userName, String operation, String cluster, String startTime, String endTime) {
        this.addParameterIfValueNotEmpty(criteria, "userName", userName);
        this.addParameterIfValueNotEmpty(criteria, "operation", operation);
        this.addParameterIfValueNotEmpty(criteria, "operationStartTime", startTime);
        this.addParameterIfValueNotEmpty(criteria, "operationEndTime", endTime);
        this.addServerFilterCriteria(criteria, cluster);
    }

    private void addServerFilterCriteria(SearchParameters.FilterCriteria parentCriteria, String cluster) {
        if (StringUtils.isEmpty((String)cluster)) {
            return;
        }
        SearchParameters.FilterCriteria criteria = new SearchParameters.FilterCriteria();
        criteria.setCondition(SearchParameters.FilterCriteria.Condition.OR);
        criteria.setCriterion(new ArrayList());
        this.addParameterIfValueNotEmpty(criteria, "sourceServerName", cluster);
        this.addParameterIfValueNotEmpty(criteria, "targetServerName", cluster);
        parentCriteria.getCriterion().add(criteria);
    }

    private void addParameterIfValueNotEmpty(SearchParameters.FilterCriteria criteria, String attributeName, String value) {
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        SearchParameters.FilterCriteria filterCriteria = new SearchParameters.FilterCriteria();
        filterCriteria.setAttributeName(attributeName);
        filterCriteria.setAttributeValue(value);
        filterCriteria.setOperator(SearchParameters.Operator.EQ);
        criteria.getCriterion().add(filterCriteria);
    }

    public void add(String userName, String sourceCluster, String targetCluster, String operation, String result, long startTime, long endTime, boolean hasData) throws AtlasBaseException {
        if (!hasData) {
            return;
        }
        ExportImportAuditEntry entry = new ExportImportAuditEntry();
        entry.setUserName(userName);
        entry.setSourceServerName(sourceCluster);
        entry.setTargetServerName(targetCluster);
        entry.setOperation(operation);
        entry.setResultSummary(result);
        entry.setStartTime(startTime);
        entry.setEndTime(endTime);
        this.save(entry);
        LOG.info("addAuditEntry: user: {}, source: {}, target: {}, operation: {}", new Object[]{entry.getUserName(), entry.getSourceServerName(), entry.getTargetServerName(), entry.getOperation()});
    }
}

