/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.impexp.ImportTransformer;
import org.apache.atlas.repository.impexp.ImportTransforms;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ImportTransformsShaper {
    private static final Logger LOG = LoggerFactory.getLogger(ImportTransformsShaper.class);
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasTypeDefStore typeDefStore;

    @Inject
    public ImportTransformsShaper(AtlasTypeRegistry typeRegistry, AtlasTypeDefStore typeDefStore) {
        this.typeRegistry = typeRegistry;
        this.typeDefStore = typeDefStore;
    }

    public void shape(ImportTransforms importTransform, AtlasExportRequest request) throws AtlasBaseException {
        this.getCreateClassifications(importTransform, request);
        this.updateTransformsWithSubTypes(importTransform);
    }

    private void getCreateClassifications(ImportTransforms importTransform, AtlasExportRequest request) throws AtlasBaseException {
        Map<String, Map<String, List<ImportTransformer>>> mapMapList = importTransform.getTransforms();
        for (Map<String, List<ImportTransformer>> mapList : mapMapList.values()) {
            for (List<ImportTransformer> list : mapList.values()) {
                for (ImportTransformer importTransformer : list) {
                    if (!(importTransformer instanceof ImportTransformer.AddClassification)) continue;
                    ImportTransformer.AddClassification addClassification = (ImportTransformer.AddClassification)importTransformer;
                    this.addFilters(request, addClassification);
                    this.getCreateTag(addClassification.getClassificationName());
                }
            }
        }
    }

    private void addFilters(AtlasExportRequest request, ImportTransformer.AddClassification transformer) {
        for (AtlasObjectId objectId : request.getItemsToExport()) {
            transformer.addFilter(objectId);
        }
    }

    private void updateTransformsWithSubTypes(ImportTransforms importTransforms) {
        String[] transformTypes = importTransforms.getTypes().toArray(new String[importTransforms.getTypes().size()]);
        for (int i = 0; i < transformTypes.length; ++i) {
            String typeName = transformTypes[i];
            AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
            if (entityType == null) continue;
            importTransforms.addParentTransformsToSubTypes(typeName, entityType.getAllSubTypes());
        }
    }

    private String getCreateTag(String classificationName) throws AtlasBaseException {
        AtlasClassificationDef classificationDef = this.typeRegistry.getClassificationDefByName(classificationName);
        if (classificationDef != null) {
            return classificationName;
        }
        classificationDef = new AtlasClassificationDef(classificationName);
        AtlasTypesDef typesDef = new AtlasTypesDef();
        typesDef.setClassificationDefs(Collections.singletonList(classificationDef));
        this.typeDefStore.createTypesDef(typesDef);
        LOG.info("created classification: {}", (Object)classificationName);
        return classificationName;
    }
}

