/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.impexp.ExportService;
import org.apache.atlas.repository.impexp.ExtractStrategy;
import org.apache.atlas.repository.util.UniqueList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalExportEntityProvider
implements ExtractStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalExportEntityProvider.class);
    private static final String QUERY_PARAMETER_START_GUID = "startGuid";
    private static final String QUERY_PARAMETER_MODIFICATION_TIMESTAMP = "modificationTimestamp";
    private AtlasGraph atlasGraph;
    private static final String QUERY_DB = "g.V().has('__guid', startGuid)";
    private static final String QUERY_TABLE = "g.V().has('__guid', startGuid).in('__hive_table.db')";
    private static final String QUERY_SD = "g.V().has('__guid', startGuid).in('__hive_table.db').out('__hive_table.sd')";
    private static final String QUERY_COLUMN = "g.V().has('__guid', startGuid).in('__hive_table.db').out('__hive_table.columns')";
    private static final String TRANSFORM_CLAUSE = ".project('__guid').by('__guid').dedup().toList()";
    private static final String TIMESTAMP_CLAUSE = ".has('__modificationTimestamp', gt(modificationTimestamp))";
    private static final String QUERY_TABLE_DB = "g.V().has('__guid', startGuid).out('__hive_table.db')";
    private static final String QUERY_TABLE_SD = "g.V().has('__guid', startGuid).out('__hive_table.sd')";
    private static final String QUERY_TABLE_COLUMNS = "g.V().has('__guid', startGuid).out('__hive_table.columns')";
    private ScriptEngine scriptEngine;

    @Inject
    public IncrementalExportEntityProvider(AtlasGraph atlasGraph) {
        this.atlasGraph = atlasGraph;
        try {
            this.scriptEngine = atlasGraph.getGremlinScriptEngine();
        }
        catch (AtlasBaseException e) {
            LOG.error("Error instantiating script engine.", (Throwable)e);
        }
    }

    @Override
    public void fullFetch(AtlasEntity entity, ExportService.ExportContext context) {
        this.populate(entity.getGuid(), context.changeMarker, context.guidsToProcess);
    }

    @Override
    public void connectedFetch(AtlasEntity entity, ExportService.ExportContext context) {
        context.guidsToProcess.addAll(this.fetchGuids(entity.getGuid(), QUERY_TABLE_DB, context.changeMarker));
        context.guidsToProcess.addAll(this.fetchGuids(entity.getGuid(), QUERY_TABLE_SD, context.changeMarker));
        context.guidsToProcess.addAll(this.fetchGuids(entity.getGuid(), QUERY_TABLE_COLUMNS, context.changeMarker));
    }

    public void populate(String dbEntityGuid, long timeStamp, UniqueList<String> guidsToProcess) {
        if (timeStamp == 0L) {
            this.full(dbEntityGuid, guidsToProcess);
        } else {
            this.partial(dbEntityGuid, timeStamp, guidsToProcess);
        }
    }

    @Override
    public void close() {
        if (this.scriptEngine != null) {
            this.atlasGraph.releaseGremlinScriptEngine(this.scriptEngine);
        }
    }

    private void partial(String dbEntityGuid, long timeStamp, UniqueList<String> guidsToProcess) {
        guidsToProcess.addAll(this.fetchGuids(dbEntityGuid, QUERY_TABLE, timeStamp));
        guidsToProcess.addAll(this.fetchGuids(dbEntityGuid, QUERY_SD, timeStamp));
        guidsToProcess.addAll(this.fetchGuids(dbEntityGuid, QUERY_COLUMN, timeStamp));
    }

    private void full(String dbEntityGuid, UniqueList<String> guidsToProcess) {
        guidsToProcess.addAll(this.fetchGuids(dbEntityGuid, QUERY_TABLE, 0L));
    }

    private List<String> fetchGuids(final String dbEntityGuid, String query, long timeStamp) {
        HashMap<String, Object> bindings = new HashMap<String, Object>(){
            {
                this.put(IncrementalExportEntityProvider.QUERY_PARAMETER_START_GUID, dbEntityGuid);
            }
        };
        String queryWithClause = query;
        if (timeStamp > 0L) {
            bindings.put(QUERY_PARAMETER_MODIFICATION_TIMESTAMP, timeStamp);
            queryWithClause = queryWithClause.concat(TIMESTAMP_CLAUSE);
        }
        return this.executeGremlinQuery(queryWithClause, (Map<String, Object>)bindings);
    }

    private List<String> executeGremlinQuery(String query, Map<String, Object> bindings) {
        try {
            ArrayList<String> guids = new ArrayList<String>();
            String queryWithTransform = query + TRANSFORM_CLAUSE;
            List result = (List)this.atlasGraph.executeGremlinScript(this.scriptEngine, bindings, queryWithTransform, false);
            if (result == null) {
                return guids;
            }
            for (Map item : result) {
                guids.add((String)item.get("__guid"));
            }
            return guids;
        }
        catch (ScriptException e) {
            LOG.error("error executing query: {}: bindings: {}", new Object[]{query, bindings, e});
            return null;
        }
    }
}

