/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.annotation.AtlasService;
import org.apache.atlas.model.impexp.MigrationStatus;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graphdb.GraphDBMigrator;
import org.apache.atlas.repository.migration.DataMigrationStatusService;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtlasService
@Singleton
public class MigrationProgressService {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationProgressService.class);
    private static final String FILE_EXTENSION_ZIP = ".zip";
    public static final String MIGRATION_QUERY_CACHE_TTL = "atlas.migration.query.cache.ttlInSecs";
    @VisibleForTesting
    static long DEFAULT_CACHE_TTL_IN_SECS = 120000L;
    private final long cacheValidity;
    private final GraphDBMigrator migrator;
    private MigrationStatus cachedStatus;
    private long cacheExpirationTime = 0L;
    private DataMigrationStatusService dataMigrationStatusService;
    private boolean zipFileBasedMigrationImport;

    @Inject
    public MigrationProgressService(Configuration configuration, GraphDBMigrator migrator) {
        this.migrator = migrator;
        this.cacheValidity = configuration != null ? configuration.getLong(MIGRATION_QUERY_CACHE_TTL, DEFAULT_CACHE_TTL_IN_SECS) : DEFAULT_CACHE_TTL_IN_SECS;
        this.zipFileBasedMigrationImport = this.isZipFileBasedMigrationEnabled();
        this.initConditionallyZipFileBasedMigrator();
    }

    private void initConditionallyZipFileBasedMigrator() {
        if (!this.zipFileBasedMigrationImport) {
            return;
        }
        this.dataMigrationStatusService = new DataMigrationStatusService(AtlasGraphProvider.getGraphInstance());
        this.dataMigrationStatusService.init(this.getFileNameFromMigrationProperty());
    }

    private boolean isZipFileBasedMigrationEnabled() {
        return StringUtils.endsWithIgnoreCase((String)this.getFileNameFromMigrationProperty(), (String)FILE_EXTENSION_ZIP);
    }

    public MigrationStatus getStatus() {
        return this.fetchStatus();
    }

    private MigrationStatus fetchStatus() {
        long currentTime = System.currentTimeMillis();
        if (this.resetCache(currentTime)) {
            this.cachedStatus = this.zipFileBasedMigrationImport ? this.dataMigrationStatusService.getStatus() : this.migrator.getMigrationStatus();
        }
        return this.cachedStatus;
    }

    private boolean resetCache(long currentTime) {
        boolean ret;
        boolean bl = ret = this.cachedStatus == null || currentTime > this.cacheExpirationTime;
        if (ret) {
            this.cacheExpirationTime = currentTime + this.cacheValidity;
        }
        return ret;
    }

    public String getFileNameFromMigrationProperty() {
        try {
            return ApplicationProperties.get().getString("atlas.migration.data.filename", "");
        }
        catch (AtlasException e) {
            return "";
        }
    }
}

