/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.ogm;

import org.apache.atlas.model.AtlasBaseModelObject;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.ogm.DataTransferObject;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractDataTransferObject<T extends AtlasBaseModelObject>
implements DataTransferObject<T> {
    private final AtlasTypeRegistry typeRegistry;
    private final Class<T> objectType;
    private final String entityTypeName;

    protected AbstractDataTransferObject(AtlasTypeRegistry typeRegistry, Class<T> tClass) {
        this(typeRegistry, tClass, tClass.getSimpleName());
    }

    protected AbstractDataTransferObject(AtlasTypeRegistry typeRegistry, Class<T> tClass, String entityTypeName) {
        this.typeRegistry = typeRegistry;
        this.objectType = tClass;
        this.entityTypeName = entityTypeName;
    }

    @Override
    public Class getObjectType() {
        return this.objectType;
    }

    @Override
    public AtlasEntityType getEntityType() {
        AtlasEntityType ret = this.typeRegistry.getEntityTypeByName(this.entityTypeName);
        return ret;
    }

    protected AtlasEntity getDefaultAtlasEntity(T obj) {
        AtlasEntity ret = this.getEntityType().createDefaultValue();
        if (obj != null && StringUtils.isNotEmpty((CharSequence)obj.getGuid())) {
            ret.setGuid(obj.getGuid());
        }
        return ret;
    }

    public void setGuid(T o, AtlasEntity entity) {
        o.setGuid(entity.getGuid());
    }
}

