/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.ogm.glossary;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.atlas.model.AtlasBaseModelObject;
import org.apache.atlas.model.glossary.enums.AtlasTermRelationshipStatus;
import org.apache.atlas.model.glossary.relations.AtlasGlossaryHeader;
import org.apache.atlas.model.glossary.relations.AtlasRelatedCategoryHeader;
import org.apache.atlas.model.glossary.relations.AtlasRelatedTermHeader;
import org.apache.atlas.model.glossary.relations.AtlasTermCategorizationHeader;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.repository.ogm.AbstractDataTransferObject;
import org.apache.atlas.type.AtlasTypeRegistry;

public abstract class AbstractGlossaryDTO<T extends AtlasBaseModelObject>
extends AbstractDataTransferObject<T> {
    protected AbstractGlossaryDTO(AtlasTypeRegistry typeRegistry, Class<T> tClass) {
        super(typeRegistry, tClass);
    }

    protected AbstractGlossaryDTO(AtlasTypeRegistry typeRegistry, Class<T> tClass, String entityTypeName) {
        super(typeRegistry, tClass, entityTypeName);
    }

    protected AtlasRelatedTermHeader constructRelatedTermId(AtlasRelatedObjectId relatedObjectId) {
        AtlasRelatedTermHeader ret = new AtlasRelatedTermHeader();
        ret.setTermGuid(relatedObjectId.getGuid());
        ret.setRelationGuid(relatedObjectId.getRelationshipGuid());
        ret.setDisplayText(relatedObjectId.getDisplayText());
        AtlasStruct relationshipAttributes = relatedObjectId.getRelationshipAttributes();
        if (relationshipAttributes != null) {
            ret.setDescription((String)relationshipAttributes.getAttribute("description"));
            ret.setExpression((String)relationshipAttributes.getAttribute("expression"));
            ret.setSource((String)relationshipAttributes.getAttribute("source"));
            ret.setSteward((String)relationshipAttributes.getAttribute("steward"));
            Object status = relationshipAttributes.getAttribute("status");
            if (status instanceof String) {
                ret.setStatus(AtlasTermRelationshipStatus.valueOf((String)((String)status)));
            } else if (status instanceof AtlasTermRelationshipStatus) {
                ret.setStatus((AtlasTermRelationshipStatus)status);
            }
        }
        return ret;
    }

    protected AtlasRelatedObjectId termIdToRelatedObjectId(AtlasRelatedTermHeader relatedTermId) {
        AtlasRelatedObjectId ret = new AtlasRelatedObjectId();
        ret.setGuid(relatedTermId.getTermGuid());
        ret.setRelationshipGuid(relatedTermId.getRelationGuid());
        AtlasStruct relationshipAttributes = new AtlasStruct();
        relationshipAttributes.setAttribute("description", (Object)relatedTermId.getDescription());
        relationshipAttributes.setAttribute("expression", (Object)relatedTermId.getExpression());
        relationshipAttributes.setAttribute("source", (Object)relatedTermId.getSource());
        relationshipAttributes.setAttribute("steward", (Object)relatedTermId.getSteward());
        relationshipAttributes.setAttribute("status", (Object)relatedTermId.getStatus().name());
        ret.setRelationshipAttributes(relationshipAttributes);
        return ret;
    }

    protected AtlasRelatedCategoryHeader constructRelatedCategoryId(AtlasRelatedObjectId relatedObjectId) {
        AtlasRelatedCategoryHeader ret = new AtlasRelatedCategoryHeader();
        ret.setCategoryGuid(relatedObjectId.getGuid());
        ret.setRelationGuid(relatedObjectId.getRelationshipGuid());
        ret.setDisplayText(relatedObjectId.getDisplayText());
        AtlasStruct relationshipAttributes = relatedObjectId.getRelationshipAttributes();
        if (relationshipAttributes != null) {
            ret.setDescription((String)relationshipAttributes.getAttribute("description"));
            ret.setParentCategoryGuid(relationshipAttributes.getAttribute("parentCategoryGuid") == null ? null : (String)relationshipAttributes.getAttribute("parentCategoryGuid"));
        }
        return ret;
    }

    protected AtlasRelatedObjectId relatedCategoryIdToRelatedObjectId(AtlasRelatedCategoryHeader relatedCategoryId) {
        AtlasRelatedObjectId ret = new AtlasRelatedObjectId();
        ret.setGuid(relatedCategoryId.getCategoryGuid());
        ret.setRelationshipGuid(relatedCategoryId.getRelationGuid());
        AtlasStruct relationshipAttributes = new AtlasStruct();
        relationshipAttributes.setAttribute("description", (Object)relatedCategoryId.getDescription());
        ret.setRelationshipAttributes(relationshipAttributes);
        return ret;
    }

    protected AtlasGlossaryHeader constructGlossaryId(AtlasRelatedObjectId relatedObjectId) {
        AtlasGlossaryHeader ret = new AtlasGlossaryHeader();
        ret.setGlossaryGuid(relatedObjectId.getGuid());
        ret.setRelationGuid(relatedObjectId.getRelationshipGuid());
        return ret;
    }

    protected AtlasRelatedObjectId glossaryIdToRelatedObjectId(AtlasGlossaryHeader glossaryId) {
        AtlasRelatedObjectId ret = new AtlasRelatedObjectId();
        ret.setGuid(glossaryId.getGlossaryGuid());
        ret.setRelationshipGuid(glossaryId.getRelationGuid());
        return ret;
    }

    protected AtlasTermCategorizationHeader constructTermCategorizationId(AtlasRelatedObjectId category) {
        AtlasTermCategorizationHeader ret = new AtlasTermCategorizationHeader();
        ret.setCategoryGuid(category.getGuid());
        ret.setRelationGuid(category.getRelationshipGuid());
        AtlasStruct relationshipAttributes = category.getRelationshipAttributes();
        if (relationshipAttributes != null) {
            ret.setDescription((String)relationshipAttributes.getAttribute("description"));
            Object status = relationshipAttributes.getAttribute("status");
            if (status instanceof AtlasTermRelationshipStatus) {
                ret.setStatus((AtlasTermRelationshipStatus)status);
            } else if (status instanceof String) {
                ret.setStatus(AtlasTermRelationshipStatus.valueOf((String)((String)status)));
            }
        }
        return ret;
    }

    protected Set<AtlasRelatedTermHeader> toRelatedTermIdsSet(Object relatedObjectIds) {
        HashSet<AtlasRelatedTermHeader> ret = null;
        if (relatedObjectIds instanceof Collection) {
            ret = new HashSet<AtlasRelatedTermHeader>();
            for (Object t : (Collection)relatedObjectIds) {
                if (!(t instanceof AtlasRelatedObjectId)) continue;
                ret.add(this.constructRelatedTermId((AtlasRelatedObjectId)t));
            }
        }
        return ret;
    }
}

