/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.patches;

import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.patches.AtlasPatch;
import org.apache.atlas.repository.patches.AtlasPatchRegistry;

public abstract class AtlasPatchHandler {
    public static final String JAVA_PATCH_TYPE = "JAVA_PATCH";
    private final String patchId;
    private final String patchDescription;
    private final AtlasPatchRegistry patchRegistry;
    private AtlasPatch.PatchStatus status;

    public AtlasPatchHandler(AtlasPatchRegistry patchRegistry, String patchId, String patchDescription) {
        this.patchId = patchId;
        this.patchDescription = patchDescription;
        this.patchRegistry = patchRegistry;
        this.status = this.getStatusFromRegistry();
        this.register();
    }

    private void register() {
        AtlasPatch.PatchStatus patchStatus = this.getStatus();
        if (patchStatus == null || patchStatus == AtlasPatch.PatchStatus.UNKNOWN) {
            this.patchRegistry.register(this.patchId, this.patchDescription, JAVA_PATCH_TYPE, "apply", AtlasPatch.PatchStatus.UNKNOWN);
        }
    }

    public AtlasPatch.PatchStatus getStatusFromRegistry() {
        return this.patchRegistry.getStatus(this.patchId);
    }

    public AtlasPatch.PatchStatus getStatus() {
        return this.status;
    }

    public void setStatus(AtlasPatch.PatchStatus status) {
        this.status = status;
        this.patchRegistry.updateStatus(this.patchId, status);
    }

    public String getPatchId() {
        return this.patchId;
    }

    public abstract void apply() throws AtlasBaseException;
}

