/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.patches;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.atlas.model.patches.AtlasPatch;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.patches.AtlasPatchHandler;
import org.apache.atlas.repository.patches.ClassificationTextPatch;
import org.apache.atlas.repository.patches.FreeTextRequestHandlerPatch;
import org.apache.atlas.repository.patches.IndexConsistencyPatch;
import org.apache.atlas.repository.patches.PatchContext;
import org.apache.atlas.repository.patches.ProcessNamePatch;
import org.apache.atlas.repository.patches.ReIndexPatch;
import org.apache.atlas.repository.patches.RelationshipTypeNamePatch;
import org.apache.atlas.repository.patches.SuggestionsRequestHandlerPatch;
import org.apache.atlas.repository.patches.UniqueAttributePatch;
import org.apache.atlas.repository.patches.UpdateCompositeIndexStatusPatch;
import org.apache.atlas.repository.store.graph.v2.EntityGraphMapper;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AtlasPatchManager {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasPatchManager.class);
    private final List<AtlasPatchHandler> handlers = new ArrayList<AtlasPatchHandler>();
    private final AtlasGraph atlasGraph;
    private final AtlasTypeRegistry typeRegistry;
    private final GraphBackedSearchIndexer indexer;
    private final EntityGraphMapper entityGraphMapper;
    private PatchContext context;

    @Inject
    public AtlasPatchManager(AtlasGraph atlasGraph, AtlasTypeRegistry typeRegistry, GraphBackedSearchIndexer indexer, EntityGraphMapper entityGraphMapper) {
        this.atlasGraph = atlasGraph;
        this.typeRegistry = typeRegistry;
        this.indexer = indexer;
        this.entityGraphMapper = entityGraphMapper;
    }

    public AtlasPatch.AtlasPatches getAllPatches() {
        return this.context.getPatchRegistry().getAllPatches();
    }

    public void applyAll() {
        LOG.info("==> AtlasPatchManager.applyAll()");
        this.init();
        try {
            for (AtlasPatchHandler handler : this.handlers) {
                AtlasPatch.PatchStatus patchStatus = handler.getStatusFromRegistry();
                if (patchStatus == AtlasPatch.PatchStatus.APPLIED || patchStatus == AtlasPatch.PatchStatus.SKIPPED) {
                    LOG.info("Ignoring java handler: {}; status: {}", (Object)handler.getPatchId(), (Object)patchStatus);
                    continue;
                }
                LOG.info("Applying java handler: {}; status: {}", (Object)handler.getPatchId(), (Object)patchStatus);
                handler.apply();
            }
        }
        catch (Exception ex) {
            LOG.error("Error applying patches.", (Throwable)ex);
        }
        LOG.info("<== AtlasPatchManager.applyAll()");
    }

    private void init() {
        LOG.info("==> AtlasPatchManager.init()");
        this.context = new PatchContext(this.atlasGraph, this.typeRegistry, this.indexer, this.entityGraphMapper);
        this.handlers.add(new UniqueAttributePatch(this.context));
        this.handlers.add(new ClassificationTextPatch(this.context));
        this.handlers.add(new FreeTextRequestHandlerPatch(this.context));
        this.handlers.add(new SuggestionsRequestHandlerPatch(this.context));
        this.handlers.add(new IndexConsistencyPatch(this.context));
        this.handlers.add(new ReIndexPatch(this.context));
        this.handlers.add(new ProcessNamePatch(this.context));
        this.handlers.add(new UpdateCompositeIndexStatusPatch(this.context));
        this.handlers.add(new RelationshipTypeNamePatch(this.context));
        LOG.info("<== AtlasPatchManager.init()");
    }

    public void addPatchHandler(AtlasPatchHandler patchHandler) {
        this.handlers.add(patchHandler);
    }

    public PatchContext getContext() {
        return this.context;
    }
}

