/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.patches;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.pc.WorkItemBuilder;
import org.apache.atlas.pc.WorkItemConsumer;
import org.apache.atlas.pc.WorkItemManager;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.patches.PatchContext;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EdgePatchProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(EdgePatchProcessor.class);
    private static final String NUM_WORKERS_PROPERTY = "atlas.patch.numWorkers";
    private static final String BATCH_SIZE_PROPERTY = "atlas.patch.batchSize";
    private static final String ATLAS_SOLR_SHARDS = "ATLAS_SOLR_SHARDS";
    private static final String WORKER_NAME_PREFIX = "patchWorkItem";
    public static final int NUM_WORKERS;
    public static final int BATCH_SIZE;
    private final AtlasGraph graph;
    private final GraphBackedSearchIndexer indexer;
    private final AtlasTypeRegistry typeRegistry;

    public EdgePatchProcessor(PatchContext context) {
        this.graph = context.getGraph();
        this.indexer = context.getIndexer();
        this.typeRegistry = context.getTypeRegistry();
    }

    public AtlasGraph getGraph() {
        return this.graph;
    }

    public GraphBackedSearchIndexer getIndexer() {
        return this.indexer;
    }

    public AtlasTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public void apply() throws AtlasBaseException {
        this.prepareForExecution();
        this.execute();
    }

    protected abstract void prepareForExecution() throws AtlasBaseException;

    protected abstract void submitEdgesToUpdate(WorkItemManager var1);

    protected abstract void processEdgesItem(String var1, AtlasEdge var2, String var3, AtlasRelationshipType var4) throws AtlasBaseException;

    private void execute() {
        WorkItemManager manager = new WorkItemManager((WorkItemBuilder)new ConsumerBuilder(this.graph, this.typeRegistry, this), WORKER_NAME_PREFIX, BATCH_SIZE, NUM_WORKERS, false);
        try {
            this.submitEdgesToUpdate(manager);
            manager.drain();
        }
        finally {
            try {
                manager.shutdown();
            }
            catch (InterruptedException e) {
                LOG.error("EdgePatchProcessor.execute(): interrupted during WorkItemManager shutdown.", (Throwable)e);
            }
        }
    }

    static {
        int numWorkers = 3;
        int batchSize = 300;
        try {
            Configuration config = ApplicationProperties.get();
            numWorkers = config.getInt(NUM_WORKERS_PROPERTY, config.getInt(ATLAS_SOLR_SHARDS, 1) * 3);
            batchSize = config.getInt(BATCH_SIZE_PROPERTY, 300);
            LOG.info("EdgePatchProcessor: {}={}, {}={}", new Object[]{NUM_WORKERS_PROPERTY, numWorkers, BATCH_SIZE_PROPERTY, batchSize});
        }
        catch (Exception e) {
            LOG.error("Error retrieving configuration.", (Throwable)e);
        }
        NUM_WORKERS = numWorkers;
        BATCH_SIZE = batchSize;
    }

    private static class Consumer
    extends WorkItemConsumer<String> {
        private int MAX_COMMIT_RETRY_COUNT = 3;
        private final AtlasGraph graph;
        private final AtlasTypeRegistry typeRegistry;
        private final AtomicLong counter;
        private final EdgePatchProcessor individualItemProcessor;

        public Consumer(AtlasGraph graph, AtlasTypeRegistry typeRegistry, BlockingQueue<String> queue, EdgePatchProcessor individualItemProcessor) {
            super(queue);
            this.graph = graph;
            this.typeRegistry = typeRegistry;
            this.counter = new AtomicLong(0L);
            this.individualItemProcessor = individualItemProcessor;
        }

        protected void doCommit() {
            if (this.counter.get() % (long)BATCH_SIZE == 0L) {
                LOG.info("Processed: {}", (Object)this.counter.get());
                this.attemptCommit();
            }
        }

        protected void commitDirty() {
            this.attemptCommit();
            LOG.info("Total: Commit: {}", (Object)this.counter.get());
            super.commitDirty();
        }

        private void attemptCommit() {
            for (int retryCount = 1; retryCount <= this.MAX_COMMIT_RETRY_COUNT; ++retryCount) {
                try {
                    this.graph.commit();
                    break;
                }
                catch (Exception ex) {
                    LOG.error("Commit exception: ", (Object)retryCount, (Object)ex);
                    try {
                        Thread.currentThread();
                        Thread.sleep(300 * retryCount);
                    }
                    catch (InterruptedException e) {
                        LOG.error("Commit exception: Pause: Interrputed!", (Throwable)e);
                    }
                    continue;
                }
            }
        }

        protected void processItem(String edgeId) {
            this.counter.incrementAndGet();
            AtlasEdge edge = this.graph.getEdge(edgeId);
            if (edge == null) {
                LOG.warn("processItem(edgeId={}): AtlasEdge not found!", (Object)edgeId);
                return;
            }
            String typeName = (String)edge.getProperty(Constants.ENTITY_TYPE_PROPERTY_KEY, String.class);
            AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName(typeName);
            if (relationshipType == null) {
                return;
            }
            try {
                this.individualItemProcessor.processEdgesItem(edgeId, edge, typeName, relationshipType);
                this.doCommit();
            }
            catch (AtlasBaseException e) {
                LOG.error("Error processing: {}", (Object)edgeId, (Object)e);
            }
        }
    }

    private static class ConsumerBuilder
    implements WorkItemBuilder<Consumer, String> {
        private final AtlasTypeRegistry typeRegistry;
        private final AtlasGraph graph;
        private final EdgePatchProcessor patchItemProcessor;

        public ConsumerBuilder(AtlasGraph graph, AtlasTypeRegistry typeRegistry, EdgePatchProcessor patchItemProcessor) {
            this.graph = graph;
            this.typeRegistry = typeRegistry;
            this.patchItemProcessor = patchItemProcessor;
        }

        public Consumer build(BlockingQueue<String> queue) {
            return new Consumer(this.graph, this.typeRegistry, queue, this.patchItemProcessor);
        }
    }
}

