/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.patches;

import java.util.Collection;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.patches.AtlasPatch;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.pc.WorkItemManager;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.IndexException;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graphdb.AtlasCardinality;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphManagement;
import org.apache.atlas.repository.graphdb.AtlasSchemaViolationException;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.patches.AtlasPatchHandler;
import org.apache.atlas.repository.patches.ConcurrentPatchProcessor;
import org.apache.atlas.repository.patches.PatchContext;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueAttributePatch
extends AtlasPatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UniqueAttributePatch.class);
    private static final String PATCH_ID = "JAVA_PATCH_0000_001";
    private static final String PATCH_DESCRIPTION = "Add __u_ property for each unique attribute of active entities";
    private final PatchContext context;

    public UniqueAttributePatch(PatchContext context) {
        super(context.getPatchRegistry(), PATCH_ID, PATCH_DESCRIPTION);
        this.context = context;
    }

    @Override
    public void apply() throws AtlasBaseException {
        UniqueAttributePatchProcessor patchProcessor = new UniqueAttributePatchProcessor(this.context);
        patchProcessor.apply();
        this.setStatus(AtlasPatch.PatchStatus.APPLIED);
        LOG.info("UniqueAttributePatch.apply(): patchId={}, status={}", (Object)this.getPatchId(), (Object)this.getStatus());
    }

    public static class UniqueAttributePatchProcessor
    extends ConcurrentPatchProcessor {
        public UniqueAttributePatchProcessor(PatchContext context) {
            super(context);
        }

        @Override
        protected void prepareForExecution() {
            this.createIndexForUniqueAttributes();
        }

        @Override
        public void submitVerticesToUpdate(WorkItemManager manager) {
            AtlasTypeRegistry typeRegistry = this.getTypeRegistry();
            AtlasGraph graph = this.getGraph();
            for (AtlasEntityType entityType : typeRegistry.getAllEntityTypes()) {
                LOG.info("finding entities of type {}", (Object)entityType.getTypeName());
                Iterable iterable = graph.query().has(Constants.ENTITY_TYPE_PROPERTY_KEY, (Object)entityType.getTypeName()).vertexIds();
                int count = 0;
                for (Object vertexId : iterable) {
                    manager.checkProduce((Object)((Long)vertexId));
                    ++count;
                }
                LOG.info("found {} entities of type {}", (Object)count, (Object)entityType.getTypeName());
            }
        }

        @Override
        protected void processVertexItem(Long vertexId, AtlasVertex vertex, String typeName, AtlasEntityType entityType) {
            this.processItem(vertexId, vertex, typeName, entityType);
        }

        private void createIndexForUniqueAttributes() {
            for (AtlasEntityType entityType : this.getTypeRegistry().getAllEntityTypes()) {
                String typeName = entityType.getTypeName();
                Collection<AtlasStructType.AtlasAttribute> uniqAttributes = entityType.getUniqAttributes().values();
                if (CollectionUtils.isEmpty(uniqAttributes)) {
                    LOG.info("UniqueAttributePatchProcessor.apply(): no unique attribute for entity-type {}", (Object)typeName);
                    continue;
                }
                this.createIndexForUniqueAttributes(typeName, uniqAttributes);
            }
        }

        private void createIndexForUniqueAttributes(String typeName, Collection<AtlasStructType.AtlasAttribute> attributes) {
            try {
                AtlasGraphManagement management = this.getGraph().getManagementSystem();
                for (AtlasStructType.AtlasAttribute attribute : attributes) {
                    String uniquePropertyName = attribute.getVertexUniquePropertyName();
                    if (management.getPropertyKey(uniquePropertyName) != null) continue;
                    AtlasStructDef.AtlasAttributeDef attributeDef = attribute.getAttributeDef();
                    boolean isIndexable = attributeDef.getIsIndexable();
                    String attribTypeName = attributeDef.getTypeName();
                    Class propertyClass = this.getIndexer().getPrimitiveClass(attribTypeName);
                    AtlasCardinality cardinality = this.getIndexer().toAtlasCardinality(attributeDef.getCardinality());
                    this.getIndexer().createVertexIndex(management, uniquePropertyName, GraphBackedSearchIndexer.UniqueKind.PER_TYPE_UNIQUE, propertyClass, cardinality, isIndexable, true, AtlasStructDef.AtlasAttributeDef.IndexType.STRING.equals((Object)attribute.getIndexType()));
                }
                this.getIndexer().commit(management);
                this.getGraph().commit();
                LOG.info("Unique attributes: type: {}: Registered!", (Object)typeName);
            }
            catch (IndexException e) {
                LOG.error("Error creating index: type: {}", (Object)typeName, (Object)e);
            }
        }

        protected void processItem(Long vertexId, AtlasVertex vertex, String typeName, AtlasEntityType entityType) {
            LOG.debug("processItem(typeName={}, vertexId={})", (Object)typeName, (Object)vertexId);
            this.processIndexStringAttribute(vertexId, vertex, typeName, entityType);
            if (AtlasGraphUtilsV2.getState((AtlasElement)vertex) == AtlasEntity.Status.ACTIVE) {
                this.processUniqueAttribute(vertexId, vertex, typeName, entityType);
            }
            LOG.debug("processItem(typeName={}, vertexId={}): Done!", (Object)typeName, (Object)vertexId);
        }

        private void processIndexStringAttribute(Long vertexId, AtlasVertex vertex, String typeName, AtlasEntityType entityType) {
            for (AtlasStructType.AtlasAttribute attribute : entityType.getAllAttributes().values()) {
                String attrVal;
                String vertexPropertyName;
                if (attribute.getAttributeDef().getIndexType() == null || attribute.getAttributeDef().getIndexType() != AtlasStructDef.AtlasAttributeDef.IndexType.STRING || vertex.getProperty(vertexPropertyName = attribute.getVertexPropertyName(), String.class) != null || (attrVal = AtlasGraphUtilsV2.getEncodedProperty(vertex, attribute.getQualifiedName(), String.class)) == null) continue;
                AtlasGraphUtilsV2.setEncodedProperty(vertex, vertexPropertyName, attrVal);
            }
            LOG.debug("processIndexStringAttribute(typeName={}, vertexId={}): Done!", (Object)typeName, (Object)vertexId);
        }

        private void processUniqueAttribute(Long vertexId, AtlasVertex vertex, String typeName, AtlasEntityType entityType) {
            for (AtlasStructType.AtlasAttribute attribute : entityType.getUniqAttributes().values()) {
                String uniquePropertyKey = attribute.getVertexUniquePropertyName();
                Collection propertyKeys = vertex.getPropertyKeys();
                Object uniqAttrValue = null;
                if (propertyKeys != null && propertyKeys.contains(uniquePropertyKey)) continue;
                try {
                    String propertyKey = attribute.getVertexPropertyName();
                    uniqAttrValue = EntityGraphRetriever.mapVertexToPrimitive((AtlasElement)vertex, propertyKey, attribute.getAttributeDef());
                    AtlasGraphUtilsV2.setEncodedProperty(vertex, uniquePropertyKey, uniqAttrValue);
                }
                catch (AtlasSchemaViolationException ex) {
                    LOG.error("Duplicates detected: {}:{}:{}", new Object[]{typeName, uniqAttrValue, AtlasGraphUtilsV2.getIdFromVertex(vertex)});
                    vertex.removeProperty(uniquePropertyKey);
                }
            }
            LOG.debug("processUniqueAttribute(typeName={}, vertexId={}): Done!", (Object)typeName, (Object)vertexId);
        }
    }
}

