/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.bootstrap;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.AtlasException;
import org.apache.atlas.RequestContext;
import org.apache.atlas.authorize.AtlasAuthorizerFactory;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.ha.HAConfiguration;
import org.apache.atlas.listener.ActiveStateChangeHandler;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.patches.AtlasPatch;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasRelationshipEndDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.patches.AddMandatoryAttributesPatch;
import org.apache.atlas.repository.patches.AtlasPatchManager;
import org.apache.atlas.repository.patches.AtlasPatchRegistry;
import org.apache.atlas.repository.patches.SuperTypesUpdatePatch;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=2)
public class AtlasTypeDefStoreInitializer
implements ActiveStateChangeHandler {
    public static final Logger LOG = LoggerFactory.getLogger(AtlasTypeDefStoreInitializer.class);
    public static final String PATCHES_FOLDER_NAME = "patches";
    public static final String RELATIONSHIP_LABEL = "relationshipLabel";
    public static final String RELATIONSHIP_CATEGORY = "relationshipCategory";
    public static final String RELATIONSHIP_SWAP_ENDS = "swapEnds";
    public static final String TYPEDEF_PATCH_TYPE = "TYPEDEF_PATCH";
    private final AtlasTypeDefStore typeDefStore;
    private final AtlasTypeRegistry typeRegistry;
    private final Configuration conf;
    private final AtlasGraph graph;
    private final AtlasPatchManager patchManager;

    @Inject
    public AtlasTypeDefStoreInitializer(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry, AtlasGraph graph, Configuration conf, AtlasPatchManager patchManager) {
        this.typeDefStore = typeDefStore;
        this.typeRegistry = typeRegistry;
        this.conf = conf;
        this.graph = graph;
        this.patchManager = patchManager;
    }

    @PostConstruct
    public void init() {
        LOG.info("==> AtlasTypeDefStoreInitializer.init()");
        if (!HAConfiguration.isHAEnabled((Configuration)this.conf)) {
            this.startInternal();
        } else {
            LOG.info("AtlasTypeDefStoreInitializer.init(): deferring type loading until instance activation");
        }
        LOG.info("<== AtlasTypeDefStoreInitializer.init()");
    }

    private void loadBootstrapTypeDefs() {
        LOG.info("==> AtlasTypeDefStoreInitializer.loadBootstrapTypeDefs()");
        String atlasHomeDir = System.getProperty("atlas.home");
        String modelsDirName = (StringUtils.isEmpty((CharSequence)atlasHomeDir) ? "." : atlasHomeDir) + File.separator + "models";
        if (modelsDirName == null || modelsDirName.length() == 0) {
            LOG.info("Types directory {} does not exist or not readable or has no typedef files", (Object)modelsDirName);
        } else {
            File topModeltypesDir = new File(modelsDirName);
            Object[] modelsDirContents = topModeltypesDir.exists() ? topModeltypesDir.listFiles() : null;
            AtlasPatchRegistry patchRegistry = new AtlasPatchRegistry(this.graph);
            if (modelsDirContents != null && modelsDirContents.length > 0) {
                Arrays.sort(modelsDirContents);
                for (Object folder : modelsDirContents) {
                    if (((File)folder).isFile() || ((File)folder).getName().equals(PATCHES_FOLDER_NAME)) continue;
                    this.loadModelsInFolder((File)folder, patchRegistry);
                }
            }
            this.loadModelsInFolder(topModeltypesDir, patchRegistry);
        }
        LOG.info("<== AtlasTypeDefStoreInitializer.loadBootstrapTypeDefs()");
    }

    private void loadModelsInFolder(File typesDir, AtlasPatchRegistry patchRegistry) {
        Object[] typeDefFiles;
        LOG.info("==> AtlasTypeDefStoreInitializer({})", (Object)typesDir);
        String typesDirName = typesDir.getName();
        Object[] objectArray = typeDefFiles = typesDir.exists() ? typesDir.listFiles() : null;
        if (typeDefFiles == null || typeDefFiles.length == 0) {
            LOG.info("Types directory {} does not exist or not readable or has no typedef files", (Object)typesDirName);
        } else {
            Arrays.sort(typeDefFiles);
            for (Object typeDefFile : typeDefFiles) {
                if (!((File)typeDefFile).isFile()) continue;
                try {
                    String jsonStr = new String(Files.readAllBytes(((File)typeDefFile).toPath()), StandardCharsets.UTF_8);
                    AtlasTypesDef typesDef = (AtlasTypesDef)AtlasType.fromJson((String)jsonStr, AtlasTypesDef.class);
                    if (typesDef == null || typesDef.isEmpty()) {
                        LOG.info("No type in file {}", (Object)((File)typeDefFile).getAbsolutePath());
                        continue;
                    }
                    AtlasTypesDef typesToCreate = AtlasTypeDefStoreInitializer.getTypesToCreate(typesDef, this.typeRegistry);
                    AtlasTypesDef typesToUpdate = AtlasTypeDefStoreInitializer.getTypesToUpdate(typesDef, this.typeRegistry, true);
                    if (!typesToCreate.isEmpty() || !typesToUpdate.isEmpty()) {
                        this.typeDefStore.createUpdateTypesDef(typesToCreate, typesToUpdate);
                        LOG.info("Created/Updated types defined in file {}", (Object)((File)typeDefFile).getAbsolutePath());
                        continue;
                    }
                    LOG.info("No new type in file {}", (Object)((File)typeDefFile).getAbsolutePath());
                }
                catch (Throwable t) {
                    LOG.error("error while registering types in file {}", (Object)((File)typeDefFile).getAbsolutePath(), (Object)t);
                }
            }
            this.applyTypePatches(typesDir.getPath(), patchRegistry);
        }
        LOG.info("<== AtlasTypeDefStoreInitializer({})", (Object)typesDir);
    }

    public static AtlasTypesDef getTypesToCreate(AtlasTypesDef typesDef, AtlasTypeRegistry typeRegistry) {
        AtlasTypesDef typesToCreate = new AtlasTypesDef();
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getEnumDefs())) {
            for (AtlasEnumDef enumDef : typesDef.getEnumDefs()) {
                if (typeRegistry.isRegisteredType(enumDef.getName())) continue;
                typesToCreate.getEnumDefs().add(enumDef);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getStructDefs())) {
            for (AtlasStructDef structDef : typesDef.getStructDefs()) {
                if (typeRegistry.isRegisteredType(structDef.getName())) continue;
                typesToCreate.getStructDefs().add(structDef);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getClassificationDefs())) {
            for (AtlasClassificationDef classificationDef : typesDef.getClassificationDefs()) {
                if (typeRegistry.isRegisteredType(classificationDef.getName())) continue;
                typesToCreate.getClassificationDefs().add(classificationDef);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getEntityDefs())) {
            for (AtlasEntityDef entityDef : typesDef.getEntityDefs()) {
                if (typeRegistry.isRegisteredType(entityDef.getName())) continue;
                typesToCreate.getEntityDefs().add(entityDef);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getRelationshipDefs())) {
            for (AtlasRelationshipDef relationshipDef : typesDef.getRelationshipDefs()) {
                if (typeRegistry.isRegisteredType(relationshipDef.getName())) continue;
                typesToCreate.getRelationshipDefs().add(relationshipDef);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getBusinessMetadataDefs())) {
            for (AtlasBusinessMetadataDef businessMetadataDef : typesDef.getBusinessMetadataDefs()) {
                if (typeRegistry.isRegisteredType(businessMetadataDef.getName())) continue;
                typesToCreate.getBusinessMetadataDefs().add(businessMetadataDef);
            }
        }
        return typesToCreate;
    }

    public static AtlasTypesDef getTypesToUpdate(AtlasTypesDef typesDef, AtlasTypeRegistry typeRegistry, boolean checkTypeVersion) {
        AtlasTypesDef typesToUpdate = new AtlasTypesDef();
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getStructDefs())) {
            for (AtlasStructDef newStructDef : typesDef.getStructDefs()) {
                AtlasStructDef oldStructDef = typeRegistry.getStructDefByName(newStructDef.getName());
                if (oldStructDef == null || !AtlasTypeDefStoreInitializer.updateTypeAttributes(oldStructDef, newStructDef, checkTypeVersion)) continue;
                typesToUpdate.getStructDefs().add(newStructDef);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getClassificationDefs())) {
            for (AtlasClassificationDef newClassifDef : typesDef.getClassificationDefs()) {
                AtlasClassificationDef oldClassifDef = typeRegistry.getClassificationDefByName(newClassifDef.getName());
                if (oldClassifDef == null || !AtlasTypeDefStoreInitializer.updateTypeAttributes((AtlasStructDef)oldClassifDef, (AtlasStructDef)newClassifDef, checkTypeVersion)) continue;
                typesToUpdate.getClassificationDefs().add(newClassifDef);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getEntityDefs())) {
            for (AtlasEntityDef newEntityDef : typesDef.getEntityDefs()) {
                AtlasEntityDef oldEntityDef = typeRegistry.getEntityDefByName(newEntityDef.getName());
                if (oldEntityDef == null || !AtlasTypeDefStoreInitializer.updateTypeAttributes((AtlasStructDef)oldEntityDef, (AtlasStructDef)newEntityDef, checkTypeVersion)) continue;
                typesToUpdate.getEntityDefs().add(newEntityDef);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getEnumDefs())) {
            for (AtlasEnumDef newEnumDef : typesDef.getEnumDefs()) {
                AtlasEnumDef oldEnumDef = typeRegistry.getEnumDefByName(newEnumDef.getName());
                if (oldEnumDef == null || !AtlasTypeDefStoreInitializer.isTypeUpdateApplicable((AtlasBaseTypeDef)oldEnumDef, (AtlasBaseTypeDef)newEnumDef, checkTypeVersion)) continue;
                if (CollectionUtils.isNotEmpty((Collection)oldEnumDef.getElementDefs())) {
                    for (AtlasEnumDef.AtlasEnumElementDef oldEnumElem : oldEnumDef.getElementDefs()) {
                        if (newEnumDef.hasElement(oldEnumElem.getValue())) continue;
                        newEnumDef.addElement(oldEnumElem);
                    }
                }
                typesToUpdate.getEnumDefs().add(newEnumDef);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getRelationshipDefs())) {
            for (AtlasRelationshipDef relationshipDef : typesDef.getRelationshipDefs()) {
                AtlasRelationshipDef oldRelationshipDef = typeRegistry.getRelationshipDefByName(relationshipDef.getName());
                if (oldRelationshipDef == null || !AtlasTypeDefStoreInitializer.updateTypeAttributes((AtlasStructDef)oldRelationshipDef, (AtlasStructDef)relationshipDef, checkTypeVersion)) continue;
                typesToUpdate.getRelationshipDefs().add(relationshipDef);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getBusinessMetadataDefs())) {
            for (AtlasBusinessMetadataDef businessMetadataDef : typesDef.getBusinessMetadataDefs()) {
                AtlasBusinessMetadataDef oldDef = typeRegistry.getBusinessMetadataDefByName(businessMetadataDef.getName());
                if (oldDef == null || !AtlasTypeDefStoreInitializer.updateTypeAttributes((AtlasStructDef)oldDef, (AtlasStructDef)businessMetadataDef, checkTypeVersion)) continue;
                typesToUpdate.getBusinessMetadataDefs().add(businessMetadataDef);
            }
        }
        return typesToUpdate;
    }

    public void instanceIsActive() {
        LOG.info("==> AtlasTypeDefStoreInitializer.instanceIsActive()");
        this.startInternal();
        LOG.info("<== AtlasTypeDefStoreInitializer.instanceIsActive()");
    }

    private void startInternal() {
        try {
            this.typeDefStore.init();
            this.loadBootstrapTypeDefs();
            this.typeDefStore.notifyLoadCompletion();
            try {
                AtlasAuthorizerFactory.getAtlasAuthorizer();
            }
            catch (Throwable t) {
                LOG.error("AtlasTypeDefStoreInitializer.instanceIsActive(): Unable to obtain AtlasAuthorizer", t);
            }
        }
        catch (AtlasBaseException e) {
            LOG.error("Failed to init after becoming active", (Throwable)e);
        }
        finally {
            RequestContext.clear();
        }
    }

    public void instanceIsPassive() throws AtlasException {
        LOG.info("==> AtlasTypeDefStoreInitializer.instanceIsPassive()");
        LOG.info("<== AtlasTypeDefStoreInitializer.instanceIsPassive()");
    }

    public int getHandlerOrder() {
        return ActiveStateChangeHandler.HandlerOrder.TYPEDEF_STORE_INITIALIZER.getOrder();
    }

    private static boolean updateTypeAttributes(AtlasStructDef oldStructDef, AtlasStructDef newStructDef, boolean checkTypeVersion) {
        boolean ret = AtlasTypeDefStoreInitializer.isTypeUpdateApplicable((AtlasBaseTypeDef)oldStructDef, (AtlasBaseTypeDef)newStructDef, checkTypeVersion);
        if (ret && CollectionUtils.isNotEmpty((Collection)oldStructDef.getAttributeDefs())) {
            for (AtlasStructDef.AtlasAttributeDef oldAttrDef : oldStructDef.getAttributeDefs()) {
                if (newStructDef.hasAttribute(oldAttrDef.getName())) continue;
                newStructDef.addAttribute(oldAttrDef);
            }
        }
        return ret;
    }

    private static boolean isTypeUpdateApplicable(AtlasBaseTypeDef oldTypeDef, AtlasBaseTypeDef newTypeDef, boolean checkVersion) {
        boolean ret = true;
        if (checkVersion) {
            String oldTypeVersion = oldTypeDef.getTypeVersion();
            String newTypeVersion = newTypeDef.getTypeVersion();
            ret = ObjectUtils.compare((Comparable)((Object)newTypeVersion), (Comparable)((Object)oldTypeVersion)) > 0;
        }
        return ret;
    }

    private void applyTypePatches(String typesDirName, AtlasPatchRegistry patchRegistry) {
        Object[] typePatchFiles;
        String typePatchesDirName = typesDirName + File.separator + PATCHES_FOLDER_NAME;
        File typePatchesDir = new File(typePatchesDirName);
        Object[] objectArray = typePatchFiles = typePatchesDir.exists() ? typePatchesDir.listFiles() : null;
        if (typePatchFiles == null || typePatchFiles.length == 0) {
            LOG.info("Type patches directory {} does not exist or not readable or has no patches", (Object)typePatchesDirName);
        } else {
            LOG.info("Type patches directory {} is being processed", (Object)typePatchesDirName);
            Arrays.sort(typePatchFiles);
            PatchHandler[] patchHandlers = new PatchHandler[]{new UpdateEnumDefPatchHandler(this.typeDefStore, this.typeRegistry), new AddAttributePatchHandler(this.typeDefStore, this.typeRegistry), new UpdateAttributePatchHandler(this.typeDefStore, this.typeRegistry), new RemoveLegacyRefAttributesPatchHandler(this.typeDefStore, this.typeRegistry), new UpdateTypeDefOptionsPatchHandler(this.typeDefStore, this.typeRegistry), new SetServiceTypePatchHandler(this.typeDefStore, this.typeRegistry), new UpdateAttributeMetadataHandler(this.typeDefStore, this.typeRegistry), new AddSuperTypePatchHandler(this.typeDefStore, this.typeRegistry), new AddMandatoryAttributePatchHandler(this.typeDefStore, this.typeRegistry)};
            HashMap<String, PatchHandler> patchHandlerRegistry = new HashMap<String, PatchHandler>();
            for (PatchHandler patchHandler : patchHandlers) {
                for (String supportedAction : patchHandler.getSupportedActions()) {
                    patchHandlerRegistry.put(supportedAction, patchHandler);
                }
            }
            for (Object typePatchFile : typePatchFiles) {
                if (!((File)typePatchFile).isFile()) continue;
                String patchFile = ((File)typePatchFile).getAbsolutePath();
                LOG.info("Applying patches in file {}", (Object)patchFile);
                try {
                    String jsonStr = new String(Files.readAllBytes(((File)typePatchFile).toPath()), StandardCharsets.UTF_8);
                    TypeDefPatches patches = (TypeDefPatches)AtlasType.fromJson((String)jsonStr, TypeDefPatches.class);
                    if (patches == null || CollectionUtils.isEmpty(patches.getPatches())) {
                        LOG.info("No patches in file {}", (Object)patchFile);
                        continue;
                    }
                    int patchIndex = 0;
                    for (TypeDefPatch patch : patches.getPatches()) {
                        PatchHandler patchHandler = (PatchHandler)patchHandlerRegistry.get(patch.getAction());
                        if (patchHandler == null) {
                            LOG.error("Unknown patch action {} in file {}. Ignored", (Object)patch.getAction(), (Object)patchFile);
                            continue;
                        }
                        if (patchRegistry.isApplicable(patch.getId(), patchFile, patchIndex++)) {
                            AtlasPatch.PatchStatus status;
                            try {
                                status = patchHandler.applyPatch(patch);
                            }
                            catch (AtlasBaseException ex) {
                                status = AtlasPatch.PatchStatus.FAILED;
                                LOG.error("Failed to apply {} (status: {}; action: {}) in file: {}. Ignored.", new Object[]{patch.getId(), status.toString(), patch.getAction(), patchFile});
                            }
                            patchRegistry.register(patch.id, patch.description, TYPEDEF_PATCH_TYPE, patch.action, status);
                            LOG.info("{} (status: {}; action: {}) in file: {}", new Object[]{patch.getId(), status.toString(), patch.getAction(), patchFile});
                            continue;
                        }
                        LOG.info("{} in file: {} already {}. Ignoring.", new Object[]{patch.getId(), patchFile, patchRegistry.getStatus(patch.getId()).toString()});
                    }
                }
                catch (Throwable t) {
                    LOG.error("Failed to apply patches in file {}. Ignored", (Object)patchFile, (Object)t);
                }
            }
        }
    }

    class AddSuperTypePatchHandler
    extends PatchHandler {
        public AddSuperTypePatchHandler(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) {
            super(typeDefStore, typeRegistry, new String[]{"ADD_SUPER_TYPES"});
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public AtlasPatch.PatchStatus applyPatch(TypeDefPatch patch) throws AtlasBaseException {
            String typeName = patch.getTypeName();
            AtlasBaseTypeDef typeDef = this.typeRegistry.getTypeDefByName(typeName);
            if (typeDef == null) {
                throw new AtlasBaseException(AtlasErrorCode.PATCH_FOR_UNKNOWN_TYPE, new String[]{patch.getAction(), typeName});
            }
            Set<String> superTypesToBeAdded = patch.getSuperTypes();
            if (CollectionUtils.isNotEmpty(superTypesToBeAdded) && this.isPatchApplicable(patch, typeDef)) {
                if (!typeDef.getClass().equals(AtlasEntityDef.class)) throw new AtlasBaseException(AtlasErrorCode.PATCH_NOT_APPLICABLE_FOR_TYPE, new String[]{patch.getAction(), typeDef.getClass().getSimpleName()});
                AtlasEntityDef updatedDef = new AtlasEntityDef((AtlasEntityDef)typeDef);
                for (String superType : superTypesToBeAdded) {
                    updatedDef.addSuperType(superType);
                }
                updatedDef.setTypeVersion(patch.getUpdateToVersion());
                this.typeDefStore.updateEntityDefByName(typeName, updatedDef);
                LOG.info("Update entities of {} with new supertypes", (Object)typeName);
                AtlasTypeDefStoreInitializer.this.patchManager.addPatchHandler(new SuperTypesUpdatePatch(AtlasTypeDefStoreInitializer.this.patchManager.getContext(), patch.getId(), typeName));
                return AtlasPatch.PatchStatus.APPLIED;
            }
            if (CollectionUtils.isEmpty(superTypesToBeAdded)) {
                LOG.info("patch skipped: No superTypes provided to add for typeName={}", (Object)patch.getTypeName());
                return AtlasPatch.PatchStatus.SKIPPED;
            } else {
                LOG.info("patch skipped: typeName={}; applyToVersion={}; updateToVersion={}", new Object[]{patch.getTypeName(), patch.getApplyToVersion(), patch.getUpdateToVersion()});
            }
            return AtlasPatch.PatchStatus.SKIPPED;
        }
    }

    class UpdateAttributeMetadataHandler
    extends PatchHandler {
        public UpdateAttributeMetadataHandler(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) {
            super(typeDefStore, typeRegistry, new String[]{"UPDATE_ATTRIBUTE_METADATA"});
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public AtlasPatch.PatchStatus applyPatch(TypeDefPatch patch) throws AtlasBaseException {
            String typeName = patch.getTypeName();
            AtlasBaseTypeDef typeDef = this.typeRegistry.getTypeDefByName(typeName);
            if (typeDef == null) {
                throw new AtlasBaseException(AtlasErrorCode.PATCH_FOR_UNKNOWN_TYPE, new String[]{patch.getAction(), typeName});
            }
            if (this.isPatchApplicable(patch, typeDef)) {
                String attributeNameFromPatch = patch.getAttributeName();
                if (typeDef.getClass().equals(AtlasEntityDef.class)) {
                    AtlasEntityDef entityDef = new AtlasEntityDef((AtlasEntityDef)typeDef);
                    this.updateAttributeMetadata(patch, entityDef.getAttributeDefs());
                    entityDef.setTypeVersion(patch.getUpdateToVersion());
                    this.typeDefStore.updateEntityDefByName(typeName, entityDef);
                    return AtlasPatch.PatchStatus.APPLIED;
                }
                if (!typeDef.getClass().equals(AtlasStructDef.class)) throw new AtlasBaseException(AtlasErrorCode.PATCH_NOT_APPLICABLE_FOR_TYPE, new String[]{patch.getAction(), typeDef.getClass().getSimpleName()});
                AtlasStructDef updatedDef = new AtlasStructDef((AtlasStructDef)typeDef);
                this.updateAttributeMetadata(patch, updatedDef.getAttributeDefs());
                updatedDef.setTypeVersion(patch.getUpdateToVersion());
                this.typeDefStore.updateStructDefByName(typeName, updatedDef);
                return AtlasPatch.PatchStatus.APPLIED;
            }
            LOG.info("patch skipped: typeName={}; applyToVersion={}; updateToVersion={}", new Object[]{patch.getTypeName(), patch.getApplyToVersion(), patch.getUpdateToVersion()});
            return AtlasPatch.PatchStatus.SKIPPED;
        }

        private void updateAttributeMetadata(TypeDefPatch patch, List<AtlasStructDef.AtlasAttributeDef> attributeDefsFromEntity) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : attributeDefsFromEntity) {
                if (!attributeDef.getName().equalsIgnoreCase(patch.getAttributeName())) continue;
                this.updateAttribute(attributeDef, patch.getParams());
            }
        }

        private void updateAttribute(AtlasStructDef.AtlasAttributeDef atlasAttributeDef, Map<String, Object> params) {
            if (!params.isEmpty()) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    try {
                        if ("searchWeight".equalsIgnoreCase(entry.getKey())) {
                            Number number = (Number)entry.getValue();
                            int searchWeight = number.intValue();
                            if (!GraphBackedSearchIndexer.isValidSearchWeight(number.intValue())) {
                                String msg = String.format("Invalid search weight '%d' was provided for property %s.", searchWeight, atlasAttributeDef.getName());
                                LOG.error(msg);
                                throw new RuntimeException(msg);
                            }
                            atlasAttributeDef.setSearchWeight(searchWeight);
                            LOG.info("Updating Model attribute {}'s property{} to {}.", new Object[]{atlasAttributeDef.getName(), entry.getKey(), entry.getValue()});
                            continue;
                        }
                        if ("indexType".equalsIgnoreCase(entry.getKey())) {
                            String indexTypeString = (String)entry.getValue();
                            if (StringUtils.isEmpty((CharSequence)indexTypeString)) continue;
                            try {
                                AtlasStructDef.AtlasAttributeDef.IndexType indexType = AtlasStructDef.AtlasAttributeDef.IndexType.valueOf((String)indexTypeString);
                                atlasAttributeDef.setIndexType(indexType);
                                continue;
                            }
                            catch (IllegalArgumentException e) {
                                String msg = String.format("Value %s provided for the attribute %s is not valid.", indexTypeString, "indexType");
                                LOG.error(msg);
                                throw new RuntimeException(msg);
                            }
                        }
                        String msg = String.format("Received unknown property{} for attribute {}'s ", entry.getKey(), atlasAttributeDef.getName());
                        LOG.error(msg);
                        throw new RuntimeException(msg);
                    }
                    catch (Exception e) {
                        String msg = String.format("Error encountered in updating Model attribute %s's property '%s' to %s.", atlasAttributeDef.getName(), entry.getKey(), entry.getValue().toString());
                        LOG.info(msg, (Throwable)e);
                        throw new RuntimeException(msg, e);
                    }
                }
            }
        }
    }

    class SetServiceTypePatchHandler
    extends PatchHandler {
        public SetServiceTypePatchHandler(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) {
            super(typeDefStore, typeRegistry, new String[]{"SET_SERVICE_TYPE"});
        }

        @Override
        public AtlasPatch.PatchStatus applyPatch(TypeDefPatch patch) throws AtlasBaseException {
            AtlasPatch.PatchStatus ret;
            String typeName = patch.getTypeName();
            AtlasBaseTypeDef typeDef = this.typeRegistry.getTypeDefByName(typeName);
            if (typeDef == null) {
                throw new AtlasBaseException(AtlasErrorCode.PATCH_FOR_UNKNOWN_TYPE, new String[]{patch.getAction(), typeName});
            }
            if (this.isPatchApplicable(patch, typeDef)) {
                typeDef.setServiceType(patch.getServiceType());
                typeDef.setTypeVersion(patch.getUpdateToVersion());
                this.typeDefStore.updateTypesDef(AtlasTypeUtil.getTypesDef((AtlasBaseTypeDef)typeDef));
                ret = AtlasPatch.PatchStatus.APPLIED;
            } else {
                LOG.info("patch skipped: typeName={}; applyToVersion={}; updateToVersion={}", new Object[]{patch.getTypeName(), patch.getApplyToVersion(), patch.getUpdateToVersion()});
                ret = AtlasPatch.PatchStatus.SKIPPED;
            }
            return ret;
        }
    }

    class UpdateTypeDefOptionsPatchHandler
    extends PatchHandler {
        public UpdateTypeDefOptionsPatchHandler(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) {
            super(typeDefStore, typeRegistry, new String[]{"UPDATE_TYPEDEF_OPTIONS"});
        }

        @Override
        public AtlasPatch.PatchStatus applyPatch(TypeDefPatch patch) throws AtlasBaseException {
            AtlasPatch.PatchStatus ret;
            String typeName = patch.getTypeName();
            AtlasBaseTypeDef typeDef = this.typeRegistry.getTypeDefByName(typeName);
            if (typeDef == null) {
                throw new AtlasBaseException(AtlasErrorCode.PATCH_FOR_UNKNOWN_TYPE, new String[]{patch.getAction(), typeName});
            }
            if (MapUtils.isEmpty(patch.getTypeDefOptions())) {
                throw new AtlasBaseException(AtlasErrorCode.PATCH_INVALID_DATA, new String[]{patch.getAction(), typeName});
            }
            if (this.isPatchApplicable(patch, typeDef)) {
                if (typeDef.getOptions() == null) {
                    typeDef.setOptions(patch.getTypeDefOptions());
                } else {
                    typeDef.getOptions().putAll(patch.getTypeDefOptions());
                }
                typeDef.setTypeVersion(patch.getUpdateToVersion());
                this.typeDefStore.updateTypesDef(AtlasTypeUtil.getTypesDef((AtlasBaseTypeDef)typeDef));
                ret = AtlasPatch.PatchStatus.APPLIED;
            } else {
                LOG.info("patch skipped: typeName={}; applyToVersion={}; updateToVersion={}", new Object[]{patch.getTypeName(), patch.getApplyToVersion(), patch.getUpdateToVersion()});
                ret = AtlasPatch.PatchStatus.SKIPPED;
            }
            return ret;
        }
    }

    class RemoveLegacyRefAttributesPatchHandler
    extends PatchHandler {
        public RemoveLegacyRefAttributesPatchHandler(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) {
            super(typeDefStore, typeRegistry, new String[]{"REMOVE_LEGACY_REF_ATTRIBUTES"});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public AtlasPatch.PatchStatus applyPatch(TypeDefPatch patch) throws AtlasBaseException {
            String typeName = patch.getTypeName();
            AtlasBaseTypeDef typeDef = this.typeRegistry.getTypeDefByName(typeName);
            AtlasPatch.PatchStatus ret = AtlasPatch.PatchStatus.UNKNOWN;
            if (typeDef == null) {
                throw new AtlasBaseException(AtlasErrorCode.PATCH_FOR_UNKNOWN_TYPE, new String[]{patch.getAction(), typeName});
            }
            if (this.isPatchApplicable(patch, typeDef)) {
                if (!typeDef.getClass().equals(AtlasRelationshipDef.class)) return ret;
                AtlasRelationshipDef relationshipDef = (AtlasRelationshipDef)typeDef;
                AtlasRelationshipEndDef end1Def = relationshipDef.getEndDef1();
                AtlasRelationshipEndDef end2Def = relationshipDef.getEndDef2();
                AtlasEntityType end1Type = this.typeRegistry.getEntityTypeByName(end1Def.getType());
                AtlasEntityType end2Type = this.typeRegistry.getEntityTypeByName(end2Def.getType());
                String newRelationshipLabel = null;
                AtlasRelationshipDef.RelationshipCategory newRelationshipCategory = null;
                boolean swapEnds = false;
                if (patch.getParams() != null) {
                    Object relLabel = patch.getParams().get(AtlasTypeDefStoreInitializer.RELATIONSHIP_LABEL);
                    Object relCategory = patch.getParams().get(AtlasTypeDefStoreInitializer.RELATIONSHIP_CATEGORY);
                    Object relSwapEnds = patch.getParams().get(AtlasTypeDefStoreInitializer.RELATIONSHIP_SWAP_ENDS);
                    if (relLabel != null) {
                        newRelationshipLabel = relLabel.toString();
                    }
                    if (relCategory != null) {
                        newRelationshipCategory = AtlasRelationshipDef.RelationshipCategory.valueOf((String)relCategory.toString());
                    }
                    if (relSwapEnds != null) {
                        swapEnds = Boolean.valueOf(relSwapEnds.toString());
                    }
                }
                if (StringUtils.isEmpty(newRelationshipLabel)) {
                    AtlasStructType.AtlasAttribute legacyAttribute;
                    if (end1Def.getIsLegacyAttribute()) {
                        if (end2Def.getIsLegacyAttribute()) throw new AtlasBaseException(AtlasErrorCode.PATCH_MISSING_RELATIONSHIP_LABEL, new String[]{patch.getAction(), typeName});
                        legacyAttribute = end1Type.getAttribute(end1Def.getName());
                        newRelationshipLabel = "__" + legacyAttribute.getQualifiedName();
                    } else if (end2Def.getIsLegacyAttribute()) {
                        legacyAttribute = end2Type.getAttribute(end2Def.getName());
                        newRelationshipLabel = "__" + legacyAttribute.getQualifiedName();
                    } else {
                        newRelationshipLabel = relationshipDef.getRelationshipLabel();
                    }
                }
                AtlasRelationshipDef updatedDef = new AtlasRelationshipDef(relationshipDef);
                if (swapEnds) {
                    AtlasRelationshipEndDef tmp = updatedDef.getEndDef1();
                    updatedDef.setEndDef1(updatedDef.getEndDef2());
                    updatedDef.setEndDef2(tmp);
                }
                end1Def = updatedDef.getEndDef1();
                end2Def = updatedDef.getEndDef2();
                end1Type = this.typeRegistry.getEntityTypeByName(end1Def.getType());
                end2Type = this.typeRegistry.getEntityTypeByName(end2Def.getType());
                updatedDef.setRelationshipLabel(newRelationshipLabel);
                if (newRelationshipCategory != null) {
                    updatedDef.setRelationshipCategory(newRelationshipCategory);
                }
                updatedDef.setTypeVersion(patch.getUpdateToVersion());
                AtlasEntityDef updatedEntityDef1 = new AtlasEntityDef(end1Type.getEntityDef());
                AtlasEntityDef updatedEntityDef2 = new AtlasEntityDef(end2Type.getEntityDef());
                updatedEntityDef1.removeAttribute(end1Def.getName());
                updatedEntityDef2.removeAttribute(end2Def.getName());
                AtlasTypesDef typesDef = new AtlasTypesDef();
                typesDef.setEntityDefs(Arrays.asList(updatedEntityDef1, updatedEntityDef2));
                typesDef.setRelationshipDefs(Collections.singletonList(updatedDef));
                try {
                    RequestContext.get().setInTypePatching(true);
                    this.typeDefStore.updateTypesDef(typesDef);
                    ret = AtlasPatch.PatchStatus.APPLIED;
                    return ret;
                }
                finally {
                    RequestContext.get().setInTypePatching(false);
                    RequestContext.clear();
                }
            } else {
                LOG.info("patch skipped: typeName={}; applyToVersion={}; updateToVersion={}", new Object[]{patch.getTypeName(), patch.getApplyToVersion(), patch.getUpdateToVersion()});
                return AtlasPatch.PatchStatus.SKIPPED;
            }
        }
    }

    class UpdateAttributePatchHandler
    extends PatchHandler {
        public UpdateAttributePatchHandler(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) {
            super(typeDefStore, typeRegistry, new String[]{"UPDATE_ATTRIBUTE"});
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public AtlasPatch.PatchStatus applyPatch(TypeDefPatch patch) throws AtlasBaseException {
            String typeName = patch.getTypeName();
            AtlasBaseTypeDef typeDef = this.typeRegistry.getTypeDefByName(typeName);
            if (typeDef == null) {
                throw new AtlasBaseException(AtlasErrorCode.PATCH_FOR_UNKNOWN_TYPE, new String[]{patch.getAction(), typeName});
            }
            if (this.isPatchApplicable(patch, typeDef)) {
                if (typeDef.getClass().equals(AtlasEntityDef.class)) {
                    AtlasEntityDef updatedDef = new AtlasEntityDef((AtlasEntityDef)typeDef);
                    this.addOrUpdateAttributes((AtlasStructDef)updatedDef, patch.getAttributeDefs());
                    updatedDef.setTypeVersion(patch.getUpdateToVersion());
                    this.typeDefStore.updateEntityDefByName(typeName, updatedDef);
                    return AtlasPatch.PatchStatus.APPLIED;
                }
                if (typeDef.getClass().equals(AtlasClassificationDef.class)) {
                    AtlasClassificationDef updatedDef = new AtlasClassificationDef((AtlasClassificationDef)typeDef);
                    this.addOrUpdateAttributes((AtlasStructDef)updatedDef, patch.getAttributeDefs());
                    updatedDef.setTypeVersion(patch.getUpdateToVersion());
                    this.typeDefStore.updateClassificationDefByName(typeName, updatedDef);
                    return AtlasPatch.PatchStatus.APPLIED;
                }
                if (!typeDef.getClass().equals(AtlasStructDef.class)) throw new AtlasBaseException(AtlasErrorCode.PATCH_NOT_APPLICABLE_FOR_TYPE, new String[]{patch.getAction(), typeDef.getClass().getSimpleName()});
                AtlasStructDef updatedDef = new AtlasStructDef((AtlasStructDef)typeDef);
                this.addOrUpdateAttributes(updatedDef, patch.getAttributeDefs());
                updatedDef.setTypeVersion(patch.getUpdateToVersion());
                this.typeDefStore.updateStructDefByName(typeName, updatedDef);
                return AtlasPatch.PatchStatus.APPLIED;
            }
            LOG.info("patch skipped: typeName={}; applyToVersion={}; updateToVersion={}", new Object[]{patch.getTypeName(), patch.getApplyToVersion(), patch.getUpdateToVersion()});
            return AtlasPatch.PatchStatus.SKIPPED;
        }

        private void addOrUpdateAttributes(AtlasStructDef structDef, List<AtlasStructDef.AtlasAttributeDef> attributesToUpdate) {
            for (AtlasStructDef.AtlasAttributeDef attributeToUpdate : attributesToUpdate) {
                String attrName = attributeToUpdate.getName();
                if (structDef.hasAttribute(attrName)) {
                    structDef.removeAttribute(attrName);
                }
                structDef.addAttribute(attributeToUpdate);
            }
        }
    }

    class AddMandatoryAttributePatchHandler
    extends PatchHandler {
        public AddMandatoryAttributePatchHandler(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) {
            super(typeDefStore, typeRegistry, new String[]{"ADD_MANDATORY_ATTRIBUTE"});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AtlasPatch.PatchStatus applyPatch(TypeDefPatch patch) throws AtlasBaseException {
            AtlasPatch.PatchStatus ret;
            String typeName = patch.getTypeName();
            AtlasBaseTypeDef typeDef = this.typeRegistry.getTypeDefByName(typeName);
            if (typeDef == null) {
                throw new AtlasBaseException(AtlasErrorCode.PATCH_FOR_UNKNOWN_TYPE, new String[]{patch.getAction(), typeName});
            }
            if (this.isPatchApplicable(patch, typeDef)) {
                List<AtlasStructDef.AtlasAttributeDef> attributesToAdd = this.getAttributesToAdd(patch, (AtlasStructDef)typeDef);
                if (CollectionUtils.isEmpty(attributesToAdd)) {
                    LOG.info("patch skipped: typeName={}; mandatory attributes are not valid in patch {}", (Object)patch.getTypeName(), (Object)patch.getId());
                    ret = AtlasPatch.PatchStatus.SKIPPED;
                } else {
                    try {
                        RequestContext.get().setInTypePatching(true);
                        RequestContext.get().setCurrentTypePatchAction("ADD_MANDATORY_ATTRIBUTE");
                        if (typeDef.getClass().equals(AtlasEntityDef.class)) {
                            AtlasEntityDef updatedDef = new AtlasEntityDef((AtlasEntityDef)typeDef);
                            this.updateTypeDefWithPatch(patch, (AtlasStructDef)updatedDef, attributesToAdd);
                            this.typeDefStore.updateEntityDefByName(typeName, updatedDef);
                        } else if (typeDef.getClass().equals(AtlasClassificationDef.class)) {
                            AtlasClassificationDef updatedDef = new AtlasClassificationDef((AtlasClassificationDef)typeDef);
                            this.updateTypeDefWithPatch(patch, (AtlasStructDef)updatedDef, attributesToAdd);
                            this.typeDefStore.updateClassificationDefByName(typeName, updatedDef);
                        } else if (typeDef.getClass().equals(AtlasStructDef.class)) {
                            AtlasStructDef updatedDef = new AtlasStructDef((AtlasStructDef)typeDef);
                            this.updateTypeDefWithPatch(patch, updatedDef, attributesToAdd);
                            this.typeDefStore.updateStructDefByName(typeName, updatedDef);
                        } else {
                            throw new AtlasBaseException(AtlasErrorCode.PATCH_NOT_APPLICABLE_FOR_TYPE, new String[]{patch.getAction(), typeDef.getClass().getSimpleName()});
                        }
                        LOG.info("adding a Java patch to update entities of {} with new mandatory attributes", (Object)typeName);
                        AtlasTypeDefStoreInitializer.this.patchManager.addPatchHandler(new AddMandatoryAttributesPatch(AtlasTypeDefStoreInitializer.this.patchManager.getContext(), patch.getId(), typeName, attributesToAdd));
                        ret = AtlasPatch.PatchStatus.APPLIED;
                    }
                    finally {
                        RequestContext.get().setInTypePatching(false);
                        RequestContext.clear();
                    }
                }
            } else {
                LOG.info("patch skipped: typeName={}; applyToVersion={}; updateToVersion={}", new Object[]{patch.getTypeName(), patch.getApplyToVersion(), patch.getUpdateToVersion()});
                ret = AtlasPatch.PatchStatus.SKIPPED;
            }
            return ret;
        }

        private List<AtlasStructDef.AtlasAttributeDef> getAttributesToAdd(TypeDefPatch patch, AtlasStructDef updatedDef) throws AtlasBaseException {
            ArrayList<AtlasStructDef.AtlasAttributeDef> ret = new ArrayList<AtlasStructDef.AtlasAttributeDef>();
            for (AtlasStructDef.AtlasAttributeDef attributeDef : patch.getAttributeDefs()) {
                TypeCategory attributeType = this.typeRegistry.getType(attributeDef.getTypeName()).getTypeCategory();
                if (updatedDef.hasAttribute(attributeDef.getName())) {
                    LOG.warn("AddMandatoryAttributePatchHandler(id={}, typeName={}, attribute={}): already exists in type {}. Ignoring attribute", new Object[]{patch.getId(), patch.getTypeName(), attributeDef.getName(), updatedDef.getName()});
                    continue;
                }
                if (attributeDef.getIsOptional()) {
                    LOG.warn("AddMandatoryAttributePatchHandler(id={}, typeName={}, attribute={}): is not mandatory attribute. Ignoring attribute", new Object[]{patch.getId(), patch.getTypeName(), attributeDef.getName()});
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)attributeDef.getDefaultValue())) {
                    LOG.warn("AddMandatoryAttributePatchHandler(id={}, typeName={}, attribute={}): default value is missing. Ignoring attribute", new Object[]{patch.getId(), patch.getTypeName(), attributeDef.getName()});
                    continue;
                }
                if (!TypeCategory.PRIMITIVE.equals((Object)attributeType)) {
                    LOG.warn("AddMandatoryAttributePatchHandler(id={}, typeName={}, attribute={}): type {} is not primitive. Ignoring attribute", new Object[]{patch.getId(), patch.getTypeName(), attributeDef.getName(), attributeDef.getTypeName()});
                    continue;
                }
                if (attributeDef.getIsUnique()) {
                    LOG.warn("AddMandatoryAttributePatchHandler(id={}, typeName={}, attribute={}): is not unique. Ignoring attribute", new Object[]{patch.getId(), patch.getTypeName(), attributeDef.getName()});
                    continue;
                }
                ret.add(attributeDef);
            }
            return ret;
        }

        private void updateTypeDefWithPatch(TypeDefPatch patch, AtlasStructDef updatedDef, List<AtlasStructDef.AtlasAttributeDef> attributesToAdd) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : attributesToAdd) {
                updatedDef.addAttribute(attributeDef);
            }
            updatedDef.setTypeVersion(patch.getUpdateToVersion());
        }
    }

    class AddAttributePatchHandler
    extends PatchHandler {
        public AddAttributePatchHandler(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) {
            super(typeDefStore, typeRegistry, new String[]{"ADD_ATTRIBUTE"});
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public AtlasPatch.PatchStatus applyPatch(TypeDefPatch patch) throws AtlasBaseException {
            String typeName = patch.getTypeName();
            AtlasBaseTypeDef typeDef = this.typeRegistry.getTypeDefByName(typeName);
            if (typeDef == null) {
                throw new AtlasBaseException(AtlasErrorCode.PATCH_FOR_UNKNOWN_TYPE, new String[]{patch.getAction(), typeName});
            }
            if (this.isPatchApplicable(patch, typeDef)) {
                if (typeDef.getClass().equals(AtlasEntityDef.class)) {
                    AtlasEntityDef updatedDef = new AtlasEntityDef((AtlasEntityDef)typeDef);
                    for (AtlasStructDef.AtlasAttributeDef attributeDef : patch.getAttributeDefs()) {
                        updatedDef.addAttribute(attributeDef);
                    }
                    updatedDef.setTypeVersion(patch.getUpdateToVersion());
                    this.typeDefStore.updateEntityDefByName(typeName, updatedDef);
                    return AtlasPatch.PatchStatus.APPLIED;
                }
                if (typeDef.getClass().equals(AtlasClassificationDef.class)) {
                    AtlasClassificationDef updatedDef = new AtlasClassificationDef((AtlasClassificationDef)typeDef);
                    for (AtlasStructDef.AtlasAttributeDef attributeDef : patch.getAttributeDefs()) {
                        updatedDef.addAttribute(attributeDef);
                    }
                    updatedDef.setTypeVersion(patch.getUpdateToVersion());
                    this.typeDefStore.updateClassificationDefByName(typeName, updatedDef);
                    return AtlasPatch.PatchStatus.APPLIED;
                }
                if (typeDef.getClass().equals(AtlasStructDef.class)) {
                    AtlasStructDef updatedDef = new AtlasStructDef((AtlasStructDef)typeDef);
                    for (AtlasStructDef.AtlasAttributeDef attributeDef : patch.getAttributeDefs()) {
                        updatedDef.addAttribute(attributeDef);
                    }
                    updatedDef.setTypeVersion(patch.getUpdateToVersion());
                    this.typeDefStore.updateStructDefByName(typeName, updatedDef);
                    return AtlasPatch.PatchStatus.APPLIED;
                }
                if (!typeDef.getClass().equals(AtlasRelationshipDef.class)) throw new AtlasBaseException(AtlasErrorCode.PATCH_NOT_APPLICABLE_FOR_TYPE, new String[]{patch.getAction(), typeDef.getClass().getSimpleName()});
                AtlasRelationshipDef updatedDef = new AtlasRelationshipDef((AtlasRelationshipDef)typeDef);
                for (AtlasStructDef.AtlasAttributeDef attributeDef : patch.getAttributeDefs()) {
                    updatedDef.addAttribute(attributeDef);
                }
                updatedDef.setTypeVersion(patch.getUpdateToVersion());
                this.typeDefStore.updateRelationshipDefByName(typeName, updatedDef);
                return AtlasPatch.PatchStatus.APPLIED;
            }
            LOG.info("patch skipped: typeName={}; applyToVersion={}; updateToVersion={}", new Object[]{patch.getTypeName(), patch.getApplyToVersion(), patch.getUpdateToVersion()});
            return AtlasPatch.PatchStatus.SKIPPED;
        }
    }

    class UpdateEnumDefPatchHandler
    extends PatchHandler {
        public UpdateEnumDefPatchHandler(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) {
            super(typeDefStore, typeRegistry, new String[]{"UPDATE_ENUMDEF"});
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public AtlasPatch.PatchStatus applyPatch(TypeDefPatch patch) throws AtlasBaseException {
            String typeName = patch.getTypeName();
            AtlasBaseTypeDef typeDef = this.typeRegistry.getTypeDefByName(typeName);
            if (typeDef == null) {
                throw new AtlasBaseException(AtlasErrorCode.PATCH_FOR_UNKNOWN_TYPE, new String[]{patch.getAction(), typeName});
            }
            if (this.isPatchApplicable(patch, typeDef)) {
                if (!typeDef.getClass().equals(AtlasEnumDef.class)) throw new AtlasBaseException(AtlasErrorCode.PATCH_NOT_APPLICABLE_FOR_TYPE, new String[]{patch.getAction(), typeDef.getClass().getSimpleName()});
                AtlasEnumDef updatedDef = new AtlasEnumDef((AtlasEnumDef)typeDef);
                for (AtlasEnumDef.AtlasEnumElementDef elementDef : patch.getElementDefs()) {
                    updatedDef.addElement(elementDef);
                }
                updatedDef.setTypeVersion(patch.getUpdateToVersion());
                this.typeDefStore.updateEnumDefByName(typeName, updatedDef);
                return AtlasPatch.PatchStatus.APPLIED;
            }
            LOG.info("patch skipped: typeName={}; applyToVersion={}; updateToVersion={}", new Object[]{patch.getTypeName(), patch.getApplyToVersion(), patch.getUpdateToVersion()});
            return AtlasPatch.PatchStatus.SKIPPED;
        }
    }

    abstract class PatchHandler {
        protected final AtlasTypeDefStore typeDefStore;
        protected final AtlasTypeRegistry typeRegistry;
        protected final String[] supportedActions;

        protected PatchHandler(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry, String[] supportedActions) {
            this.typeDefStore = typeDefStore;
            this.typeRegistry = typeRegistry;
            this.supportedActions = supportedActions;
        }

        public String[] getSupportedActions() {
            return this.supportedActions;
        }

        public abstract AtlasPatch.PatchStatus applyPatch(TypeDefPatch var1) throws AtlasBaseException;

        protected boolean isPatchApplicable(TypeDefPatch patch, AtlasBaseTypeDef currentTypeDef) {
            String currentVersion = currentTypeDef.getTypeVersion();
            String applyToVersion = patch.getApplyToVersion();
            return currentVersion == null || currentVersion.equalsIgnoreCase(applyToVersion) || currentVersion.startsWith(applyToVersion + ".");
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    static class TypeDefPatches {
        private List<TypeDefPatch> patches;

        TypeDefPatches() {
        }

        public List<TypeDefPatch> getPatches() {
            return this.patches;
        }

        public void setPatches(List<TypeDefPatch> patches) {
            this.patches = patches;
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    static class TypeDefPatch {
        private String id;
        private String description;
        private String action;
        private String typeName;
        private String applyToVersion;
        private String updateToVersion;
        private Map<String, Object> params;
        private List<AtlasStructDef.AtlasAttributeDef> attributeDefs;
        private List<AtlasEnumDef.AtlasEnumElementDef> elementDefs;
        private Map<String, String> typeDefOptions;
        private String serviceType;
        private String attributeName;
        private Set<String> superTypes;

        TypeDefPatch() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public String getApplyToVersion() {
            return this.applyToVersion;
        }

        public void setApplyToVersion(String applyToVersion) {
            this.applyToVersion = applyToVersion;
        }

        public String getUpdateToVersion() {
            return this.updateToVersion;
        }

        public void setUpdateToVersion(String updateToVersion) {
            this.updateToVersion = updateToVersion;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public void setParams(Map<String, Object> params) {
            this.params = params;
        }

        public List<AtlasStructDef.AtlasAttributeDef> getAttributeDefs() {
            return this.attributeDefs;
        }

        public void setAttributeDefs(List<AtlasStructDef.AtlasAttributeDef> attributeDefs) {
            this.attributeDefs = attributeDefs;
        }

        public List<AtlasEnumDef.AtlasEnumElementDef> getElementDefs() {
            return this.elementDefs;
        }

        public void setElementDefs(List<AtlasEnumDef.AtlasEnumElementDef> elementDefs) {
            this.elementDefs = elementDefs;
        }

        public Map<String, String> getTypeDefOptions() {
            return this.typeDefOptions;
        }

        public void setTypeDefOptions(Map<String, String> typeDefOptions) {
            this.typeDefOptions = typeDefOptions;
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public Set<String> getSuperTypes() {
            return this.superTypes;
        }

        public void setSuperTypes(Set<String> superTypes) {
            this.superTypes = superTypes;
        }
    }
}

